//! This file is auto-generated by tools/gen_spirv_spec.zig.

const std = @import("std");

pub const Version = packed struct(Word) {
    padding: u8 = 0,
    minor: u8,
    major: u8,
    padding0: u8 = 0,

    pub fn toWord(self: @This()) Word {
        return @bitCast(self);
    }
};

pub const Word = u32;
pub const IdResult = enum(Word) {
    none,
    _,

    pub fn format(
        self: IdResult,
        comptime _: []const u8,
        _: std.fmt.FormatOptions,
        writer: anytype,
    ) @TypeOf(writer).Error!void {
        switch (self) {
            .none => try writer.writeAll("(none)"),
            else => try writer.print("%{}", .{@intFromEnum(self)}),
        }
    }
};
pub const IdResultType = IdResult;
pub const IdRef = IdResult;

pub const IdMemorySemantics = IdRef;
pub const IdScope = IdRef;

pub const LiteralInteger = Word;
pub const LiteralFloat = Word;
pub const LiteralString = []const u8;
pub const LiteralContextDependentNumber = union(enum) {
    int32: i32,
    uint32: u32,
    int64: i64,
    uint64: u64,
    float32: f32,
    float64: f64,
};
pub const LiteralExtInstInteger = struct { inst: Word };
pub const LiteralSpecConstantOpInteger = struct { opcode: Opcode };
pub const PairLiteralIntegerIdRef = struct { value: LiteralInteger, label: IdRef };
pub const PairIdRefLiteralInteger = struct { target: IdRef, member: LiteralInteger };
pub const PairIdRefIdRef = [2]IdRef;

pub const Quantifier = enum {
    required,
    optional,
    variadic,
};

pub const Operand = struct {
    kind: OperandKind,
    quantifier: Quantifier,
};

pub const OperandCategory = enum {
    bit_enum,
    value_enum,
    id,
    literal,
    composite,
};

pub const Enumerant = struct {
    name: []const u8,
    value: Word,
    parameters: []const OperandKind,
};

pub const Instruction = struct {
    name: []const u8,
    opcode: Word,
    operands: []const Operand,
};

pub const zig_generator_id: Word = 41;
pub const version = Version{ .major = 1, .minor = 6, .patch = 1 };
pub const magic_number: Word = 0x07230203;

pub const Class = enum {
    Miscellaneous,
    Debug,
    Extension,
    ModeSetting,
    TypeDeclaration,
    ConstantCreation,
    Function,
    Memory,
    Annotation,
    Composite,
    Image,
    Conversion,
    Arithmetic,
    RelationalAndLogical,
    Bit,
    Derivative,
    Primitive,
    Barrier,
    Atomic,
    ControlFlow,
    Group,
    Pipe,
    DeviceSideEnqueue,
    NonUniform,
    Reserved,
};

pub const OperandKind = enum {
    Opcode,
    ImageOperands,
    FPFastMathMode,
    SelectionControl,
    LoopControl,
    FunctionControl,
    MemorySemantics,
    MemoryAccess,
    KernelProfilingInfo,
    RayFlags,
    FragmentShadingRate,
    RawAccessChainOperands,
    SourceLanguage,
    ExecutionModel,
    AddressingModel,
    MemoryModel,
    ExecutionMode,
    StorageClass,
    Dim,
    SamplerAddressingMode,
    SamplerFilterMode,
    ImageFormat,
    ImageChannelOrder,
    ImageChannelDataType,
    FPRoundingMode,
    FPDenormMode,
    QuantizationModes,
    FPOperationMode,
    OverflowModes,
    LinkageType,
    AccessQualifier,
    HostAccessQualifier,
    FunctionParameterAttribute,
    Decoration,
    BuiltIn,
    Scope,
    GroupOperation,
    KernelEnqueueFlags,
    Capability,
    RayQueryIntersection,
    RayQueryCommittedIntersectionType,
    RayQueryCandidateIntersectionType,
    PackedVectorFormat,
    CooperativeMatrixOperands,
    CooperativeMatrixLayout,
    CooperativeMatrixUse,
    InitializationModeQualifier,
    LoadCacheControl,
    StoreCacheControl,
    NamedMaximumNumberOfRegisters,
    IdResultType,
    IdResult,
    IdMemorySemantics,
    IdScope,
    IdRef,
    LiteralInteger,
    LiteralString,
    LiteralFloat,
    LiteralContextDependentNumber,
    LiteralExtInstInteger,
    LiteralSpecConstantOpInteger,
    PairLiteralIntegerIdRef,
    PairIdRefLiteralInteger,
    PairIdRefIdRef,
    @"OpenCL.DebugInfo.100.DebugInfoFlags",
    @"OpenCL.DebugInfo.100.DebugBaseTypeAttributeEncoding",
    @"OpenCL.DebugInfo.100.DebugCompositeType",
    @"OpenCL.DebugInfo.100.DebugTypeQualifier",
    @"OpenCL.DebugInfo.100.DebugOperation",
    @"OpenCL.DebugInfo.100.DebugImportedEntity",
    @"NonSemantic.Shader.DebugInfo.100.DebugInfoFlags",
    @"NonSemantic.Shader.DebugInfo.100.BuildIdentifierFlags",
    @"NonSemantic.Shader.DebugInfo.100.DebugBaseTypeAttributeEncoding",
    @"NonSemantic.Shader.DebugInfo.100.DebugCompositeType",
    @"NonSemantic.Shader.DebugInfo.100.DebugTypeQualifier",
    @"NonSemantic.Shader.DebugInfo.100.DebugOperation",
    @"NonSemantic.Shader.DebugInfo.100.DebugImportedEntity",
    @"NonSemantic.ClspvReflection.6.KernelPropertyFlags",
    @"DebugInfo.DebugInfoFlags",
    @"DebugInfo.DebugBaseTypeAttributeEncoding",
    @"DebugInfo.DebugCompositeType",
    @"DebugInfo.DebugTypeQualifier",
    @"DebugInfo.DebugOperation",

    pub fn category(self: OperandKind) OperandCategory {
        return switch (self) {
            .Opcode => .literal,
            .ImageOperands => .bit_enum,
            .FPFastMathMode => .bit_enum,
            .SelectionControl => .bit_enum,
            .LoopControl => .bit_enum,
            .FunctionControl => .bit_enum,
            .MemorySemantics => .bit_enum,
            .MemoryAccess => .bit_enum,
            .KernelProfilingInfo => .bit_enum,
            .RayFlags => .bit_enum,
            .FragmentShadingRate => .bit_enum,
            .RawAccessChainOperands => .bit_enum,
            .SourceLanguage => .value_enum,
            .ExecutionModel => .value_enum,
            .AddressingModel => .value_enum,
            .MemoryModel => .value_enum,
            .ExecutionMode => .value_enum,
            .StorageClass => .value_enum,
            .Dim => .value_enum,
            .SamplerAddressingMode => .value_enum,
            .SamplerFilterMode => .value_enum,
            .ImageFormat => .value_enum,
            .ImageChannelOrder => .value_enum,
            .ImageChannelDataType => .value_enum,
            .FPRoundingMode => .value_enum,
            .FPDenormMode => .value_enum,
            .QuantizationModes => .value_enum,
            .FPOperationMode => .value_enum,
            .OverflowModes => .value_enum,
            .LinkageType => .value_enum,
            .AccessQualifier => .value_enum,
            .HostAccessQualifier => .value_enum,
            .FunctionParameterAttribute => .value_enum,
            .Decoration => .value_enum,
            .BuiltIn => .value_enum,
            .Scope => .value_enum,
            .GroupOperation => .value_enum,
            .KernelEnqueueFlags => .value_enum,
            .Capability => .value_enum,
            .RayQueryIntersection => .value_enum,
            .RayQueryCommittedIntersectionType => .value_enum,
            .RayQueryCandidateIntersectionType => .value_enum,
            .PackedVectorFormat => .value_enum,
            .CooperativeMatrixOperands => .bit_enum,
            .CooperativeMatrixLayout => .value_enum,
            .CooperativeMatrixUse => .value_enum,
            .InitializationModeQualifier => .value_enum,
            .LoadCacheControl => .value_enum,
            .StoreCacheControl => .value_enum,
            .NamedMaximumNumberOfRegisters => .value_enum,
            .IdResultType => .id,
            .IdResult => .id,
            .IdMemorySemantics => .id,
            .IdScope => .id,
            .IdRef => .id,
            .LiteralInteger => .literal,
            .LiteralString => .literal,
            .LiteralFloat => .literal,
            .LiteralContextDependentNumber => .literal,
            .LiteralExtInstInteger => .literal,
            .LiteralSpecConstantOpInteger => .literal,
            .PairLiteralIntegerIdRef => .composite,
            .PairIdRefLiteralInteger => .composite,
            .PairIdRefIdRef => .composite,
            .@"OpenCL.DebugInfo.100.DebugInfoFlags" => .bit_enum,
            .@"OpenCL.DebugInfo.100.DebugBaseTypeAttributeEncoding" => .value_enum,
            .@"OpenCL.DebugInfo.100.DebugCompositeType" => .value_enum,
            .@"OpenCL.DebugInfo.100.DebugTypeQualifier" => .value_enum,
            .@"OpenCL.DebugInfo.100.DebugOperation" => .value_enum,
            .@"OpenCL.DebugInfo.100.DebugImportedEntity" => .value_enum,
            .@"NonSemantic.Shader.DebugInfo.100.DebugInfoFlags" => .bit_enum,
            .@"NonSemantic.Shader.DebugInfo.100.BuildIdentifierFlags" => .bit_enum,
            .@"NonSemantic.Shader.DebugInfo.100.DebugBaseTypeAttributeEncoding" => .value_enum,
            .@"NonSemantic.Shader.DebugInfo.100.DebugCompositeType" => .value_enum,
            .@"NonSemantic.Shader.DebugInfo.100.DebugTypeQualifier" => .value_enum,
            .@"NonSemantic.Shader.DebugInfo.100.DebugOperation" => .value_enum,
            .@"NonSemantic.Shader.DebugInfo.100.DebugImportedEntity" => .value_enum,
            .@"NonSemantic.ClspvReflection.6.KernelPropertyFlags" => .bit_enum,
            .@"DebugInfo.DebugInfoFlags" => .bit_enum,
            .@"DebugInfo.DebugBaseTypeAttributeEncoding" => .value_enum,
            .@"DebugInfo.DebugCompositeType" => .value_enum,
            .@"DebugInfo.DebugTypeQualifier" => .value_enum,
            .@"DebugInfo.DebugOperation" => .value_enum,
        };
    }
    pub fn enumerants(self: OperandKind) []const Enumerant {
        return switch (self) {
            .Opcode => unreachable,
            .ImageOperands => &[_]Enumerant{
                .{ .name = "Bias", .value = 0x0001, .parameters = &[_]OperandKind{.IdRef} },
                .{ .name = "Lod", .value = 0x0002, .parameters = &[_]OperandKind{.IdRef} },
                .{ .name = "Grad", .value = 0x0004, .parameters = &[_]OperandKind{ .IdRef, .IdRef } },
                .{ .name = "ConstOffset", .value = 0x0008, .parameters = &[_]OperandKind{.IdRef} },
                .{ .name = "Offset", .value = 0x0010, .parameters = &[_]OperandKind{.IdRef} },
                .{ .name = "ConstOffsets", .value = 0x0020, .parameters = &[_]OperandKind{.IdRef} },
                .{ .name = "Sample", .value = 0x0040, .parameters = &[_]OperandKind{.IdRef} },
                .{ .name = "MinLod", .value = 0x0080, .parameters = &[_]OperandKind{.IdRef} },
                .{ .name = "MakeTexelAvailable", .value = 0x0100, .parameters = &[_]OperandKind{.IdScope} },
                .{ .name = "MakeTexelAvailableKHR", .value = 0x0100, .parameters = &[_]OperandKind{.IdScope} },
                .{ .name = "MakeTexelVisible", .value = 0x0200, .parameters = &[_]OperandKind{.IdScope} },
                .{ .name = "MakeTexelVisibleKHR", .value = 0x0200, .parameters = &[_]OperandKind{.IdScope} },
                .{ .name = "NonPrivateTexel", .value = 0x0400, .parameters = &[_]OperandKind{} },
                .{ .name = "NonPrivateTexelKHR", .value = 0x0400, .parameters = &[_]OperandKind{} },
                .{ .name = "VolatileTexel", .value = 0x0800, .parameters = &[_]OperandKind{} },
                .{ .name = "VolatileTexelKHR", .value = 0x0800, .parameters = &[_]OperandKind{} },
                .{ .name = "SignExtend", .value = 0x1000, .parameters = &[_]OperandKind{} },
                .{ .name = "ZeroExtend", .value = 0x2000, .parameters = &[_]OperandKind{} },
                .{ .name = "Nontemporal", .value = 0x4000, .parameters = &[_]OperandKind{} },
                .{ .name = "Offsets", .value = 0x10000, .parameters = &[_]OperandKind{.IdRef} },
            },
            .FPFastMathMode => &[_]Enumerant{
                .{ .name = "NotNaN", .value = 0x0001, .parameters = &[_]OperandKind{} },
                .{ .name = "NotInf", .value = 0x0002, .parameters = &[_]OperandKind{} },
                .{ .name = "NSZ", .value = 0x0004, .parameters = &[_]OperandKind{} },
                .{ .name = "AllowRecip", .value = 0x0008, .parameters = &[_]OperandKind{} },
                .{ .name = "Fast", .value = 0x0010, .parameters = &[_]OperandKind{} },
                .{ .name = "AllowContract", .value = 0x10000, .parameters = &[_]OperandKind{} },
                .{ .name = "AllowContractFastINTEL", .value = 0x10000, .parameters = &[_]OperandKind{} },
                .{ .name = "AllowReassoc", .value = 0x20000, .parameters = &[_]OperandKind{} },
                .{ .name = "AllowReassocINTEL", .value = 0x20000, .parameters = &[_]OperandKind{} },
                .{ .name = "AllowTransform", .value = 0x40000, .parameters = &[_]OperandKind{} },
            },
            .SelectionControl => &[_]Enumerant{
                .{ .name = "Flatten", .value = 0x0001, .parameters = &[_]OperandKind{} },
                .{ .name = "DontFlatten", .value = 0x0002, .parameters = &[_]OperandKind{} },
            },
            .LoopControl => &[_]Enumerant{
                .{ .name = "Unroll", .value = 0x0001, .parameters = &[_]OperandKind{} },
                .{ .name = "DontUnroll", .value = 0x0002, .parameters = &[_]OperandKind{} },
                .{ .name = "DependencyInfinite", .value = 0x0004, .parameters = &[_]OperandKind{} },
                .{ .name = "DependencyLength", .value = 0x0008, .parameters = &[_]OperandKind{.LiteralInteger} },
                .{ .name = "MinIterations", .value = 0x0010, .parameters = &[_]OperandKind{.LiteralInteger} },
                .{ .name = "MaxIterations", .value = 0x0020, .parameters = &[_]OperandKind{.LiteralInteger} },
                .{ .name = "IterationMultiple", .value = 0x0040, .parameters = &[_]OperandKind{.LiteralInteger} },
                .{ .name = "PeelCount", .value = 0x0080, .parameters = &[_]OperandKind{.LiteralInteger} },
                .{ .name = "PartialCount", .value = 0x0100, .parameters = &[_]OperandKind{.LiteralInteger} },
                .{ .name = "InitiationIntervalINTEL", .value = 0x10000, .parameters = &[_]OperandKind{.LiteralInteger} },
                .{ .name = "MaxConcurrencyINTEL", .value = 0x20000, .parameters = &[_]OperandKind{.LiteralInteger} },
                .{ .name = "DependencyArrayINTEL", .value = 0x40000, .parameters = &[_]OperandKind{.LiteralInteger} },
                .{ .name = "PipelineEnableINTEL", .value = 0x80000, .parameters = &[_]OperandKind{.LiteralInteger} },
                .{ .name = "LoopCoalesceINTEL", .value = 0x100000, .parameters = &[_]OperandKind{.LiteralInteger} },
                .{ .name = "MaxInterleavingINTEL", .value = 0x200000, .parameters = &[_]OperandKind{.LiteralInteger} },
                .{ .name = "SpeculatedIterationsINTEL", .value = 0x400000, .parameters = &[_]OperandKind{.LiteralInteger} },
                .{ .name = "NoFusionINTEL", .value = 0x800000, .parameters = &[_]OperandKind{} },
                .{ .name = "LoopCountINTEL", .value = 0x1000000, .parameters = &[_]OperandKind{.LiteralInteger} },
                .{ .name = "MaxReinvocationDelayINTEL", .value = 0x2000000, .parameters = &[_]OperandKind{.LiteralInteger} },
            },
            .FunctionControl => &[_]Enumerant{
                .{ .name = "Inline", .value = 0x0001, .parameters = &[_]OperandKind{} },
                .{ .name = "DontInline", .value = 0x0002, .parameters = &[_]OperandKind{} },
                .{ .name = "Pure", .value = 0x0004, .parameters = &[_]OperandKind{} },
                .{ .name = "Const", .value = 0x0008, .parameters = &[_]OperandKind{} },
                .{ .name = "OptNoneINTEL", .value = 0x10000, .parameters = &[_]OperandKind{} },
            },
            .MemorySemantics => &[_]Enumerant{
                .{ .name = "Relaxed", .value = 0x0000, .parameters = &[_]OperandKind{} },
                .{ .name = "Acquire", .value = 0x0002, .parameters = &[_]OperandKind{} },
                .{ .name = "Release", .value = 0x0004, .parameters = &[_]OperandKind{} },
                .{ .name = "AcquireRelease", .value = 0x0008, .parameters = &[_]OperandKind{} },
                .{ .name = "SequentiallyConsistent", .value = 0x0010, .parameters = &[_]OperandKind{} },
                .{ .name = "UniformMemory", .value = 0x0040, .parameters = &[_]OperandKind{} },
                .{ .name = "SubgroupMemory", .value = 0x0080, .parameters = &[_]OperandKind{} },
                .{ .name = "WorkgroupMemory", .value = 0x0100, .parameters = &[_]OperandKind{} },
                .{ .name = "CrossWorkgroupMemory", .value = 0x0200, .parameters = &[_]OperandKind{} },
                .{ .name = "AtomicCounterMemory", .value = 0x0400, .parameters = &[_]OperandKind{} },
                .{ .name = "ImageMemory", .value = 0x0800, .parameters = &[_]OperandKind{} },
                .{ .name = "OutputMemory", .value = 0x1000, .parameters = &[_]OperandKind{} },
                .{ .name = "OutputMemoryKHR", .value = 0x1000, .parameters = &[_]OperandKind{} },
                .{ .name = "MakeAvailable", .value = 0x2000, .parameters = &[_]OperandKind{} },
                .{ .name = "MakeAvailableKHR", .value = 0x2000, .parameters = &[_]OperandKind{} },
                .{ .name = "MakeVisible", .value = 0x4000, .parameters = &[_]OperandKind{} },
                .{ .name = "MakeVisibleKHR", .value = 0x4000, .parameters = &[_]OperandKind{} },
                .{ .name = "Volatile", .value = 0x8000, .parameters = &[_]OperandKind{} },
            },
            .MemoryAccess => &[_]Enumerant{
                .{ .name = "Volatile", .value = 0x0001, .parameters = &[_]OperandKind{} },
                .{ .name = "Aligned", .value = 0x0002, .parameters = &[_]OperandKind{.LiteralInteger} },
                .{ .name = "Nontemporal", .value = 0x0004, .parameters = &[_]OperandKind{} },
                .{ .name = "MakePointerAvailable", .value = 0x0008, .parameters = &[_]OperandKind{.IdScope} },
                .{ .name = "MakePointerAvailableKHR", .value = 0x0008, .parameters = &[_]OperandKind{.IdScope} },
                .{ .name = "MakePointerVisible", .value = 0x0010, .parameters = &[_]OperandKind{.IdScope} },
                .{ .name = "MakePointerVisibleKHR", .value = 0x0010, .parameters = &[_]OperandKind{.IdScope} },
                .{ .name = "NonPrivatePointer", .value = 0x0020, .parameters = &[_]OperandKind{} },
                .{ .name = "NonPrivatePointerKHR", .value = 0x0020, .parameters = &[_]OperandKind{} },
                .{ .name = "AliasScopeINTELMask", .value = 0x10000, .parameters = &[_]OperandKind{.IdRef} },
                .{ .name = "NoAliasINTELMask", .value = 0x20000, .parameters = &[_]OperandKind{.IdRef} },
            },
            .KernelProfilingInfo => &[_]Enumerant{
                .{ .name = "CmdExecTime", .value = 0x0001, .parameters = &[_]OperandKind{} },
            },
            .RayFlags => &[_]Enumerant{
                .{ .name = "NoneKHR", .value = 0x0000, .parameters = &[_]OperandKind{} },
                .{ .name = "OpaqueKHR", .value = 0x0001, .parameters = &[_]OperandKind{} },
                .{ .name = "NoOpaqueKHR", .value = 0x0002, .parameters = &[_]OperandKind{} },
                .{ .name = "TerminateOnFirstHitKHR", .value = 0x0004, .parameters = &[_]OperandKind{} },
                .{ .name = "SkipClosestHitShaderKHR", .value = 0x0008, .parameters = &[_]OperandKind{} },
                .{ .name = "CullBackFacingTrianglesKHR", .value = 0x0010, .parameters = &[_]OperandKind{} },
                .{ .name = "CullFrontFacingTrianglesKHR", .value = 0x0020, .parameters = &[_]OperandKind{} },
                .{ .name = "CullOpaqueKHR", .value = 0x0040, .parameters = &[_]OperandKind{} },
                .{ .name = "CullNoOpaqueKHR", .value = 0x0080, .parameters = &[_]OperandKind{} },
                .{ .name = "SkipTrianglesKHR", .value = 0x0100, .parameters = &[_]OperandKind{} },
                .{ .name = "SkipAABBsKHR", .value = 0x0200, .parameters = &[_]OperandKind{} },
                .{ .name = "ForceOpacityMicromap2StateEXT", .value = 0x0400, .parameters = &[_]OperandKind{} },
            },
            .FragmentShadingRate => &[_]Enumerant{
                .{ .name = "Vertical2Pixels", .value = 0x0001, .parameters = &[_]OperandKind{} },
                .{ .name = "Vertical4Pixels", .value = 0x0002, .parameters = &[_]OperandKind{} },
                .{ .name = "Horizontal2Pixels", .value = 0x0004, .parameters = &[_]OperandKind{} },
                .{ .name = "Horizontal4Pixels", .value = 0x0008, .parameters = &[_]OperandKind{} },
            },
            .RawAccessChainOperands => &[_]Enumerant{
                .{ .name = "RobustnessPerComponentNV", .value = 0x0001, .parameters = &[_]OperandKind{} },
                .{ .name = "RobustnessPerElementNV", .value = 0x0002, .parameters = &[_]OperandKind{} },
            },
            .SourceLanguage => &[_]Enumerant{
                .{ .name = "Unknown", .value = 0, .parameters = &[_]OperandKind{} },
                .{ .name = "ESSL", .value = 1, .parameters = &[_]OperandKind{} },
                .{ .name = "GLSL", .value = 2, .parameters = &[_]OperandKind{} },
                .{ .name = "OpenCL_C", .value = 3, .parameters = &[_]OperandKind{} },
                .{ .name = "OpenCL_CPP", .value = 4, .parameters = &[_]OperandKind{} },
                .{ .name = "HLSL", .value = 5, .parameters = &[_]OperandKind{} },
                .{ .name = "CPP_for_OpenCL", .value = 6, .parameters = &[_]OperandKind{} },
                .{ .name = "SYCL", .value = 7, .parameters = &[_]OperandKind{} },
                .{ .name = "HERO_C", .value = 8, .parameters = &[_]OperandKind{} },
                .{ .name = "NZSL", .value = 9, .parameters = &[_]OperandKind{} },
                .{ .name = "WGSL", .value = 10, .parameters = &[_]OperandKind{} },
                .{ .name = "Slang", .value = 11, .parameters = &[_]OperandKind{} },
                .{ .name = "Zig", .value = 12, .parameters = &[_]OperandKind{} },
            },
            .ExecutionModel => &[_]Enumerant{
                .{ .name = "Vertex", .value = 0, .parameters = &[_]OperandKind{} },
                .{ .name = "TessellationControl", .value = 1, .parameters = &[_]OperandKind{} },
                .{ .name = "TessellationEvaluation", .value = 2, .parameters = &[_]OperandKind{} },
                .{ .name = "Geometry", .value = 3, .parameters = &[_]OperandKind{} },
                .{ .name = "Fragment", .value = 4, .parameters = &[_]OperandKind{} },
                .{ .name = "GLCompute", .value = 5, .parameters = &[_]OperandKind{} },
                .{ .name = "Kernel", .value = 6, .parameters = &[_]OperandKind{} },
                .{ .name = "TaskNV", .value = 5267, .parameters = &[_]OperandKind{} },
                .{ .name = "MeshNV", .value = 5268, .parameters = &[_]OperandKind{} },
                .{ .name = "RayGenerationNV", .value = 5313, .parameters = &[_]OperandKind{} },
                .{ .name = "RayGenerationKHR", .value = 5313, .parameters = &[_]OperandKind{} },
                .{ .name = "IntersectionNV", .value = 5314, .parameters = &[_]OperandKind{} },
                .{ .name = "IntersectionKHR", .value = 5314, .parameters = &[_]OperandKind{} },
                .{ .name = "AnyHitNV", .value = 5315, .parameters = &[_]OperandKind{} },
                .{ .name = "AnyHitKHR", .value = 5315, .parameters = &[_]OperandKind{} },
                .{ .name = "ClosestHitNV", .value = 5316, .parameters = &[_]OperandKind{} },
                .{ .name = "ClosestHitKHR", .value = 5316, .parameters = &[_]OperandKind{} },
                .{ .name = "MissNV", .value = 5317, .parameters = &[_]OperandKind{} },
                .{ .name = "MissKHR", .value = 5317, .parameters = &[_]OperandKind{} },
                .{ .name = "CallableNV", .value = 5318, .parameters = &[_]OperandKind{} },
                .{ .name = "CallableKHR", .value = 5318, .parameters = &[_]OperandKind{} },
                .{ .name = "TaskEXT", .value = 5364, .parameters = &[_]OperandKind{} },
                .{ .name = "MeshEXT", .value = 5365, .parameters = &[_]OperandKind{} },
            },
            .AddressingModel => &[_]Enumerant{
                .{ .name = "Logical", .value = 0, .parameters = &[_]OperandKind{} },
                .{ .name = "Physical32", .value = 1, .parameters = &[_]OperandKind{} },
                .{ .name = "Physical64", .value = 2, .parameters = &[_]OperandKind{} },
                .{ .name = "PhysicalStorageBuffer64", .value = 5348, .parameters = &[_]OperandKind{} },
                .{ .name = "PhysicalStorageBuffer64EXT", .value = 5348, .parameters = &[_]OperandKind{} },
            },
            .MemoryModel => &[_]Enumerant{
                .{ .name = "Simple", .value = 0, .parameters = &[_]OperandKind{} },
                .{ .name = "GLSL450", .value = 1, .parameters = &[_]OperandKind{} },
                .{ .name = "OpenCL", .value = 2, .parameters = &[_]OperandKind{} },
                .{ .name = "Vulkan", .value = 3, .parameters = &[_]OperandKind{} },
                .{ .name = "VulkanKHR", .value = 3, .parameters = &[_]OperandKind{} },
            },
            .ExecutionMode => &[_]Enumerant{
                .{ .name = "Invocations", .value = 0, .parameters = &[_]OperandKind{.LiteralInteger} },
                .{ .name = "SpacingEqual", .value = 1, .parameters = &[_]OperandKind{} },
                .{ .name = "SpacingFractionalEven", .value = 2, .parameters = &[_]OperandKind{} },
                .{ .name = "SpacingFractionalOdd", .value = 3, .parameters = &[_]OperandKind{} },
                .{ .name = "VertexOrderCw", .value = 4, .parameters = &[_]OperandKind{} },
                .{ .name = "VertexOrderCcw", .value = 5, .parameters = &[_]OperandKind{} },
                .{ .name = "PixelCenterInteger", .value = 6, .parameters = &[_]OperandKind{} },
                .{ .name = "OriginUpperLeft", .value = 7, .parameters = &[_]OperandKind{} },
                .{ .name = "OriginLowerLeft", .value = 8, .parameters = &[_]OperandKind{} },
                .{ .name = "EarlyFragmentTests", .value = 9, .parameters = &[_]OperandKind{} },
                .{ .name = "PointMode", .value = 10, .parameters = &[_]OperandKind{} },
                .{ .name = "Xfb", .value = 11, .parameters = &[_]OperandKind{} },
                .{ .name = "DepthReplacing", .value = 12, .parameters = &[_]OperandKind{} },
                .{ .name = "DepthGreater", .value = 14, .parameters = &[_]OperandKind{} },
                .{ .name = "DepthLess", .value = 15, .parameters = &[_]OperandKind{} },
                .{ .name = "DepthUnchanged", .value = 16, .parameters = &[_]OperandKind{} },
                .{ .name = "LocalSize", .value = 17, .parameters = &[_]OperandKind{ .LiteralInteger, .LiteralInteger, .LiteralInteger } },
                .{ .name = "LocalSizeHint", .value = 18, .parameters = &[_]OperandKind{ .LiteralInteger, .LiteralInteger, .LiteralInteger } },
                .{ .name = "InputPoints", .value = 19, .parameters = &[_]OperandKind{} },
                .{ .name = "InputLines", .value = 20, .parameters = &[_]OperandKind{} },
                .{ .name = "InputLinesAdjacency", .value = 21, .parameters = &[_]OperandKind{} },
                .{ .name = "Triangles", .value = 22, .parameters = &[_]OperandKind{} },
                .{ .name = "InputTrianglesAdjacency", .value = 23, .parameters = &[_]OperandKind{} },
                .{ .name = "Quads", .value = 24, .parameters = &[_]OperandKind{} },
                .{ .name = "Isolines", .value = 25, .parameters = &[_]OperandKind{} },
                .{ .name = "OutputVertices", .value = 26, .parameters = &[_]OperandKind{.LiteralInteger} },
                .{ .name = "OutputPoints", .value = 27, .parameters = &[_]OperandKind{} },
                .{ .name = "OutputLineStrip", .value = 28, .parameters = &[_]OperandKind{} },
                .{ .name = "OutputTriangleStrip", .value = 29, .parameters = &[_]OperandKind{} },
                .{ .name = "VecTypeHint", .value = 30, .parameters = &[_]OperandKind{.LiteralInteger} },
                .{ .name = "ContractionOff", .value = 31, .parameters = &[_]OperandKind{} },
                .{ .name = "Initializer", .value = 33, .parameters = &[_]OperandKind{} },
                .{ .name = "Finalizer", .value = 34, .parameters = &[_]OperandKind{} },
                .{ .name = "SubgroupSize", .value = 35, .parameters = &[_]OperandKind{.LiteralInteger} },
                .{ .name = "SubgroupsPerWorkgroup", .value = 36, .parameters = &[_]OperandKind{.LiteralInteger} },
                .{ .name = "SubgroupsPerWorkgroupId", .value = 37, .parameters = &[_]OperandKind{.IdRef} },
                .{ .name = "LocalSizeId", .value = 38, .parameters = &[_]OperandKind{ .IdRef, .IdRef, .IdRef } },
                .{ .name = "LocalSizeHintId", .value = 39, .parameters = &[_]OperandKind{ .IdRef, .IdRef, .IdRef } },
                .{ .name = "NonCoherentColorAttachmentReadEXT", .value = 4169, .parameters = &[_]OperandKind{} },
                .{ .name = "NonCoherentDepthAttachmentReadEXT", .value = 4170, .parameters = &[_]OperandKind{} },
                .{ .name = "NonCoherentStencilAttachmentReadEXT", .value = 4171, .parameters = &[_]OperandKind{} },
                .{ .name = "SubgroupUniformControlFlowKHR", .value = 4421, .parameters = &[_]OperandKind{} },
                .{ .name = "PostDepthCoverage", .value = 4446, .parameters = &[_]OperandKind{} },
                .{ .name = "DenormPreserve", .value = 4459, .parameters = &[_]OperandKind{.LiteralInteger} },
                .{ .name = "DenormFlushToZero", .value = 4460, .parameters = &[_]OperandKind{.LiteralInteger} },
                .{ .name = "SignedZeroInfNanPreserve", .value = 4461, .parameters = &[_]OperandKind{.LiteralInteger} },
                .{ .name = "RoundingModeRTE", .value = 4462, .parameters = &[_]OperandKind{.LiteralInteger} },
                .{ .name = "RoundingModeRTZ", .value = 4463, .parameters = &[_]OperandKind{.LiteralInteger} },
                .{ .name = "EarlyAndLateFragmentTestsAMD", .value = 5017, .parameters = &[_]OperandKind{} },
                .{ .name = "StencilRefReplacingEXT", .value = 5027, .parameters = &[_]OperandKind{} },
                .{ .name = "CoalescingAMDX", .value = 5069, .parameters = &[_]OperandKind{} },
                .{ .name = "MaxNodeRecursionAMDX", .value = 5071, .parameters = &[_]OperandKind{.IdRef} },
                .{ .name = "StaticNumWorkgroupsAMDX", .value = 5072, .parameters = &[_]OperandKind{ .IdRef, .IdRef, .IdRef } },
                .{ .name = "ShaderIndexAMDX", .value = 5073, .parameters = &[_]OperandKind{.IdRef} },
                .{ .name = "MaxNumWorkgroupsAMDX", .value = 5077, .parameters = &[_]OperandKind{ .IdRef, .IdRef, .IdRef } },
                .{ .name = "StencilRefUnchangedFrontAMD", .value = 5079, .parameters = &[_]OperandKind{} },
                .{ .name = "StencilRefGreaterFrontAMD", .value = 5080, .parameters = &[_]OperandKind{} },
                .{ .name = "StencilRefLessFrontAMD", .value = 5081, .parameters = &[_]OperandKind{} },
                .{ .name = "StencilRefUnchangedBackAMD", .value = 5082, .parameters = &[_]OperandKind{} },
                .{ .name = "StencilRefGreaterBackAMD", .value = 5083, .parameters = &[_]OperandKind{} },
                .{ .name = "StencilRefLessBackAMD", .value = 5084, .parameters = &[_]OperandKind{} },
                .{ .name = "QuadDerivativesKHR", .value = 5088, .parameters = &[_]OperandKind{} },
                .{ .name = "RequireFullQuadsKHR", .value = 5089, .parameters = &[_]OperandKind{} },
                .{ .name = "OutputLinesNV", .value = 5269, .parameters = &[_]OperandKind{} },
                .{ .name = "OutputLinesEXT", .value = 5269, .parameters = &[_]OperandKind{} },
                .{ .name = "OutputPrimitivesNV", .value = 5270, .parameters = &[_]OperandKind{.LiteralInteger} },
                .{ .name = "OutputPrimitivesEXT", .value = 5270, .parameters = &[_]OperandKind{.LiteralInteger} },
                .{ .name = "DerivativeGroupQuadsNV", .value = 5289, .parameters = &[_]OperandKind{} },
                .{ .name = "DerivativeGroupLinearNV", .value = 5290, .parameters = &[_]OperandKind{} },
                .{ .name = "OutputTrianglesNV", .value = 5298, .parameters = &[_]OperandKind{} },
                .{ .name = "OutputTrianglesEXT", .value = 5298, .parameters = &[_]OperandKind{} },
                .{ .name = "PixelInterlockOrderedEXT", .value = 5366, .parameters = &[_]OperandKind{} },
                .{ .name = "PixelInterlockUnorderedEXT", .value = 5367, .parameters = &[_]OperandKind{} },
                .{ .name = "SampleInterlockOrderedEXT", .value = 5368, .parameters = &[_]OperandKind{} },
                .{ .name = "SampleInterlockUnorderedEXT", .value = 5369, .parameters = &[_]OperandKind{} },
                .{ .name = "ShadingRateInterlockOrderedEXT", .value = 5370, .parameters = &[_]OperandKind{} },
                .{ .name = "ShadingRateInterlockUnorderedEXT", .value = 5371, .parameters = &[_]OperandKind{} },
                .{ .name = "SharedLocalMemorySizeINTEL", .value = 5618, .parameters = &[_]OperandKind{.LiteralInteger} },
                .{ .name = "RoundingModeRTPINTEL", .value = 5620, .parameters = &[_]OperandKind{.LiteralInteger} },
                .{ .name = "RoundingModeRTNINTEL", .value = 5621, .parameters = &[_]OperandKind{.LiteralInteger} },
                .{ .name = "FloatingPointModeALTINTEL", .value = 5622, .parameters = &[_]OperandKind{.LiteralInteger} },
                .{ .name = "FloatingPointModeIEEEINTEL", .value = 5623, .parameters = &[_]OperandKind{.LiteralInteger} },
                .{ .name = "MaxWorkgroupSizeINTEL", .value = 5893, .parameters = &[_]OperandKind{ .LiteralInteger, .LiteralInteger, .LiteralInteger } },
                .{ .name = "MaxWorkDimINTEL", .value = 5894, .parameters = &[_]OperandKind{.LiteralInteger} },
                .{ .name = "NoGlobalOffsetINTEL", .value = 5895, .parameters = &[_]OperandKind{} },
                .{ .name = "NumSIMDWorkitemsINTEL", .value = 5896, .parameters = &[_]OperandKind{.LiteralInteger} },
                .{ .name = "SchedulerTargetFmaxMhzINTEL", .value = 5903, .parameters = &[_]OperandKind{.LiteralInteger} },
                .{ .name = "MaximallyReconvergesKHR", .value = 6023, .parameters = &[_]OperandKind{} },
                .{ .name = "FPFastMathDefault", .value = 6028, .parameters = &[_]OperandKind{ .IdRef, .IdRef } },
                .{ .name = "StreamingInterfaceINTEL", .value = 6154, .parameters = &[_]OperandKind{.LiteralInteger} },
                .{ .name = "RegisterMapInterfaceINTEL", .value = 6160, .parameters = &[_]OperandKind{.LiteralInteger} },
                .{ .name = "NamedBarrierCountINTEL", .value = 6417, .parameters = &[_]OperandKind{.LiteralInteger} },
                .{ .name = "MaximumRegistersINTEL", .value = 6461, .parameters = &[_]OperandKind{.LiteralInteger} },
                .{ .name = "MaximumRegistersIdINTEL", .value = 6462, .parameters = &[_]OperandKind{.IdRef} },
                .{ .name = "NamedMaximumRegistersINTEL", .value = 6463, .parameters = &[_]OperandKind{.NamedMaximumNumberOfRegisters} },
            },
            .StorageClass => &[_]Enumerant{
                .{ .name = "UniformConstant", .value = 0, .parameters = &[_]OperandKind{} },
                .{ .name = "Input", .value = 1, .parameters = &[_]OperandKind{} },
                .{ .name = "Uniform", .value = 2, .parameters = &[_]OperandKind{} },
                .{ .name = "Output", .value = 3, .parameters = &[_]OperandKind{} },
                .{ .name = "Workgroup", .value = 4, .parameters = &[_]OperandKind{} },
                .{ .name = "CrossWorkgroup", .value = 5, .parameters = &[_]OperandKind{} },
                .{ .name = "Private", .value = 6, .parameters = &[_]OperandKind{} },
                .{ .name = "Function", .value = 7, .parameters = &[_]OperandKind{} },
                .{ .name = "Generic", .value = 8, .parameters = &[_]OperandKind{} },
                .{ .name = "PushConstant", .value = 9, .parameters = &[_]OperandKind{} },
                .{ .name = "AtomicCounter", .value = 10, .parameters = &[_]OperandKind{} },
                .{ .name = "Image", .value = 11, .parameters = &[_]OperandKind{} },
                .{ .name = "StorageBuffer", .value = 12, .parameters = &[_]OperandKind{} },
                .{ .name = "TileImageEXT", .value = 4172, .parameters = &[_]OperandKind{} },
                .{ .name = "NodePayloadAMDX", .value = 5068, .parameters = &[_]OperandKind{} },
                .{ .name = "NodeOutputPayloadAMDX", .value = 5076, .parameters = &[_]OperandKind{} },
                .{ .name = "CallableDataNV", .value = 5328, .parameters = &[_]OperandKind{} },
                .{ .name = "CallableDataKHR", .value = 5328, .parameters = &[_]OperandKind{} },
                .{ .name = "IncomingCallableDataNV", .value = 5329, .parameters = &[_]OperandKind{} },
                .{ .name = "IncomingCallableDataKHR", .value = 5329, .parameters = &[_]OperandKind{} },
                .{ .name = "RayPayloadNV", .value = 5338, .parameters = &[_]OperandKind{} },
                .{ .name = "RayPayloadKHR", .value = 5338, .parameters = &[_]OperandKind{} },
                .{ .name = "HitAttributeNV", .value = 5339, .parameters = &[_]OperandKind{} },
                .{ .name = "HitAttributeKHR", .value = 5339, .parameters = &[_]OperandKind{} },
                .{ .name = "IncomingRayPayloadNV", .value = 5342, .parameters = &[_]OperandKind{} },
                .{ .name = "IncomingRayPayloadKHR", .value = 5342, .parameters = &[_]OperandKind{} },
                .{ .name = "ShaderRecordBufferNV", .value = 5343, .parameters = &[_]OperandKind{} },
                .{ .name = "ShaderRecordBufferKHR", .value = 5343, .parameters = &[_]OperandKind{} },
                .{ .name = "PhysicalStorageBuffer", .value = 5349, .parameters = &[_]OperandKind{} },
                .{ .name = "PhysicalStorageBufferEXT", .value = 5349, .parameters = &[_]OperandKind{} },
                .{ .name = "HitObjectAttributeNV", .value = 5385, .parameters = &[_]OperandKind{} },
                .{ .name = "TaskPayloadWorkgroupEXT", .value = 5402, .parameters = &[_]OperandKind{} },
                .{ .name = "CodeSectionINTEL", .value = 5605, .parameters = &[_]OperandKind{} },
                .{ .name = "DeviceOnlyINTEL", .value = 5936, .parameters = &[_]OperandKind{} },
                .{ .name = "HostOnlyINTEL", .value = 5937, .parameters = &[_]OperandKind{} },
            },
            .Dim => &[_]Enumerant{
                .{ .name = "1D", .value = 0, .parameters = &[_]OperandKind{} },
                .{ .name = "2D", .value = 1, .parameters = &[_]OperandKind{} },
                .{ .name = "3D", .value = 2, .parameters = &[_]OperandKind{} },
                .{ .name = "Cube", .value = 3, .parameters = &[_]OperandKind{} },
                .{ .name = "Rect", .value = 4, .parameters = &[_]OperandKind{} },
                .{ .name = "Buffer", .value = 5, .parameters = &[_]OperandKind{} },
                .{ .name = "SubpassData", .value = 6, .parameters = &[_]OperandKind{} },
                .{ .name = "TileImageDataEXT", .value = 4173, .parameters = &[_]OperandKind{} },
            },
            .SamplerAddressingMode => &[_]Enumerant{
                .{ .name = "None", .value = 0, .parameters = &[_]OperandKind{} },
                .{ .name = "ClampToEdge", .value = 1, .parameters = &[_]OperandKind{} },
                .{ .name = "Clamp", .value = 2, .parameters = &[_]OperandKind{} },
                .{ .name = "Repeat", .value = 3, .parameters = &[_]OperandKind{} },
                .{ .name = "RepeatMirrored", .value = 4, .parameters = &[_]OperandKind{} },
            },
            .SamplerFilterMode => &[_]Enumerant{
                .{ .name = "Nearest", .value = 0, .parameters = &[_]OperandKind{} },
                .{ .name = "Linear", .value = 1, .parameters = &[_]OperandKind{} },
            },
            .ImageFormat => &[_]Enumerant{
                .{ .name = "Unknown", .value = 0, .parameters = &[_]OperandKind{} },
                .{ .name = "Rgba32f", .value = 1, .parameters = &[_]OperandKind{} },
                .{ .name = "Rgba16f", .value = 2, .parameters = &[_]OperandKind{} },
                .{ .name = "R32f", .value = 3, .parameters = &[_]OperandKind{} },
                .{ .name = "Rgba8", .value = 4, .parameters = &[_]OperandKind{} },
                .{ .name = "Rgba8Snorm", .value = 5, .parameters = &[_]OperandKind{} },
                .{ .name = "Rg32f", .value = 6, .parameters = &[_]OperandKind{} },
                .{ .name = "Rg16f", .value = 7, .parameters = &[_]OperandKind{} },
                .{ .name = "R11fG11fB10f", .value = 8, .parameters = &[_]OperandKind{} },
                .{ .name = "R16f", .value = 9, .parameters = &[_]OperandKind{} },
                .{ .name = "Rgba16", .value = 10, .parameters = &[_]OperandKind{} },
                .{ .name = "Rgb10A2", .value = 11, .parameters = &[_]OperandKind{} },
                .{ .name = "Rg16", .value = 12, .parameters = &[_]OperandKind{} },
                .{ .name = "Rg8", .value = 13, .parameters = &[_]OperandKind{} },
                .{ .name = "R16", .value = 14, .parameters = &[_]OperandKind{} },
                .{ .name = "R8", .value = 15, .parameters = &[_]OperandKind{} },
                .{ .name = "Rgba16Snorm", .value = 16, .parameters = &[_]OperandKind{} },
                .{ .name = "Rg16Snorm", .value = 17, .parameters = &[_]OperandKind{} },
                .{ .name = "Rg8Snorm", .value = 18, .parameters = &[_]OperandKind{} },
                .{ .name = "R16Snorm", .value = 19, .parameters = &[_]OperandKind{} },
                .{ .name = "R8Snorm", .value = 20, .parameters = &[_]OperandKind{} },
                .{ .name = "Rgba32i", .value = 21, .parameters = &[_]OperandKind{} },
                .{ .name = "Rgba16i", .value = 22, .parameters = &[_]OperandKind{} },
                .{ .name = "Rgba8i", .value = 23, .parameters = &[_]OperandKind{} },
                .{ .name = "R32i", .value = 24, .parameters = &[_]OperandKind{} },
                .{ .name = "Rg32i", .value = 25, .parameters = &[_]OperandKind{} },
                .{ .name = "Rg16i", .value = 26, .parameters = &[_]OperandKind{} },
                .{ .name = "Rg8i", .value = 27, .parameters = &[_]OperandKind{} },
                .{ .name = "R16i", .value = 28, .parameters = &[_]OperandKind{} },
                .{ .name = "R8i", .value = 29, .parameters = &[_]OperandKind{} },
                .{ .name = "Rgba32ui", .value = 30, .parameters = &[_]OperandKind{} },
                .{ .name = "Rgba16ui", .value = 31, .parameters = &[_]OperandKind{} },
                .{ .name = "Rgba8ui", .value = 32, .parameters = &[_]OperandKind{} },
                .{ .name = "R32ui", .value = 33, .parameters = &[_]OperandKind{} },
                .{ .name = "Rgb10a2ui", .value = 34, .parameters = &[_]OperandKind{} },
                .{ .name = "Rg32ui", .value = 35, .parameters = &[_]OperandKind{} },
                .{ .name = "Rg16ui", .value = 36, .parameters = &[_]OperandKind{} },
                .{ .name = "Rg8ui", .value = 37, .parameters = &[_]OperandKind{} },
                .{ .name = "R16ui", .value = 38, .parameters = &[_]OperandKind{} },
                .{ .name = "R8ui", .value = 39, .parameters = &[_]OperandKind{} },
                .{ .name = "R64ui", .value = 40, .parameters = &[_]OperandKind{} },
                .{ .name = "R64i", .value = 41, .parameters = &[_]OperandKind{} },
            },
            .ImageChannelOrder => &[_]Enumerant{
                .{ .name = "R", .value = 0, .parameters = &[_]OperandKind{} },
                .{ .name = "A", .value = 1, .parameters = &[_]OperandKind{} },
                .{ .name = "RG", .value = 2, .parameters = &[_]OperandKind{} },
                .{ .name = "RA", .value = 3, .parameters = &[_]OperandKind{} },
                .{ .name = "RGB", .value = 4, .parameters = &[_]OperandKind{} },
                .{ .name = "RGBA", .value = 5, .parameters = &[_]OperandKind{} },
                .{ .name = "BGRA", .value = 6, .parameters = &[_]OperandKind{} },
                .{ .name = "ARGB", .value = 7, .parameters = &[_]OperandKind{} },
                .{ .name = "Intensity", .value = 8, .parameters = &[_]OperandKind{} },
                .{ .name = "Luminance", .value = 9, .parameters = &[_]OperandKind{} },
                .{ .name = "Rx", .value = 10, .parameters = &[_]OperandKind{} },
                .{ .name = "RGx", .value = 11, .parameters = &[_]OperandKind{} },
                .{ .name = "RGBx", .value = 12, .parameters = &[_]OperandKind{} },
                .{ .name = "Depth", .value = 13, .parameters = &[_]OperandKind{} },
                .{ .name = "DepthStencil", .value = 14, .parameters = &[_]OperandKind{} },
                .{ .name = "sRGB", .value = 15, .parameters = &[_]OperandKind{} },
                .{ .name = "sRGBx", .value = 16, .parameters = &[_]OperandKind{} },
                .{ .name = "sRGBA", .value = 17, .parameters = &[_]OperandKind{} },
                .{ .name = "sBGRA", .value = 18, .parameters = &[_]OperandKind{} },
                .{ .name = "ABGR", .value = 19, .parameters = &[_]OperandKind{} },
            },
            .ImageChannelDataType => &[_]Enumerant{
                .{ .name = "SnormInt8", .value = 0, .parameters = &[_]OperandKind{} },
                .{ .name = "SnormInt16", .value = 1, .parameters = &[_]OperandKind{} },
                .{ .name = "UnormInt8", .value = 2, .parameters = &[_]OperandKind{} },
                .{ .name = "UnormInt16", .value = 3, .parameters = &[_]OperandKind{} },
                .{ .name = "UnormShort565", .value = 4, .parameters = &[_]OperandKind{} },
                .{ .name = "UnormShort555", .value = 5, .parameters = &[_]OperandKind{} },
                .{ .name = "UnormInt101010", .value = 6, .parameters = &[_]OperandKind{} },
                .{ .name = "SignedInt8", .value = 7, .parameters = &[_]OperandKind{} },
                .{ .name = "SignedInt16", .value = 8, .parameters = &[_]OperandKind{} },
                .{ .name = "SignedInt32", .value = 9, .parameters = &[_]OperandKind{} },
                .{ .name = "UnsignedInt8", .value = 10, .parameters = &[_]OperandKind{} },
                .{ .name = "UnsignedInt16", .value = 11, .parameters = &[_]OperandKind{} },
                .{ .name = "UnsignedInt32", .value = 12, .parameters = &[_]OperandKind{} },
                .{ .name = "HalfFloat", .value = 13, .parameters = &[_]OperandKind{} },
                .{ .name = "Float", .value = 14, .parameters = &[_]OperandKind{} },
                .{ .name = "UnormInt24", .value = 15, .parameters = &[_]OperandKind{} },
                .{ .name = "UnormInt101010_2", .value = 16, .parameters = &[_]OperandKind{} },
                .{ .name = "UnsignedIntRaw10EXT", .value = 19, .parameters = &[_]OperandKind{} },
                .{ .name = "UnsignedIntRaw12EXT", .value = 20, .parameters = &[_]OperandKind{} },
            },
            .FPRoundingMode => &[_]Enumerant{
                .{ .name = "RTE", .value = 0, .parameters = &[_]OperandKind{} },
                .{ .name = "RTZ", .value = 1, .parameters = &[_]OperandKind{} },
                .{ .name = "RTP", .value = 2, .parameters = &[_]OperandKind{} },
                .{ .name = "RTN", .value = 3, .parameters = &[_]OperandKind{} },
            },
            .FPDenormMode => &[_]Enumerant{
                .{ .name = "Preserve", .value = 0, .parameters = &[_]OperandKind{} },
                .{ .name = "FlushToZero", .value = 1, .parameters = &[_]OperandKind{} },
            },
            .QuantizationModes => &[_]Enumerant{
                .{ .name = "TRN", .value = 0, .parameters = &[_]OperandKind{} },
                .{ .name = "TRN_ZERO", .value = 1, .parameters = &[_]OperandKind{} },
                .{ .name = "RND", .value = 2, .parameters = &[_]OperandKind{} },
                .{ .name = "RND_ZERO", .value = 3, .parameters = &[_]OperandKind{} },
                .{ .name = "RND_INF", .value = 4, .parameters = &[_]OperandKind{} },
                .{ .name = "RND_MIN_INF", .value = 5, .parameters = &[_]OperandKind{} },
                .{ .name = "RND_CONV", .value = 6, .parameters = &[_]OperandKind{} },
                .{ .name = "RND_CONV_ODD", .value = 7, .parameters = &[_]OperandKind{} },
            },
            .FPOperationMode => &[_]Enumerant{
                .{ .name = "IEEE", .value = 0, .parameters = &[_]OperandKind{} },
                .{ .name = "ALT", .value = 1, .parameters = &[_]OperandKind{} },
            },
            .OverflowModes => &[_]Enumerant{
                .{ .name = "WRAP", .value = 0, .parameters = &[_]OperandKind{} },
                .{ .name = "SAT", .value = 1, .parameters = &[_]OperandKind{} },
                .{ .name = "SAT_ZERO", .value = 2, .parameters = &[_]OperandKind{} },
                .{ .name = "SAT_SYM", .value = 3, .parameters = &[_]OperandKind{} },
            },
            .LinkageType => &[_]Enumerant{
                .{ .name = "Export", .value = 0, .parameters = &[_]OperandKind{} },
                .{ .name = "Import", .value = 1, .parameters = &[_]OperandKind{} },
                .{ .name = "LinkOnceODR", .value = 2, .parameters = &[_]OperandKind{} },
            },
            .AccessQualifier => &[_]Enumerant{
                .{ .name = "ReadOnly", .value = 0, .parameters = &[_]OperandKind{} },
                .{ .name = "WriteOnly", .value = 1, .parameters = &[_]OperandKind{} },
                .{ .name = "ReadWrite", .value = 2, .parameters = &[_]OperandKind{} },
            },
            .HostAccessQualifier => &[_]Enumerant{
                .{ .name = "NoneINTEL", .value = 0, .parameters = &[_]OperandKind{} },
                .{ .name = "ReadINTEL", .value = 1, .parameters = &[_]OperandKind{} },
                .{ .name = "WriteINTEL", .value = 2, .parameters = &[_]OperandKind{} },
                .{ .name = "ReadWriteINTEL", .value = 3, .parameters = &[_]OperandKind{} },
            },
            .FunctionParameterAttribute => &[_]Enumerant{
                .{ .name = "Zext", .value = 0, .parameters = &[_]OperandKind{} },
                .{ .name = "Sext", .value = 1, .parameters = &[_]OperandKind{} },
                .{ .name = "ByVal", .value = 2, .parameters = &[_]OperandKind{} },
                .{ .name = "Sret", .value = 3, .parameters = &[_]OperandKind{} },
                .{ .name = "NoAlias", .value = 4, .parameters = &[_]OperandKind{} },
                .{ .name = "NoCapture", .value = 5, .parameters = &[_]OperandKind{} },
                .{ .name = "NoWrite", .value = 6, .parameters = &[_]OperandKind{} },
                .{ .name = "NoReadWrite", .value = 7, .parameters = &[_]OperandKind{} },
                .{ .name = "RuntimeAlignedINTEL", .value = 5940, .parameters = &[_]OperandKind{} },
            },
            .Decoration => &[_]Enumerant{
                .{ .name = "RelaxedPrecision", .value = 0, .parameters = &[_]OperandKind{} },
                .{ .name = "SpecId", .value = 1, .parameters = &[_]OperandKind{.LiteralInteger} },
                .{ .name = "Block", .value = 2, .parameters = &[_]OperandKind{} },
                .{ .name = "BufferBlock", .value = 3, .parameters = &[_]OperandKind{} },
                .{ .name = "RowMajor", .value = 4, .parameters = &[_]OperandKind{} },
                .{ .name = "ColMajor", .value = 5, .parameters = &[_]OperandKind{} },
                .{ .name = "ArrayStride", .value = 6, .parameters = &[_]OperandKind{.LiteralInteger} },
                .{ .name = "MatrixStride", .value = 7, .parameters = &[_]OperandKind{.LiteralInteger} },
                .{ .name = "GLSLShared", .value = 8, .parameters = &[_]OperandKind{} },
                .{ .name = "GLSLPacked", .value = 9, .parameters = &[_]OperandKind{} },
                .{ .name = "CPacked", .value = 10, .parameters = &[_]OperandKind{} },
                .{ .name = "BuiltIn", .value = 11, .parameters = &[_]OperandKind{.BuiltIn} },
                .{ .name = "NoPerspective", .value = 13, .parameters = &[_]OperandKind{} },
                .{ .name = "Flat", .value = 14, .parameters = &[_]OperandKind{} },
                .{ .name = "Patch", .value = 15, .parameters = &[_]OperandKind{} },
                .{ .name = "Centroid", .value = 16, .parameters = &[_]OperandKind{} },
                .{ .name = "Sample", .value = 17, .parameters = &[_]OperandKind{} },
                .{ .name = "Invariant", .value = 18, .parameters = &[_]OperandKind{} },
                .{ .name = "Restrict", .value = 19, .parameters = &[_]OperandKind{} },
                .{ .name = "Aliased", .value = 20, .parameters = &[_]OperandKind{} },
                .{ .name = "Volatile", .value = 21, .parameters = &[_]OperandKind{} },
                .{ .name = "Constant", .value = 22, .parameters = &[_]OperandKind{} },
                .{ .name = "Coherent", .value = 23, .parameters = &[_]OperandKind{} },
                .{ .name = "NonWritable", .value = 24, .parameters = &[_]OperandKind{} },
                .{ .name = "NonReadable", .value = 25, .parameters = &[_]OperandKind{} },
                .{ .name = "Uniform", .value = 26, .parameters = &[_]OperandKind{} },
                .{ .name = "UniformId", .value = 27, .parameters = &[_]OperandKind{.IdScope} },
                .{ .name = "SaturatedConversion", .value = 28, .parameters = &[_]OperandKind{} },
                .{ .name = "Stream", .value = 29, .parameters = &[_]OperandKind{.LiteralInteger} },
                .{ .name = "Location", .value = 30, .parameters = &[_]OperandKind{.LiteralInteger} },
                .{ .name = "Component", .value = 31, .parameters = &[_]OperandKind{.LiteralInteger} },
                .{ .name = "Index", .value = 32, .parameters = &[_]OperandKind{.LiteralInteger} },
                .{ .name = "Binding", .value = 33, .parameters = &[_]OperandKind{.LiteralInteger} },
                .{ .name = "DescriptorSet", .value = 34, .parameters = &[_]OperandKind{.LiteralInteger} },
                .{ .name = "Offset", .value = 35, .parameters = &[_]OperandKind{.LiteralInteger} },
                .{ .name = "XfbBuffer", .value = 36, .parameters = &[_]OperandKind{.LiteralInteger} },
                .{ .name = "XfbStride", .value = 37, .parameters = &[_]OperandKind{.LiteralInteger} },
                .{ .name = "FuncParamAttr", .value = 38, .parameters = &[_]OperandKind{.FunctionParameterAttribute} },
                .{ .name = "FPRoundingMode", .value = 39, .parameters = &[_]OperandKind{.FPRoundingMode} },
                .{ .name = "FPFastMathMode", .value = 40, .parameters = &[_]OperandKind{.FPFastMathMode} },
                .{ .name = "LinkageAttributes", .value = 41, .parameters = &[_]OperandKind{ .LiteralString, .LinkageType } },
                .{ .name = "NoContraction", .value = 42, .parameters = &[_]OperandKind{} },
                .{ .name = "InputAttachmentIndex", .value = 43, .parameters = &[_]OperandKind{.LiteralInteger} },
                .{ .name = "Alignment", .value = 44, .parameters = &[_]OperandKind{.LiteralInteger} },
                .{ .name = "MaxByteOffset", .value = 45, .parameters = &[_]OperandKind{.LiteralInteger} },
                .{ .name = "AlignmentId", .value = 46, .parameters = &[_]OperandKind{.IdRef} },
                .{ .name = "MaxByteOffsetId", .value = 47, .parameters = &[_]OperandKind{.IdRef} },
                .{ .name = "NoSignedWrap", .value = 4469, .parameters = &[_]OperandKind{} },
                .{ .name = "NoUnsignedWrap", .value = 4470, .parameters = &[_]OperandKind{} },
                .{ .name = "WeightTextureQCOM", .value = 4487, .parameters = &[_]OperandKind{} },
                .{ .name = "BlockMatchTextureQCOM", .value = 4488, .parameters = &[_]OperandKind{} },
                .{ .name = "BlockMatchSamplerQCOM", .value = 4499, .parameters = &[_]OperandKind{} },
                .{ .name = "ExplicitInterpAMD", .value = 4999, .parameters = &[_]OperandKind{} },
                .{ .name = "NodeSharesPayloadLimitsWithAMDX", .value = 5019, .parameters = &[_]OperandKind{.IdRef} },
                .{ .name = "NodeMaxPayloadsAMDX", .value = 5020, .parameters = &[_]OperandKind{.IdRef} },
                .{ .name = "TrackFinishWritingAMDX", .value = 5078, .parameters = &[_]OperandKind{} },
                .{ .name = "PayloadNodeNameAMDX", .value = 5091, .parameters = &[_]OperandKind{.LiteralString} },
                .{ .name = "OverrideCoverageNV", .value = 5248, .parameters = &[_]OperandKind{} },
                .{ .name = "PassthroughNV", .value = 5250, .parameters = &[_]OperandKind{} },
                .{ .name = "ViewportRelativeNV", .value = 5252, .parameters = &[_]OperandKind{} },
                .{ .name = "SecondaryViewportRelativeNV", .value = 5256, .parameters = &[_]OperandKind{.LiteralInteger} },
                .{ .name = "PerPrimitiveNV", .value = 5271, .parameters = &[_]OperandKind{} },
                .{ .name = "PerPrimitiveEXT", .value = 5271, .parameters = &[_]OperandKind{} },
                .{ .name = "PerViewNV", .value = 5272, .parameters = &[_]OperandKind{} },
                .{ .name = "PerTaskNV", .value = 5273, .parameters = &[_]OperandKind{} },
                .{ .name = "PerVertexKHR", .value = 5285, .parameters = &[_]OperandKind{} },
                .{ .name = "PerVertexNV", .value = 5285, .parameters = &[_]OperandKind{} },
                .{ .name = "NonUniform", .value = 5300, .parameters = &[_]OperandKind{} },
                .{ .name = "NonUniformEXT", .value = 5300, .parameters = &[_]OperandKind{} },
                .{ .name = "RestrictPointer", .value = 5355, .parameters = &[_]OperandKind{} },
                .{ .name = "RestrictPointerEXT", .value = 5355, .parameters = &[_]OperandKind{} },
                .{ .name = "AliasedPointer", .value = 5356, .parameters = &[_]OperandKind{} },
                .{ .name = "AliasedPointerEXT", .value = 5356, .parameters = &[_]OperandKind{} },
                .{ .name = "HitObjectShaderRecordBufferNV", .value = 5386, .parameters = &[_]OperandKind{} },
                .{ .name = "BindlessSamplerNV", .value = 5398, .parameters = &[_]OperandKind{} },
                .{ .name = "BindlessImageNV", .value = 5399, .parameters = &[_]OperandKind{} },
                .{ .name = "BoundSamplerNV", .value = 5400, .parameters = &[_]OperandKind{} },
                .{ .name = "BoundImageNV", .value = 5401, .parameters = &[_]OperandKind{} },
                .{ .name = "SIMTCallINTEL", .value = 5599, .parameters = &[_]OperandKind{.LiteralInteger} },
                .{ .name = "ReferencedIndirectlyINTEL", .value = 5602, .parameters = &[_]OperandKind{} },
                .{ .name = "ClobberINTEL", .value = 5607, .parameters = &[_]OperandKind{.LiteralString} },
                .{ .name = "SideEffectsINTEL", .value = 5608, .parameters = &[_]OperandKind{} },
                .{ .name = "VectorComputeVariableINTEL", .value = 5624, .parameters = &[_]OperandKind{} },
                .{ .name = "FuncParamIOKindINTEL", .value = 5625, .parameters = &[_]OperandKind{.LiteralInteger} },
                .{ .name = "VectorComputeFunctionINTEL", .value = 5626, .parameters = &[_]OperandKind{} },
                .{ .name = "StackCallINTEL", .value = 5627, .parameters = &[_]OperandKind{} },
                .{ .name = "GlobalVariableOffsetINTEL", .value = 5628, .parameters = &[_]OperandKind{.LiteralInteger} },
                .{ .name = "CounterBuffer", .value = 5634, .parameters = &[_]OperandKind{.IdRef} },
                .{ .name = "HlslCounterBufferGOOGLE", .value = 5634, .parameters = &[_]OperandKind{.IdRef} },
                .{ .name = "UserSemantic", .value = 5635, .parameters = &[_]OperandKind{.LiteralString} },
                .{ .name = "HlslSemanticGOOGLE", .value = 5635, .parameters = &[_]OperandKind{.LiteralString} },
                .{ .name = "UserTypeGOOGLE", .value = 5636, .parameters = &[_]OperandKind{.LiteralString} },
                .{ .name = "FunctionRoundingModeINTEL", .value = 5822, .parameters = &[_]OperandKind{ .LiteralInteger, .FPRoundingMode } },
                .{ .name = "FunctionDenormModeINTEL", .value = 5823, .parameters = &[_]OperandKind{ .LiteralInteger, .FPDenormMode } },
                .{ .name = "RegisterINTEL", .value = 5825, .parameters = &[_]OperandKind{} },
                .{ .name = "MemoryINTEL", .value = 5826, .parameters = &[_]OperandKind{.LiteralString} },
                .{ .name = "NumbanksINTEL", .value = 5827, .parameters = &[_]OperandKind{.LiteralInteger} },
                .{ .name = "BankwidthINTEL", .value = 5828, .parameters = &[_]OperandKind{.LiteralInteger} },
                .{ .name = "MaxPrivateCopiesINTEL", .value = 5829, .parameters = &[_]OperandKind{.LiteralInteger} },
                .{ .name = "SinglepumpINTEL", .value = 5830, .parameters = &[_]OperandKind{} },
                .{ .name = "DoublepumpINTEL", .value = 5831, .parameters = &[_]OperandKind{} },
                .{ .name = "MaxReplicatesINTEL", .value = 5832, .parameters = &[_]OperandKind{.LiteralInteger} },
                .{ .name = "SimpleDualPortINTEL", .value = 5833, .parameters = &[_]OperandKind{} },
                .{ .name = "MergeINTEL", .value = 5834, .parameters = &[_]OperandKind{ .LiteralString, .LiteralString } },
                .{ .name = "BankBitsINTEL", .value = 5835, .parameters = &[_]OperandKind{.LiteralInteger} },
                .{ .name = "ForcePow2DepthINTEL", .value = 5836, .parameters = &[_]OperandKind{.LiteralInteger} },
                .{ .name = "StridesizeINTEL", .value = 5883, .parameters = &[_]OperandKind{.LiteralInteger} },
                .{ .name = "WordsizeINTEL", .value = 5884, .parameters = &[_]OperandKind{.LiteralInteger} },
                .{ .name = "TrueDualPortINTEL", .value = 5885, .parameters = &[_]OperandKind{} },
                .{ .name = "BurstCoalesceINTEL", .value = 5899, .parameters = &[_]OperandKind{} },
                .{ .name = "CacheSizeINTEL", .value = 5900, .parameters = &[_]OperandKind{.LiteralInteger} },
                .{ .name = "DontStaticallyCoalesceINTEL", .value = 5901, .parameters = &[_]OperandKind{} },
                .{ .name = "PrefetchINTEL", .value = 5902, .parameters = &[_]OperandKind{.LiteralInteger} },
                .{ .name = "StallEnableINTEL", .value = 5905, .parameters = &[_]OperandKind{} },
                .{ .name = "FuseLoopsInFunctionINTEL", .value = 5907, .parameters = &[_]OperandKind{} },
                .{ .name = "MathOpDSPModeINTEL", .value = 5909, .parameters = &[_]OperandKind{ .LiteralInteger, .LiteralInteger } },
                .{ .name = "AliasScopeINTEL", .value = 5914, .parameters = &[_]OperandKind{.IdRef} },
                .{ .name = "NoAliasINTEL", .value = 5915, .parameters = &[_]OperandKind{.IdRef} },
                .{ .name = "InitiationIntervalINTEL", .value = 5917, .parameters = &[_]OperandKind{.LiteralInteger} },
                .{ .name = "MaxConcurrencyINTEL", .value = 5918, .parameters = &[_]OperandKind{.LiteralInteger} },
                .{ .name = "PipelineEnableINTEL", .value = 5919, .parameters = &[_]OperandKind{.LiteralInteger} },
                .{ .name = "BufferLocationINTEL", .value = 5921, .parameters = &[_]OperandKind{.LiteralInteger} },
                .{ .name = "IOPipeStorageINTEL", .value = 5944, .parameters = &[_]OperandKind{.LiteralInteger} },
                .{ .name = "FunctionFloatingPointModeINTEL", .value = 6080, .parameters = &[_]OperandKind{ .LiteralInteger, .FPOperationMode } },
                .{ .name = "SingleElementVectorINTEL", .value = 6085, .parameters = &[_]OperandKind{} },
                .{ .name = "VectorComputeCallableFunctionINTEL", .value = 6087, .parameters = &[_]OperandKind{} },
                .{ .name = "MediaBlockIOINTEL", .value = 6140, .parameters = &[_]OperandKind{} },
                .{ .name = "StallFreeINTEL", .value = 6151, .parameters = &[_]OperandKind{} },
                .{ .name = "FPMaxErrorDecorationINTEL", .value = 6170, .parameters = &[_]OperandKind{.LiteralFloat} },
                .{ .name = "LatencyControlLabelINTEL", .value = 6172, .parameters = &[_]OperandKind{.LiteralInteger} },
                .{ .name = "LatencyControlConstraintINTEL", .value = 6173, .parameters = &[_]OperandKind{ .LiteralInteger, .LiteralInteger, .LiteralInteger } },
                .{ .name = "ConduitKernelArgumentINTEL", .value = 6175, .parameters = &[_]OperandKind{} },
                .{ .name = "RegisterMapKernelArgumentINTEL", .value = 6176, .parameters = &[_]OperandKind{} },
                .{ .name = "MMHostInterfaceAddressWidthINTEL", .value = 6177, .parameters = &[_]OperandKind{.LiteralInteger} },
                .{ .name = "MMHostInterfaceDataWidthINTEL", .value = 6178, .parameters = &[_]OperandKind{.LiteralInteger} },
                .{ .name = "MMHostInterfaceLatencyINTEL", .value = 6179, .parameters = &[_]OperandKind{.LiteralInteger} },
                .{ .name = "MMHostInterfaceReadWriteModeINTEL", .value = 6180, .parameters = &[_]OperandKind{.AccessQualifier} },
                .{ .name = "MMHostInterfaceMaxBurstINTEL", .value = 6181, .parameters = &[_]OperandKind{.LiteralInteger} },
                .{ .name = "MMHostInterfaceWaitRequestINTEL", .value = 6182, .parameters = &[_]OperandKind{.LiteralInteger} },
                .{ .name = "StableKernelArgumentINTEL", .value = 6183, .parameters = &[_]OperandKind{} },
                .{ .name = "HostAccessINTEL", .value = 6188, .parameters = &[_]OperandKind{ .HostAccessQualifier, .LiteralString } },
                .{ .name = "InitModeINTEL", .value = 6190, .parameters = &[_]OperandKind{.InitializationModeQualifier} },
                .{ .name = "ImplementInRegisterMapINTEL", .value = 6191, .parameters = &[_]OperandKind{.LiteralInteger} },
                .{ .name = "CacheControlLoadINTEL", .value = 6442, .parameters = &[_]OperandKind{ .LiteralInteger, .LoadCacheControl } },
                .{ .name = "CacheControlStoreINTEL", .value = 6443, .parameters = &[_]OperandKind{ .LiteralInteger, .StoreCacheControl } },
            },
            .BuiltIn => &[_]Enumerant{
                .{ .name = "Position", .value = 0, .parameters = &[_]OperandKind{} },
                .{ .name = "PointSize", .value = 1, .parameters = &[_]OperandKind{} },
                .{ .name = "ClipDistance", .value = 3, .parameters = &[_]OperandKind{} },
                .{ .name = "CullDistance", .value = 4, .parameters = &[_]OperandKind{} },
                .{ .name = "VertexId", .value = 5, .parameters = &[_]OperandKind{} },
                .{ .name = "InstanceId", .value = 6, .parameters = &[_]OperandKind{} },
                .{ .name = "PrimitiveId", .value = 7, .parameters = &[_]OperandKind{} },
                .{ .name = "InvocationId", .value = 8, .parameters = &[_]OperandKind{} },
                .{ .name = "Layer", .value = 9, .parameters = &[_]OperandKind{} },
                .{ .name = "ViewportIndex", .value = 10, .parameters = &[_]OperandKind{} },
                .{ .name = "TessLevelOuter", .value = 11, .parameters = &[_]OperandKind{} },
                .{ .name = "TessLevelInner", .value = 12, .parameters = &[_]OperandKind{} },
                .{ .name = "TessCoord", .value = 13, .parameters = &[_]OperandKind{} },
                .{ .name = "PatchVertices", .value = 14, .parameters = &[_]OperandKind{} },
                .{ .name = "FragCoord", .value = 15, .parameters = &[_]OperandKind{} },
                .{ .name = "PointCoord", .value = 16, .parameters = &[_]OperandKind{} },
                .{ .name = "FrontFacing", .value = 17, .parameters = &[_]OperandKind{} },
                .{ .name = "SampleId", .value = 18, .parameters = &[_]OperandKind{} },
                .{ .name = "SamplePosition", .value = 19, .parameters = &[_]OperandKind{} },
                .{ .name = "SampleMask", .value = 20, .parameters = &[_]OperandKind{} },
                .{ .name = "FragDepth", .value = 22, .parameters = &[_]OperandKind{} },
                .{ .name = "HelperInvocation", .value = 23, .parameters = &[_]OperandKind{} },
                .{ .name = "NumWorkgroups", .value = 24, .parameters = &[_]OperandKind{} },
                .{ .name = "WorkgroupSize", .value = 25, .parameters = &[_]OperandKind{} },
                .{ .name = "WorkgroupId", .value = 26, .parameters = &[_]OperandKind{} },
                .{ .name = "LocalInvocationId", .value = 27, .parameters = &[_]OperandKind{} },
                .{ .name = "GlobalInvocationId", .value = 28, .parameters = &[_]OperandKind{} },
                .{ .name = "LocalInvocationIndex", .value = 29, .parameters = &[_]OperandKind{} },
                .{ .name = "WorkDim", .value = 30, .parameters = &[_]OperandKind{} },
                .{ .name = "GlobalSize", .value = 31, .parameters = &[_]OperandKind{} },
                .{ .name = "EnqueuedWorkgroupSize", .value = 32, .parameters = &[_]OperandKind{} },
                .{ .name = "GlobalOffset", .value = 33, .parameters = &[_]OperandKind{} },
                .{ .name = "GlobalLinearId", .value = 34, .parameters = &[_]OperandKind{} },
                .{ .name = "SubgroupSize", .value = 36, .parameters = &[_]OperandKind{} },
                .{ .name = "SubgroupMaxSize", .value = 37, .parameters = &[_]OperandKind{} },
                .{ .name = "NumSubgroups", .value = 38, .parameters = &[_]OperandKind{} },
                .{ .name = "NumEnqueuedSubgroups", .value = 39, .parameters = &[_]OperandKind{} },
                .{ .name = "SubgroupId", .value = 40, .parameters = &[_]OperandKind{} },
                .{ .name = "SubgroupLocalInvocationId", .value = 41, .parameters = &[_]OperandKind{} },
                .{ .name = "VertexIndex", .value = 42, .parameters = &[_]OperandKind{} },
                .{ .name = "InstanceIndex", .value = 43, .parameters = &[_]OperandKind{} },
                .{ .name = "CoreIDARM", .value = 4160, .parameters = &[_]OperandKind{} },
                .{ .name = "CoreCountARM", .value = 4161, .parameters = &[_]OperandKind{} },
                .{ .name = "CoreMaxIDARM", .value = 4162, .parameters = &[_]OperandKind{} },
                .{ .name = "WarpIDARM", .value = 4163, .parameters = &[_]OperandKind{} },
                .{ .name = "WarpMaxIDARM", .value = 4164, .parameters = &[_]OperandKind{} },
                .{ .name = "SubgroupEqMask", .value = 4416, .parameters = &[_]OperandKind{} },
                .{ .name = "SubgroupEqMaskKHR", .value = 4416, .parameters = &[_]OperandKind{} },
                .{ .name = "SubgroupGeMask", .value = 4417, .parameters = &[_]OperandKind{} },
                .{ .name = "SubgroupGeMaskKHR", .value = 4417, .parameters = &[_]OperandKind{} },
                .{ .name = "SubgroupGtMask", .value = 4418, .parameters = &[_]OperandKind{} },
                .{ .name = "SubgroupGtMaskKHR", .value = 4418, .parameters = &[_]OperandKind{} },
                .{ .name = "SubgroupLeMask", .value = 4419, .parameters = &[_]OperandKind{} },
                .{ .name = "SubgroupLeMaskKHR", .value = 4419, .parameters = &[_]OperandKind{} },
                .{ .name = "SubgroupLtMask", .value = 4420, .parameters = &[_]OperandKind{} },
                .{ .name = "SubgroupLtMaskKHR", .value = 4420, .parameters = &[_]OperandKind{} },
                .{ .name = "BaseVertex", .value = 4424, .parameters = &[_]OperandKind{} },
                .{ .name = "BaseInstance", .value = 4425, .parameters = &[_]OperandKind{} },
                .{ .name = "DrawIndex", .value = 4426, .parameters = &[_]OperandKind{} },
                .{ .name = "PrimitiveShadingRateKHR", .value = 4432, .parameters = &[_]OperandKind{} },
                .{ .name = "DeviceIndex", .value = 4438, .parameters = &[_]OperandKind{} },
                .{ .name = "ViewIndex", .value = 4440, .parameters = &[_]OperandKind{} },
                .{ .name = "ShadingRateKHR", .value = 4444, .parameters = &[_]OperandKind{} },
                .{ .name = "BaryCoordNoPerspAMD", .value = 4992, .parameters = &[_]OperandKind{} },
                .{ .name = "BaryCoordNoPerspCentroidAMD", .value = 4993, .parameters = &[_]OperandKind{} },
                .{ .name = "BaryCoordNoPerspSampleAMD", .value = 4994, .parameters = &[_]OperandKind{} },
                .{ .name = "BaryCoordSmoothAMD", .value = 4995, .parameters = &[_]OperandKind{} },
                .{ .name = "BaryCoordSmoothCentroidAMD", .value = 4996, .parameters = &[_]OperandKind{} },
                .{ .name = "BaryCoordSmoothSampleAMD", .value = 4997, .parameters = &[_]OperandKind{} },
                .{ .name = "BaryCoordPullModelAMD", .value = 4998, .parameters = &[_]OperandKind{} },
                .{ .name = "FragStencilRefEXT", .value = 5014, .parameters = &[_]OperandKind{} },
                .{ .name = "CoalescedInputCountAMDX", .value = 5021, .parameters = &[_]OperandKind{} },
                .{ .name = "ShaderIndexAMDX", .value = 5073, .parameters = &[_]OperandKind{} },
                .{ .name = "ViewportMaskNV", .value = 5253, .parameters = &[_]OperandKind{} },
                .{ .name = "SecondaryPositionNV", .value = 5257, .parameters = &[_]OperandKind{} },
                .{ .name = "SecondaryViewportMaskNV", .value = 5258, .parameters = &[_]OperandKind{} },
                .{ .name = "PositionPerViewNV", .value = 5261, .parameters = &[_]OperandKind{} },
                .{ .name = "ViewportMaskPerViewNV", .value = 5262, .parameters = &[_]OperandKind{} },
                .{ .name = "FullyCoveredEXT", .value = 5264, .parameters = &[_]OperandKind{} },
                .{ .name = "TaskCountNV", .value = 5274, .parameters = &[_]OperandKind{} },
                .{ .name = "PrimitiveCountNV", .value = 5275, .parameters = &[_]OperandKind{} },
                .{ .name = "PrimitiveIndicesNV", .value = 5276, .parameters = &[_]OperandKind{} },
                .{ .name = "ClipDistancePerViewNV", .value = 5277, .parameters = &[_]OperandKind{} },
                .{ .name = "CullDistancePerViewNV", .value = 5278, .parameters = &[_]OperandKind{} },
                .{ .name = "LayerPerViewNV", .value = 5279, .parameters = &[_]OperandKind{} },
                .{ .name = "MeshViewCountNV", .value = 5280, .parameters = &[_]OperandKind{} },
                .{ .name = "MeshViewIndicesNV", .value = 5281, .parameters = &[_]OperandKind{} },
                .{ .name = "BaryCoordKHR", .value = 5286, .parameters = &[_]OperandKind{} },
                .{ .name = "BaryCoordNV", .value = 5286, .parameters = &[_]OperandKind{} },
                .{ .name = "BaryCoordNoPerspKHR", .value = 5287, .parameters = &[_]OperandKind{} },
                .{ .name = "BaryCoordNoPerspNV", .value = 5287, .parameters = &[_]OperandKind{} },
                .{ .name = "FragSizeEXT", .value = 5292, .parameters = &[_]OperandKind{} },
                .{ .name = "FragmentSizeNV", .value = 5292, .parameters = &[_]OperandKind{} },
                .{ .name = "FragInvocationCountEXT", .value = 5293, .parameters = &[_]OperandKind{} },
                .{ .name = "InvocationsPerPixelNV", .value = 5293, .parameters = &[_]OperandKind{} },
                .{ .name = "PrimitivePointIndicesEXT", .value = 5294, .parameters = &[_]OperandKind{} },
                .{ .name = "PrimitiveLineIndicesEXT", .value = 5295, .parameters = &[_]OperandKind{} },
                .{ .name = "PrimitiveTriangleIndicesEXT", .value = 5296, .parameters = &[_]OperandKind{} },
                .{ .name = "CullPrimitiveEXT", .value = 5299, .parameters = &[_]OperandKind{} },
                .{ .name = "LaunchIdNV", .value = 5319, .parameters = &[_]OperandKind{} },
                .{ .name = "LaunchIdKHR", .value = 5319, .parameters = &[_]OperandKind{} },
                .{ .name = "LaunchSizeNV", .value = 5320, .parameters = &[_]OperandKind{} },
                .{ .name = "LaunchSizeKHR", .value = 5320, .parameters = &[_]OperandKind{} },
                .{ .name = "WorldRayOriginNV", .value = 5321, .parameters = &[_]OperandKind{} },
                .{ .name = "WorldRayOriginKHR", .value = 5321, .parameters = &[_]OperandKind{} },
                .{ .name = "WorldRayDirectionNV", .value = 5322, .parameters = &[_]OperandKind{} },
                .{ .name = "WorldRayDirectionKHR", .value = 5322, .parameters = &[_]OperandKind{} },
                .{ .name = "ObjectRayOriginNV", .value = 5323, .parameters = &[_]OperandKind{} },
                .{ .name = "ObjectRayOriginKHR", .value = 5323, .parameters = &[_]OperandKind{} },
                .{ .name = "ObjectRayDirectionNV", .value = 5324, .parameters = &[_]OperandKind{} },
                .{ .name = "ObjectRayDirectionKHR", .value = 5324, .parameters = &[_]OperandKind{} },
                .{ .name = "RayTminNV", .value = 5325, .parameters = &[_]OperandKind{} },
                .{ .name = "RayTminKHR", .value = 5325, .parameters = &[_]OperandKind{} },
                .{ .name = "RayTmaxNV", .value = 5326, .parameters = &[_]OperandKind{} },
                .{ .name = "RayTmaxKHR", .value = 5326, .parameters = &[_]OperandKind{} },
                .{ .name = "InstanceCustomIndexNV", .value = 5327, .parameters = &[_]OperandKind{} },
                .{ .name = "InstanceCustomIndexKHR", .value = 5327, .parameters = &[_]OperandKind{} },
                .{ .name = "ObjectToWorldNV", .value = 5330, .parameters = &[_]OperandKind{} },
                .{ .name = "ObjectToWorldKHR", .value = 5330, .parameters = &[_]OperandKind{} },
                .{ .name = "WorldToObjectNV", .value = 5331, .parameters = &[_]OperandKind{} },
                .{ .name = "WorldToObjectKHR", .value = 5331, .parameters = &[_]OperandKind{} },
                .{ .name = "HitTNV", .value = 5332, .parameters = &[_]OperandKind{} },
                .{ .name = "HitKindNV", .value = 5333, .parameters = &[_]OperandKind{} },
                .{ .name = "HitKindKHR", .value = 5333, .parameters = &[_]OperandKind{} },
                .{ .name = "CurrentRayTimeNV", .value = 5334, .parameters = &[_]OperandKind{} },
                .{ .name = "HitTriangleVertexPositionsKHR", .value = 5335, .parameters = &[_]OperandKind{} },
                .{ .name = "HitMicroTriangleVertexPositionsNV", .value = 5337, .parameters = &[_]OperandKind{} },
                .{ .name = "HitMicroTriangleVertexBarycentricsNV", .value = 5344, .parameters = &[_]OperandKind{} },
                .{ .name = "IncomingRayFlagsNV", .value = 5351, .parameters = &[_]OperandKind{} },
                .{ .name = "IncomingRayFlagsKHR", .value = 5351, .parameters = &[_]OperandKind{} },
                .{ .name = "RayGeometryIndexKHR", .value = 5352, .parameters = &[_]OperandKind{} },
                .{ .name = "WarpsPerSMNV", .value = 5374, .parameters = &[_]OperandKind{} },
                .{ .name = "SMCountNV", .value = 5375, .parameters = &[_]OperandKind{} },
                .{ .name = "WarpIDNV", .value = 5376, .parameters = &[_]OperandKind{} },
                .{ .name = "SMIDNV", .value = 5377, .parameters = &[_]OperandKind{} },
                .{ .name = "HitKindFrontFacingMicroTriangleNV", .value = 5405, .parameters = &[_]OperandKind{} },
                .{ .name = "HitKindBackFacingMicroTriangleNV", .value = 5406, .parameters = &[_]OperandKind{} },
                .{ .name = "CullMaskKHR", .value = 6021, .parameters = &[_]OperandKind{} },
            },
            .Scope => &[_]Enumerant{
                .{ .name = "CrossDevice", .value = 0, .parameters = &[_]OperandKind{} },
                .{ .name = "Device", .value = 1, .parameters = &[_]OperandKind{} },
                .{ .name = "Workgroup", .value = 2, .parameters = &[_]OperandKind{} },
                .{ .name = "Subgroup", .value = 3, .parameters = &[_]OperandKind{} },
                .{ .name = "Invocation", .value = 4, .parameters = &[_]OperandKind{} },
                .{ .name = "QueueFamily", .value = 5, .parameters = &[_]OperandKind{} },
                .{ .name = "QueueFamilyKHR", .value = 5, .parameters = &[_]OperandKind{} },
                .{ .name = "ShaderCallKHR", .value = 6, .parameters = &[_]OperandKind{} },
            },
            .GroupOperation => &[_]Enumerant{
                .{ .name = "Reduce", .value = 0, .parameters = &[_]OperandKind{} },
                .{ .name = "InclusiveScan", .value = 1, .parameters = &[_]OperandKind{} },
                .{ .name = "ExclusiveScan", .value = 2, .parameters = &[_]OperandKind{} },
                .{ .name = "ClusteredReduce", .value = 3, .parameters = &[_]OperandKind{} },
                .{ .name = "PartitionedReduceNV", .value = 6, .parameters = &[_]OperandKind{} },
                .{ .name = "PartitionedInclusiveScanNV", .value = 7, .parameters = &[_]OperandKind{} },
                .{ .name = "PartitionedExclusiveScanNV", .value = 8, .parameters = &[_]OperandKind{} },
            },
            .KernelEnqueueFlags => &[_]Enumerant{
                .{ .name = "NoWait", .value = 0, .parameters = &[_]OperandKind{} },
                .{ .name = "WaitKernel", .value = 1, .parameters = &[_]OperandKind{} },
                .{ .name = "WaitWorkGroup", .value = 2, .parameters = &[_]OperandKind{} },
            },
            .Capability => &[_]Enumerant{
                .{ .name = "Matrix", .value = 0, .parameters = &[_]OperandKind{} },
                .{ .name = "Shader", .value = 1, .parameters = &[_]OperandKind{} },
                .{ .name = "Geometry", .value = 2, .parameters = &[_]OperandKind{} },
                .{ .name = "Tessellation", .value = 3, .parameters = &[_]OperandKind{} },
                .{ .name = "Addresses", .value = 4, .parameters = &[_]OperandKind{} },
                .{ .name = "Linkage", .value = 5, .parameters = &[_]OperandKind{} },
                .{ .name = "Kernel", .value = 6, .parameters = &[_]OperandKind{} },
                .{ .name = "Vector16", .value = 7, .parameters = &[_]OperandKind{} },
                .{ .name = "Float16Buffer", .value = 8, .parameters = &[_]OperandKind{} },
                .{ .name = "Float16", .value = 9, .parameters = &[_]OperandKind{} },
                .{ .name = "Float64", .value = 10, .parameters = &[_]OperandKind{} },
                .{ .name = "Int64", .value = 11, .parameters = &[_]OperandKind{} },
                .{ .name = "Int64Atomics", .value = 12, .parameters = &[_]OperandKind{} },
                .{ .name = "ImageBasic", .value = 13, .parameters = &[_]OperandKind{} },
                .{ .name = "ImageReadWrite", .value = 14, .parameters = &[_]OperandKind{} },
                .{ .name = "ImageMipmap", .value = 15, .parameters = &[_]OperandKind{} },
                .{ .name = "Pipes", .value = 17, .parameters = &[_]OperandKind{} },
                .{ .name = "Groups", .value = 18, .parameters = &[_]OperandKind{} },
                .{ .name = "DeviceEnqueue", .value = 19, .parameters = &[_]OperandKind{} },
                .{ .name = "LiteralSampler", .value = 20, .parameters = &[_]OperandKind{} },
                .{ .name = "AtomicStorage", .value = 21, .parameters = &[_]OperandKind{} },
                .{ .name = "Int16", .value = 22, .parameters = &[_]OperandKind{} },
                .{ .name = "TessellationPointSize", .value = 23, .parameters = &[_]OperandKind{} },
                .{ .name = "GeometryPointSize", .value = 24, .parameters = &[_]OperandKind{} },
                .{ .name = "ImageGatherExtended", .value = 25, .parameters = &[_]OperandKind{} },
                .{ .name = "StorageImageMultisample", .value = 27, .parameters = &[_]OperandKind{} },
                .{ .name = "UniformBufferArrayDynamicIndexing", .value = 28, .parameters = &[_]OperandKind{} },
                .{ .name = "SampledImageArrayDynamicIndexing", .value = 29, .parameters = &[_]OperandKind{} },
                .{ .name = "StorageBufferArrayDynamicIndexing", .value = 30, .parameters = &[_]OperandKind{} },
                .{ .name = "StorageImageArrayDynamicIndexing", .value = 31, .parameters = &[_]OperandKind{} },
                .{ .name = "ClipDistance", .value = 32, .parameters = &[_]OperandKind{} },
                .{ .name = "CullDistance", .value = 33, .parameters = &[_]OperandKind{} },
                .{ .name = "ImageCubeArray", .value = 34, .parameters = &[_]OperandKind{} },
                .{ .name = "SampleRateShading", .value = 35, .parameters = &[_]OperandKind{} },
                .{ .name = "ImageRect", .value = 36, .parameters = &[_]OperandKind{} },
                .{ .name = "SampledRect", .value = 37, .parameters = &[_]OperandKind{} },
                .{ .name = "GenericPointer", .value = 38, .parameters = &[_]OperandKind{} },
                .{ .name = "Int8", .value = 39, .parameters = &[_]OperandKind{} },
                .{ .name = "InputAttachment", .value = 40, .parameters = &[_]OperandKind{} },
                .{ .name = "SparseResidency", .value = 41, .parameters = &[_]OperandKind{} },
                .{ .name = "MinLod", .value = 42, .parameters = &[_]OperandKind{} },
                .{ .name = "Sampled1D", .value = 43, .parameters = &[_]OperandKind{} },
                .{ .name = "Image1D", .value = 44, .parameters = &[_]OperandKind{} },
                .{ .name = "SampledCubeArray", .value = 45, .parameters = &[_]OperandKind{} },
                .{ .name = "SampledBuffer", .value = 46, .parameters = &[_]OperandKind{} },
                .{ .name = "ImageBuffer", .value = 47, .parameters = &[_]OperandKind{} },
                .{ .name = "ImageMSArray", .value = 48, .parameters = &[_]OperandKind{} },
                .{ .name = "StorageImageExtendedFormats", .value = 49, .parameters = &[_]OperandKind{} },
                .{ .name = "ImageQuery", .value = 50, .parameters = &[_]OperandKind{} },
                .{ .name = "DerivativeControl", .value = 51, .parameters = &[_]OperandKind{} },
                .{ .name = "InterpolationFunction", .value = 52, .parameters = &[_]OperandKind{} },
                .{ .name = "TransformFeedback", .value = 53, .parameters = &[_]OperandKind{} },
                .{ .name = "GeometryStreams", .value = 54, .parameters = &[_]OperandKind{} },
                .{ .name = "StorageImageReadWithoutFormat", .value = 55, .parameters = &[_]OperandKind{} },
                .{ .name = "StorageImageWriteWithoutFormat", .value = 56, .parameters = &[_]OperandKind{} },
                .{ .name = "MultiViewport", .value = 57, .parameters = &[_]OperandKind{} },
                .{ .name = "SubgroupDispatch", .value = 58, .parameters = &[_]OperandKind{} },
                .{ .name = "NamedBarrier", .value = 59, .parameters = &[_]OperandKind{} },
                .{ .name = "PipeStorage", .value = 60, .parameters = &[_]OperandKind{} },
                .{ .name = "GroupNonUniform", .value = 61, .parameters = &[_]OperandKind{} },
                .{ .name = "GroupNonUniformVote", .value = 62, .parameters = &[_]OperandKind{} },
                .{ .name = "GroupNonUniformArithmetic", .value = 63, .parameters = &[_]OperandKind{} },
                .{ .name = "GroupNonUniformBallot", .value = 64, .parameters = &[_]OperandKind{} },
                .{ .name = "GroupNonUniformShuffle", .value = 65, .parameters = &[_]OperandKind{} },
                .{ .name = "GroupNonUniformShuffleRelative", .value = 66, .parameters = &[_]OperandKind{} },
                .{ .name = "GroupNonUniformClustered", .value = 67, .parameters = &[_]OperandKind{} },
                .{ .name = "GroupNonUniformQuad", .value = 68, .parameters = &[_]OperandKind{} },
                .{ .name = "ShaderLayer", .value = 69, .parameters = &[_]OperandKind{} },
                .{ .name = "ShaderViewportIndex", .value = 70, .parameters = &[_]OperandKind{} },
                .{ .name = "UniformDecoration", .value = 71, .parameters = &[_]OperandKind{} },
                .{ .name = "CoreBuiltinsARM", .value = 4165, .parameters = &[_]OperandKind{} },
                .{ .name = "TileImageColorReadAccessEXT", .value = 4166, .parameters = &[_]OperandKind{} },
                .{ .name = "TileImageDepthReadAccessEXT", .value = 4167, .parameters = &[_]OperandKind{} },
                .{ .name = "TileImageStencilReadAccessEXT", .value = 4168, .parameters = &[_]OperandKind{} },
                .{ .name = "FragmentShadingRateKHR", .value = 4422, .parameters = &[_]OperandKind{} },
                .{ .name = "SubgroupBallotKHR", .value = 4423, .parameters = &[_]OperandKind{} },
                .{ .name = "DrawParameters", .value = 4427, .parameters = &[_]OperandKind{} },
                .{ .name = "WorkgroupMemoryExplicitLayoutKHR", .value = 4428, .parameters = &[_]OperandKind{} },
                .{ .name = "WorkgroupMemoryExplicitLayout8BitAccessKHR", .value = 4429, .parameters = &[_]OperandKind{} },
                .{ .name = "WorkgroupMemoryExplicitLayout16BitAccessKHR", .value = 4430, .parameters = &[_]OperandKind{} },
                .{ .name = "SubgroupVoteKHR", .value = 4431, .parameters = &[_]OperandKind{} },
                .{ .name = "StorageBuffer16BitAccess", .value = 4433, .parameters = &[_]OperandKind{} },
                .{ .name = "StorageUniformBufferBlock16", .value = 4433, .parameters = &[_]OperandKind{} },
                .{ .name = "UniformAndStorageBuffer16BitAccess", .value = 4434, .parameters = &[_]OperandKind{} },
                .{ .name = "StorageUniform16", .value = 4434, .parameters = &[_]OperandKind{} },
                .{ .name = "StoragePushConstant16", .value = 4435, .parameters = &[_]OperandKind{} },
                .{ .name = "StorageInputOutput16", .value = 4436, .parameters = &[_]OperandKind{} },
                .{ .name = "DeviceGroup", .value = 4437, .parameters = &[_]OperandKind{} },
                .{ .name = "MultiView", .value = 4439, .parameters = &[_]OperandKind{} },
                .{ .name = "VariablePointersStorageBuffer", .value = 4441, .parameters = &[_]OperandKind{} },
                .{ .name = "VariablePointers", .value = 4442, .parameters = &[_]OperandKind{} },
                .{ .name = "AtomicStorageOps", .value = 4445, .parameters = &[_]OperandKind{} },
                .{ .name = "SampleMaskPostDepthCoverage", .value = 4447, .parameters = &[_]OperandKind{} },
                .{ .name = "StorageBuffer8BitAccess", .value = 4448, .parameters = &[_]OperandKind{} },
                .{ .name = "UniformAndStorageBuffer8BitAccess", .value = 4449, .parameters = &[_]OperandKind{} },
                .{ .name = "StoragePushConstant8", .value = 4450, .parameters = &[_]OperandKind{} },
                .{ .name = "DenormPreserve", .value = 4464, .parameters = &[_]OperandKind{} },
                .{ .name = "DenormFlushToZero", .value = 4465, .parameters = &[_]OperandKind{} },
                .{ .name = "SignedZeroInfNanPreserve", .value = 4466, .parameters = &[_]OperandKind{} },
                .{ .name = "RoundingModeRTE", .value = 4467, .parameters = &[_]OperandKind{} },
                .{ .name = "RoundingModeRTZ", .value = 4468, .parameters = &[_]OperandKind{} },
                .{ .name = "RayQueryProvisionalKHR", .value = 4471, .parameters = &[_]OperandKind{} },
                .{ .name = "RayQueryKHR", .value = 4472, .parameters = &[_]OperandKind{} },
                .{ .name = "RayTraversalPrimitiveCullingKHR", .value = 4478, .parameters = &[_]OperandKind{} },
                .{ .name = "RayTracingKHR", .value = 4479, .parameters = &[_]OperandKind{} },
                .{ .name = "TextureSampleWeightedQCOM", .value = 4484, .parameters = &[_]OperandKind{} },
                .{ .name = "TextureBoxFilterQCOM", .value = 4485, .parameters = &[_]OperandKind{} },
                .{ .name = "TextureBlockMatchQCOM", .value = 4486, .parameters = &[_]OperandKind{} },
                .{ .name = "TextureBlockMatch2QCOM", .value = 4498, .parameters = &[_]OperandKind{} },
                .{ .name = "Float16ImageAMD", .value = 5008, .parameters = &[_]OperandKind{} },
                .{ .name = "ImageGatherBiasLodAMD", .value = 5009, .parameters = &[_]OperandKind{} },
                .{ .name = "FragmentMaskAMD", .value = 5010, .parameters = &[_]OperandKind{} },
                .{ .name = "StencilExportEXT", .value = 5013, .parameters = &[_]OperandKind{} },
                .{ .name = "ImageReadWriteLodAMD", .value = 5015, .parameters = &[_]OperandKind{} },
                .{ .name = "Int64ImageEXT", .value = 5016, .parameters = &[_]OperandKind{} },
                .{ .name = "ShaderClockKHR", .value = 5055, .parameters = &[_]OperandKind{} },
                .{ .name = "ShaderEnqueueAMDX", .value = 5067, .parameters = &[_]OperandKind{} },
                .{ .name = "QuadControlKHR", .value = 5087, .parameters = &[_]OperandKind{} },
                .{ .name = "SampleMaskOverrideCoverageNV", .value = 5249, .parameters = &[_]OperandKind{} },
                .{ .name = "GeometryShaderPassthroughNV", .value = 5251, .parameters = &[_]OperandKind{} },
                .{ .name = "ShaderViewportIndexLayerEXT", .value = 5254, .parameters = &[_]OperandKind{} },
                .{ .name = "ShaderViewportIndexLayerNV", .value = 5254, .parameters = &[_]OperandKind{} },
                .{ .name = "ShaderViewportMaskNV", .value = 5255, .parameters = &[_]OperandKind{} },
                .{ .name = "ShaderStereoViewNV", .value = 5259, .parameters = &[_]OperandKind{} },
                .{ .name = "PerViewAttributesNV", .value = 5260, .parameters = &[_]OperandKind{} },
                .{ .name = "FragmentFullyCoveredEXT", .value = 5265, .parameters = &[_]OperandKind{} },
                .{ .name = "MeshShadingNV", .value = 5266, .parameters = &[_]OperandKind{} },
                .{ .name = "ImageFootprintNV", .value = 5282, .parameters = &[_]OperandKind{} },
                .{ .name = "MeshShadingEXT", .value = 5283, .parameters = &[_]OperandKind{} },
                .{ .name = "FragmentBarycentricKHR", .value = 5284, .parameters = &[_]OperandKind{} },
                .{ .name = "FragmentBarycentricNV", .value = 5284, .parameters = &[_]OperandKind{} },
                .{ .name = "ComputeDerivativeGroupQuadsNV", .value = 5288, .parameters = &[_]OperandKind{} },
                .{ .name = "FragmentDensityEXT", .value = 5291, .parameters = &[_]OperandKind{} },
                .{ .name = "ShadingRateNV", .value = 5291, .parameters = &[_]OperandKind{} },
                .{ .name = "GroupNonUniformPartitionedNV", .value = 5297, .parameters = &[_]OperandKind{} },
                .{ .name = "ShaderNonUniform", .value = 5301, .parameters = &[_]OperandKind{} },
                .{ .name = "ShaderNonUniformEXT", .value = 5301, .parameters = &[_]OperandKind{} },
                .{ .name = "RuntimeDescriptorArray", .value = 5302, .parameters = &[_]OperandKind{} },
                .{ .name = "RuntimeDescriptorArrayEXT", .value = 5302, .parameters = &[_]OperandKind{} },
                .{ .name = "InputAttachmentArrayDynamicIndexing", .value = 5303, .parameters = &[_]OperandKind{} },
                .{ .name = "InputAttachmentArrayDynamicIndexingEXT", .value = 5303, .parameters = &[_]OperandKind{} },
                .{ .name = "UniformTexelBufferArrayDynamicIndexing", .value = 5304, .parameters = &[_]OperandKind{} },
                .{ .name = "UniformTexelBufferArrayDynamicIndexingEXT", .value = 5304, .parameters = &[_]OperandKind{} },
                .{ .name = "StorageTexelBufferArrayDynamicIndexing", .value = 5305, .parameters = &[_]OperandKind{} },
                .{ .name = "StorageTexelBufferArrayDynamicIndexingEXT", .value = 5305, .parameters = &[_]OperandKind{} },
                .{ .name = "UniformBufferArrayNonUniformIndexing", .value = 5306, .parameters = &[_]OperandKind{} },
                .{ .name = "UniformBufferArrayNonUniformIndexingEXT", .value = 5306, .parameters = &[_]OperandKind{} },
                .{ .name = "SampledImageArrayNonUniformIndexing", .value = 5307, .parameters = &[_]OperandKind{} },
                .{ .name = "SampledImageArrayNonUniformIndexingEXT", .value = 5307, .parameters = &[_]OperandKind{} },
                .{ .name = "StorageBufferArrayNonUniformIndexing", .value = 5308, .parameters = &[_]OperandKind{} },
                .{ .name = "StorageBufferArrayNonUniformIndexingEXT", .value = 5308, .parameters = &[_]OperandKind{} },
                .{ .name = "StorageImageArrayNonUniformIndexing", .value = 5309, .parameters = &[_]OperandKind{} },
                .{ .name = "StorageImageArrayNonUniformIndexingEXT", .value = 5309, .parameters = &[_]OperandKind{} },
                .{ .name = "InputAttachmentArrayNonUniformIndexing", .value = 5310, .parameters = &[_]OperandKind{} },
                .{ .name = "InputAttachmentArrayNonUniformIndexingEXT", .value = 5310, .parameters = &[_]OperandKind{} },
                .{ .name = "UniformTexelBufferArrayNonUniformIndexing", .value = 5311, .parameters = &[_]OperandKind{} },
                .{ .name = "UniformTexelBufferArrayNonUniformIndexingEXT", .value = 5311, .parameters = &[_]OperandKind{} },
                .{ .name = "StorageTexelBufferArrayNonUniformIndexing", .value = 5312, .parameters = &[_]OperandKind{} },
                .{ .name = "StorageTexelBufferArrayNonUniformIndexingEXT", .value = 5312, .parameters = &[_]OperandKind{} },
                .{ .name = "RayTracingPositionFetchKHR", .value = 5336, .parameters = &[_]OperandKind{} },
                .{ .name = "RayTracingNV", .value = 5340, .parameters = &[_]OperandKind{} },
                .{ .name = "RayTracingMotionBlurNV", .value = 5341, .parameters = &[_]OperandKind{} },
                .{ .name = "VulkanMemoryModel", .value = 5345, .parameters = &[_]OperandKind{} },
                .{ .name = "VulkanMemoryModelKHR", .value = 5345, .parameters = &[_]OperandKind{} },
                .{ .name = "VulkanMemoryModelDeviceScope", .value = 5346, .parameters = &[_]OperandKind{} },
                .{ .name = "VulkanMemoryModelDeviceScopeKHR", .value = 5346, .parameters = &[_]OperandKind{} },
                .{ .name = "PhysicalStorageBufferAddresses", .value = 5347, .parameters = &[_]OperandKind{} },
                .{ .name = "PhysicalStorageBufferAddressesEXT", .value = 5347, .parameters = &[_]OperandKind{} },
                .{ .name = "ComputeDerivativeGroupLinearNV", .value = 5350, .parameters = &[_]OperandKind{} },
                .{ .name = "RayTracingProvisionalKHR", .value = 5353, .parameters = &[_]OperandKind{} },
                .{ .name = "CooperativeMatrixNV", .value = 5357, .parameters = &[_]OperandKind{} },
                .{ .name = "FragmentShaderSampleInterlockEXT", .value = 5363, .parameters = &[_]OperandKind{} },
                .{ .name = "FragmentShaderShadingRateInterlockEXT", .value = 5372, .parameters = &[_]OperandKind{} },
                .{ .name = "ShaderSMBuiltinsNV", .value = 5373, .parameters = &[_]OperandKind{} },
                .{ .name = "FragmentShaderPixelInterlockEXT", .value = 5378, .parameters = &[_]OperandKind{} },
                .{ .name = "DemoteToHelperInvocation", .value = 5379, .parameters = &[_]OperandKind{} },
                .{ .name = "DemoteToHelperInvocationEXT", .value = 5379, .parameters = &[_]OperandKind{} },
                .{ .name = "DisplacementMicromapNV", .value = 5380, .parameters = &[_]OperandKind{} },
                .{ .name = "RayTracingOpacityMicromapEXT", .value = 5381, .parameters = &[_]OperandKind{} },
                .{ .name = "ShaderInvocationReorderNV", .value = 5383, .parameters = &[_]OperandKind{} },
                .{ .name = "BindlessTextureNV", .value = 5390, .parameters = &[_]OperandKind{} },
                .{ .name = "RayQueryPositionFetchKHR", .value = 5391, .parameters = &[_]OperandKind{} },
                .{ .name = "AtomicFloat16VectorNV", .value = 5404, .parameters = &[_]OperandKind{} },
                .{ .name = "RayTracingDisplacementMicromapNV", .value = 5409, .parameters = &[_]OperandKind{} },
                .{ .name = "RawAccessChainsNV", .value = 5414, .parameters = &[_]OperandKind{} },
                .{ .name = "SubgroupShuffleINTEL", .value = 5568, .parameters = &[_]OperandKind{} },
                .{ .name = "SubgroupBufferBlockIOINTEL", .value = 5569, .parameters = &[_]OperandKind{} },
                .{ .name = "SubgroupImageBlockIOINTEL", .value = 5570, .parameters = &[_]OperandKind{} },
                .{ .name = "SubgroupImageMediaBlockIOINTEL", .value = 5579, .parameters = &[_]OperandKind{} },
                .{ .name = "RoundToInfinityINTEL", .value = 5582, .parameters = &[_]OperandKind{} },
                .{ .name = "FloatingPointModeINTEL", .value = 5583, .parameters = &[_]OperandKind{} },
                .{ .name = "IntegerFunctions2INTEL", .value = 5584, .parameters = &[_]OperandKind{} },
                .{ .name = "FunctionPointersINTEL", .value = 5603, .parameters = &[_]OperandKind{} },
                .{ .name = "IndirectReferencesINTEL", .value = 5604, .parameters = &[_]OperandKind{} },
                .{ .name = "AsmINTEL", .value = 5606, .parameters = &[_]OperandKind{} },
                .{ .name = "AtomicFloat32MinMaxEXT", .value = 5612, .parameters = &[_]OperandKind{} },
                .{ .name = "AtomicFloat64MinMaxEXT", .value = 5613, .parameters = &[_]OperandKind{} },
                .{ .name = "AtomicFloat16MinMaxEXT", .value = 5616, .parameters = &[_]OperandKind{} },
                .{ .name = "VectorComputeINTEL", .value = 5617, .parameters = &[_]OperandKind{} },
                .{ .name = "VectorAnyINTEL", .value = 5619, .parameters = &[_]OperandKind{} },
                .{ .name = "ExpectAssumeKHR", .value = 5629, .parameters = &[_]OperandKind{} },
                .{ .name = "SubgroupAvcMotionEstimationINTEL", .value = 5696, .parameters = &[_]OperandKind{} },
                .{ .name = "SubgroupAvcMotionEstimationIntraINTEL", .value = 5697, .parameters = &[_]OperandKind{} },
                .{ .name = "SubgroupAvcMotionEstimationChromaINTEL", .value = 5698, .parameters = &[_]OperandKind{} },
                .{ .name = "VariableLengthArrayINTEL", .value = 5817, .parameters = &[_]OperandKind{} },
                .{ .name = "FunctionFloatControlINTEL", .value = 5821, .parameters = &[_]OperandKind{} },
                .{ .name = "FPGAMemoryAttributesINTEL", .value = 5824, .parameters = &[_]OperandKind{} },
                .{ .name = "FPFastMathModeINTEL", .value = 5837, .parameters = &[_]OperandKind{} },
                .{ .name = "ArbitraryPrecisionIntegersINTEL", .value = 5844, .parameters = &[_]OperandKind{} },
                .{ .name = "ArbitraryPrecisionFloatingPointINTEL", .value = 5845, .parameters = &[_]OperandKind{} },
                .{ .name = "UnstructuredLoopControlsINTEL", .value = 5886, .parameters = &[_]OperandKind{} },
                .{ .name = "FPGALoopControlsINTEL", .value = 5888, .parameters = &[_]OperandKind{} },
                .{ .name = "KernelAttributesINTEL", .value = 5892, .parameters = &[_]OperandKind{} },
                .{ .name = "FPGAKernelAttributesINTEL", .value = 5897, .parameters = &[_]OperandKind{} },
                .{ .name = "FPGAMemoryAccessesINTEL", .value = 5898, .parameters = &[_]OperandKind{} },
                .{ .name = "FPGAClusterAttributesINTEL", .value = 5904, .parameters = &[_]OperandKind{} },
                .{ .name = "LoopFuseINTEL", .value = 5906, .parameters = &[_]OperandKind{} },
                .{ .name = "FPGADSPControlINTEL", .value = 5908, .parameters = &[_]OperandKind{} },
                .{ .name = "MemoryAccessAliasingINTEL", .value = 5910, .parameters = &[_]OperandKind{} },
                .{ .name = "FPGAInvocationPipeliningAttributesINTEL", .value = 5916, .parameters = &[_]OperandKind{} },
                .{ .name = "FPGABufferLocationINTEL", .value = 5920, .parameters = &[_]OperandKind{} },
                .{ .name = "ArbitraryPrecisionFixedPointINTEL", .value = 5922, .parameters = &[_]OperandKind{} },
                .{ .name = "USMStorageClassesINTEL", .value = 5935, .parameters = &[_]OperandKind{} },
                .{ .name = "RuntimeAlignedAttributeINTEL", .value = 5939, .parameters = &[_]OperandKind{} },
                .{ .name = "IOPipesINTEL", .value = 5943, .parameters = &[_]OperandKind{} },
                .{ .name = "BlockingPipesINTEL", .value = 5945, .parameters = &[_]OperandKind{} },
                .{ .name = "FPGARegINTEL", .value = 5948, .parameters = &[_]OperandKind{} },
                .{ .name = "DotProductInputAll", .value = 6016, .parameters = &[_]OperandKind{} },
                .{ .name = "DotProductInputAllKHR", .value = 6016, .parameters = &[_]OperandKind{} },
                .{ .name = "DotProductInput4x8Bit", .value = 6017, .parameters = &[_]OperandKind{} },
                .{ .name = "DotProductInput4x8BitKHR", .value = 6017, .parameters = &[_]OperandKind{} },
                .{ .name = "DotProductInput4x8BitPacked", .value = 6018, .parameters = &[_]OperandKind{} },
                .{ .name = "DotProductInput4x8BitPackedKHR", .value = 6018, .parameters = &[_]OperandKind{} },
                .{ .name = "DotProduct", .value = 6019, .parameters = &[_]OperandKind{} },
                .{ .name = "DotProductKHR", .value = 6019, .parameters = &[_]OperandKind{} },
                .{ .name = "RayCullMaskKHR", .value = 6020, .parameters = &[_]OperandKind{} },
                .{ .name = "CooperativeMatrixKHR", .value = 6022, .parameters = &[_]OperandKind{} },
                .{ .name = "BitInstructions", .value = 6025, .parameters = &[_]OperandKind{} },
                .{ .name = "GroupNonUniformRotateKHR", .value = 6026, .parameters = &[_]OperandKind{} },
                .{ .name = "FloatControls2", .value = 6029, .parameters = &[_]OperandKind{} },
                .{ .name = "AtomicFloat32AddEXT", .value = 6033, .parameters = &[_]OperandKind{} },
                .{ .name = "AtomicFloat64AddEXT", .value = 6034, .parameters = &[_]OperandKind{} },
                .{ .name = "LongCompositesINTEL", .value = 6089, .parameters = &[_]OperandKind{} },
                .{ .name = "OptNoneINTEL", .value = 6094, .parameters = &[_]OperandKind{} },
                .{ .name = "AtomicFloat16AddEXT", .value = 6095, .parameters = &[_]OperandKind{} },
                .{ .name = "DebugInfoModuleINTEL", .value = 6114, .parameters = &[_]OperandKind{} },
                .{ .name = "BFloat16ConversionINTEL", .value = 6115, .parameters = &[_]OperandKind{} },
                .{ .name = "SplitBarrierINTEL", .value = 6141, .parameters = &[_]OperandKind{} },
                .{ .name = "FPGAClusterAttributesV2INTEL", .value = 6150, .parameters = &[_]OperandKind{} },
                .{ .name = "FPGAKernelAttributesv2INTEL", .value = 6161, .parameters = &[_]OperandKind{} },
                .{ .name = "FPMaxErrorINTEL", .value = 6169, .parameters = &[_]OperandKind{} },
                .{ .name = "FPGALatencyControlINTEL", .value = 6171, .parameters = &[_]OperandKind{} },
                .{ .name = "FPGAArgumentInterfacesINTEL", .value = 6174, .parameters = &[_]OperandKind{} },
                .{ .name = "GlobalVariableHostAccessINTEL", .value = 6187, .parameters = &[_]OperandKind{} },
                .{ .name = "GlobalVariableFPGADecorationsINTEL", .value = 6189, .parameters = &[_]OperandKind{} },
                .{ .name = "GroupUniformArithmeticKHR", .value = 6400, .parameters = &[_]OperandKind{} },
                .{ .name = "MaskedGatherScatterINTEL", .value = 6427, .parameters = &[_]OperandKind{} },
                .{ .name = "CacheControlsINTEL", .value = 6441, .parameters = &[_]OperandKind{} },
                .{ .name = "RegisterLimitsINTEL", .value = 6460, .parameters = &[_]OperandKind{} },
            },
            .RayQueryIntersection => &[_]Enumerant{
                .{ .name = "RayQueryCandidateIntersectionKHR", .value = 0, .parameters = &[_]OperandKind{} },
                .{ .name = "RayQueryCommittedIntersectionKHR", .value = 1, .parameters = &[_]OperandKind{} },
            },
            .RayQueryCommittedIntersectionType => &[_]Enumerant{
                .{ .name = "RayQueryCommittedIntersectionNoneKHR", .value = 0, .parameters = &[_]OperandKind{} },
                .{ .name = "RayQueryCommittedIntersectionTriangleKHR", .value = 1, .parameters = &[_]OperandKind{} },
                .{ .name = "RayQueryCommittedIntersectionGeneratedKHR", .value = 2, .parameters = &[_]OperandKind{} },
            },
            .RayQueryCandidateIntersectionType => &[_]Enumerant{
                .{ .name = "RayQueryCandidateIntersectionTriangleKHR", .value = 0, .parameters = &[_]OperandKind{} },
                .{ .name = "RayQueryCandidateIntersectionAABBKHR", .value = 1, .parameters = &[_]OperandKind{} },
            },
            .PackedVectorFormat => &[_]Enumerant{
                .{ .name = "PackedVectorFormat4x8Bit", .value = 0, .parameters = &[_]OperandKind{} },
                .{ .name = "PackedVectorFormat4x8BitKHR", .value = 0, .parameters = &[_]OperandKind{} },
            },
            .CooperativeMatrixOperands => &[_]Enumerant{
                .{ .name = "NoneKHR", .value = 0x0000, .parameters = &[_]OperandKind{} },
                .{ .name = "MatrixASignedComponentsKHR", .value = 0x0001, .parameters = &[_]OperandKind{} },
                .{ .name = "MatrixBSignedComponentsKHR", .value = 0x0002, .parameters = &[_]OperandKind{} },
                .{ .name = "MatrixCSignedComponentsKHR", .value = 0x0004, .parameters = &[_]OperandKind{} },
                .{ .name = "MatrixResultSignedComponentsKHR", .value = 0x0008, .parameters = &[_]OperandKind{} },
                .{ .name = "SaturatingAccumulationKHR", .value = 0x0010, .parameters = &[_]OperandKind{} },
            },
            .CooperativeMatrixLayout => &[_]Enumerant{
                .{ .name = "RowMajorKHR", .value = 0, .parameters = &[_]OperandKind{} },
                .{ .name = "ColumnMajorKHR", .value = 1, .parameters = &[_]OperandKind{} },
            },
            .CooperativeMatrixUse => &[_]Enumerant{
                .{ .name = "MatrixAKHR", .value = 0, .parameters = &[_]OperandKind{} },
                .{ .name = "MatrixBKHR", .value = 1, .parameters = &[_]OperandKind{} },
                .{ .name = "MatrixAccumulatorKHR", .value = 2, .parameters = &[_]OperandKind{} },
            },
            .InitializationModeQualifier => &[_]Enumerant{
                .{ .name = "InitOnDeviceReprogramINTEL", .value = 0, .parameters = &[_]OperandKind{} },
                .{ .name = "InitOnDeviceResetINTEL", .value = 1, .parameters = &[_]OperandKind{} },
            },
            .LoadCacheControl => &[_]Enumerant{
                .{ .name = "UncachedINTEL", .value = 0, .parameters = &[_]OperandKind{} },
                .{ .name = "CachedINTEL", .value = 1, .parameters = &[_]OperandKind{} },
                .{ .name = "StreamingINTEL", .value = 2, .parameters = &[_]OperandKind{} },
                .{ .name = "InvalidateAfterReadINTEL", .value = 3, .parameters = &[_]OperandKind{} },
                .{ .name = "ConstCachedINTEL", .value = 4, .parameters = &[_]OperandKind{} },
            },
            .StoreCacheControl => &[_]Enumerant{
                .{ .name = "UncachedINTEL", .value = 0, .parameters = &[_]OperandKind{} },
                .{ .name = "WriteThroughINTEL", .value = 1, .parameters = &[_]OperandKind{} },
                .{ .name = "WriteBackINTEL", .value = 2, .parameters = &[_]OperandKind{} },
                .{ .name = "StreamingINTEL", .value = 3, .parameters = &[_]OperandKind{} },
            },
            .NamedMaximumNumberOfRegisters => &[_]Enumerant{
                .{ .name = "AutoINTEL", .value = 0, .parameters = &[_]OperandKind{} },
            },
            .IdResultType => unreachable,
            .IdResult => unreachable,
            .IdMemorySemantics => unreachable,
            .IdScope => unreachable,
            .IdRef => unreachable,
            .LiteralInteger => unreachable,
            .LiteralString => unreachable,
            .LiteralFloat => unreachable,
            .LiteralContextDependentNumber => unreachable,
            .LiteralExtInstInteger => unreachable,
            .LiteralSpecConstantOpInteger => unreachable,
            .PairLiteralIntegerIdRef => unreachable,
            .PairIdRefLiteralInteger => unreachable,
            .PairIdRefIdRef => unreachable,
            .@"OpenCL.DebugInfo.100.DebugInfoFlags" => &[_]Enumerant{
                .{ .name = "FlagIsProtected", .value = 0x01, .parameters = &[_]OperandKind{} },
                .{ .name = "FlagIsPrivate", .value = 0x02, .parameters = &[_]OperandKind{} },
                .{ .name = "FlagIsPublic", .value = 0x03, .parameters = &[_]OperandKind{} },
                .{ .name = "FlagIsLocal", .value = 0x04, .parameters = &[_]OperandKind{} },
                .{ .name = "FlagIsDefinition", .value = 0x08, .parameters = &[_]OperandKind{} },
                .{ .name = "FlagFwdDecl", .value = 0x10, .parameters = &[_]OperandKind{} },
                .{ .name = "FlagArtificial", .value = 0x20, .parameters = &[_]OperandKind{} },
                .{ .name = "FlagExplicit", .value = 0x40, .parameters = &[_]OperandKind{} },
                .{ .name = "FlagPrototyped", .value = 0x80, .parameters = &[_]OperandKind{} },
                .{ .name = "FlagObjectPointer", .value = 0x100, .parameters = &[_]OperandKind{} },
                .{ .name = "FlagStaticMember", .value = 0x200, .parameters = &[_]OperandKind{} },
                .{ .name = "FlagIndirectVariable", .value = 0x400, .parameters = &[_]OperandKind{} },
                .{ .name = "FlagLValueReference", .value = 0x800, .parameters = &[_]OperandKind{} },
                .{ .name = "FlagRValueReference", .value = 0x1000, .parameters = &[_]OperandKind{} },
                .{ .name = "FlagIsOptimized", .value = 0x2000, .parameters = &[_]OperandKind{} },
                .{ .name = "FlagIsEnumClass", .value = 0x4000, .parameters = &[_]OperandKind{} },
                .{ .name = "FlagTypePassByValue", .value = 0x8000, .parameters = &[_]OperandKind{} },
                .{ .name = "FlagTypePassByReference", .value = 0x10000, .parameters = &[_]OperandKind{} },
            },
            .@"OpenCL.DebugInfo.100.DebugBaseTypeAttributeEncoding" => &[_]Enumerant{
                .{ .name = "Unspecified", .value = 0, .parameters = &[_]OperandKind{} },
                .{ .name = "Address", .value = 1, .parameters = &[_]OperandKind{} },
                .{ .name = "Boolean", .value = 2, .parameters = &[_]OperandKind{} },
                .{ .name = "Float", .value = 3, .parameters = &[_]OperandKind{} },
                .{ .name = "Signed", .value = 4, .parameters = &[_]OperandKind{} },
                .{ .name = "SignedChar", .value = 5, .parameters = &[_]OperandKind{} },
                .{ .name = "Unsigned", .value = 6, .parameters = &[_]OperandKind{} },
                .{ .name = "UnsignedChar", .value = 7, .parameters = &[_]OperandKind{} },
            },
            .@"OpenCL.DebugInfo.100.DebugCompositeType" => &[_]Enumerant{
                .{ .name = "Class", .value = 0, .parameters = &[_]OperandKind{} },
                .{ .name = "Structure", .value = 1, .parameters = &[_]OperandKind{} },
                .{ .name = "Union", .value = 2, .parameters = &[_]OperandKind{} },
            },
            .@"OpenCL.DebugInfo.100.DebugTypeQualifier" => &[_]Enumerant{
                .{ .name = "ConstType", .value = 0, .parameters = &[_]OperandKind{} },
                .{ .name = "VolatileType", .value = 1, .parameters = &[_]OperandKind{} },
                .{ .name = "RestrictType", .value = 2, .parameters = &[_]OperandKind{} },
                .{ .name = "AtomicType", .value = 3, .parameters = &[_]OperandKind{} },
            },
            .@"OpenCL.DebugInfo.100.DebugOperation" => &[_]Enumerant{
                .{ .name = "Deref", .value = 0, .parameters = &[_]OperandKind{} },
                .{ .name = "Plus", .value = 1, .parameters = &[_]OperandKind{} },
                .{ .name = "Minus", .value = 2, .parameters = &[_]OperandKind{} },
                .{ .name = "PlusUconst", .value = 3, .parameters = &[_]OperandKind{.LiteralInteger} },
                .{ .name = "BitPiece", .value = 4, .parameters = &[_]OperandKind{ .LiteralInteger, .LiteralInteger } },
                .{ .name = "Swap", .value = 5, .parameters = &[_]OperandKind{} },
                .{ .name = "Xderef", .value = 6, .parameters = &[_]OperandKind{} },
                .{ .name = "StackValue", .value = 7, .parameters = &[_]OperandKind{} },
                .{ .name = "Constu", .value = 8, .parameters = &[_]OperandKind{.LiteralInteger} },
                .{ .name = "Fragment", .value = 9, .parameters = &[_]OperandKind{ .LiteralInteger, .LiteralInteger } },
            },
            .@"OpenCL.DebugInfo.100.DebugImportedEntity" => &[_]Enumerant{
                .{ .name = "ImportedModule", .value = 0, .parameters = &[_]OperandKind{} },
                .{ .name = "ImportedDeclaration", .value = 1, .parameters = &[_]OperandKind{} },
            },
            .@"NonSemantic.Shader.DebugInfo.100.DebugInfoFlags" => &[_]Enumerant{
                .{ .name = "FlagIsProtected", .value = 0x01, .parameters = &[_]OperandKind{} },
                .{ .name = "FlagIsPrivate", .value = 0x02, .parameters = &[_]OperandKind{} },
                .{ .name = "FlagIsPublic", .value = 0x03, .parameters = &[_]OperandKind{} },
                .{ .name = "FlagIsLocal", .value = 0x04, .parameters = &[_]OperandKind{} },
                .{ .name = "FlagIsDefinition", .value = 0x08, .parameters = &[_]OperandKind{} },
                .{ .name = "FlagFwdDecl", .value = 0x10, .parameters = &[_]OperandKind{} },
                .{ .name = "FlagArtificial", .value = 0x20, .parameters = &[_]OperandKind{} },
                .{ .name = "FlagExplicit", .value = 0x40, .parameters = &[_]OperandKind{} },
                .{ .name = "FlagPrototyped", .value = 0x80, .parameters = &[_]OperandKind{} },
                .{ .name = "FlagObjectPointer", .value = 0x100, .parameters = &[_]OperandKind{} },
                .{ .name = "FlagStaticMember", .value = 0x200, .parameters = &[_]OperandKind{} },
                .{ .name = "FlagIndirectVariable", .value = 0x400, .parameters = &[_]OperandKind{} },
                .{ .name = "FlagLValueReference", .value = 0x800, .parameters = &[_]OperandKind{} },
                .{ .name = "FlagRValueReference", .value = 0x1000, .parameters = &[_]OperandKind{} },
                .{ .name = "FlagIsOptimized", .value = 0x2000, .parameters = &[_]OperandKind{} },
                .{ .name = "FlagIsEnumClass", .value = 0x4000, .parameters = &[_]OperandKind{} },
                .{ .name = "FlagTypePassByValue", .value = 0x8000, .parameters = &[_]OperandKind{} },
                .{ .name = "FlagTypePassByReference", .value = 0x10000, .parameters = &[_]OperandKind{} },
                .{ .name = "FlagUnknownPhysicalLayout", .value = 0x20000, .parameters = &[_]OperandKind{} },
            },
            .@"NonSemantic.Shader.DebugInfo.100.BuildIdentifierFlags" => &[_]Enumerant{
                .{ .name = "IdentifierPossibleDuplicates", .value = 0x01, .parameters = &[_]OperandKind{} },
            },
            .@"NonSemantic.Shader.DebugInfo.100.DebugBaseTypeAttributeEncoding" => &[_]Enumerant{
                .{ .name = "Unspecified", .value = 0, .parameters = &[_]OperandKind{} },
                .{ .name = "Address", .value = 1, .parameters = &[_]OperandKind{} },
                .{ .name = "Boolean", .value = 2, .parameters = &[_]OperandKind{} },
                .{ .name = "Float", .value = 3, .parameters = &[_]OperandKind{} },
                .{ .name = "Signed", .value = 4, .parameters = &[_]OperandKind{} },
                .{ .name = "SignedChar", .value = 5, .parameters = &[_]OperandKind{} },
                .{ .name = "Unsigned", .value = 6, .parameters = &[_]OperandKind{} },
                .{ .name = "UnsignedChar", .value = 7, .parameters = &[_]OperandKind{} },
            },
            .@"NonSemantic.Shader.DebugInfo.100.DebugCompositeType" => &[_]Enumerant{
                .{ .name = "Class", .value = 0, .parameters = &[_]OperandKind{} },
                .{ .name = "Structure", .value = 1, .parameters = &[_]OperandKind{} },
                .{ .name = "Union", .value = 2, .parameters = &[_]OperandKind{} },
            },
            .@"NonSemantic.Shader.DebugInfo.100.DebugTypeQualifier" => &[_]Enumerant{
                .{ .name = "ConstType", .value = 0, .parameters = &[_]OperandKind{} },
                .{ .name = "VolatileType", .value = 1, .parameters = &[_]OperandKind{} },
                .{ .name = "RestrictType", .value = 2, .parameters = &[_]OperandKind{} },
                .{ .name = "AtomicType", .value = 3, .parameters = &[_]OperandKind{} },
            },
            .@"NonSemantic.Shader.DebugInfo.100.DebugOperation" => &[_]Enumerant{
                .{ .name = "Deref", .value = 0, .parameters = &[_]OperandKind{} },
                .{ .name = "Plus", .value = 1, .parameters = &[_]OperandKind{} },
                .{ .name = "Minus", .value = 2, .parameters = &[_]OperandKind{} },
                .{ .name = "PlusUconst", .value = 3, .parameters = &[_]OperandKind{.IdRef} },
                .{ .name = "BitPiece", .value = 4, .parameters = &[_]OperandKind{ .IdRef, .IdRef } },
                .{ .name = "Swap", .value = 5, .parameters = &[_]OperandKind{} },
                .{ .name = "Xderef", .value = 6, .parameters = &[_]OperandKind{} },
                .{ .name = "StackValue", .value = 7, .parameters = &[_]OperandKind{} },
                .{ .name = "Constu", .value = 8, .parameters = &[_]OperandKind{.IdRef} },
                .{ .name = "Fragment", .value = 9, .parameters = &[_]OperandKind{ .IdRef, .IdRef } },
            },
            .@"NonSemantic.Shader.DebugInfo.100.DebugImportedEntity" => &[_]Enumerant{
                .{ .name = "ImportedModule", .value = 0, .parameters = &[_]OperandKind{} },
                .{ .name = "ImportedDeclaration", .value = 1, .parameters = &[_]OperandKind{} },
            },
            .@"NonSemantic.ClspvReflection.6.KernelPropertyFlags" => &[_]Enumerant{
                .{ .name = "MayUsePrintf", .value = 0x1, .parameters = &[_]OperandKind{} },
            },
            .@"DebugInfo.DebugInfoFlags" => &[_]Enumerant{
                .{ .name = "FlagIsProtected", .value = 0x01, .parameters = &[_]OperandKind{} },
                .{ .name = "FlagIsPrivate", .value = 0x02, .parameters = &[_]OperandKind{} },
                .{ .name = "FlagIsPublic", .value = 0x03, .parameters = &[_]OperandKind{} },
                .{ .name = "FlagIsLocal", .value = 0x04, .parameters = &[_]OperandKind{} },
                .{ .name = "FlagIsDefinition", .value = 0x08, .parameters = &[_]OperandKind{} },
                .{ .name = "FlagFwdDecl", .value = 0x10, .parameters = &[_]OperandKind{} },
                .{ .name = "FlagArtificial", .value = 0x20, .parameters = &[_]OperandKind{} },
                .{ .name = "FlagExplicit", .value = 0x40, .parameters = &[_]OperandKind{} },
                .{ .name = "FlagPrototyped", .value = 0x80, .parameters = &[_]OperandKind{} },
                .{ .name = "FlagObjectPointer", .value = 0x100, .parameters = &[_]OperandKind{} },
                .{ .name = "FlagStaticMember", .value = 0x200, .parameters = &[_]OperandKind{} },
                .{ .name = "FlagIndirectVariable", .value = 0x400, .parameters = &[_]OperandKind{} },
                .{ .name = "FlagLValueReference", .value = 0x800, .parameters = &[_]OperandKind{} },
                .{ .name = "FlagRValueReference", .value = 0x1000, .parameters = &[_]OperandKind{} },
                .{ .name = "FlagIsOptimized", .value = 0x2000, .parameters = &[_]OperandKind{} },
            },
            .@"DebugInfo.DebugBaseTypeAttributeEncoding" => &[_]Enumerant{
                .{ .name = "Unspecified", .value = 0, .parameters = &[_]OperandKind{} },
                .{ .name = "Address", .value = 1, .parameters = &[_]OperandKind{} },
                .{ .name = "Boolean", .value = 2, .parameters = &[_]OperandKind{} },
                .{ .name = "Float", .value = 4, .parameters = &[_]OperandKind{} },
                .{ .name = "Signed", .value = 5, .parameters = &[_]OperandKind{} },
                .{ .name = "SignedChar", .value = 6, .parameters = &[_]OperandKind{} },
                .{ .name = "Unsigned", .value = 7, .parameters = &[_]OperandKind{} },
                .{ .name = "UnsignedChar", .value = 8, .parameters = &[_]OperandKind{} },
            },
            .@"DebugInfo.DebugCompositeType" => &[_]Enumerant{
                .{ .name = "Class", .value = 0, .parameters = &[_]OperandKind{} },
                .{ .name = "Structure", .value = 1, .parameters = &[_]OperandKind{} },
                .{ .name = "Union", .value = 2, .parameters = &[_]OperandKind{} },
            },
            .@"DebugInfo.DebugTypeQualifier" => &[_]Enumerant{
                .{ .name = "ConstType", .value = 0, .parameters = &[_]OperandKind{} },
                .{ .name = "VolatileType", .value = 1, .parameters = &[_]OperandKind{} },
                .{ .name = "RestrictType", .value = 2, .parameters = &[_]OperandKind{} },
            },
            .@"DebugInfo.DebugOperation" => &[_]Enumerant{
                .{ .name = "Deref", .value = 0, .parameters = &[_]OperandKind{} },
                .{ .name = "Plus", .value = 1, .parameters = &[_]OperandKind{} },
                .{ .name = "Minus", .value = 2, .parameters = &[_]OperandKind{} },
                .{ .name = "PlusUconst", .value = 3, .parameters = &[_]OperandKind{.LiteralInteger} },
                .{ .name = "BitPiece", .value = 4, .parameters = &[_]OperandKind{ .LiteralInteger, .LiteralInteger } },
                .{ .name = "Swap", .value = 5, .parameters = &[_]OperandKind{} },
                .{ .name = "Xderef", .value = 6, .parameters = &[_]OperandKind{} },
                .{ .name = "StackValue", .value = 7, .parameters = &[_]OperandKind{} },
                .{ .name = "Constu", .value = 8, .parameters = &[_]OperandKind{.LiteralInteger} },
            },
        };
    }
};
pub const Opcode = enum(u16) {
    OpNop = 0,
    OpUndef = 1,
    OpSourceContinued = 2,
    OpSource = 3,
    OpSourceExtension = 4,
    OpName = 5,
    OpMemberName = 6,
    OpString = 7,
    OpLine = 8,
    OpExtension = 10,
    OpExtInstImport = 11,
    OpExtInst = 12,
    OpMemoryModel = 14,
    OpEntryPoint = 15,
    OpExecutionMode = 16,
    OpCapability = 17,
    OpTypeVoid = 19,
    OpTypeBool = 20,
    OpTypeInt = 21,
    OpTypeFloat = 22,
    OpTypeVector = 23,
    OpTypeMatrix = 24,
    OpTypeImage = 25,
    OpTypeSampler = 26,
    OpTypeSampledImage = 27,
    OpTypeArray = 28,
    OpTypeRuntimeArray = 29,
    OpTypeStruct = 30,
    OpTypeOpaque = 31,
    OpTypePointer = 32,
    OpTypeFunction = 33,
    OpTypeEvent = 34,
    OpTypeDeviceEvent = 35,
    OpTypeReserveId = 36,
    OpTypeQueue = 37,
    OpTypePipe = 38,
    OpTypeForwardPointer = 39,
    OpConstantTrue = 41,
    OpConstantFalse = 42,
    OpConstant = 43,
    OpConstantComposite = 44,
    OpConstantSampler = 45,
    OpConstantNull = 46,
    OpSpecConstantTrue = 48,
    OpSpecConstantFalse = 49,
    OpSpecConstant = 50,
    OpSpecConstantComposite = 51,
    OpSpecConstantOp = 52,
    OpFunction = 54,
    OpFunctionParameter = 55,
    OpFunctionEnd = 56,
    OpFunctionCall = 57,
    OpVariable = 59,
    OpImageTexelPointer = 60,
    OpLoad = 61,
    OpStore = 62,
    OpCopyMemory = 63,
    OpCopyMemorySized = 64,
    OpAccessChain = 65,
    OpInBoundsAccessChain = 66,
    OpPtrAccessChain = 67,
    OpArrayLength = 68,
    OpGenericPtrMemSemantics = 69,
    OpInBoundsPtrAccessChain = 70,
    OpDecorate = 71,
    OpMemberDecorate = 72,
    OpDecorationGroup = 73,
    OpGroupDecorate = 74,
    OpGroupMemberDecorate = 75,
    OpVectorExtractDynamic = 77,
    OpVectorInsertDynamic = 78,
    OpVectorShuffle = 79,
    OpCompositeConstruct = 80,
    OpCompositeExtract = 81,
    OpCompositeInsert = 82,
    OpCopyObject = 83,
    OpTranspose = 84,
    OpSampledImage = 86,
    OpImageSampleImplicitLod = 87,
    OpImageSampleExplicitLod = 88,
    OpImageSampleDrefImplicitLod = 89,
    OpImageSampleDrefExplicitLod = 90,
    OpImageSampleProjImplicitLod = 91,
    OpImageSampleProjExplicitLod = 92,
    OpImageSampleProjDrefImplicitLod = 93,
    OpImageSampleProjDrefExplicitLod = 94,
    OpImageFetch = 95,
    OpImageGather = 96,
    OpImageDrefGather = 97,
    OpImageRead = 98,
    OpImageWrite = 99,
    OpImage = 100,
    OpImageQueryFormat = 101,
    OpImageQueryOrder = 102,
    OpImageQuerySizeLod = 103,
    OpImageQuerySize = 104,
    OpImageQueryLod = 105,
    OpImageQueryLevels = 106,
    OpImageQuerySamples = 107,
    OpConvertFToU = 109,
    OpConvertFToS = 110,
    OpConvertSToF = 111,
    OpConvertUToF = 112,
    OpUConvert = 113,
    OpSConvert = 114,
    OpFConvert = 115,
    OpQuantizeToF16 = 116,
    OpConvertPtrToU = 117,
    OpSatConvertSToU = 118,
    OpSatConvertUToS = 119,
    OpConvertUToPtr = 120,
    OpPtrCastToGeneric = 121,
    OpGenericCastToPtr = 122,
    OpGenericCastToPtrExplicit = 123,
    OpBitcast = 124,
    OpSNegate = 126,
    OpFNegate = 127,
    OpIAdd = 128,
    OpFAdd = 129,
    OpISub = 130,
    OpFSub = 131,
    OpIMul = 132,
    OpFMul = 133,
    OpUDiv = 134,
    OpSDiv = 135,
    OpFDiv = 136,
    OpUMod = 137,
    OpSRem = 138,
    OpSMod = 139,
    OpFRem = 140,
    OpFMod = 141,
    OpVectorTimesScalar = 142,
    OpMatrixTimesScalar = 143,
    OpVectorTimesMatrix = 144,
    OpMatrixTimesVector = 145,
    OpMatrixTimesMatrix = 146,
    OpOuterProduct = 147,
    OpDot = 148,
    OpIAddCarry = 149,
    OpISubBorrow = 150,
    OpUMulExtended = 151,
    OpSMulExtended = 152,
    OpAny = 154,
    OpAll = 155,
    OpIsNan = 156,
    OpIsInf = 157,
    OpIsFinite = 158,
    OpIsNormal = 159,
    OpSignBitSet = 160,
    OpLessOrGreater = 161,
    OpOrdered = 162,
    OpUnordered = 163,
    OpLogicalEqual = 164,
    OpLogicalNotEqual = 165,
    OpLogicalOr = 166,
    OpLogicalAnd = 167,
    OpLogicalNot = 168,
    OpSelect = 169,
    OpIEqual = 170,
    OpINotEqual = 171,
    OpUGreaterThan = 172,
    OpSGreaterThan = 173,
    OpUGreaterThanEqual = 174,
    OpSGreaterThanEqual = 175,
    OpULessThan = 176,
    OpSLessThan = 177,
    OpULessThanEqual = 178,
    OpSLessThanEqual = 179,
    OpFOrdEqual = 180,
    OpFUnordEqual = 181,
    OpFOrdNotEqual = 182,
    OpFUnordNotEqual = 183,
    OpFOrdLessThan = 184,
    OpFUnordLessThan = 185,
    OpFOrdGreaterThan = 186,
    OpFUnordGreaterThan = 187,
    OpFOrdLessThanEqual = 188,
    OpFUnordLessThanEqual = 189,
    OpFOrdGreaterThanEqual = 190,
    OpFUnordGreaterThanEqual = 191,
    OpShiftRightLogical = 194,
    OpShiftRightArithmetic = 195,
    OpShiftLeftLogical = 196,
    OpBitwiseOr = 197,
    OpBitwiseXor = 198,
    OpBitwiseAnd = 199,
    OpNot = 200,
    OpBitFieldInsert = 201,
    OpBitFieldSExtract = 202,
    OpBitFieldUExtract = 203,
    OpBitReverse = 204,
    OpBitCount = 205,
    OpDPdx = 207,
    OpDPdy = 208,
    OpFwidth = 209,
    OpDPdxFine = 210,
    OpDPdyFine = 211,
    OpFwidthFine = 212,
    OpDPdxCoarse = 213,
    OpDPdyCoarse = 214,
    OpFwidthCoarse = 215,
    OpEmitVertex = 218,
    OpEndPrimitive = 219,
    OpEmitStreamVertex = 220,
    OpEndStreamPrimitive = 221,
    OpControlBarrier = 224,
    OpMemoryBarrier = 225,
    OpAtomicLoad = 227,
    OpAtomicStore = 228,
    OpAtomicExchange = 229,
    OpAtomicCompareExchange = 230,
    OpAtomicCompareExchangeWeak = 231,
    OpAtomicIIncrement = 232,
    OpAtomicIDecrement = 233,
    OpAtomicIAdd = 234,
    OpAtomicISub = 235,
    OpAtomicSMin = 236,
    OpAtomicUMin = 237,
    OpAtomicSMax = 238,
    OpAtomicUMax = 239,
    OpAtomicAnd = 240,
    OpAtomicOr = 241,
    OpAtomicXor = 242,
    OpPhi = 245,
    OpLoopMerge = 246,
    OpSelectionMerge = 247,
    OpLabel = 248,
    OpBranch = 249,
    OpBranchConditional = 250,
    OpSwitch = 251,
    OpKill = 252,
    OpReturn = 253,
    OpReturnValue = 254,
    OpUnreachable = 255,
    OpLifetimeStart = 256,
    OpLifetimeStop = 257,
    OpGroupAsyncCopy = 259,
    OpGroupWaitEvents = 260,
    OpGroupAll = 261,
    OpGroupAny = 262,
    OpGroupBroadcast = 263,
    OpGroupIAdd = 264,
    OpGroupFAdd = 265,
    OpGroupFMin = 266,
    OpGroupUMin = 267,
    OpGroupSMin = 268,
    OpGroupFMax = 269,
    OpGroupUMax = 270,
    OpGroupSMax = 271,
    OpReadPipe = 274,
    OpWritePipe = 275,
    OpReservedReadPipe = 276,
    OpReservedWritePipe = 277,
    OpReserveReadPipePackets = 278,
    OpReserveWritePipePackets = 279,
    OpCommitReadPipe = 280,
    OpCommitWritePipe = 281,
    OpIsValidReserveId = 282,
    OpGetNumPipePackets = 283,
    OpGetMaxPipePackets = 284,
    OpGroupReserveReadPipePackets = 285,
    OpGroupReserveWritePipePackets = 286,
    OpGroupCommitReadPipe = 287,
    OpGroupCommitWritePipe = 288,
    OpEnqueueMarker = 291,
    OpEnqueueKernel = 292,
    OpGetKernelNDrangeSubGroupCount = 293,
    OpGetKernelNDrangeMaxSubGroupSize = 294,
    OpGetKernelWorkGroupSize = 295,
    OpGetKernelPreferredWorkGroupSizeMultiple = 296,
    OpRetainEvent = 297,
    OpReleaseEvent = 298,
    OpCreateUserEvent = 299,
    OpIsValidEvent = 300,
    OpSetUserEventStatus = 301,
    OpCaptureEventProfilingInfo = 302,
    OpGetDefaultQueue = 303,
    OpBuildNDRange = 304,
    OpImageSparseSampleImplicitLod = 305,
    OpImageSparseSampleExplicitLod = 306,
    OpImageSparseSampleDrefImplicitLod = 307,
    OpImageSparseSampleDrefExplicitLod = 308,
    OpImageSparseSampleProjImplicitLod = 309,
    OpImageSparseSampleProjExplicitLod = 310,
    OpImageSparseSampleProjDrefImplicitLod = 311,
    OpImageSparseSampleProjDrefExplicitLod = 312,
    OpImageSparseFetch = 313,
    OpImageSparseGather = 314,
    OpImageSparseDrefGather = 315,
    OpImageSparseTexelsResident = 316,
    OpNoLine = 317,
    OpAtomicFlagTestAndSet = 318,
    OpAtomicFlagClear = 319,
    OpImageSparseRead = 320,
    OpSizeOf = 321,
    OpTypePipeStorage = 322,
    OpConstantPipeStorage = 323,
    OpCreatePipeFromPipeStorage = 324,
    OpGetKernelLocalSizeForSubgroupCount = 325,
    OpGetKernelMaxNumSubgroups = 326,
    OpTypeNamedBarrier = 327,
    OpNamedBarrierInitialize = 328,
    OpMemoryNamedBarrier = 329,
    OpModuleProcessed = 330,
    OpExecutionModeId = 331,
    OpDecorateId = 332,
    OpGroupNonUniformElect = 333,
    OpGroupNonUniformAll = 334,
    OpGroupNonUniformAny = 335,
    OpGroupNonUniformAllEqual = 336,
    OpGroupNonUniformBroadcast = 337,
    OpGroupNonUniformBroadcastFirst = 338,
    OpGroupNonUniformBallot = 339,
    OpGroupNonUniformInverseBallot = 340,
    OpGroupNonUniformBallotBitExtract = 341,
    OpGroupNonUniformBallotBitCount = 342,
    OpGroupNonUniformBallotFindLSB = 343,
    OpGroupNonUniformBallotFindMSB = 344,
    OpGroupNonUniformShuffle = 345,
    OpGroupNonUniformShuffleXor = 346,
    OpGroupNonUniformShuffleUp = 347,
    OpGroupNonUniformShuffleDown = 348,
    OpGroupNonUniformIAdd = 349,
    OpGroupNonUniformFAdd = 350,
    OpGroupNonUniformIMul = 351,
    OpGroupNonUniformFMul = 352,
    OpGroupNonUniformSMin = 353,
    OpGroupNonUniformUMin = 354,
    OpGroupNonUniformFMin = 355,
    OpGroupNonUniformSMax = 356,
    OpGroupNonUniformUMax = 357,
    OpGroupNonUniformFMax = 358,
    OpGroupNonUniformBitwiseAnd = 359,
    OpGroupNonUniformBitwiseOr = 360,
    OpGroupNonUniformBitwiseXor = 361,
    OpGroupNonUniformLogicalAnd = 362,
    OpGroupNonUniformLogicalOr = 363,
    OpGroupNonUniformLogicalXor = 364,
    OpGroupNonUniformQuadBroadcast = 365,
    OpGroupNonUniformQuadSwap = 366,
    OpCopyLogical = 400,
    OpPtrEqual = 401,
    OpPtrNotEqual = 402,
    OpPtrDiff = 403,
    OpColorAttachmentReadEXT = 4160,
    OpDepthAttachmentReadEXT = 4161,
    OpStencilAttachmentReadEXT = 4162,
    OpTerminateInvocation = 4416,
    OpSubgroupBallotKHR = 4421,
    OpSubgroupFirstInvocationKHR = 4422,
    OpSubgroupAllKHR = 4428,
    OpSubgroupAnyKHR = 4429,
    OpSubgroupAllEqualKHR = 4430,
    OpGroupNonUniformRotateKHR = 4431,
    OpSubgroupReadInvocationKHR = 4432,
    OpTraceRayKHR = 4445,
    OpExecuteCallableKHR = 4446,
    OpConvertUToAccelerationStructureKHR = 4447,
    OpIgnoreIntersectionKHR = 4448,
    OpTerminateRayKHR = 4449,
    OpSDot = 4450,
    OpUDot = 4451,
    OpSUDot = 4452,
    OpSDotAccSat = 4453,
    OpUDotAccSat = 4454,
    OpSUDotAccSat = 4455,
    OpTypeCooperativeMatrixKHR = 4456,
    OpCooperativeMatrixLoadKHR = 4457,
    OpCooperativeMatrixStoreKHR = 4458,
    OpCooperativeMatrixMulAddKHR = 4459,
    OpCooperativeMatrixLengthKHR = 4460,
    OpTypeRayQueryKHR = 4472,
    OpRayQueryInitializeKHR = 4473,
    OpRayQueryTerminateKHR = 4474,
    OpRayQueryGenerateIntersectionKHR = 4475,
    OpRayQueryConfirmIntersectionKHR = 4476,
    OpRayQueryProceedKHR = 4477,
    OpRayQueryGetIntersectionTypeKHR = 4479,
    OpImageSampleWeightedQCOM = 4480,
    OpImageBoxFilterQCOM = 4481,
    OpImageBlockMatchSSDQCOM = 4482,
    OpImageBlockMatchSADQCOM = 4483,
    OpImageBlockMatchWindowSSDQCOM = 4500,
    OpImageBlockMatchWindowSADQCOM = 4501,
    OpImageBlockMatchGatherSSDQCOM = 4502,
    OpImageBlockMatchGatherSADQCOM = 4503,
    OpGroupIAddNonUniformAMD = 5000,
    OpGroupFAddNonUniformAMD = 5001,
    OpGroupFMinNonUniformAMD = 5002,
    OpGroupUMinNonUniformAMD = 5003,
    OpGroupSMinNonUniformAMD = 5004,
    OpGroupFMaxNonUniformAMD = 5005,
    OpGroupUMaxNonUniformAMD = 5006,
    OpGroupSMaxNonUniformAMD = 5007,
    OpFragmentMaskFetchAMD = 5011,
    OpFragmentFetchAMD = 5012,
    OpReadClockKHR = 5056,
    OpFinalizeNodePayloadsAMDX = 5075,
    OpFinishWritingNodePayloadAMDX = 5078,
    OpInitializeNodePayloadsAMDX = 5090,
    OpGroupNonUniformQuadAllKHR = 5110,
    OpGroupNonUniformQuadAnyKHR = 5111,
    OpHitObjectRecordHitMotionNV = 5249,
    OpHitObjectRecordHitWithIndexMotionNV = 5250,
    OpHitObjectRecordMissMotionNV = 5251,
    OpHitObjectGetWorldToObjectNV = 5252,
    OpHitObjectGetObjectToWorldNV = 5253,
    OpHitObjectGetObjectRayDirectionNV = 5254,
    OpHitObjectGetObjectRayOriginNV = 5255,
    OpHitObjectTraceRayMotionNV = 5256,
    OpHitObjectGetShaderRecordBufferHandleNV = 5257,
    OpHitObjectGetShaderBindingTableRecordIndexNV = 5258,
    OpHitObjectRecordEmptyNV = 5259,
    OpHitObjectTraceRayNV = 5260,
    OpHitObjectRecordHitNV = 5261,
    OpHitObjectRecordHitWithIndexNV = 5262,
    OpHitObjectRecordMissNV = 5263,
    OpHitObjectExecuteShaderNV = 5264,
    OpHitObjectGetCurrentTimeNV = 5265,
    OpHitObjectGetAttributesNV = 5266,
    OpHitObjectGetHitKindNV = 5267,
    OpHitObjectGetPrimitiveIndexNV = 5268,
    OpHitObjectGetGeometryIndexNV = 5269,
    OpHitObjectGetInstanceIdNV = 5270,
    OpHitObjectGetInstanceCustomIndexNV = 5271,
    OpHitObjectGetWorldRayDirectionNV = 5272,
    OpHitObjectGetWorldRayOriginNV = 5273,
    OpHitObjectGetRayTMaxNV = 5274,
    OpHitObjectGetRayTMinNV = 5275,
    OpHitObjectIsEmptyNV = 5276,
    OpHitObjectIsHitNV = 5277,
    OpHitObjectIsMissNV = 5278,
    OpReorderThreadWithHitObjectNV = 5279,
    OpReorderThreadWithHintNV = 5280,
    OpTypeHitObjectNV = 5281,
    OpImageSampleFootprintNV = 5283,
    OpEmitMeshTasksEXT = 5294,
    OpSetMeshOutputsEXT = 5295,
    OpGroupNonUniformPartitionNV = 5296,
    OpWritePackedPrimitiveIndices4x8NV = 5299,
    OpFetchMicroTriangleVertexPositionNV = 5300,
    OpFetchMicroTriangleVertexBarycentricNV = 5301,
    OpReportIntersectionKHR = 5334,
    OpIgnoreIntersectionNV = 5335,
    OpTerminateRayNV = 5336,
    OpTraceNV = 5337,
    OpTraceMotionNV = 5338,
    OpTraceRayMotionNV = 5339,
    OpRayQueryGetIntersectionTriangleVertexPositionsKHR = 5340,
    OpTypeAccelerationStructureKHR = 5341,
    OpExecuteCallableNV = 5344,
    OpTypeCooperativeMatrixNV = 5358,
    OpCooperativeMatrixLoadNV = 5359,
    OpCooperativeMatrixStoreNV = 5360,
    OpCooperativeMatrixMulAddNV = 5361,
    OpCooperativeMatrixLengthNV = 5362,
    OpBeginInvocationInterlockEXT = 5364,
    OpEndInvocationInterlockEXT = 5365,
    OpDemoteToHelperInvocation = 5380,
    OpIsHelperInvocationEXT = 5381,
    OpConvertUToImageNV = 5391,
    OpConvertUToSamplerNV = 5392,
    OpConvertImageToUNV = 5393,
    OpConvertSamplerToUNV = 5394,
    OpConvertUToSampledImageNV = 5395,
    OpConvertSampledImageToUNV = 5396,
    OpSamplerImageAddressingModeNV = 5397,
    OpRawAccessChainNV = 5398,
    OpSubgroupShuffleINTEL = 5571,
    OpSubgroupShuffleDownINTEL = 5572,
    OpSubgroupShuffleUpINTEL = 5573,
    OpSubgroupShuffleXorINTEL = 5574,
    OpSubgroupBlockReadINTEL = 5575,
    OpSubgroupBlockWriteINTEL = 5576,
    OpSubgroupImageBlockReadINTEL = 5577,
    OpSubgroupImageBlockWriteINTEL = 5578,
    OpSubgroupImageMediaBlockReadINTEL = 5580,
    OpSubgroupImageMediaBlockWriteINTEL = 5581,
    OpUCountLeadingZerosINTEL = 5585,
    OpUCountTrailingZerosINTEL = 5586,
    OpAbsISubINTEL = 5587,
    OpAbsUSubINTEL = 5588,
    OpIAddSatINTEL = 5589,
    OpUAddSatINTEL = 5590,
    OpIAverageINTEL = 5591,
    OpUAverageINTEL = 5592,
    OpIAverageRoundedINTEL = 5593,
    OpUAverageRoundedINTEL = 5594,
    OpISubSatINTEL = 5595,
    OpUSubSatINTEL = 5596,
    OpIMul32x16INTEL = 5597,
    OpUMul32x16INTEL = 5598,
    OpAtomicFMinEXT = 5614,
    OpAtomicFMaxEXT = 5615,
    OpAssumeTrueKHR = 5630,
    OpExpectKHR = 5631,
    OpDecorateString = 5632,
    OpMemberDecorateString = 5633,
    OpLoopControlINTEL = 5887,
    OpReadPipeBlockingINTEL = 5946,
    OpWritePipeBlockingINTEL = 5947,
    OpFPGARegINTEL = 5949,
    OpRayQueryGetRayTMinKHR = 6016,
    OpRayQueryGetRayFlagsKHR = 6017,
    OpRayQueryGetIntersectionTKHR = 6018,
    OpRayQueryGetIntersectionInstanceCustomIndexKHR = 6019,
    OpRayQueryGetIntersectionInstanceIdKHR = 6020,
    OpRayQueryGetIntersectionInstanceShaderBindingTableRecordOffsetKHR = 6021,
    OpRayQueryGetIntersectionGeometryIndexKHR = 6022,
    OpRayQueryGetIntersectionPrimitiveIndexKHR = 6023,
    OpRayQueryGetIntersectionBarycentricsKHR = 6024,
    OpRayQueryGetIntersectionFrontFaceKHR = 6025,
    OpRayQueryGetIntersectionCandidateAABBOpaqueKHR = 6026,
    OpRayQueryGetIntersectionObjectRayDirectionKHR = 6027,
    OpRayQueryGetIntersectionObjectRayOriginKHR = 6028,
    OpRayQueryGetWorldRayDirectionKHR = 6029,
    OpRayQueryGetWorldRayOriginKHR = 6030,
    OpRayQueryGetIntersectionObjectToWorldKHR = 6031,
    OpRayQueryGetIntersectionWorldToObjectKHR = 6032,
    OpAtomicFAddEXT = 6035,
    OpTypeBufferSurfaceINTEL = 6086,
    OpTypeStructContinuedINTEL = 6090,
    OpConstantCompositeContinuedINTEL = 6091,
    OpSpecConstantCompositeContinuedINTEL = 6092,
    OpCompositeConstructContinuedINTEL = 6096,
    OpConvertFToBF16INTEL = 6116,
    OpConvertBF16ToFINTEL = 6117,
    OpControlBarrierArriveINTEL = 6142,
    OpControlBarrierWaitINTEL = 6143,
    OpGroupIMulKHR = 6401,
    OpGroupFMulKHR = 6402,
    OpGroupBitwiseAndKHR = 6403,
    OpGroupBitwiseOrKHR = 6404,
    OpGroupBitwiseXorKHR = 6405,
    OpGroupLogicalAndKHR = 6406,
    OpGroupLogicalOrKHR = 6407,
    OpGroupLogicalXorKHR = 6408,
    OpMaskedGatherINTEL = 6428,
    OpMaskedScatterINTEL = 6429,
    pub const OpSDotKHR = Opcode.OpSDot;
    pub const OpUDotKHR = Opcode.OpUDot;
    pub const OpSUDotKHR = Opcode.OpSUDot;
    pub const OpSDotAccSatKHR = Opcode.OpSDotAccSat;
    pub const OpUDotAccSatKHR = Opcode.OpUDotAccSat;
    pub const OpSUDotAccSatKHR = Opcode.OpSUDotAccSat;
    pub const OpReportIntersectionNV = Opcode.OpReportIntersectionKHR;
    pub const OpTypeAccelerationStructureNV = Opcode.OpTypeAccelerationStructureKHR;
    pub const OpDemoteToHelperInvocationEXT = Opcode.OpDemoteToHelperInvocation;
    pub const OpDecorateStringGOOGLE = Opcode.OpDecorateString;
    pub const OpMemberDecorateStringGOOGLE = Opcode.OpMemberDecorateString;

    pub fn Operands(comptime self: Opcode) type {
        return switch (self) {
            .OpNop => void,
            .OpUndef => struct { id_result_type: IdResultType, id_result: IdResult },
            .OpSourceContinued => struct { continued_source: LiteralString },
            .OpSource => struct { source_language: SourceLanguage, version: LiteralInteger, file: ?IdRef = null, source: ?LiteralString = null },
            .OpSourceExtension => struct { extension: LiteralString },
            .OpName => struct { target: IdRef, name: LiteralString },
            .OpMemberName => struct { type: IdRef, member: LiteralInteger, name: LiteralString },
            .OpString => struct { id_result: IdResult, string: LiteralString },
            .OpLine => struct { file: IdRef, line: LiteralInteger, column: LiteralInteger },
            .OpExtension => struct { name: LiteralString },
            .OpExtInstImport => struct { id_result: IdResult, name: LiteralString },
            .OpExtInst => struct { id_result_type: IdResultType, id_result: IdResult, set: IdRef, instruction: LiteralExtInstInteger, id_ref_4: []const IdRef = &.{} },
            .OpMemoryModel => struct { addressing_model: AddressingModel, memory_model: MemoryModel },
            .OpEntryPoint => struct { execution_model: ExecutionModel, entry_point: IdRef, name: LiteralString, interface: []const IdRef = &.{} },
            .OpExecutionMode => struct { entry_point: IdRef, mode: ExecutionMode.Extended },
            .OpCapability => struct { capability: Capability },
            .OpTypeVoid => struct { id_result: IdResult },
            .OpTypeBool => struct { id_result: IdResult },
            .OpTypeInt => struct { id_result: IdResult, width: LiteralInteger, signedness: LiteralInteger },
            .OpTypeFloat => struct { id_result: IdResult, width: LiteralInteger },
            .OpTypeVector => struct { id_result: IdResult, component_type: IdRef, component_count: LiteralInteger },
            .OpTypeMatrix => struct { id_result: IdResult, column_type: IdRef, column_count: LiteralInteger },
            .OpTypeImage => struct { id_result: IdResult, sampled_type: IdRef, dim: Dim, depth: LiteralInteger, arrayed: LiteralInteger, ms: LiteralInteger, sampled: LiteralInteger, image_format: ImageFormat, access_qualifier: ?AccessQualifier = null },
            .OpTypeSampler => struct { id_result: IdResult },
            .OpTypeSampledImage => struct { id_result: IdResult, image_type: IdRef },
            .OpTypeArray => struct { id_result: IdResult, element_type: IdRef, length: IdRef },
            .OpTypeRuntimeArray => struct { id_result: IdResult, element_type: IdRef },
            .OpTypeStruct => struct { id_result: IdResult, id_ref: []const IdRef = &.{} },
            .OpTypeOpaque => struct { id_result: IdResult, literal_string: LiteralString },
            .OpTypePointer => struct { id_result: IdResult, storage_class: StorageClass, type: IdRef },
            .OpTypeFunction => struct { id_result: IdResult, return_type: IdRef, id_ref_2: []const IdRef = &.{} },
            .OpTypeEvent => struct { id_result: IdResult },
            .OpTypeDeviceEvent => struct { id_result: IdResult },
            .OpTypeReserveId => struct { id_result: IdResult },
            .OpTypeQueue => struct { id_result: IdResult },
            .OpTypePipe => struct { id_result: IdResult, qualifier: AccessQualifier },
            .OpTypeForwardPointer => struct { pointer_type: IdRef, storage_class: StorageClass },
            .OpConstantTrue => struct { id_result_type: IdResultType, id_result: IdResult },
            .OpConstantFalse => struct { id_result_type: IdResultType, id_result: IdResult },
            .OpConstant => struct { id_result_type: IdResultType, id_result: IdResult, value: LiteralContextDependentNumber },
            .OpConstantComposite => struct { id_result_type: IdResultType, id_result: IdResult, constituents: []const IdRef = &.{} },
            .OpConstantSampler => struct { id_result_type: IdResultType, id_result: IdResult, sampler_addressing_mode: SamplerAddressingMode, param: LiteralInteger, sampler_filter_mode: SamplerFilterMode },
            .OpConstantNull => struct { id_result_type: IdResultType, id_result: IdResult },
            .OpSpecConstantTrue => struct { id_result_type: IdResultType, id_result: IdResult },
            .OpSpecConstantFalse => struct { id_result_type: IdResultType, id_result: IdResult },
            .OpSpecConstant => struct { id_result_type: IdResultType, id_result: IdResult, value: LiteralContextDependentNumber },
            .OpSpecConstantComposite => struct { id_result_type: IdResultType, id_result: IdResult, constituents: []const IdRef = &.{} },
            .OpSpecConstantOp => struct { id_result_type: IdResultType, id_result: IdResult, opcode: LiteralSpecConstantOpInteger },
            .OpFunction => struct { id_result_type: IdResultType, id_result: IdResult, function_control: FunctionControl, function_type: IdRef },
            .OpFunctionParameter => struct { id_result_type: IdResultType, id_result: IdResult },
            .OpFunctionEnd => void,
            .OpFunctionCall => struct { id_result_type: IdResultType, id_result: IdResult, function: IdRef, id_ref_3: []const IdRef = &.{} },
            .OpVariable => struct { id_result_type: IdResultType, id_result: IdResult, storage_class: StorageClass, initializer: ?IdRef = null },
            .OpImageTexelPointer => struct { id_result_type: IdResultType, id_result: IdResult, image: IdRef, coordinate: IdRef, sample: IdRef },
            .OpLoad => struct { id_result_type: IdResultType, id_result: IdResult, pointer: IdRef, memory_access: ?MemoryAccess.Extended = null },
            .OpStore => struct { pointer: IdRef, object: IdRef, memory_access: ?MemoryAccess.Extended = null },
            .OpCopyMemory => struct { target: IdRef, source: IdRef, memory_access_2: ?MemoryAccess.Extended = null, memory_access_3: ?MemoryAccess.Extended = null },
            .OpCopyMemorySized => struct { target: IdRef, source: IdRef, size: IdRef, memory_access_3: ?MemoryAccess.Extended = null, memory_access_4: ?MemoryAccess.Extended = null },
            .OpAccessChain => struct { id_result_type: IdResultType, id_result: IdResult, base: IdRef, indexes: []const IdRef = &.{} },
            .OpInBoundsAccessChain => struct { id_result_type: IdResultType, id_result: IdResult, base: IdRef, indexes: []const IdRef = &.{} },
            .OpPtrAccessChain => struct { id_result_type: IdResultType, id_result: IdResult, base: IdRef, element: IdRef, indexes: []const IdRef = &.{} },
            .OpArrayLength => struct { id_result_type: IdResultType, id_result: IdResult, structure: IdRef, array_member: LiteralInteger },
            .OpGenericPtrMemSemantics => struct { id_result_type: IdResultType, id_result: IdResult, pointer: IdRef },
            .OpInBoundsPtrAccessChain => struct { id_result_type: IdResultType, id_result: IdResult, base: IdRef, element: IdRef, indexes: []const IdRef = &.{} },
            .OpDecorate => struct { target: IdRef, decoration: Decoration.Extended },
            .OpMemberDecorate => struct { structure_type: IdRef, member: LiteralInteger, decoration: Decoration.Extended },
            .OpDecorationGroup => struct { id_result: IdResult },
            .OpGroupDecorate => struct { decoration_group: IdRef, targets: []const IdRef = &.{} },
            .OpGroupMemberDecorate => struct { decoration_group: IdRef, targets: []const PairIdRefLiteralInteger = &.{} },
            .OpVectorExtractDynamic => struct { id_result_type: IdResultType, id_result: IdResult, vector: IdRef, index: IdRef },
            .OpVectorInsertDynamic => struct { id_result_type: IdResultType, id_result: IdResult, vector: IdRef, component: IdRef, index: IdRef },
            .OpVectorShuffle => struct { id_result_type: IdResultType, id_result: IdResult, vector_1: IdRef, vector_2: IdRef, components: []const LiteralInteger = &.{} },
            .OpCompositeConstruct => struct { id_result_type: IdResultType, id_result: IdResult, constituents: []const IdRef = &.{} },
            .OpCompositeExtract => struct { id_result_type: IdResultType, id_result: IdResult, composite: IdRef, indexes: []const LiteralInteger = &.{} },
            .OpCompositeInsert => struct { id_result_type: IdResultType, id_result: IdResult, object: IdRef, composite: IdRef, indexes: []const LiteralInteger = &.{} },
            .OpCopyObject => struct { id_result_type: IdResultType, id_result: IdResult, operand: IdRef },
            .OpTranspose => struct { id_result_type: IdResultType, id_result: IdResult, matrix: IdRef },
            .OpSampledImage => struct { id_result_type: IdResultType, id_result: IdResult, image: IdRef, sampler: IdRef },
            .OpImageSampleImplicitLod => struct { id_result_type: IdResultType, id_result: IdResult, sampled_image: IdRef, coordinate: IdRef, image_operands: ?ImageOperands.Extended = null },
            .OpImageSampleExplicitLod => struct { id_result_type: IdResultType, id_result: IdResult, sampled_image: IdRef, coordinate: IdRef, image_operands: ImageOperands.Extended },
            .OpImageSampleDrefImplicitLod => struct { id_result_type: IdResultType, id_result: IdResult, sampled_image: IdRef, coordinate: IdRef, d_ref: IdRef, image_operands: ?ImageOperands.Extended = null },
            .OpImageSampleDrefExplicitLod => struct { id_result_type: IdResultType, id_result: IdResult, sampled_image: IdRef, coordinate: IdRef, d_ref: IdRef, image_operands: ImageOperands.Extended },
            .OpImageSampleProjImplicitLod => struct { id_result_type: IdResultType, id_result: IdResult, sampled_image: IdRef, coordinate: IdRef, image_operands: ?ImageOperands.Extended = null },
            .OpImageSampleProjExplicitLod => struct { id_result_type: IdResultType, id_result: IdResult, sampled_image: IdRef, coordinate: IdRef, image_operands: ImageOperands.Extended },
            .OpImageSampleProjDrefImplicitLod => struct { id_result_type: IdResultType, id_result: IdResult, sampled_image: IdRef, coordinate: IdRef, d_ref: IdRef, image_operands: ?ImageOperands.Extended = null },
            .OpImageSampleProjDrefExplicitLod => struct { id_result_type: IdResultType, id_result: IdResult, sampled_image: IdRef, coordinate: IdRef, d_ref: IdRef, image_operands: ImageOperands.Extended },
            .OpImageFetch => struct { id_result_type: IdResultType, id_result: IdResult, image: IdRef, coordinate: IdRef, image_operands: ?ImageOperands.Extended = null },
            .OpImageGather => struct { id_result_type: IdResultType, id_result: IdResult, sampled_image: IdRef, coordinate: IdRef, component: IdRef, image_operands: ?ImageOperands.Extended = null },
            .OpImageDrefGather => struct { id_result_type: IdResultType, id_result: IdResult, sampled_image: IdRef, coordinate: IdRef, d_ref: IdRef, image_operands: ?ImageOperands.Extended = null },
            .OpImageRead => struct { id_result_type: IdResultType, id_result: IdResult, image: IdRef, coordinate: IdRef, image_operands: ?ImageOperands.Extended = null },
            .OpImageWrite => struct { image: IdRef, coordinate: IdRef, texel: IdRef, image_operands: ?ImageOperands.Extended = null },
            .OpImage => struct { id_result_type: IdResultType, id_result: IdResult, sampled_image: IdRef },
            .OpImageQueryFormat => struct { id_result_type: IdResultType, id_result: IdResult, image: IdRef },
            .OpImageQueryOrder => struct { id_result_type: IdResultType, id_result: IdResult, image: IdRef },
            .OpImageQuerySizeLod => struct { id_result_type: IdResultType, id_result: IdResult, image: IdRef, level_of_detail: IdRef },
            .OpImageQuerySize => struct { id_result_type: IdResultType, id_result: IdResult, image: IdRef },
            .OpImageQueryLod => struct { id_result_type: IdResultType, id_result: IdResult, sampled_image: IdRef, coordinate: IdRef },
            .OpImageQueryLevels => struct { id_result_type: IdResultType, id_result: IdResult, image: IdRef },
            .OpImageQuerySamples => struct { id_result_type: IdResultType, id_result: IdResult, image: IdRef },
            .OpConvertFToU => struct { id_result_type: IdResultType, id_result: IdResult, float_value: IdRef },
            .OpConvertFToS => struct { id_result_type: IdResultType, id_result: IdResult, float_value: IdRef },
            .OpConvertSToF => struct { id_result_type: IdResultType, id_result: IdResult, signed_value: IdRef },
            .OpConvertUToF => struct { id_result_type: IdResultType, id_result: IdResult, unsigned_value: IdRef },
            .OpUConvert => struct { id_result_type: IdResultType, id_result: IdResult, unsigned_value: IdRef },
            .OpSConvert => struct { id_result_type: IdResultType, id_result: IdResult, signed_value: IdRef },
            .OpFConvert => struct { id_result_type: IdResultType, id_result: IdResult, float_value: IdRef },
            .OpQuantizeToF16 => struct { id_result_type: IdResultType, id_result: IdResult, value: IdRef },
            .OpConvertPtrToU => struct { id_result_type: IdResultType, id_result: IdResult, pointer: IdRef },
            .OpSatConvertSToU => struct { id_result_type: IdResultType, id_result: IdResult, signed_value: IdRef },
            .OpSatConvertUToS => struct { id_result_type: IdResultType, id_result: IdResult, unsigned_value: IdRef },
            .OpConvertUToPtr => struct { id_result_type: IdResultType, id_result: IdResult, integer_value: IdRef },
            .OpPtrCastToGeneric => struct { id_result_type: IdResultType, id_result: IdResult, pointer: IdRef },
            .OpGenericCastToPtr => struct { id_result_type: IdResultType, id_result: IdResult, pointer: IdRef },
            .OpGenericCastToPtrExplicit => struct { id_result_type: IdResultType, id_result: IdResult, pointer: IdRef, storage: StorageClass },
            .OpBitcast => struct { id_result_type: IdResultType, id_result: IdResult, operand: IdRef },
            .OpSNegate => struct { id_result_type: IdResultType, id_result: IdResult, operand: IdRef },
            .OpFNegate => struct { id_result_type: IdResultType, id_result: IdResult, operand: IdRef },
            .OpIAdd => struct { id_result_type: IdResultType, id_result: IdResult, operand_1: IdRef, operand_2: IdRef },
            .OpFAdd => struct { id_result_type: IdResultType, id_result: IdResult, operand_1: IdRef, operand_2: IdRef },
            .OpISub => struct { id_result_type: IdResultType, id_result: IdResult, operand_1: IdRef, operand_2: IdRef },
            .OpFSub => struct { id_result_type: IdResultType, id_result: IdResult, operand_1: IdRef, operand_2: IdRef },
            .OpIMul => struct { id_result_type: IdResultType, id_result: IdResult, operand_1: IdRef, operand_2: IdRef },
            .OpFMul => struct { id_result_type: IdResultType, id_result: IdResult, operand_1: IdRef, operand_2: IdRef },
            .OpUDiv => struct { id_result_type: IdResultType, id_result: IdResult, operand_1: IdRef, operand_2: IdRef },
            .OpSDiv => struct { id_result_type: IdResultType, id_result: IdResult, operand_1: IdRef, operand_2: IdRef },
            .OpFDiv => struct { id_result_type: IdResultType, id_result: IdResult, operand_1: IdRef, operand_2: IdRef },
            .OpUMod => struct { id_result_type: IdResultType, id_result: IdResult, operand_1: IdRef, operand_2: IdRef },
            .OpSRem => struct { id_result_type: IdResultType, id_result: IdResult, operand_1: IdRef, operand_2: IdRef },
            .OpSMod => struct { id_result_type: IdResultType, id_result: IdResult, operand_1: IdRef, operand_2: IdRef },
            .OpFRem => struct { id_result_type: IdResultType, id_result: IdResult, operand_1: IdRef, operand_2: IdRef },
            .OpFMod => struct { id_result_type: IdResultType, id_result: IdResult, operand_1: IdRef, operand_2: IdRef },
            .OpVectorTimesScalar => struct { id_result_type: IdResultType, id_result: IdResult, vector: IdRef, scalar: IdRef },
            .OpMatrixTimesScalar => struct { id_result_type: IdResultType, id_result: IdResult, matrix: IdRef, scalar: IdRef },
            .OpVectorTimesMatrix => struct { id_result_type: IdResultType, id_result: IdResult, vector: IdRef, matrix: IdRef },
            .OpMatrixTimesVector => struct { id_result_type: IdResultType, id_result: IdResult, matrix: IdRef, vector: IdRef },
            .OpMatrixTimesMatrix => struct { id_result_type: IdResultType, id_result: IdResult, leftmatrix: IdRef, rightmatrix: IdRef },
            .OpOuterProduct => struct { id_result_type: IdResultType, id_result: IdResult, vector_1: IdRef, vector_2: IdRef },
            .OpDot => struct { id_result_type: IdResultType, id_result: IdResult, vector_1: IdRef, vector_2: IdRef },
            .OpIAddCarry => struct { id_result_type: IdResultType, id_result: IdResult, operand_1: IdRef, operand_2: IdRef },
            .OpISubBorrow => struct { id_result_type: IdResultType, id_result: IdResult, operand_1: IdRef, operand_2: IdRef },
            .OpUMulExtended => struct { id_result_type: IdResultType, id_result: IdResult, operand_1: IdRef, operand_2: IdRef },
            .OpSMulExtended => struct { id_result_type: IdResultType, id_result: IdResult, operand_1: IdRef, operand_2: IdRef },
            .OpAny => struct { id_result_type: IdResultType, id_result: IdResult, vector: IdRef },
            .OpAll => struct { id_result_type: IdResultType, id_result: IdResult, vector: IdRef },
            .OpIsNan => struct { id_result_type: IdResultType, id_result: IdResult, x: IdRef },
            .OpIsInf => struct { id_result_type: IdResultType, id_result: IdResult, x: IdRef },
            .OpIsFinite => struct { id_result_type: IdResultType, id_result: IdResult, x: IdRef },
            .OpIsNormal => struct { id_result_type: IdResultType, id_result: IdResult, x: IdRef },
            .OpSignBitSet => struct { id_result_type: IdResultType, id_result: IdResult, x: IdRef },
            .OpLessOrGreater => struct { id_result_type: IdResultType, id_result: IdResult, x: IdRef, y: IdRef },
            .OpOrdered => struct { id_result_type: IdResultType, id_result: IdResult, x: IdRef, y: IdRef },
            .OpUnordered => struct { id_result_type: IdResultType, id_result: IdResult, x: IdRef, y: IdRef },
            .OpLogicalEqual => struct { id_result_type: IdResultType, id_result: IdResult, operand_1: IdRef, operand_2: IdRef },
            .OpLogicalNotEqual => struct { id_result_type: IdResultType, id_result: IdResult, operand_1: IdRef, operand_2: IdRef },
            .OpLogicalOr => struct { id_result_type: IdResultType, id_result: IdResult, operand_1: IdRef, operand_2: IdRef },
            .OpLogicalAnd => struct { id_result_type: IdResultType, id_result: IdResult, operand_1: IdRef, operand_2: IdRef },
            .OpLogicalNot => struct { id_result_type: IdResultType, id_result: IdResult, operand: IdRef },
            .OpSelect => struct { id_result_type: IdResultType, id_result: IdResult, condition: IdRef, object_1: IdRef, object_2: IdRef },
            .OpIEqual => struct { id_result_type: IdResultType, id_result: IdResult, operand_1: IdRef, operand_2: IdRef },
            .OpINotEqual => struct { id_result_type: IdResultType, id_result: IdResult, operand_1: IdRef, operand_2: IdRef },
            .OpUGreaterThan => struct { id_result_type: IdResultType, id_result: IdResult, operand_1: IdRef, operand_2: IdRef },
            .OpSGreaterThan => struct { id_result_type: IdResultType, id_result: IdResult, operand_1: IdRef, operand_2: IdRef },
            .OpUGreaterThanEqual => struct { id_result_type: IdResultType, id_result: IdResult, operand_1: IdRef, operand_2: IdRef },
            .OpSGreaterThanEqual => struct { id_result_type: IdResultType, id_result: IdResult, operand_1: IdRef, operand_2: IdRef },
            .OpULessThan => struct { id_result_type: IdResultType, id_result: IdResult, operand_1: IdRef, operand_2: IdRef },
            .OpSLessThan => struct { id_result_type: IdResultType, id_result: IdResult, operand_1: IdRef, operand_2: IdRef },
            .OpULessThanEqual => struct { id_result_type: IdResultType, id_result: IdResult, operand_1: IdRef, operand_2: IdRef },
            .OpSLessThanEqual => struct { id_result_type: IdResultType, id_result: IdResult, operand_1: IdRef, operand_2: IdRef },
            .OpFOrdEqual => struct { id_result_type: IdResultType, id_result: IdResult, operand_1: IdRef, operand_2: IdRef },
            .OpFUnordEqual => struct { id_result_type: IdResultType, id_result: IdResult, operand_1: IdRef, operand_2: IdRef },
            .OpFOrdNotEqual => struct { id_result_type: IdResultType, id_result: IdResult, operand_1: IdRef, operand_2: IdRef },
            .OpFUnordNotEqual => struct { id_result_type: IdResultType, id_result: IdResult, operand_1: IdRef, operand_2: IdRef },
            .OpFOrdLessThan => struct { id_result_type: IdResultType, id_result: IdResult, operand_1: IdRef, operand_2: IdRef },
            .OpFUnordLessThan => struct { id_result_type: IdResultType, id_result: IdResult, operand_1: IdRef, operand_2: IdRef },
            .OpFOrdGreaterThan => struct { id_result_type: IdResultType, id_result: IdResult, operand_1: IdRef, operand_2: IdRef },
            .OpFUnordGreaterThan => struct { id_result_type: IdResultType, id_result: IdResult, operand_1: IdRef, operand_2: IdRef },
            .OpFOrdLessThanEqual => struct { id_result_type: IdResultType, id_result: IdResult, operand_1: IdRef, operand_2: IdRef },
            .OpFUnordLessThanEqual => struct { id_result_type: IdResultType, id_result: IdResult, operand_1: IdRef, operand_2: IdRef },
            .OpFOrdGreaterThanEqual => struct { id_result_type: IdResultType, id_result: IdResult, operand_1: IdRef, operand_2: IdRef },
            .OpFUnordGreaterThanEqual => struct { id_result_type: IdResultType, id_result: IdResult, operand_1: IdRef, operand_2: IdRef },
            .OpShiftRightLogical => struct { id_result_type: IdResultType, id_result: IdResult, base: IdRef, shift: IdRef },
            .OpShiftRightArithmetic => struct { id_result_type: IdResultType, id_result: IdResult, base: IdRef, shift: IdRef },
            .OpShiftLeftLogical => struct { id_result_type: IdResultType, id_result: IdResult, base: IdRef, shift: IdRef },
            .OpBitwiseOr => struct { id_result_type: IdResultType, id_result: IdResult, operand_1: IdRef, operand_2: IdRef },
            .OpBitwiseXor => struct { id_result_type: IdResultType, id_result: IdResult, operand_1: IdRef, operand_2: IdRef },
            .OpBitwiseAnd => struct { id_result_type: IdResultType, id_result: IdResult, operand_1: IdRef, operand_2: IdRef },
            .OpNot => struct { id_result_type: IdResultType, id_result: IdResult, operand: IdRef },
            .OpBitFieldInsert => struct { id_result_type: IdResultType, id_result: IdResult, base: IdRef, insert: IdRef, offset: IdRef, count: IdRef },
            .OpBitFieldSExtract => struct { id_result_type: IdResultType, id_result: IdResult, base: IdRef, offset: IdRef, count: IdRef },
            .OpBitFieldUExtract => struct { id_result_type: IdResultType, id_result: IdResult, base: IdRef, offset: IdRef, count: IdRef },
            .OpBitReverse => struct { id_result_type: IdResultType, id_result: IdResult, base: IdRef },
            .OpBitCount => struct { id_result_type: IdResultType, id_result: IdResult, base: IdRef },
            .OpDPdx => struct { id_result_type: IdResultType, id_result: IdResult, p: IdRef },
            .OpDPdy => struct { id_result_type: IdResultType, id_result: IdResult, p: IdRef },
            .OpFwidth => struct { id_result_type: IdResultType, id_result: IdResult, p: IdRef },
            .OpDPdxFine => struct { id_result_type: IdResultType, id_result: IdResult, p: IdRef },
            .OpDPdyFine => struct { id_result_type: IdResultType, id_result: IdResult, p: IdRef },
            .OpFwidthFine => struct { id_result_type: IdResultType, id_result: IdResult, p: IdRef },
            .OpDPdxCoarse => struct { id_result_type: IdResultType, id_result: IdResult, p: IdRef },
            .OpDPdyCoarse => struct { id_result_type: IdResultType, id_result: IdResult, p: IdRef },
            .OpFwidthCoarse => struct { id_result_type: IdResultType, id_result: IdResult, p: IdRef },
            .OpEmitVertex => void,
            .OpEndPrimitive => void,
            .OpEmitStreamVertex => struct { stream: IdRef },
            .OpEndStreamPrimitive => struct { stream: IdRef },
            .OpControlBarrier => struct { execution: IdScope, memory: IdScope, semantics: IdMemorySemantics },
            .OpMemoryBarrier => struct { memory: IdScope, semantics: IdMemorySemantics },
            .OpAtomicLoad => struct { id_result_type: IdResultType, id_result: IdResult, pointer: IdRef, memory: IdScope, semantics: IdMemorySemantics },
            .OpAtomicStore => struct { pointer: IdRef, memory: IdScope, semantics: IdMemorySemantics, value: IdRef },
            .OpAtomicExchange => struct { id_result_type: IdResultType, id_result: IdResult, pointer: IdRef, memory: IdScope, semantics: IdMemorySemantics, value: IdRef },
            .OpAtomicCompareExchange => struct { id_result_type: IdResultType, id_result: IdResult, pointer: IdRef, memory: IdScope, equal: IdMemorySemantics, unequal: IdMemorySemantics, value: IdRef, comparator: IdRef },
            .OpAtomicCompareExchangeWeak => struct { id_result_type: IdResultType, id_result: IdResult, pointer: IdRef, memory: IdScope, equal: IdMemorySemantics, unequal: IdMemorySemantics, value: IdRef, comparator: IdRef },
            .OpAtomicIIncrement => struct { id_result_type: IdResultType, id_result: IdResult, pointer: IdRef, memory: IdScope, semantics: IdMemorySemantics },
            .OpAtomicIDecrement => struct { id_result_type: IdResultType, id_result: IdResult, pointer: IdRef, memory: IdScope, semantics: IdMemorySemantics },
            .OpAtomicIAdd => struct { id_result_type: IdResultType, id_result: IdResult, pointer: IdRef, memory: IdScope, semantics: IdMemorySemantics, value: IdRef },
            .OpAtomicISub => struct { id_result_type: IdResultType, id_result: IdResult, pointer: IdRef, memory: IdScope, semantics: IdMemorySemantics, value: IdRef },
            .OpAtomicSMin => struct { id_result_type: IdResultType, id_result: IdResult, pointer: IdRef, memory: IdScope, semantics: IdMemorySemantics, value: IdRef },
            .OpAtomicUMin => struct { id_result_type: IdResultType, id_result: IdResult, pointer: IdRef, memory: IdScope, semantics: IdMemorySemantics, value: IdRef },
            .OpAtomicSMax => struct { id_result_type: IdResultType, id_result: IdResult, pointer: IdRef, memory: IdScope, semantics: IdMemorySemantics, value: IdRef },
            .OpAtomicUMax => struct { id_result_type: IdResultType, id_result: IdResult, pointer: IdRef, memory: IdScope, semantics: IdMemorySemantics, value: IdRef },
            .OpAtomicAnd => struct { id_result_type: IdResultType, id_result: IdResult, pointer: IdRef, memory: IdScope, semantics: IdMemorySemantics, value: IdRef },
            .OpAtomicOr => struct { id_result_type: IdResultType, id_result: IdResult, pointer: IdRef, memory: IdScope, semantics: IdMemorySemantics, value: IdRef },
            .OpAtomicXor => struct { id_result_type: IdResultType, id_result: IdResult, pointer: IdRef, memory: IdScope, semantics: IdMemorySemantics, value: IdRef },
            .OpPhi => struct { id_result_type: IdResultType, id_result: IdResult, pair_id_ref_id_ref: []const PairIdRefIdRef = &.{} },
            .OpLoopMerge => struct { merge_block: IdRef, continue_target: IdRef, loop_control: LoopControl.Extended },
            .OpSelectionMerge => struct { merge_block: IdRef, selection_control: SelectionControl },
            .OpLabel => struct { id_result: IdResult },
            .OpBranch => struct { target_label: IdRef },
            .OpBranchConditional => struct { condition: IdRef, true_label: IdRef, false_label: IdRef, branch_weights: []const LiteralInteger = &.{} },
            .OpSwitch => struct { selector: IdRef, default: IdRef, target: []const PairLiteralIntegerIdRef = &.{} },
            .OpKill => void,
            .OpReturn => void,
            .OpReturnValue => struct { value: IdRef },
            .OpUnreachable => void,
            .OpLifetimeStart => struct { pointer: IdRef, size: LiteralInteger },
            .OpLifetimeStop => struct { pointer: IdRef, size: LiteralInteger },
            .OpGroupAsyncCopy => struct { id_result_type: IdResultType, id_result: IdResult, execution: IdScope, destination: IdRef, source: IdRef, num_elements: IdRef, stride: IdRef, event: IdRef },
            .OpGroupWaitEvents => struct { execution: IdScope, num_events: IdRef, events_list: IdRef },
            .OpGroupAll => struct { id_result_type: IdResultType, id_result: IdResult, execution: IdScope, predicate: IdRef },
            .OpGroupAny => struct { id_result_type: IdResultType, id_result: IdResult, execution: IdScope, predicate: IdRef },
            .OpGroupBroadcast => struct { id_result_type: IdResultType, id_result: IdResult, execution: IdScope, value: IdRef, localid: IdRef },
            .OpGroupIAdd => struct { id_result_type: IdResultType, id_result: IdResult, execution: IdScope, operation: GroupOperation, x: IdRef },
            .OpGroupFAdd => struct { id_result_type: IdResultType, id_result: IdResult, execution: IdScope, operation: GroupOperation, x: IdRef },
            .OpGroupFMin => struct { id_result_type: IdResultType, id_result: IdResult, execution: IdScope, operation: GroupOperation, x: IdRef },
            .OpGroupUMin => struct { id_result_type: IdResultType, id_result: IdResult, execution: IdScope, operation: GroupOperation, x: IdRef },
            .OpGroupSMin => struct { id_result_type: IdResultType, id_result: IdResult, execution: IdScope, operation: GroupOperation, x: IdRef },
            .OpGroupFMax => struct { id_result_type: IdResultType, id_result: IdResult, execution: IdScope, operation: GroupOperation, x: IdRef },
            .OpGroupUMax => struct { id_result_type: IdResultType, id_result: IdResult, execution: IdScope, operation: GroupOperation, x: IdRef },
            .OpGroupSMax => struct { id_result_type: IdResultType, id_result: IdResult, execution: IdScope, operation: GroupOperation, x: IdRef },
            .OpReadPipe => struct { id_result_type: IdResultType, id_result: IdResult, pipe: IdRef, pointer: IdRef, packet_size: IdRef, packet_alignment: IdRef },
            .OpWritePipe => struct { id_result_type: IdResultType, id_result: IdResult, pipe: IdRef, pointer: IdRef, packet_size: IdRef, packet_alignment: IdRef },
            .OpReservedReadPipe => struct { id_result_type: IdResultType, id_result: IdResult, pipe: IdRef, reserve_id: IdRef, index: IdRef, pointer: IdRef, packet_size: IdRef, packet_alignment: IdRef },
            .OpReservedWritePipe => struct { id_result_type: IdResultType, id_result: IdResult, pipe: IdRef, reserve_id: IdRef, index: IdRef, pointer: IdRef, packet_size: IdRef, packet_alignment: IdRef },
            .OpReserveReadPipePackets => struct { id_result_type: IdResultType, id_result: IdResult, pipe: IdRef, num_packets: IdRef, packet_size: IdRef, packet_alignment: IdRef },
            .OpReserveWritePipePackets => struct { id_result_type: IdResultType, id_result: IdResult, pipe: IdRef, num_packets: IdRef, packet_size: IdRef, packet_alignment: IdRef },
            .OpCommitReadPipe => struct { pipe: IdRef, reserve_id: IdRef, packet_size: IdRef, packet_alignment: IdRef },
            .OpCommitWritePipe => struct { pipe: IdRef, reserve_id: IdRef, packet_size: IdRef, packet_alignment: IdRef },
            .OpIsValidReserveId => struct { id_result_type: IdResultType, id_result: IdResult, reserve_id: IdRef },
            .OpGetNumPipePackets => struct { id_result_type: IdResultType, id_result: IdResult, pipe: IdRef, packet_size: IdRef, packet_alignment: IdRef },
            .OpGetMaxPipePackets => struct { id_result_type: IdResultType, id_result: IdResult, pipe: IdRef, packet_size: IdRef, packet_alignment: IdRef },
            .OpGroupReserveReadPipePackets => struct { id_result_type: IdResultType, id_result: IdResult, execution: IdScope, pipe: IdRef, num_packets: IdRef, packet_size: IdRef, packet_alignment: IdRef },
            .OpGroupReserveWritePipePackets => struct { id_result_type: IdResultType, id_result: IdResult, execution: IdScope, pipe: IdRef, num_packets: IdRef, packet_size: IdRef, packet_alignment: IdRef },
            .OpGroupCommitReadPipe => struct { execution: IdScope, pipe: IdRef, reserve_id: IdRef, packet_size: IdRef, packet_alignment: IdRef },
            .OpGroupCommitWritePipe => struct { execution: IdScope, pipe: IdRef, reserve_id: IdRef, packet_size: IdRef, packet_alignment: IdRef },
            .OpEnqueueMarker => struct { id_result_type: IdResultType, id_result: IdResult, queue: IdRef, num_events: IdRef, wait_events: IdRef, ret_event: IdRef },
            .OpEnqueueKernel => struct { id_result_type: IdResultType, id_result: IdResult, queue: IdRef, flags: IdRef, nd_range: IdRef, num_events: IdRef, wait_events: IdRef, ret_event: IdRef, invoke: IdRef, param: IdRef, param_size: IdRef, param_align: IdRef, local_size: []const IdRef = &.{} },
            .OpGetKernelNDrangeSubGroupCount => struct { id_result_type: IdResultType, id_result: IdResult, nd_range: IdRef, invoke: IdRef, param: IdRef, param_size: IdRef, param_align: IdRef },
            .OpGetKernelNDrangeMaxSubGroupSize => struct { id_result_type: IdResultType, id_result: IdResult, nd_range: IdRef, invoke: IdRef, param: IdRef, param_size: IdRef, param_align: IdRef },
            .OpGetKernelWorkGroupSize => struct { id_result_type: IdResultType, id_result: IdResult, invoke: IdRef, param: IdRef, param_size: IdRef, param_align: IdRef },
            .OpGetKernelPreferredWorkGroupSizeMultiple => struct { id_result_type: IdResultType, id_result: IdResult, invoke: IdRef, param: IdRef, param_size: IdRef, param_align: IdRef },
            .OpRetainEvent => struct { event: IdRef },
            .OpReleaseEvent => struct { event: IdRef },
            .OpCreateUserEvent => struct { id_result_type: IdResultType, id_result: IdResult },
            .OpIsValidEvent => struct { id_result_type: IdResultType, id_result: IdResult, event: IdRef },
            .OpSetUserEventStatus => struct { event: IdRef, status: IdRef },
            .OpCaptureEventProfilingInfo => struct { event: IdRef, profiling_info: IdRef, value: IdRef },
            .OpGetDefaultQueue => struct { id_result_type: IdResultType, id_result: IdResult },
            .OpBuildNDRange => struct { id_result_type: IdResultType, id_result: IdResult, globalworksize: IdRef, localworksize: IdRef, globalworkoffset: IdRef },
            .OpImageSparseSampleImplicitLod => struct { id_result_type: IdResultType, id_result: IdResult, sampled_image: IdRef, coordinate: IdRef, image_operands: ?ImageOperands.Extended = null },
            .OpImageSparseSampleExplicitLod => struct { id_result_type: IdResultType, id_result: IdResult, sampled_image: IdRef, coordinate: IdRef, image_operands: ImageOperands.Extended },
            .OpImageSparseSampleDrefImplicitLod => struct { id_result_type: IdResultType, id_result: IdResult, sampled_image: IdRef, coordinate: IdRef, d_ref: IdRef, image_operands: ?ImageOperands.Extended = null },
            .OpImageSparseSampleDrefExplicitLod => struct { id_result_type: IdResultType, id_result: IdResult, sampled_image: IdRef, coordinate: IdRef, d_ref: IdRef, image_operands: ImageOperands.Extended },
            .OpImageSparseSampleProjImplicitLod => struct { id_result_type: IdResultType, id_result: IdResult, sampled_image: IdRef, coordinate: IdRef, image_operands: ?ImageOperands.Extended = null },
            .OpImageSparseSampleProjExplicitLod => struct { id_result_type: IdResultType, id_result: IdResult, sampled_image: IdRef, coordinate: IdRef, image_operands: ImageOperands.Extended },
            .OpImageSparseSampleProjDrefImplicitLod => struct { id_result_type: IdResultType, id_result: IdResult, sampled_image: IdRef, coordinate: IdRef, d_ref: IdRef, image_operands: ?ImageOperands.Extended = null },
            .OpImageSparseSampleProjDrefExplicitLod => struct { id_result_type: IdResultType, id_result: IdResult, sampled_image: IdRef, coordinate: IdRef, d_ref: IdRef, image_operands: ImageOperands.Extended },
            .OpImageSparseFetch => struct { id_result_type: IdResultType, id_result: IdResult, image: IdRef, coordinate: IdRef, image_operands: ?ImageOperands.Extended = null },
            .OpImageSparseGather => struct { id_result_type: IdResultType, id_result: IdResult, sampled_image: IdRef, coordinate: IdRef, component: IdRef, image_operands: ?ImageOperands.Extended = null },
            .OpImageSparseDrefGather => struct { id_result_type: IdResultType, id_result: IdResult, sampled_image: IdRef, coordinate: IdRef, d_ref: IdRef, image_operands: ?ImageOperands.Extended = null },
            .OpImageSparseTexelsResident => struct { id_result_type: IdResultType, id_result: IdResult, resident_code: IdRef },
            .OpNoLine => void,
            .OpAtomicFlagTestAndSet => struct { id_result_type: IdResultType, id_result: IdResult, pointer: IdRef, memory: IdScope, semantics: IdMemorySemantics },
            .OpAtomicFlagClear => struct { pointer: IdRef, memory: IdScope, semantics: IdMemorySemantics },
            .OpImageSparseRead => struct { id_result_type: IdResultType, id_result: IdResult, image: IdRef, coordinate: IdRef, image_operands: ?ImageOperands.Extended = null },
            .OpSizeOf => struct { id_result_type: IdResultType, id_result: IdResult, pointer: IdRef },
            .OpTypePipeStorage => struct { id_result: IdResult },
            .OpConstantPipeStorage => struct { id_result_type: IdResultType, id_result: IdResult, packet_size: LiteralInteger, packet_alignment: LiteralInteger, capacity: LiteralInteger },
            .OpCreatePipeFromPipeStorage => struct { id_result_type: IdResultType, id_result: IdResult, pipe_storage: IdRef },
            .OpGetKernelLocalSizeForSubgroupCount => struct { id_result_type: IdResultType, id_result: IdResult, subgroup_count: IdRef, invoke: IdRef, param: IdRef, param_size: IdRef, param_align: IdRef },
            .OpGetKernelMaxNumSubgroups => struct { id_result_type: IdResultType, id_result: IdResult, invoke: IdRef, param: IdRef, param_size: IdRef, param_align: IdRef },
            .OpTypeNamedBarrier => struct { id_result: IdResult },
            .OpNamedBarrierInitialize => struct { id_result_type: IdResultType, id_result: IdResult, subgroup_count: IdRef },
            .OpMemoryNamedBarrier => struct { named_barrier: IdRef, memory: IdScope, semantics: IdMemorySemantics },
            .OpModuleProcessed => struct { process: LiteralString },
            .OpExecutionModeId => struct { entry_point: IdRef, mode: ExecutionMode.Extended },
            .OpDecorateId => struct { target: IdRef, decoration: Decoration.Extended },
            .OpGroupNonUniformElect => struct { id_result_type: IdResultType, id_result: IdResult, execution: IdScope },
            .OpGroupNonUniformAll => struct { id_result_type: IdResultType, id_result: IdResult, execution: IdScope, predicate: IdRef },
            .OpGroupNonUniformAny => struct { id_result_type: IdResultType, id_result: IdResult, execution: IdScope, predicate: IdRef },
            .OpGroupNonUniformAllEqual => struct { id_result_type: IdResultType, id_result: IdResult, execution: IdScope, value: IdRef },
            .OpGroupNonUniformBroadcast => struct { id_result_type: IdResultType, id_result: IdResult, execution: IdScope, value: IdRef, id: IdRef },
            .OpGroupNonUniformBroadcastFirst => struct { id_result_type: IdResultType, id_result: IdResult, execution: IdScope, value: IdRef },
            .OpGroupNonUniformBallot => struct { id_result_type: IdResultType, id_result: IdResult, execution: IdScope, predicate: IdRef },
            .OpGroupNonUniformInverseBallot => struct { id_result_type: IdResultType, id_result: IdResult, execution: IdScope, value: IdRef },
            .OpGroupNonUniformBallotBitExtract => struct { id_result_type: IdResultType, id_result: IdResult, execution: IdScope, value: IdRef, index: IdRef },
            .OpGroupNonUniformBallotBitCount => struct { id_result_type: IdResultType, id_result: IdResult, execution: IdScope, operation: GroupOperation, value: IdRef },
            .OpGroupNonUniformBallotFindLSB => struct { id_result_type: IdResultType, id_result: IdResult, execution: IdScope, value: IdRef },
            .OpGroupNonUniformBallotFindMSB => struct { id_result_type: IdResultType, id_result: IdResult, execution: IdScope, value: IdRef },
            .OpGroupNonUniformShuffle => struct { id_result_type: IdResultType, id_result: IdResult, execution: IdScope, value: IdRef, id: IdRef },
            .OpGroupNonUniformShuffleXor => struct { id_result_type: IdResultType, id_result: IdResult, execution: IdScope, value: IdRef, mask: IdRef },
            .OpGroupNonUniformShuffleUp => struct { id_result_type: IdResultType, id_result: IdResult, execution: IdScope, value: IdRef, delta: IdRef },
            .OpGroupNonUniformShuffleDown => struct { id_result_type: IdResultType, id_result: IdResult, execution: IdScope, value: IdRef, delta: IdRef },
            .OpGroupNonUniformIAdd => struct { id_result_type: IdResultType, id_result: IdResult, execution: IdScope, operation: GroupOperation, value: IdRef, clustersize: ?IdRef = null },
            .OpGroupNonUniformFAdd => struct { id_result_type: IdResultType, id_result: IdResult, execution: IdScope, operation: GroupOperation, value: IdRef, clustersize: ?IdRef = null },
            .OpGroupNonUniformIMul => struct { id_result_type: IdResultType, id_result: IdResult, execution: IdScope, operation: GroupOperation, value: IdRef, clustersize: ?IdRef = null },
            .OpGroupNonUniformFMul => struct { id_result_type: IdResultType, id_result: IdResult, execution: IdScope, operation: GroupOperation, value: IdRef, clustersize: ?IdRef = null },
            .OpGroupNonUniformSMin => struct { id_result_type: IdResultType, id_result: IdResult, execution: IdScope, operation: GroupOperation, value: IdRef, clustersize: ?IdRef = null },
            .OpGroupNonUniformUMin => struct { id_result_type: IdResultType, id_result: IdResult, execution: IdScope, operation: GroupOperation, value: IdRef, clustersize: ?IdRef = null },
            .OpGroupNonUniformFMin => struct { id_result_type: IdResultType, id_result: IdResult, execution: IdScope, operation: GroupOperation, value: IdRef, clustersize: ?IdRef = null },
            .OpGroupNonUniformSMax => struct { id_result_type: IdResultType, id_result: IdResult, execution: IdScope, operation: GroupOperation, value: IdRef, clustersize: ?IdRef = null },
            .OpGroupNonUniformUMax => struct { id_result_type: IdResultType, id_result: IdResult, execution: IdScope, operation: GroupOperation, value: IdRef, clustersize: ?IdRef = null },
            .OpGroupNonUniformFMax => struct { id_result_type: IdResultType, id_result: IdResult, execution: IdScope, operation: GroupOperation, value: IdRef, clustersize: ?IdRef = null },
            .OpGroupNonUniformBitwiseAnd => struct { id_result_type: IdResultType, id_result: IdResult, execution: IdScope, operation: GroupOperation, value: IdRef, clustersize: ?IdRef = null },
            .OpGroupNonUniformBitwiseOr => struct { id_result_type: IdResultType, id_result: IdResult, execution: IdScope, operation: GroupOperation, value: IdRef, clustersize: ?IdRef = null },
            .OpGroupNonUniformBitwiseXor => struct { id_result_type: IdResultType, id_result: IdResult, execution: IdScope, operation: GroupOperation, value: IdRef, clustersize: ?IdRef = null },
            .OpGroupNonUniformLogicalAnd => struct { id_result_type: IdResultType, id_result: IdResult, execution: IdScope, operation: GroupOperation, value: IdRef, clustersize: ?IdRef = null },
            .OpGroupNonUniformLogicalOr => struct { id_result_type: IdResultType, id_result: IdResult, execution: IdScope, operation: GroupOperation, value: IdRef, clustersize: ?IdRef = null },
            .OpGroupNonUniformLogicalXor => struct { id_result_type: IdResultType, id_result: IdResult, execution: IdScope, operation: GroupOperation, value: IdRef, clustersize: ?IdRef = null },
            .OpGroupNonUniformQuadBroadcast => struct { id_result_type: IdResultType, id_result: IdResult, execution: IdScope, value: IdRef, index: IdRef },
            .OpGroupNonUniformQuadSwap => struct { id_result_type: IdResultType, id_result: IdResult, execution: IdScope, value: IdRef, direction: IdRef },
            .OpCopyLogical => struct { id_result_type: IdResultType, id_result: IdResult, operand: IdRef },
            .OpPtrEqual => struct { id_result_type: IdResultType, id_result: IdResult, operand_1: IdRef, operand_2: IdRef },
            .OpPtrNotEqual => struct { id_result_type: IdResultType, id_result: IdResult, operand_1: IdRef, operand_2: IdRef },
            .OpPtrDiff => struct { id_result_type: IdResultType, id_result: IdResult, operand_1: IdRef, operand_2: IdRef },
            .OpColorAttachmentReadEXT => struct { id_result_type: IdResultType, id_result: IdResult, attachment: IdRef, sample: ?IdRef = null },
            .OpDepthAttachmentReadEXT => struct { id_result_type: IdResultType, id_result: IdResult, sample: ?IdRef = null },
            .OpStencilAttachmentReadEXT => struct { id_result_type: IdResultType, id_result: IdResult, sample: ?IdRef = null },
            .OpTerminateInvocation => void,
            .OpSubgroupBallotKHR => struct { id_result_type: IdResultType, id_result: IdResult, predicate: IdRef },
            .OpSubgroupFirstInvocationKHR => struct { id_result_type: IdResultType, id_result: IdResult, value: IdRef },
            .OpSubgroupAllKHR => struct { id_result_type: IdResultType, id_result: IdResult, predicate: IdRef },
            .OpSubgroupAnyKHR => struct { id_result_type: IdResultType, id_result: IdResult, predicate: IdRef },
            .OpSubgroupAllEqualKHR => struct { id_result_type: IdResultType, id_result: IdResult, predicate: IdRef },
            .OpGroupNonUniformRotateKHR => struct { id_result_type: IdResultType, id_result: IdResult, execution: IdScope, value: IdRef, delta: IdRef, clustersize: ?IdRef = null },
            .OpSubgroupReadInvocationKHR => struct { id_result_type: IdResultType, id_result: IdResult, value: IdRef, index: IdRef },
            .OpTraceRayKHR => struct { accel: IdRef, ray_flags: IdRef, cull_mask: IdRef, sbt_offset: IdRef, sbt_stride: IdRef, miss_index: IdRef, ray_origin: IdRef, ray_tmin: IdRef, ray_direction: IdRef, ray_tmax: IdRef, payload: IdRef },
            .OpExecuteCallableKHR => struct { sbt_index: IdRef, callable_data: IdRef },
            .OpConvertUToAccelerationStructureKHR => struct { id_result_type: IdResultType, id_result: IdResult, accel: IdRef },
            .OpIgnoreIntersectionKHR => void,
            .OpTerminateRayKHR => void,
            .OpSDot => struct { id_result_type: IdResultType, id_result: IdResult, vector_1: IdRef, vector_2: IdRef, packed_vector_format: ?PackedVectorFormat = null },
            .OpUDot => struct { id_result_type: IdResultType, id_result: IdResult, vector_1: IdRef, vector_2: IdRef, packed_vector_format: ?PackedVectorFormat = null },
            .OpSUDot => struct { id_result_type: IdResultType, id_result: IdResult, vector_1: IdRef, vector_2: IdRef, packed_vector_format: ?PackedVectorFormat = null },
            .OpSDotAccSat => struct { id_result_type: IdResultType, id_result: IdResult, vector_1: IdRef, vector_2: IdRef, accumulator: IdRef, packed_vector_format: ?PackedVectorFormat = null },
            .OpUDotAccSat => struct { id_result_type: IdResultType, id_result: IdResult, vector_1: IdRef, vector_2: IdRef, accumulator: IdRef, packed_vector_format: ?PackedVectorFormat = null },
            .OpSUDotAccSat => struct { id_result_type: IdResultType, id_result: IdResult, vector_1: IdRef, vector_2: IdRef, accumulator: IdRef, packed_vector_format: ?PackedVectorFormat = null },
            .OpTypeCooperativeMatrixKHR => struct { id_result: IdResult, component_type: IdRef, scope: IdScope, rows: IdRef, columns: IdRef, use: IdRef },
            .OpCooperativeMatrixLoadKHR => struct { id_result_type: IdResultType, id_result: IdResult, pointer: IdRef, memorylayout: IdRef, stride: ?IdRef = null, memory_operand: ?MemoryAccess.Extended = null },
            .OpCooperativeMatrixStoreKHR => struct { pointer: IdRef, object: IdRef, memorylayout: IdRef, stride: ?IdRef = null, memory_operand: ?MemoryAccess.Extended = null },
            .OpCooperativeMatrixMulAddKHR => struct { id_result_type: IdResultType, id_result: IdResult, a: IdRef, b: IdRef, c: IdRef, cooperative_matrix_operands: ?CooperativeMatrixOperands = null },
            .OpCooperativeMatrixLengthKHR => struct { id_result_type: IdResultType, id_result: IdResult, type: IdRef },
            .OpTypeRayQueryKHR => struct { id_result: IdResult },
            .OpRayQueryInitializeKHR => struct { rayquery: IdRef, accel: IdRef, rayflags: IdRef, cullmask: IdRef, rayorigin: IdRef, raytmin: IdRef, raydirection: IdRef, raytmax: IdRef },
            .OpRayQueryTerminateKHR => struct { rayquery: IdRef },
            .OpRayQueryGenerateIntersectionKHR => struct { rayquery: IdRef, hitt: IdRef },
            .OpRayQueryConfirmIntersectionKHR => struct { rayquery: IdRef },
            .OpRayQueryProceedKHR => struct { id_result_type: IdResultType, id_result: IdResult, rayquery: IdRef },
            .OpRayQueryGetIntersectionTypeKHR => struct { id_result_type: IdResultType, id_result: IdResult, rayquery: IdRef, intersection: IdRef },
            .OpImageSampleWeightedQCOM => struct { id_result_type: IdResultType, id_result: IdResult, texture: IdRef, coordinates: IdRef, weights: IdRef },
            .OpImageBoxFilterQCOM => struct { id_result_type: IdResultType, id_result: IdResult, texture: IdRef, coordinates: IdRef, box_size: IdRef },
            .OpImageBlockMatchSSDQCOM => struct { id_result_type: IdResultType, id_result: IdResult, target: IdRef, target_coordinates: IdRef, reference: IdRef, reference_coordinates: IdRef, block_size: IdRef },
            .OpImageBlockMatchSADQCOM => struct { id_result_type: IdResultType, id_result: IdResult, target: IdRef, target_coordinates: IdRef, reference: IdRef, reference_coordinates: IdRef, block_size: IdRef },
            .OpImageBlockMatchWindowSSDQCOM => struct { id_result_type: IdResultType, id_result: IdResult, target_sampled_image: IdRef, target_coordinates: IdRef, reference_sampled_image: IdRef, reference_coordinates: IdRef, block_size: IdRef },
            .OpImageBlockMatchWindowSADQCOM => struct { id_result_type: IdResultType, id_result: IdResult, target_sampled_image: IdRef, target_coordinates: IdRef, reference_sampled_image: IdRef, reference_coordinates: IdRef, block_size: IdRef },
            .OpImageBlockMatchGatherSSDQCOM => struct { id_result_type: IdResultType, id_result: IdResult, target_sampled_image: IdRef, target_coordinates: IdRef, reference_sampled_image: IdRef, reference_coordinates: IdRef, block_size: IdRef },
            .OpImageBlockMatchGatherSADQCOM => struct { id_result_type: IdResultType, id_result: IdResult, target_sampled_image: IdRef, target_coordinates: IdRef, reference_sampled_image: IdRef, reference_coordinates: IdRef, block_size: IdRef },
            .OpGroupIAddNonUniformAMD => struct { id_result_type: IdResultType, id_result: IdResult, execution: IdScope, operation: GroupOperation, x: IdRef },
            .OpGroupFAddNonUniformAMD => struct { id_result_type: IdResultType, id_result: IdResult, execution: IdScope, operation: GroupOperation, x: IdRef },
            .OpGroupFMinNonUniformAMD => struct { id_result_type: IdResultType, id_result: IdResult, execution: IdScope, operation: GroupOperation, x: IdRef },
            .OpGroupUMinNonUniformAMD => struct { id_result_type: IdResultType, id_result: IdResult, execution: IdScope, operation: GroupOperation, x: IdRef },
            .OpGroupSMinNonUniformAMD => struct { id_result_type: IdResultType, id_result: IdResult, execution: IdScope, operation: GroupOperation, x: IdRef },
            .OpGroupFMaxNonUniformAMD => struct { id_result_type: IdResultType, id_result: IdResult, execution: IdScope, operation: GroupOperation, x: IdRef },
            .OpGroupUMaxNonUniformAMD => struct { id_result_type: IdResultType, id_result: IdResult, execution: IdScope, operation: GroupOperation, x: IdRef },
            .OpGroupSMaxNonUniformAMD => struct { id_result_type: IdResultType, id_result: IdResult, execution: IdScope, operation: GroupOperation, x: IdRef },
            .OpFragmentMaskFetchAMD => struct { id_result_type: IdResultType, id_result: IdResult, image: IdRef, coordinate: IdRef },
            .OpFragmentFetchAMD => struct { id_result_type: IdResultType, id_result: IdResult, image: IdRef, coordinate: IdRef, fragment_index: IdRef },
            .OpReadClockKHR => struct { id_result_type: IdResultType, id_result: IdResult, scope: IdScope },
            .OpFinalizeNodePayloadsAMDX => struct { payload_array: IdRef },
            .OpFinishWritingNodePayloadAMDX => struct { id_result_type: IdResultType, id_result: IdResult, payload: IdRef },
            .OpInitializeNodePayloadsAMDX => struct { payload_array: IdRef, visibility: IdScope, payload_count: IdRef, node_index: IdRef },
            .OpGroupNonUniformQuadAllKHR => struct { id_result_type: IdResultType, id_result: IdResult, predicate: IdRef },
            .OpGroupNonUniformQuadAnyKHR => struct { id_result_type: IdResultType, id_result: IdResult, predicate: IdRef },
            .OpHitObjectRecordHitMotionNV => struct { hit_object: IdRef, acceleration_structure: IdRef, instanceid: IdRef, primitiveid: IdRef, geometryindex: IdRef, hit_kind: IdRef, sbt_record_offset: IdRef, sbt_record_stride: IdRef, origin: IdRef, tmin: IdRef, direction: IdRef, tmax: IdRef, current_time: IdRef, hitobject_attributes: IdRef },
            .OpHitObjectRecordHitWithIndexMotionNV => struct { hit_object: IdRef, acceleration_structure: IdRef, instanceid: IdRef, primitiveid: IdRef, geometryindex: IdRef, hit_kind: IdRef, sbt_record_index: IdRef, origin: IdRef, tmin: IdRef, direction: IdRef, tmax: IdRef, current_time: IdRef, hitobject_attributes: IdRef },
            .OpHitObjectRecordMissMotionNV => struct { hit_object: IdRef, sbt_index: IdRef, origin: IdRef, tmin: IdRef, direction: IdRef, tmax: IdRef, current_time: IdRef },
            .OpHitObjectGetWorldToObjectNV => struct { id_result_type: IdResultType, id_result: IdResult, hit_object: IdRef },
            .OpHitObjectGetObjectToWorldNV => struct { id_result_type: IdResultType, id_result: IdResult, hit_object: IdRef },
            .OpHitObjectGetObjectRayDirectionNV => struct { id_result_type: IdResultType, id_result: IdResult, hit_object: IdRef },
            .OpHitObjectGetObjectRayOriginNV => struct { id_result_type: IdResultType, id_result: IdResult, hit_object: IdRef },
            .OpHitObjectTraceRayMotionNV => struct { hit_object: IdRef, acceleration_structure: IdRef, rayflags: IdRef, cullmask: IdRef, sbt_record_offset: IdRef, sbt_record_stride: IdRef, miss_index: IdRef, origin: IdRef, tmin: IdRef, direction: IdRef, tmax: IdRef, time: IdRef, payload: IdRef },
            .OpHitObjectGetShaderRecordBufferHandleNV => struct { id_result_type: IdResultType, id_result: IdResult, hit_object: IdRef },
            .OpHitObjectGetShaderBindingTableRecordIndexNV => struct { id_result_type: IdResultType, id_result: IdResult, hit_object: IdRef },
            .OpHitObjectRecordEmptyNV => struct { hit_object: IdRef },
            .OpHitObjectTraceRayNV => struct { hit_object: IdRef, acceleration_structure: IdRef, rayflags: IdRef, cullmask: IdRef, sbt_record_offset: IdRef, sbt_record_stride: IdRef, miss_index: IdRef, origin: IdRef, tmin: IdRef, direction: IdRef, tmax: IdRef, payload: IdRef },
            .OpHitObjectRecordHitNV => struct { hit_object: IdRef, acceleration_structure: IdRef, instanceid: IdRef, primitiveid: IdRef, geometryindex: IdRef, hit_kind: IdRef, sbt_record_offset: IdRef, sbt_record_stride: IdRef, origin: IdRef, tmin: IdRef, direction: IdRef, tmax: IdRef, hitobject_attributes: IdRef },
            .OpHitObjectRecordHitWithIndexNV => struct { hit_object: IdRef, acceleration_structure: IdRef, instanceid: IdRef, primitiveid: IdRef, geometryindex: IdRef, hit_kind: IdRef, sbt_record_index: IdRef, origin: IdRef, tmin: IdRef, direction: IdRef, tmax: IdRef, hitobject_attributes: IdRef },
            .OpHitObjectRecordMissNV => struct { hit_object: IdRef, sbt_index: IdRef, origin: IdRef, tmin: IdRef, direction: IdRef, tmax: IdRef },
            .OpHitObjectExecuteShaderNV => struct { hit_object: IdRef, payload: IdRef },
            .OpHitObjectGetCurrentTimeNV => struct { id_result_type: IdResultType, id_result: IdResult, hit_object: IdRef },
            .OpHitObjectGetAttributesNV => struct { hit_object: IdRef, hit_object_attribute: IdRef },
            .OpHitObjectGetHitKindNV => struct { id_result_type: IdResultType, id_result: IdResult, hit_object: IdRef },
            .OpHitObjectGetPrimitiveIndexNV => struct { id_result_type: IdResultType, id_result: IdResult, hit_object: IdRef },
            .OpHitObjectGetGeometryIndexNV => struct { id_result_type: IdResultType, id_result: IdResult, hit_object: IdRef },
            .OpHitObjectGetInstanceIdNV => struct { id_result_type: IdResultType, id_result: IdResult, hit_object: IdRef },
            .OpHitObjectGetInstanceCustomIndexNV => struct { id_result_type: IdResultType, id_result: IdResult, hit_object: IdRef },
            .OpHitObjectGetWorldRayDirectionNV => struct { id_result_type: IdResultType, id_result: IdResult, hit_object: IdRef },
            .OpHitObjectGetWorldRayOriginNV => struct { id_result_type: IdResultType, id_result: IdResult, hit_object: IdRef },
            .OpHitObjectGetRayTMaxNV => struct { id_result_type: IdResultType, id_result: IdResult, hit_object: IdRef },
            .OpHitObjectGetRayTMinNV => struct { id_result_type: IdResultType, id_result: IdResult, hit_object: IdRef },
            .OpHitObjectIsEmptyNV => struct { id_result_type: IdResultType, id_result: IdResult, hit_object: IdRef },
            .OpHitObjectIsHitNV => struct { id_result_type: IdResultType, id_result: IdResult, hit_object: IdRef },
            .OpHitObjectIsMissNV => struct { id_result_type: IdResultType, id_result: IdResult, hit_object: IdRef },
            .OpReorderThreadWithHitObjectNV => struct { hit_object: IdRef, hint: ?IdRef = null, bits: ?IdRef = null },
            .OpReorderThreadWithHintNV => struct { hint: IdRef, bits: IdRef },
            .OpTypeHitObjectNV => struct { id_result: IdResult },
            .OpImageSampleFootprintNV => struct { id_result_type: IdResultType, id_result: IdResult, sampled_image: IdRef, coordinate: IdRef, granularity: IdRef, coarse: IdRef, image_operands: ?ImageOperands.Extended = null },
            .OpEmitMeshTasksEXT => struct { group_count_x: IdRef, group_count_y: IdRef, group_count_z: IdRef, payload: ?IdRef = null },
            .OpSetMeshOutputsEXT => struct { vertex_count: IdRef, primitive_count: IdRef },
            .OpGroupNonUniformPartitionNV => struct { id_result_type: IdResultType, id_result: IdResult, value: IdRef },
            .OpWritePackedPrimitiveIndices4x8NV => struct { index_offset: IdRef, packed_indices: IdRef },
            .OpFetchMicroTriangleVertexPositionNV => struct { id_result_type: IdResultType, id_result: IdResult, accel: IdRef, instance_id: IdRef, geometry_index: IdRef, primitive_index: IdRef, barycentric: IdRef },
            .OpFetchMicroTriangleVertexBarycentricNV => struct { id_result_type: IdResultType, id_result: IdResult, accel: IdRef, instance_id: IdRef, geometry_index: IdRef, primitive_index: IdRef, barycentric: IdRef },
            .OpReportIntersectionKHR => struct { id_result_type: IdResultType, id_result: IdResult, hit: IdRef, hitkind: IdRef },
            .OpIgnoreIntersectionNV => void,
            .OpTerminateRayNV => void,
            .OpTraceNV => struct { accel: IdRef, ray_flags: IdRef, cull_mask: IdRef, sbt_offset: IdRef, sbt_stride: IdRef, miss_index: IdRef, ray_origin: IdRef, ray_tmin: IdRef, ray_direction: IdRef, ray_tmax: IdRef, payloadid: IdRef },
            .OpTraceMotionNV => struct { accel: IdRef, ray_flags: IdRef, cull_mask: IdRef, sbt_offset: IdRef, sbt_stride: IdRef, miss_index: IdRef, ray_origin: IdRef, ray_tmin: IdRef, ray_direction: IdRef, ray_tmax: IdRef, time: IdRef, payloadid: IdRef },
            .OpTraceRayMotionNV => struct { accel: IdRef, ray_flags: IdRef, cull_mask: IdRef, sbt_offset: IdRef, sbt_stride: IdRef, miss_index: IdRef, ray_origin: IdRef, ray_tmin: IdRef, ray_direction: IdRef, ray_tmax: IdRef, time: IdRef, payload: IdRef },
            .OpRayQueryGetIntersectionTriangleVertexPositionsKHR => struct { id_result_type: IdResultType, id_result: IdResult, rayquery: IdRef, intersection: IdRef },
            .OpTypeAccelerationStructureKHR => struct { id_result: IdResult },
            .OpExecuteCallableNV => struct { sbt_index: IdRef, callable_dataid: IdRef },
            .OpTypeCooperativeMatrixNV => struct { id_result: IdResult, component_type: IdRef, execution: IdScope, rows: IdRef, columns: IdRef },
            .OpCooperativeMatrixLoadNV => struct { id_result_type: IdResultType, id_result: IdResult, pointer: IdRef, stride: IdRef, column_major: IdRef, memory_access: ?MemoryAccess.Extended = null },
            .OpCooperativeMatrixStoreNV => struct { pointer: IdRef, object: IdRef, stride: IdRef, column_major: IdRef, memory_access: ?MemoryAccess.Extended = null },
            .OpCooperativeMatrixMulAddNV => struct { id_result_type: IdResultType, id_result: IdResult, a: IdRef, b: IdRef, c: IdRef },
            .OpCooperativeMatrixLengthNV => struct { id_result_type: IdResultType, id_result: IdResult, type: IdRef },
            .OpBeginInvocationInterlockEXT => void,
            .OpEndInvocationInterlockEXT => void,
            .OpDemoteToHelperInvocation => void,
            .OpIsHelperInvocationEXT => struct { id_result_type: IdResultType, id_result: IdResult },
            .OpConvertUToImageNV => struct { id_result_type: IdResultType, id_result: IdResult, operand: IdRef },
            .OpConvertUToSamplerNV => struct { id_result_type: IdResultType, id_result: IdResult, operand: IdRef },
            .OpConvertImageToUNV => struct { id_result_type: IdResultType, id_result: IdResult, operand: IdRef },
            .OpConvertSamplerToUNV => struct { id_result_type: IdResultType, id_result: IdResult, operand: IdRef },
            .OpConvertUToSampledImageNV => struct { id_result_type: IdResultType, id_result: IdResult, operand: IdRef },
            .OpConvertSampledImageToUNV => struct { id_result_type: IdResultType, id_result: IdResult, operand: IdRef },
            .OpSamplerImageAddressingModeNV => struct { bit_width: LiteralInteger },
            .OpRawAccessChainNV => struct { id_result_type: IdResultType, id_result: IdResult, base: IdRef, byte_stride: IdRef, element_index: IdRef, byte_offset: IdRef, raw_access_chain_operands: ?RawAccessChainOperands = null },
            .OpSubgroupShuffleINTEL => struct { id_result_type: IdResultType, id_result: IdResult, data: IdRef, invocationid: IdRef },
            .OpSubgroupShuffleDownINTEL => struct { id_result_type: IdResultType, id_result: IdResult, current: IdRef, next: IdRef, delta: IdRef },
            .OpSubgroupShuffleUpINTEL => struct { id_result_type: IdResultType, id_result: IdResult, previous: IdRef, current: IdRef, delta: IdRef },
            .OpSubgroupShuffleXorINTEL => struct { id_result_type: IdResultType, id_result: IdResult, data: IdRef, value: IdRef },
            .OpSubgroupBlockReadINTEL => struct { id_result_type: IdResultType, id_result: IdResult, ptr: IdRef },
            .OpSubgroupBlockWriteINTEL => struct { ptr: IdRef, data: IdRef },
            .OpSubgroupImageBlockReadINTEL => struct { id_result_type: IdResultType, id_result: IdResult, image: IdRef, coordinate: IdRef },
            .OpSubgroupImageBlockWriteINTEL => struct { image: IdRef, coordinate: IdRef, data: IdRef },
            .OpSubgroupImageMediaBlockReadINTEL => struct { id_result_type: IdResultType, id_result: IdResult, image: IdRef, coordinate: IdRef, width: IdRef, height: IdRef },
            .OpSubgroupImageMediaBlockWriteINTEL => struct { image: IdRef, coordinate: IdRef, width: IdRef, height: IdRef, data: IdRef },
            .OpUCountLeadingZerosINTEL => struct { id_result_type: IdResultType, id_result: IdResult, operand: IdRef },
            .OpUCountTrailingZerosINTEL => struct { id_result_type: IdResultType, id_result: IdResult, operand: IdRef },
            .OpAbsISubINTEL => struct { id_result_type: IdResultType, id_result: IdResult, operand_1: IdRef, operand_2: IdRef },
            .OpAbsUSubINTEL => struct { id_result_type: IdResultType, id_result: IdResult, operand_1: IdRef, operand_2: IdRef },
            .OpIAddSatINTEL => struct { id_result_type: IdResultType, id_result: IdResult, operand_1: IdRef, operand_2: IdRef },
            .OpUAddSatINTEL => struct { id_result_type: IdResultType, id_result: IdResult, operand_1: IdRef, operand_2: IdRef },
            .OpIAverageINTEL => struct { id_result_type: IdResultType, id_result: IdResult, operand_1: IdRef, operand_2: IdRef },
            .OpUAverageINTEL => struct { id_result_type: IdResultType, id_result: IdResult, operand_1: IdRef, operand_2: IdRef },
            .OpIAverageRoundedINTEL => struct { id_result_type: IdResultType, id_result: IdResult, operand_1: IdRef, operand_2: IdRef },
            .OpUAverageRoundedINTEL => struct { id_result_type: IdResultType, id_result: IdResult, operand_1: IdRef, operand_2: IdRef },
            .OpISubSatINTEL => struct { id_result_type: IdResultType, id_result: IdResult, operand_1: IdRef, operand_2: IdRef },
            .OpUSubSatINTEL => struct { id_result_type: IdResultType, id_result: IdResult, operand_1: IdRef, operand_2: IdRef },
            .OpIMul32x16INTEL => struct { id_result_type: IdResultType, id_result: IdResult, operand_1: IdRef, operand_2: IdRef },
            .OpUMul32x16INTEL => struct { id_result_type: IdResultType, id_result: IdResult, operand_1: IdRef, operand_2: IdRef },
            .OpAtomicFMinEXT => struct { id_result_type: IdResultType, id_result: IdResult, pointer: IdRef, memory: IdScope, semantics: IdMemorySemantics, value: IdRef },
            .OpAtomicFMaxEXT => struct { id_result_type: IdResultType, id_result: IdResult, pointer: IdRef, memory: IdScope, semantics: IdMemorySemantics, value: IdRef },
            .OpAssumeTrueKHR => struct { condition: IdRef },
            .OpExpectKHR => struct { id_result_type: IdResultType, id_result: IdResult, value: IdRef, expectedvalue: IdRef },
            .OpDecorateString => struct { target: IdRef, decoration: Decoration.Extended },
            .OpMemberDecorateString => struct { struct_type: IdRef, member: LiteralInteger, decoration: Decoration.Extended },
            .OpLoopControlINTEL => struct { loop_control_parameters: []const LiteralInteger = &.{} },
            .OpReadPipeBlockingINTEL => struct { id_result_type: IdResultType, id_result: IdResult, packet_size: IdRef, packet_alignment: IdRef },
            .OpWritePipeBlockingINTEL => struct { id_result_type: IdResultType, id_result: IdResult, packet_size: IdRef, packet_alignment: IdRef },
            .OpFPGARegINTEL => struct { id_result_type: IdResultType, id_result: IdResult, result: IdRef, input: IdRef },
            .OpRayQueryGetRayTMinKHR => struct { id_result_type: IdResultType, id_result: IdResult, rayquery: IdRef },
            .OpRayQueryGetRayFlagsKHR => struct { id_result_type: IdResultType, id_result: IdResult, rayquery: IdRef },
            .OpRayQueryGetIntersectionTKHR => struct { id_result_type: IdResultType, id_result: IdResult, rayquery: IdRef, intersection: IdRef },
            .OpRayQueryGetIntersectionInstanceCustomIndexKHR => struct { id_result_type: IdResultType, id_result: IdResult, rayquery: IdRef, intersection: IdRef },
            .OpRayQueryGetIntersectionInstanceIdKHR => struct { id_result_type: IdResultType, id_result: IdResult, rayquery: IdRef, intersection: IdRef },
            .OpRayQueryGetIntersectionInstanceShaderBindingTableRecordOffsetKHR => struct { id_result_type: IdResultType, id_result: IdResult, rayquery: IdRef, intersection: IdRef },
            .OpRayQueryGetIntersectionGeometryIndexKHR => struct { id_result_type: IdResultType, id_result: IdResult, rayquery: IdRef, intersection: IdRef },
            .OpRayQueryGetIntersectionPrimitiveIndexKHR => struct { id_result_type: IdResultType, id_result: IdResult, rayquery: IdRef, intersection: IdRef },
            .OpRayQueryGetIntersectionBarycentricsKHR => struct { id_result_type: IdResultType, id_result: IdResult, rayquery: IdRef, intersection: IdRef },
            .OpRayQueryGetIntersectionFrontFaceKHR => struct { id_result_type: IdResultType, id_result: IdResult, rayquery: IdRef, intersection: IdRef },
            .OpRayQueryGetIntersectionCandidateAABBOpaqueKHR => struct { id_result_type: IdResultType, id_result: IdResult, rayquery: IdRef },
            .OpRayQueryGetIntersectionObjectRayDirectionKHR => struct { id_result_type: IdResultType, id_result: IdResult, rayquery: IdRef, intersection: IdRef },
            .OpRayQueryGetIntersectionObjectRayOriginKHR => struct { id_result_type: IdResultType, id_result: IdResult, rayquery: IdRef, intersection: IdRef },
            .OpRayQueryGetWorldRayDirectionKHR => struct { id_result_type: IdResultType, id_result: IdResult, rayquery: IdRef },
            .OpRayQueryGetWorldRayOriginKHR => struct { id_result_type: IdResultType, id_result: IdResult, rayquery: IdRef },
            .OpRayQueryGetIntersectionObjectToWorldKHR => struct { id_result_type: IdResultType, id_result: IdResult, rayquery: IdRef, intersection: IdRef },
            .OpRayQueryGetIntersectionWorldToObjectKHR => struct { id_result_type: IdResultType, id_result: IdResult, rayquery: IdRef, intersection: IdRef },
            .OpAtomicFAddEXT => struct { id_result_type: IdResultType, id_result: IdResult, pointer: IdRef, memory: IdScope, semantics: IdMemorySemantics, value: IdRef },
            .OpTypeBufferSurfaceINTEL => struct { id_result: IdResult, accessqualifier: AccessQualifier },
            .OpTypeStructContinuedINTEL => struct { id_ref: []const IdRef = &.{} },
            .OpConstantCompositeContinuedINTEL => struct { constituents: []const IdRef = &.{} },
            .OpSpecConstantCompositeContinuedINTEL => struct { constituents: []const IdRef = &.{} },
            .OpCompositeConstructContinuedINTEL => struct { id_result_type: IdResultType, id_result: IdResult, constituents: []const IdRef = &.{} },
            .OpConvertFToBF16INTEL => struct { id_result_type: IdResultType, id_result: IdResult, float_value: IdRef },
            .OpConvertBF16ToFINTEL => struct { id_result_type: IdResultType, id_result: IdResult, bfloat16_value: IdRef },
            .OpControlBarrierArriveINTEL => struct { execution: IdScope, memory: IdScope, semantics: IdMemorySemantics },
            .OpControlBarrierWaitINTEL => struct { execution: IdScope, memory: IdScope, semantics: IdMemorySemantics },
            .OpGroupIMulKHR => struct { id_result_type: IdResultType, id_result: IdResult, execution: IdScope, operation: GroupOperation, x: IdRef },
            .OpGroupFMulKHR => struct { id_result_type: IdResultType, id_result: IdResult, execution: IdScope, operation: GroupOperation, x: IdRef },
            .OpGroupBitwiseAndKHR => struct { id_result_type: IdResultType, id_result: IdResult, execution: IdScope, operation: GroupOperation, x: IdRef },
            .OpGroupBitwiseOrKHR => struct { id_result_type: IdResultType, id_result: IdResult, execution: IdScope, operation: GroupOperation, x: IdRef },
            .OpGroupBitwiseXorKHR => struct { id_result_type: IdResultType, id_result: IdResult, execution: IdScope, operation: GroupOperation, x: IdRef },
            .OpGroupLogicalAndKHR => struct { id_result_type: IdResultType, id_result: IdResult, execution: IdScope, operation: GroupOperation, x: IdRef },
            .OpGroupLogicalOrKHR => struct { id_result_type: IdResultType, id_result: IdResult, execution: IdScope, operation: GroupOperation, x: IdRef },
            .OpGroupLogicalXorKHR => struct { id_result_type: IdResultType, id_result: IdResult, execution: IdScope, operation: GroupOperation, x: IdRef },
            .OpMaskedGatherINTEL => struct { id_result_type: IdResultType, id_result: IdResult, ptrvector: IdRef, alignment: LiteralInteger, mask: IdRef, fillempty: IdRef },
            .OpMaskedScatterINTEL => struct { inputvector: IdRef, ptrvector: IdRef, alignment: LiteralInteger, mask: IdRef },
        };
    }
    pub fn class(self: Opcode) Class {
        return switch (self) {
            .OpNop => .Miscellaneous,
            .OpUndef => .Miscellaneous,
            .OpSourceContinued => .Debug,
            .OpSource => .Debug,
            .OpSourceExtension => .Debug,
            .OpName => .Debug,
            .OpMemberName => .Debug,
            .OpString => .Debug,
            .OpLine => .Debug,
            .OpExtension => .Extension,
            .OpExtInstImport => .Extension,
            .OpExtInst => .Extension,
            .OpMemoryModel => .ModeSetting,
            .OpEntryPoint => .ModeSetting,
            .OpExecutionMode => .ModeSetting,
            .OpCapability => .ModeSetting,
            .OpTypeVoid => .TypeDeclaration,
            .OpTypeBool => .TypeDeclaration,
            .OpTypeInt => .TypeDeclaration,
            .OpTypeFloat => .TypeDeclaration,
            .OpTypeVector => .TypeDeclaration,
            .OpTypeMatrix => .TypeDeclaration,
            .OpTypeImage => .TypeDeclaration,
            .OpTypeSampler => .TypeDeclaration,
            .OpTypeSampledImage => .TypeDeclaration,
            .OpTypeArray => .TypeDeclaration,
            .OpTypeRuntimeArray => .TypeDeclaration,
            .OpTypeStruct => .TypeDeclaration,
            .OpTypeOpaque => .TypeDeclaration,
            .OpTypePointer => .TypeDeclaration,
            .OpTypeFunction => .TypeDeclaration,
            .OpTypeEvent => .TypeDeclaration,
            .OpTypeDeviceEvent => .TypeDeclaration,
            .OpTypeReserveId => .TypeDeclaration,
            .OpTypeQueue => .TypeDeclaration,
            .OpTypePipe => .TypeDeclaration,
            .OpTypeForwardPointer => .TypeDeclaration,
            .OpConstantTrue => .ConstantCreation,
            .OpConstantFalse => .ConstantCreation,
            .OpConstant => .ConstantCreation,
            .OpConstantComposite => .ConstantCreation,
            .OpConstantSampler => .ConstantCreation,
            .OpConstantNull => .ConstantCreation,
            .OpSpecConstantTrue => .ConstantCreation,
            .OpSpecConstantFalse => .ConstantCreation,
            .OpSpecConstant => .ConstantCreation,
            .OpSpecConstantComposite => .ConstantCreation,
            .OpSpecConstantOp => .ConstantCreation,
            .OpFunction => .Function,
            .OpFunctionParameter => .Function,
            .OpFunctionEnd => .Function,
            .OpFunctionCall => .Function,
            .OpVariable => .Memory,
            .OpImageTexelPointer => .Memory,
            .OpLoad => .Memory,
            .OpStore => .Memory,
            .OpCopyMemory => .Memory,
            .OpCopyMemorySized => .Memory,
            .OpAccessChain => .Memory,
            .OpInBoundsAccessChain => .Memory,
            .OpPtrAccessChain => .Memory,
            .OpArrayLength => .Memory,
            .OpGenericPtrMemSemantics => .Memory,
            .OpInBoundsPtrAccessChain => .Memory,
            .OpDecorate => .Annotation,
            .OpMemberDecorate => .Annotation,
            .OpDecorationGroup => .Annotation,
            .OpGroupDecorate => .Annotation,
            .OpGroupMemberDecorate => .Annotation,
            .OpVectorExtractDynamic => .Composite,
            .OpVectorInsertDynamic => .Composite,
            .OpVectorShuffle => .Composite,
            .OpCompositeConstruct => .Composite,
            .OpCompositeExtract => .Composite,
            .OpCompositeInsert => .Composite,
            .OpCopyObject => .Composite,
            .OpTranspose => .Composite,
            .OpSampledImage => .Image,
            .OpImageSampleImplicitLod => .Image,
            .OpImageSampleExplicitLod => .Image,
            .OpImageSampleDrefImplicitLod => .Image,
            .OpImageSampleDrefExplicitLod => .Image,
            .OpImageSampleProjImplicitLod => .Image,
            .OpImageSampleProjExplicitLod => .Image,
            .OpImageSampleProjDrefImplicitLod => .Image,
            .OpImageSampleProjDrefExplicitLod => .Image,
            .OpImageFetch => .Image,
            .OpImageGather => .Image,
            .OpImageDrefGather => .Image,
            .OpImageRead => .Image,
            .OpImageWrite => .Image,
            .OpImage => .Image,
            .OpImageQueryFormat => .Image,
            .OpImageQueryOrder => .Image,
            .OpImageQuerySizeLod => .Image,
            .OpImageQuerySize => .Image,
            .OpImageQueryLod => .Image,
            .OpImageQueryLevels => .Image,
            .OpImageQuerySamples => .Image,
            .OpConvertFToU => .Conversion,
            .OpConvertFToS => .Conversion,
            .OpConvertSToF => .Conversion,
            .OpConvertUToF => .Conversion,
            .OpUConvert => .Conversion,
            .OpSConvert => .Conversion,
            .OpFConvert => .Conversion,
            .OpQuantizeToF16 => .Conversion,
            .OpConvertPtrToU => .Conversion,
            .OpSatConvertSToU => .Conversion,
            .OpSatConvertUToS => .Conversion,
            .OpConvertUToPtr => .Conversion,
            .OpPtrCastToGeneric => .Conversion,
            .OpGenericCastToPtr => .Conversion,
            .OpGenericCastToPtrExplicit => .Conversion,
            .OpBitcast => .Conversion,
            .OpSNegate => .Arithmetic,
            .OpFNegate => .Arithmetic,
            .OpIAdd => .Arithmetic,
            .OpFAdd => .Arithmetic,
            .OpISub => .Arithmetic,
            .OpFSub => .Arithmetic,
            .OpIMul => .Arithmetic,
            .OpFMul => .Arithmetic,
            .OpUDiv => .Arithmetic,
            .OpSDiv => .Arithmetic,
            .OpFDiv => .Arithmetic,
            .OpUMod => .Arithmetic,
            .OpSRem => .Arithmetic,
            .OpSMod => .Arithmetic,
            .OpFRem => .Arithmetic,
            .OpFMod => .Arithmetic,
            .OpVectorTimesScalar => .Arithmetic,
            .OpMatrixTimesScalar => .Arithmetic,
            .OpVectorTimesMatrix => .Arithmetic,
            .OpMatrixTimesVector => .Arithmetic,
            .OpMatrixTimesMatrix => .Arithmetic,
            .OpOuterProduct => .Arithmetic,
            .OpDot => .Arithmetic,
            .OpIAddCarry => .Arithmetic,
            .OpISubBorrow => .Arithmetic,
            .OpUMulExtended => .Arithmetic,
            .OpSMulExtended => .Arithmetic,
            .OpAny => .RelationalAndLogical,
            .OpAll => .RelationalAndLogical,
            .OpIsNan => .RelationalAndLogical,
            .OpIsInf => .RelationalAndLogical,
            .OpIsFinite => .RelationalAndLogical,
            .OpIsNormal => .RelationalAndLogical,
            .OpSignBitSet => .RelationalAndLogical,
            .OpLessOrGreater => .RelationalAndLogical,
            .OpOrdered => .RelationalAndLogical,
            .OpUnordered => .RelationalAndLogical,
            .OpLogicalEqual => .RelationalAndLogical,
            .OpLogicalNotEqual => .RelationalAndLogical,
            .OpLogicalOr => .RelationalAndLogical,
            .OpLogicalAnd => .RelationalAndLogical,
            .OpLogicalNot => .RelationalAndLogical,
            .OpSelect => .RelationalAndLogical,
            .OpIEqual => .RelationalAndLogical,
            .OpINotEqual => .RelationalAndLogical,
            .OpUGreaterThan => .RelationalAndLogical,
            .OpSGreaterThan => .RelationalAndLogical,
            .OpUGreaterThanEqual => .RelationalAndLogical,
            .OpSGreaterThanEqual => .RelationalAndLogical,
            .OpULessThan => .RelationalAndLogical,
            .OpSLessThan => .RelationalAndLogical,
            .OpULessThanEqual => .RelationalAndLogical,
            .OpSLessThanEqual => .RelationalAndLogical,
            .OpFOrdEqual => .RelationalAndLogical,
            .OpFUnordEqual => .RelationalAndLogical,
            .OpFOrdNotEqual => .RelationalAndLogical,
            .OpFUnordNotEqual => .RelationalAndLogical,
            .OpFOrdLessThan => .RelationalAndLogical,
            .OpFUnordLessThan => .RelationalAndLogical,
            .OpFOrdGreaterThan => .RelationalAndLogical,
            .OpFUnordGreaterThan => .RelationalAndLogical,
            .OpFOrdLessThanEqual => .RelationalAndLogical,
            .OpFUnordLessThanEqual => .RelationalAndLogical,
            .OpFOrdGreaterThanEqual => .RelationalAndLogical,
            .OpFUnordGreaterThanEqual => .RelationalAndLogical,
            .OpShiftRightLogical => .Bit,
            .OpShiftRightArithmetic => .Bit,
            .OpShiftLeftLogical => .Bit,
            .OpBitwiseOr => .Bit,
            .OpBitwiseXor => .Bit,
            .OpBitwiseAnd => .Bit,
            .OpNot => .Bit,
            .OpBitFieldInsert => .Bit,
            .OpBitFieldSExtract => .Bit,
            .OpBitFieldUExtract => .Bit,
            .OpBitReverse => .Bit,
            .OpBitCount => .Bit,
            .OpDPdx => .Derivative,
            .OpDPdy => .Derivative,
            .OpFwidth => .Derivative,
            .OpDPdxFine => .Derivative,
            .OpDPdyFine => .Derivative,
            .OpFwidthFine => .Derivative,
            .OpDPdxCoarse => .Derivative,
            .OpDPdyCoarse => .Derivative,
            .OpFwidthCoarse => .Derivative,
            .OpEmitVertex => .Primitive,
            .OpEndPrimitive => .Primitive,
            .OpEmitStreamVertex => .Primitive,
            .OpEndStreamPrimitive => .Primitive,
            .OpControlBarrier => .Barrier,
            .OpMemoryBarrier => .Barrier,
            .OpAtomicLoad => .Atomic,
            .OpAtomicStore => .Atomic,
            .OpAtomicExchange => .Atomic,
            .OpAtomicCompareExchange => .Atomic,
            .OpAtomicCompareExchangeWeak => .Atomic,
            .OpAtomicIIncrement => .Atomic,
            .OpAtomicIDecrement => .Atomic,
            .OpAtomicIAdd => .Atomic,
            .OpAtomicISub => .Atomic,
            .OpAtomicSMin => .Atomic,
            .OpAtomicUMin => .Atomic,
            .OpAtomicSMax => .Atomic,
            .OpAtomicUMax => .Atomic,
            .OpAtomicAnd => .Atomic,
            .OpAtomicOr => .Atomic,
            .OpAtomicXor => .Atomic,
            .OpPhi => .ControlFlow,
            .OpLoopMerge => .ControlFlow,
            .OpSelectionMerge => .ControlFlow,
            .OpLabel => .ControlFlow,
            .OpBranch => .ControlFlow,
            .OpBranchConditional => .ControlFlow,
            .OpSwitch => .ControlFlow,
            .OpKill => .ControlFlow,
            .OpReturn => .ControlFlow,
            .OpReturnValue => .ControlFlow,
            .OpUnreachable => .ControlFlow,
            .OpLifetimeStart => .ControlFlow,
            .OpLifetimeStop => .ControlFlow,
            .OpGroupAsyncCopy => .Group,
            .OpGroupWaitEvents => .Group,
            .OpGroupAll => .Group,
            .OpGroupAny => .Group,
            .OpGroupBroadcast => .Group,
            .OpGroupIAdd => .Group,
            .OpGroupFAdd => .Group,
            .OpGroupFMin => .Group,
            .OpGroupUMin => .Group,
            .OpGroupSMin => .Group,
            .OpGroupFMax => .Group,
            .OpGroupUMax => .Group,
            .OpGroupSMax => .Group,
            .OpReadPipe => .Pipe,
            .OpWritePipe => .Pipe,
            .OpReservedReadPipe => .Pipe,
            .OpReservedWritePipe => .Pipe,
            .OpReserveReadPipePackets => .Pipe,
            .OpReserveWritePipePackets => .Pipe,
            .OpCommitReadPipe => .Pipe,
            .OpCommitWritePipe => .Pipe,
            .OpIsValidReserveId => .Pipe,
            .OpGetNumPipePackets => .Pipe,
            .OpGetMaxPipePackets => .Pipe,
            .OpGroupReserveReadPipePackets => .Pipe,
            .OpGroupReserveWritePipePackets => .Pipe,
            .OpGroupCommitReadPipe => .Pipe,
            .OpGroupCommitWritePipe => .Pipe,
            .OpEnqueueMarker => .DeviceSideEnqueue,
            .OpEnqueueKernel => .DeviceSideEnqueue,
            .OpGetKernelNDrangeSubGroupCount => .DeviceSideEnqueue,
            .OpGetKernelNDrangeMaxSubGroupSize => .DeviceSideEnqueue,
            .OpGetKernelWorkGroupSize => .DeviceSideEnqueue,
            .OpGetKernelPreferredWorkGroupSizeMultiple => .DeviceSideEnqueue,
            .OpRetainEvent => .DeviceSideEnqueue,
            .OpReleaseEvent => .DeviceSideEnqueue,
            .OpCreateUserEvent => .DeviceSideEnqueue,
            .OpIsValidEvent => .DeviceSideEnqueue,
            .OpSetUserEventStatus => .DeviceSideEnqueue,
            .OpCaptureEventProfilingInfo => .DeviceSideEnqueue,
            .OpGetDefaultQueue => .DeviceSideEnqueue,
            .OpBuildNDRange => .DeviceSideEnqueue,
            .OpImageSparseSampleImplicitLod => .Image,
            .OpImageSparseSampleExplicitLod => .Image,
            .OpImageSparseSampleDrefImplicitLod => .Image,
            .OpImageSparseSampleDrefExplicitLod => .Image,
            .OpImageSparseSampleProjImplicitLod => .Image,
            .OpImageSparseSampleProjExplicitLod => .Image,
            .OpImageSparseSampleProjDrefImplicitLod => .Image,
            .OpImageSparseSampleProjDrefExplicitLod => .Image,
            .OpImageSparseFetch => .Image,
            .OpImageSparseGather => .Image,
            .OpImageSparseDrefGather => .Image,
            .OpImageSparseTexelsResident => .Image,
            .OpNoLine => .Debug,
            .OpAtomicFlagTestAndSet => .Atomic,
            .OpAtomicFlagClear => .Atomic,
            .OpImageSparseRead => .Image,
            .OpSizeOf => .Miscellaneous,
            .OpTypePipeStorage => .TypeDeclaration,
            .OpConstantPipeStorage => .Pipe,
            .OpCreatePipeFromPipeStorage => .Pipe,
            .OpGetKernelLocalSizeForSubgroupCount => .DeviceSideEnqueue,
            .OpGetKernelMaxNumSubgroups => .DeviceSideEnqueue,
            .OpTypeNamedBarrier => .TypeDeclaration,
            .OpNamedBarrierInitialize => .Barrier,
            .OpMemoryNamedBarrier => .Barrier,
            .OpModuleProcessed => .Debug,
            .OpExecutionModeId => .ModeSetting,
            .OpDecorateId => .Annotation,
            .OpGroupNonUniformElect => .NonUniform,
            .OpGroupNonUniformAll => .NonUniform,
            .OpGroupNonUniformAny => .NonUniform,
            .OpGroupNonUniformAllEqual => .NonUniform,
            .OpGroupNonUniformBroadcast => .NonUniform,
            .OpGroupNonUniformBroadcastFirst => .NonUniform,
            .OpGroupNonUniformBallot => .NonUniform,
            .OpGroupNonUniformInverseBallot => .NonUniform,
            .OpGroupNonUniformBallotBitExtract => .NonUniform,
            .OpGroupNonUniformBallotBitCount => .NonUniform,
            .OpGroupNonUniformBallotFindLSB => .NonUniform,
            .OpGroupNonUniformBallotFindMSB => .NonUniform,
            .OpGroupNonUniformShuffle => .NonUniform,
            .OpGroupNonUniformShuffleXor => .NonUniform,
            .OpGroupNonUniformShuffleUp => .NonUniform,
            .OpGroupNonUniformShuffleDown => .NonUniform,
            .OpGroupNonUniformIAdd => .NonUniform,
            .OpGroupNonUniformFAdd => .NonUniform,
            .OpGroupNonUniformIMul => .NonUniform,
            .OpGroupNonUniformFMul => .NonUniform,
            .OpGroupNonUniformSMin => .NonUniform,
            .OpGroupNonUniformUMin => .NonUniform,
            .OpGroupNonUniformFMin => .NonUniform,
            .OpGroupNonUniformSMax => .NonUniform,
            .OpGroupNonUniformUMax => .NonUniform,
            .OpGroupNonUniformFMax => .NonUniform,
            .OpGroupNonUniformBitwiseAnd => .NonUniform,
            .OpGroupNonUniformBitwiseOr => .NonUniform,
            .OpGroupNonUniformBitwiseXor => .NonUniform,
            .OpGroupNonUniformLogicalAnd => .NonUniform,
            .OpGroupNonUniformLogicalOr => .NonUniform,
            .OpGroupNonUniformLogicalXor => .NonUniform,
            .OpGroupNonUniformQuadBroadcast => .NonUniform,
            .OpGroupNonUniformQuadSwap => .NonUniform,
            .OpCopyLogical => .Composite,
            .OpPtrEqual => .Memory,
            .OpPtrNotEqual => .Memory,
            .OpPtrDiff => .Memory,
            .OpColorAttachmentReadEXT => .Image,
            .OpDepthAttachmentReadEXT => .Image,
            .OpStencilAttachmentReadEXT => .Image,
            .OpTerminateInvocation => .ControlFlow,
            .OpSubgroupBallotKHR => .Group,
            .OpSubgroupFirstInvocationKHR => .Group,
            .OpSubgroupAllKHR => .Group,
            .OpSubgroupAnyKHR => .Group,
            .OpSubgroupAllEqualKHR => .Group,
            .OpGroupNonUniformRotateKHR => .Group,
            .OpSubgroupReadInvocationKHR => .Group,
            .OpTraceRayKHR => .Reserved,
            .OpExecuteCallableKHR => .Reserved,
            .OpConvertUToAccelerationStructureKHR => .Reserved,
            .OpIgnoreIntersectionKHR => .Reserved,
            .OpTerminateRayKHR => .Reserved,
            .OpSDot => .Arithmetic,
            .OpUDot => .Arithmetic,
            .OpSUDot => .Arithmetic,
            .OpSDotAccSat => .Arithmetic,
            .OpUDotAccSat => .Arithmetic,
            .OpSUDotAccSat => .Arithmetic,
            .OpTypeCooperativeMatrixKHR => .TypeDeclaration,
            .OpCooperativeMatrixLoadKHR => .Memory,
            .OpCooperativeMatrixStoreKHR => .Memory,
            .OpCooperativeMatrixMulAddKHR => .Arithmetic,
            .OpCooperativeMatrixLengthKHR => .Miscellaneous,
            .OpTypeRayQueryKHR => .TypeDeclaration,
            .OpRayQueryInitializeKHR => .Reserved,
            .OpRayQueryTerminateKHR => .Reserved,
            .OpRayQueryGenerateIntersectionKHR => .Reserved,
            .OpRayQueryConfirmIntersectionKHR => .Reserved,
            .OpRayQueryProceedKHR => .Reserved,
            .OpRayQueryGetIntersectionTypeKHR => .Reserved,
            .OpImageSampleWeightedQCOM => .Image,
            .OpImageBoxFilterQCOM => .Image,
            .OpImageBlockMatchSSDQCOM => .Image,
            .OpImageBlockMatchSADQCOM => .Image,
            .OpImageBlockMatchWindowSSDQCOM => .Image,
            .OpImageBlockMatchWindowSADQCOM => .Image,
            .OpImageBlockMatchGatherSSDQCOM => .Image,
            .OpImageBlockMatchGatherSADQCOM => .Image,
            .OpGroupIAddNonUniformAMD => .Group,
            .OpGroupFAddNonUniformAMD => .Group,
            .OpGroupFMinNonUniformAMD => .Group,
            .OpGroupUMinNonUniformAMD => .Group,
            .OpGroupSMinNonUniformAMD => .Group,
            .OpGroupFMaxNonUniformAMD => .Group,
            .OpGroupUMaxNonUniformAMD => .Group,
            .OpGroupSMaxNonUniformAMD => .Group,
            .OpFragmentMaskFetchAMD => .Reserved,
            .OpFragmentFetchAMD => .Reserved,
            .OpReadClockKHR => .Reserved,
            .OpFinalizeNodePayloadsAMDX => .Reserved,
            .OpFinishWritingNodePayloadAMDX => .Reserved,
            .OpInitializeNodePayloadsAMDX => .Reserved,
            .OpGroupNonUniformQuadAllKHR => .NonUniform,
            .OpGroupNonUniformQuadAnyKHR => .NonUniform,
            .OpHitObjectRecordHitMotionNV => .Reserved,
            .OpHitObjectRecordHitWithIndexMotionNV => .Reserved,
            .OpHitObjectRecordMissMotionNV => .Reserved,
            .OpHitObjectGetWorldToObjectNV => .Reserved,
            .OpHitObjectGetObjectToWorldNV => .Reserved,
            .OpHitObjectGetObjectRayDirectionNV => .Reserved,
            .OpHitObjectGetObjectRayOriginNV => .Reserved,
            .OpHitObjectTraceRayMotionNV => .Reserved,
            .OpHitObjectGetShaderRecordBufferHandleNV => .Reserved,
            .OpHitObjectGetShaderBindingTableRecordIndexNV => .Reserved,
            .OpHitObjectRecordEmptyNV => .Reserved,
            .OpHitObjectTraceRayNV => .Reserved,
            .OpHitObjectRecordHitNV => .Reserved,
            .OpHitObjectRecordHitWithIndexNV => .Reserved,
            .OpHitObjectRecordMissNV => .Reserved,
            .OpHitObjectExecuteShaderNV => .Reserved,
            .OpHitObjectGetCurrentTimeNV => .Reserved,
            .OpHitObjectGetAttributesNV => .Reserved,
            .OpHitObjectGetHitKindNV => .Reserved,
            .OpHitObjectGetPrimitiveIndexNV => .Reserved,
            .OpHitObjectGetGeometryIndexNV => .Reserved,
            .OpHitObjectGetInstanceIdNV => .Reserved,
            .OpHitObjectGetInstanceCustomIndexNV => .Reserved,
            .OpHitObjectGetWorldRayDirectionNV => .Reserved,
            .OpHitObjectGetWorldRayOriginNV => .Reserved,
            .OpHitObjectGetRayTMaxNV => .Reserved,
            .OpHitObjectGetRayTMinNV => .Reserved,
            .OpHitObjectIsEmptyNV => .Reserved,
            .OpHitObjectIsHitNV => .Reserved,
            .OpHitObjectIsMissNV => .Reserved,
            .OpReorderThreadWithHitObjectNV => .Reserved,
            .OpReorderThreadWithHintNV => .Reserved,
            .OpTypeHitObjectNV => .TypeDeclaration,
            .OpImageSampleFootprintNV => .Image,
            .OpEmitMeshTasksEXT => .Reserved,
            .OpSetMeshOutputsEXT => .Reserved,
            .OpGroupNonUniformPartitionNV => .NonUniform,
            .OpWritePackedPrimitiveIndices4x8NV => .Reserved,
            .OpFetchMicroTriangleVertexPositionNV => .Reserved,
            .OpFetchMicroTriangleVertexBarycentricNV => .Reserved,
            .OpReportIntersectionKHR => .Reserved,
            .OpIgnoreIntersectionNV => .Reserved,
            .OpTerminateRayNV => .Reserved,
            .OpTraceNV => .Reserved,
            .OpTraceMotionNV => .Reserved,
            .OpTraceRayMotionNV => .Reserved,
            .OpRayQueryGetIntersectionTriangleVertexPositionsKHR => .Reserved,
            .OpTypeAccelerationStructureKHR => .TypeDeclaration,
            .OpExecuteCallableNV => .Reserved,
            .OpTypeCooperativeMatrixNV => .TypeDeclaration,
            .OpCooperativeMatrixLoadNV => .Reserved,
            .OpCooperativeMatrixStoreNV => .Reserved,
            .OpCooperativeMatrixMulAddNV => .Reserved,
            .OpCooperativeMatrixLengthNV => .Reserved,
            .OpBeginInvocationInterlockEXT => .Reserved,
            .OpEndInvocationInterlockEXT => .Reserved,
            .OpDemoteToHelperInvocation => .ControlFlow,
            .OpIsHelperInvocationEXT => .Reserved,
            .OpConvertUToImageNV => .Reserved,
            .OpConvertUToSamplerNV => .Reserved,
            .OpConvertImageToUNV => .Reserved,
            .OpConvertSamplerToUNV => .Reserved,
            .OpConvertUToSampledImageNV => .Reserved,
            .OpConvertSampledImageToUNV => .Reserved,
            .OpSamplerImageAddressingModeNV => .Reserved,
            .OpRawAccessChainNV => .Memory,
            .OpSubgroupShuffleINTEL => .Group,
            .OpSubgroupShuffleDownINTEL => .Group,
            .OpSubgroupShuffleUpINTEL => .Group,
            .OpSubgroupShuffleXorINTEL => .Group,
            .OpSubgroupBlockReadINTEL => .Group,
            .OpSubgroupBlockWriteINTEL => .Group,
            .OpSubgroupImageBlockReadINTEL => .Group,
            .OpSubgroupImageBlockWriteINTEL => .Group,
            .OpSubgroupImageMediaBlockReadINTEL => .Group,
            .OpSubgroupImageMediaBlockWriteINTEL => .Group,
            .OpUCountLeadingZerosINTEL => .Reserved,
            .OpUCountTrailingZerosINTEL => .Reserved,
            .OpAbsISubINTEL => .Reserved,
            .OpAbsUSubINTEL => .Reserved,
            .OpIAddSatINTEL => .Reserved,
            .OpUAddSatINTEL => .Reserved,
            .OpIAverageINTEL => .Reserved,
            .OpUAverageINTEL => .Reserved,
            .OpIAverageRoundedINTEL => .Reserved,
            .OpUAverageRoundedINTEL => .Reserved,
            .OpISubSatINTEL => .Reserved,
            .OpUSubSatINTEL => .Reserved,
            .OpIMul32x16INTEL => .Reserved,
            .OpUMul32x16INTEL => .Reserved,
            .OpAtomicFMinEXT => .Atomic,
            .OpAtomicFMaxEXT => .Atomic,
            .OpAssumeTrueKHR => .Miscellaneous,
            .OpExpectKHR => .Miscellaneous,
            .OpDecorateString => .Annotation,
            .OpMemberDecorateString => .Annotation,
            .OpLoopControlINTEL => .Reserved,
            .OpReadPipeBlockingINTEL => .Pipe,
            .OpWritePipeBlockingINTEL => .Pipe,
            .OpFPGARegINTEL => .Reserved,
            .OpRayQueryGetRayTMinKHR => .Reserved,
            .OpRayQueryGetRayFlagsKHR => .Reserved,
            .OpRayQueryGetIntersectionTKHR => .Reserved,
            .OpRayQueryGetIntersectionInstanceCustomIndexKHR => .Reserved,
            .OpRayQueryGetIntersectionInstanceIdKHR => .Reserved,
            .OpRayQueryGetIntersectionInstanceShaderBindingTableRecordOffsetKHR => .Reserved,
            .OpRayQueryGetIntersectionGeometryIndexKHR => .Reserved,
            .OpRayQueryGetIntersectionPrimitiveIndexKHR => .Reserved,
            .OpRayQueryGetIntersectionBarycentricsKHR => .Reserved,
            .OpRayQueryGetIntersectionFrontFaceKHR => .Reserved,
            .OpRayQueryGetIntersectionCandidateAABBOpaqueKHR => .Reserved,
            .OpRayQueryGetIntersectionObjectRayDirectionKHR => .Reserved,
            .OpRayQueryGetIntersectionObjectRayOriginKHR => .Reserved,
            .OpRayQueryGetWorldRayDirectionKHR => .Reserved,
            .OpRayQueryGetWorldRayOriginKHR => .Reserved,
            .OpRayQueryGetIntersectionObjectToWorldKHR => .Reserved,
            .OpRayQueryGetIntersectionWorldToObjectKHR => .Reserved,
            .OpAtomicFAddEXT => .Atomic,
            .OpTypeBufferSurfaceINTEL => .TypeDeclaration,
            .OpTypeStructContinuedINTEL => .TypeDeclaration,
            .OpConstantCompositeContinuedINTEL => .ConstantCreation,
            .OpSpecConstantCompositeContinuedINTEL => .ConstantCreation,
            .OpCompositeConstructContinuedINTEL => .Composite,
            .OpConvertFToBF16INTEL => .Conversion,
            .OpConvertBF16ToFINTEL => .Conversion,
            .OpControlBarrierArriveINTEL => .Barrier,
            .OpControlBarrierWaitINTEL => .Barrier,
            .OpGroupIMulKHR => .Group,
            .OpGroupFMulKHR => .Group,
            .OpGroupBitwiseAndKHR => .Group,
            .OpGroupBitwiseOrKHR => .Group,
            .OpGroupBitwiseXorKHR => .Group,
            .OpGroupLogicalAndKHR => .Group,
            .OpGroupLogicalOrKHR => .Group,
            .OpGroupLogicalXorKHR => .Group,
            .OpMaskedGatherINTEL => .Memory,
            .OpMaskedScatterINTEL => .Memory,
        };
    }
};
pub const ImageOperands = packed struct {
    Bias: bool = false,
    Lod: bool = false,
    Grad: bool = false,
    ConstOffset: bool = false,
    Offset: bool = false,
    ConstOffsets: bool = false,
    Sample: bool = false,
    MinLod: bool = false,
    MakeTexelAvailable: bool = false,
    MakeTexelVisible: bool = false,
    NonPrivateTexel: bool = false,
    VolatileTexel: bool = false,
    SignExtend: bool = false,
    ZeroExtend: bool = false,
    Nontemporal: bool = false,
    _reserved_bit_15: bool = false,
    Offsets: bool = false,
    _reserved_bit_17: bool = false,
    _reserved_bit_18: bool = false,
    _reserved_bit_19: bool = false,
    _reserved_bit_20: bool = false,
    _reserved_bit_21: bool = false,
    _reserved_bit_22: bool = false,
    _reserved_bit_23: bool = false,
    _reserved_bit_24: bool = false,
    _reserved_bit_25: bool = false,
    _reserved_bit_26: bool = false,
    _reserved_bit_27: bool = false,
    _reserved_bit_28: bool = false,
    _reserved_bit_29: bool = false,
    _reserved_bit_30: bool = false,
    _reserved_bit_31: bool = false,

    pub const MakeTexelAvailableKHR: ImageOperands = .{ .MakeTexelAvailable = true };
    pub const MakeTexelVisibleKHR: ImageOperands = .{ .MakeTexelVisible = true };
    pub const NonPrivateTexelKHR: ImageOperands = .{ .NonPrivateTexel = true };
    pub const VolatileTexelKHR: ImageOperands = .{ .VolatileTexel = true };

    pub const Extended = struct {
        Bias: ?struct { id_ref: IdRef } = null,
        Lod: ?struct { id_ref: IdRef } = null,
        Grad: ?struct { id_ref_0: IdRef, id_ref_1: IdRef } = null,
        ConstOffset: ?struct { id_ref: IdRef } = null,
        Offset: ?struct { id_ref: IdRef } = null,
        ConstOffsets: ?struct { id_ref: IdRef } = null,
        Sample: ?struct { id_ref: IdRef } = null,
        MinLod: ?struct { id_ref: IdRef } = null,
        MakeTexelAvailable: ?struct { id_scope: IdScope } = null,
        MakeTexelVisible: ?struct { id_scope: IdScope } = null,
        NonPrivateTexel: bool = false,
        VolatileTexel: bool = false,
        SignExtend: bool = false,
        ZeroExtend: bool = false,
        Nontemporal: bool = false,
        _reserved_bit_15: bool = false,
        Offsets: ?struct { id_ref: IdRef } = null,
        _reserved_bit_17: bool = false,
        _reserved_bit_18: bool = false,
        _reserved_bit_19: bool = false,
        _reserved_bit_20: bool = false,
        _reserved_bit_21: bool = false,
        _reserved_bit_22: bool = false,
        _reserved_bit_23: bool = false,
        _reserved_bit_24: bool = false,
        _reserved_bit_25: bool = false,
        _reserved_bit_26: bool = false,
        _reserved_bit_27: bool = false,
        _reserved_bit_28: bool = false,
        _reserved_bit_29: bool = false,
        _reserved_bit_30: bool = false,
        _reserved_bit_31: bool = false,
    };
};
pub const FPFastMathMode = packed struct {
    NotNaN: bool = false,
    NotInf: bool = false,
    NSZ: bool = false,
    AllowRecip: bool = false,
    Fast: bool = false,
    _reserved_bit_5: bool = false,
    _reserved_bit_6: bool = false,
    _reserved_bit_7: bool = false,
    _reserved_bit_8: bool = false,
    _reserved_bit_9: bool = false,
    _reserved_bit_10: bool = false,
    _reserved_bit_11: bool = false,
    _reserved_bit_12: bool = false,
    _reserved_bit_13: bool = false,
    _reserved_bit_14: bool = false,
    _reserved_bit_15: bool = false,
    AllowContract: bool = false,
    AllowReassoc: bool = false,
    AllowTransform: bool = false,
    _reserved_bit_19: bool = false,
    _reserved_bit_20: bool = false,
    _reserved_bit_21: bool = false,
    _reserved_bit_22: bool = false,
    _reserved_bit_23: bool = false,
    _reserved_bit_24: bool = false,
    _reserved_bit_25: bool = false,
    _reserved_bit_26: bool = false,
    _reserved_bit_27: bool = false,
    _reserved_bit_28: bool = false,
    _reserved_bit_29: bool = false,
    _reserved_bit_30: bool = false,
    _reserved_bit_31: bool = false,

    pub const AllowContractFastINTEL: FPFastMathMode = .{ .AllowContract = true };
    pub const AllowReassocINTEL: FPFastMathMode = .{ .AllowReassoc = true };
};
pub const SelectionControl = packed struct {
    Flatten: bool = false,
    DontFlatten: bool = false,
    _reserved_bit_2: bool = false,
    _reserved_bit_3: bool = false,
    _reserved_bit_4: bool = false,
    _reserved_bit_5: bool = false,
    _reserved_bit_6: bool = false,
    _reserved_bit_7: bool = false,
    _reserved_bit_8: bool = false,
    _reserved_bit_9: bool = false,
    _reserved_bit_10: bool = false,
    _reserved_bit_11: bool = false,
    _reserved_bit_12: bool = false,
    _reserved_bit_13: bool = false,
    _reserved_bit_14: bool = false,
    _reserved_bit_15: bool = false,
    _reserved_bit_16: bool = false,
    _reserved_bit_17: bool = false,
    _reserved_bit_18: bool = false,
    _reserved_bit_19: bool = false,
    _reserved_bit_20: bool = false,
    _reserved_bit_21: bool = false,
    _reserved_bit_22: bool = false,
    _reserved_bit_23: bool = false,
    _reserved_bit_24: bool = false,
    _reserved_bit_25: bool = false,
    _reserved_bit_26: bool = false,
    _reserved_bit_27: bool = false,
    _reserved_bit_28: bool = false,
    _reserved_bit_29: bool = false,
    _reserved_bit_30: bool = false,
    _reserved_bit_31: bool = false,
};
pub const LoopControl = packed struct {
    Unroll: bool = false,
    DontUnroll: bool = false,
    DependencyInfinite: bool = false,
    DependencyLength: bool = false,
    MinIterations: bool = false,
    MaxIterations: bool = false,
    IterationMultiple: bool = false,
    PeelCount: bool = false,
    PartialCount: bool = false,
    _reserved_bit_9: bool = false,
    _reserved_bit_10: bool = false,
    _reserved_bit_11: bool = false,
    _reserved_bit_12: bool = false,
    _reserved_bit_13: bool = false,
    _reserved_bit_14: bool = false,
    _reserved_bit_15: bool = false,
    InitiationIntervalINTEL: bool = false,
    MaxConcurrencyINTEL: bool = false,
    DependencyArrayINTEL: bool = false,
    PipelineEnableINTEL: bool = false,
    LoopCoalesceINTEL: bool = false,
    MaxInterleavingINTEL: bool = false,
    SpeculatedIterationsINTEL: bool = false,
    NoFusionINTEL: bool = false,
    LoopCountINTEL: bool = false,
    MaxReinvocationDelayINTEL: bool = false,
    _reserved_bit_26: bool = false,
    _reserved_bit_27: bool = false,
    _reserved_bit_28: bool = false,
    _reserved_bit_29: bool = false,
    _reserved_bit_30: bool = false,
    _reserved_bit_31: bool = false,

    pub const Extended = struct {
        Unroll: bool = false,
        DontUnroll: bool = false,
        DependencyInfinite: bool = false,
        DependencyLength: ?struct { literal_integer: LiteralInteger } = null,
        MinIterations: ?struct { literal_integer: LiteralInteger } = null,
        MaxIterations: ?struct { literal_integer: LiteralInteger } = null,
        IterationMultiple: ?struct { literal_integer: LiteralInteger } = null,
        PeelCount: ?struct { literal_integer: LiteralInteger } = null,
        PartialCount: ?struct { literal_integer: LiteralInteger } = null,
        _reserved_bit_9: bool = false,
        _reserved_bit_10: bool = false,
        _reserved_bit_11: bool = false,
        _reserved_bit_12: bool = false,
        _reserved_bit_13: bool = false,
        _reserved_bit_14: bool = false,
        _reserved_bit_15: bool = false,
        InitiationIntervalINTEL: ?struct { literal_integer: LiteralInteger } = null,
        MaxConcurrencyINTEL: ?struct { literal_integer: LiteralInteger } = null,
        DependencyArrayINTEL: ?struct { literal_integer: LiteralInteger } = null,
        PipelineEnableINTEL: ?struct { literal_integer: LiteralInteger } = null,
        LoopCoalesceINTEL: ?struct { literal_integer: LiteralInteger } = null,
        MaxInterleavingINTEL: ?struct { literal_integer: LiteralInteger } = null,
        SpeculatedIterationsINTEL: ?struct { literal_integer: LiteralInteger } = null,
        NoFusionINTEL: bool = false,
        LoopCountINTEL: ?struct { literal_integer: LiteralInteger } = null,
        MaxReinvocationDelayINTEL: ?struct { literal_integer: LiteralInteger } = null,
        _reserved_bit_26: bool = false,
        _reserved_bit_27: bool = false,
        _reserved_bit_28: bool = false,
        _reserved_bit_29: bool = false,
        _reserved_bit_30: bool = false,
        _reserved_bit_31: bool = false,
    };
};
pub const FunctionControl = packed struct {
    Inline: bool = false,
    DontInline: bool = false,
    Pure: bool = false,
    Const: bool = false,
    _reserved_bit_4: bool = false,
    _reserved_bit_5: bool = false,
    _reserved_bit_6: bool = false,
    _reserved_bit_7: bool = false,
    _reserved_bit_8: bool = false,
    _reserved_bit_9: bool = false,
    _reserved_bit_10: bool = false,
    _reserved_bit_11: bool = false,
    _reserved_bit_12: bool = false,
    _reserved_bit_13: bool = false,
    _reserved_bit_14: bool = false,
    _reserved_bit_15: bool = false,
    OptNoneINTEL: bool = false,
    _reserved_bit_17: bool = false,
    _reserved_bit_18: bool = false,
    _reserved_bit_19: bool = false,
    _reserved_bit_20: bool = false,
    _reserved_bit_21: bool = false,
    _reserved_bit_22: bool = false,
    _reserved_bit_23: bool = false,
    _reserved_bit_24: bool = false,
    _reserved_bit_25: bool = false,
    _reserved_bit_26: bool = false,
    _reserved_bit_27: bool = false,
    _reserved_bit_28: bool = false,
    _reserved_bit_29: bool = false,
    _reserved_bit_30: bool = false,
    _reserved_bit_31: bool = false,
};
pub const MemorySemantics = packed struct {
    _reserved_bit_0: bool = false,
    Acquire: bool = false,
    Release: bool = false,
    AcquireRelease: bool = false,
    SequentiallyConsistent: bool = false,
    _reserved_bit_5: bool = false,
    UniformMemory: bool = false,
    SubgroupMemory: bool = false,
    WorkgroupMemory: bool = false,
    CrossWorkgroupMemory: bool = false,
    AtomicCounterMemory: bool = false,
    ImageMemory: bool = false,
    OutputMemory: bool = false,
    MakeAvailable: bool = false,
    MakeVisible: bool = false,
    Volatile: bool = false,
    _reserved_bit_16: bool = false,
    _reserved_bit_17: bool = false,
    _reserved_bit_18: bool = false,
    _reserved_bit_19: bool = false,
    _reserved_bit_20: bool = false,
    _reserved_bit_21: bool = false,
    _reserved_bit_22: bool = false,
    _reserved_bit_23: bool = false,
    _reserved_bit_24: bool = false,
    _reserved_bit_25: bool = false,
    _reserved_bit_26: bool = false,
    _reserved_bit_27: bool = false,
    _reserved_bit_28: bool = false,
    _reserved_bit_29: bool = false,
    _reserved_bit_30: bool = false,
    _reserved_bit_31: bool = false,

    pub const OutputMemoryKHR: MemorySemantics = .{ .OutputMemory = true };
    pub const MakeAvailableKHR: MemorySemantics = .{ .MakeAvailable = true };
    pub const MakeVisibleKHR: MemorySemantics = .{ .MakeVisible = true };
};
pub const MemoryAccess = packed struct {
    Volatile: bool = false,
    Aligned: bool = false,
    Nontemporal: bool = false,
    MakePointerAvailable: bool = false,
    MakePointerVisible: bool = false,
    NonPrivatePointer: bool = false,
    _reserved_bit_6: bool = false,
    _reserved_bit_7: bool = false,
    _reserved_bit_8: bool = false,
    _reserved_bit_9: bool = false,
    _reserved_bit_10: bool = false,
    _reserved_bit_11: bool = false,
    _reserved_bit_12: bool = false,
    _reserved_bit_13: bool = false,
    _reserved_bit_14: bool = false,
    _reserved_bit_15: bool = false,
    AliasScopeINTELMask: bool = false,
    NoAliasINTELMask: bool = false,
    _reserved_bit_18: bool = false,
    _reserved_bit_19: bool = false,
    _reserved_bit_20: bool = false,
    _reserved_bit_21: bool = false,
    _reserved_bit_22: bool = false,
    _reserved_bit_23: bool = false,
    _reserved_bit_24: bool = false,
    _reserved_bit_25: bool = false,
    _reserved_bit_26: bool = false,
    _reserved_bit_27: bool = false,
    _reserved_bit_28: bool = false,
    _reserved_bit_29: bool = false,
    _reserved_bit_30: bool = false,
    _reserved_bit_31: bool = false,

    pub const MakePointerAvailableKHR: MemoryAccess = .{ .MakePointerAvailable = true };
    pub const MakePointerVisibleKHR: MemoryAccess = .{ .MakePointerVisible = true };
    pub const NonPrivatePointerKHR: MemoryAccess = .{ .NonPrivatePointer = true };

    pub const Extended = struct {
        Volatile: bool = false,
        Aligned: ?struct { literal_integer: LiteralInteger } = null,
        Nontemporal: bool = false,
        MakePointerAvailable: ?struct { id_scope: IdScope } = null,
        MakePointerVisible: ?struct { id_scope: IdScope } = null,
        NonPrivatePointer: bool = false,
        _reserved_bit_6: bool = false,
        _reserved_bit_7: bool = false,
        _reserved_bit_8: bool = false,
        _reserved_bit_9: bool = false,
        _reserved_bit_10: bool = false,
        _reserved_bit_11: bool = false,
        _reserved_bit_12: bool = false,
        _reserved_bit_13: bool = false,
        _reserved_bit_14: bool = false,
        _reserved_bit_15: bool = false,
        AliasScopeINTELMask: ?struct { id_ref: IdRef } = null,
        NoAliasINTELMask: ?struct { id_ref: IdRef } = null,
        _reserved_bit_18: bool = false,
        _reserved_bit_19: bool = false,
        _reserved_bit_20: bool = false,
        _reserved_bit_21: bool = false,
        _reserved_bit_22: bool = false,
        _reserved_bit_23: bool = false,
        _reserved_bit_24: bool = false,
        _reserved_bit_25: bool = false,
        _reserved_bit_26: bool = false,
        _reserved_bit_27: bool = false,
        _reserved_bit_28: bool = false,
        _reserved_bit_29: bool = false,
        _reserved_bit_30: bool = false,
        _reserved_bit_31: bool = false,
    };
};
pub const KernelProfilingInfo = packed struct {
    CmdExecTime: bool = false,
    _reserved_bit_1: bool = false,
    _reserved_bit_2: bool = false,
    _reserved_bit_3: bool = false,
    _reserved_bit_4: bool = false,
    _reserved_bit_5: bool = false,
    _reserved_bit_6: bool = false,
    _reserved_bit_7: bool = false,
    _reserved_bit_8: bool = false,
    _reserved_bit_9: bool = false,
    _reserved_bit_10: bool = false,
    _reserved_bit_11: bool = false,
    _reserved_bit_12: bool = false,
    _reserved_bit_13: bool = false,
    _reserved_bit_14: bool = false,
    _reserved_bit_15: bool = false,
    _reserved_bit_16: bool = false,
    _reserved_bit_17: bool = false,
    _reserved_bit_18: bool = false,
    _reserved_bit_19: bool = false,
    _reserved_bit_20: bool = false,
    _reserved_bit_21: bool = false,
    _reserved_bit_22: bool = false,
    _reserved_bit_23: bool = false,
    _reserved_bit_24: bool = false,
    _reserved_bit_25: bool = false,
    _reserved_bit_26: bool = false,
    _reserved_bit_27: bool = false,
    _reserved_bit_28: bool = false,
    _reserved_bit_29: bool = false,
    _reserved_bit_30: bool = false,
    _reserved_bit_31: bool = false,
};
pub const RayFlags = packed struct {
    OpaqueKHR: bool = false,
    NoOpaqueKHR: bool = false,
    TerminateOnFirstHitKHR: bool = false,
    SkipClosestHitShaderKHR: bool = false,
    CullBackFacingTrianglesKHR: bool = false,
    CullFrontFacingTrianglesKHR: bool = false,
    CullOpaqueKHR: bool = false,
    CullNoOpaqueKHR: bool = false,
    SkipTrianglesKHR: bool = false,
    SkipAABBsKHR: bool = false,
    ForceOpacityMicromap2StateEXT: bool = false,
    _reserved_bit_11: bool = false,
    _reserved_bit_12: bool = false,
    _reserved_bit_13: bool = false,
    _reserved_bit_14: bool = false,
    _reserved_bit_15: bool = false,
    _reserved_bit_16: bool = false,
    _reserved_bit_17: bool = false,
    _reserved_bit_18: bool = false,
    _reserved_bit_19: bool = false,
    _reserved_bit_20: bool = false,
    _reserved_bit_21: bool = false,
    _reserved_bit_22: bool = false,
    _reserved_bit_23: bool = false,
    _reserved_bit_24: bool = false,
    _reserved_bit_25: bool = false,
    _reserved_bit_26: bool = false,
    _reserved_bit_27: bool = false,
    _reserved_bit_28: bool = false,
    _reserved_bit_29: bool = false,
    _reserved_bit_30: bool = false,
    _reserved_bit_31: bool = false,
};
pub const FragmentShadingRate = packed struct {
    Vertical2Pixels: bool = false,
    Vertical4Pixels: bool = false,
    Horizontal2Pixels: bool = false,
    Horizontal4Pixels: bool = false,
    _reserved_bit_4: bool = false,
    _reserved_bit_5: bool = false,
    _reserved_bit_6: bool = false,
    _reserved_bit_7: bool = false,
    _reserved_bit_8: bool = false,
    _reserved_bit_9: bool = false,
    _reserved_bit_10: bool = false,
    _reserved_bit_11: bool = false,
    _reserved_bit_12: bool = false,
    _reserved_bit_13: bool = false,
    _reserved_bit_14: bool = false,
    _reserved_bit_15: bool = false,
    _reserved_bit_16: bool = false,
    _reserved_bit_17: bool = false,
    _reserved_bit_18: bool = false,
    _reserved_bit_19: bool = false,
    _reserved_bit_20: bool = false,
    _reserved_bit_21: bool = false,
    _reserved_bit_22: bool = false,
    _reserved_bit_23: bool = false,
    _reserved_bit_24: bool = false,
    _reserved_bit_25: bool = false,
    _reserved_bit_26: bool = false,
    _reserved_bit_27: bool = false,
    _reserved_bit_28: bool = false,
    _reserved_bit_29: bool = false,
    _reserved_bit_30: bool = false,
    _reserved_bit_31: bool = false,
};
pub const RawAccessChainOperands = packed struct {
    RobustnessPerComponentNV: bool = false,
    RobustnessPerElementNV: bool = false,
    _reserved_bit_2: bool = false,
    _reserved_bit_3: bool = false,
    _reserved_bit_4: bool = false,
    _reserved_bit_5: bool = false,
    _reserved_bit_6: bool = false,
    _reserved_bit_7: bool = false,
    _reserved_bit_8: bool = false,
    _reserved_bit_9: bool = false,
    _reserved_bit_10: bool = false,
    _reserved_bit_11: bool = false,
    _reserved_bit_12: bool = false,
    _reserved_bit_13: bool = false,
    _reserved_bit_14: bool = false,
    _reserved_bit_15: bool = false,
    _reserved_bit_16: bool = false,
    _reserved_bit_17: bool = false,
    _reserved_bit_18: bool = false,
    _reserved_bit_19: bool = false,
    _reserved_bit_20: bool = false,
    _reserved_bit_21: bool = false,
    _reserved_bit_22: bool = false,
    _reserved_bit_23: bool = false,
    _reserved_bit_24: bool = false,
    _reserved_bit_25: bool = false,
    _reserved_bit_26: bool = false,
    _reserved_bit_27: bool = false,
    _reserved_bit_28: bool = false,
    _reserved_bit_29: bool = false,
    _reserved_bit_30: bool = false,
    _reserved_bit_31: bool = false,
};
pub const SourceLanguage = enum(u32) {
    Unknown = 0,
    ESSL = 1,
    GLSL = 2,
    OpenCL_C = 3,
    OpenCL_CPP = 4,
    HLSL = 5,
    CPP_for_OpenCL = 6,
    SYCL = 7,
    HERO_C = 8,
    NZSL = 9,
    WGSL = 10,
    Slang = 11,
    Zig = 12,
};
pub const ExecutionModel = enum(u32) {
    Vertex = 0,
    TessellationControl = 1,
    TessellationEvaluation = 2,
    Geometry = 3,
    Fragment = 4,
    GLCompute = 5,
    Kernel = 6,
    TaskNV = 5267,
    MeshNV = 5268,
    RayGenerationKHR = 5313,
    IntersectionKHR = 5314,
    AnyHitKHR = 5315,
    ClosestHitKHR = 5316,
    MissKHR = 5317,
    CallableKHR = 5318,
    TaskEXT = 5364,
    MeshEXT = 5365,

    pub const RayGenerationNV = ExecutionModel.RayGenerationKHR;
    pub const IntersectionNV = ExecutionModel.IntersectionKHR;
    pub const AnyHitNV = ExecutionModel.AnyHitKHR;
    pub const ClosestHitNV = ExecutionModel.ClosestHitKHR;
    pub const MissNV = ExecutionModel.MissKHR;
    pub const CallableNV = ExecutionModel.CallableKHR;
};
pub const AddressingModel = enum(u32) {
    Logical = 0,
    Physical32 = 1,
    Physical64 = 2,
    PhysicalStorageBuffer64 = 5348,

    pub const PhysicalStorageBuffer64EXT = AddressingModel.PhysicalStorageBuffer64;
};
pub const MemoryModel = enum(u32) {
    Simple = 0,
    GLSL450 = 1,
    OpenCL = 2,
    Vulkan = 3,

    pub const VulkanKHR = MemoryModel.Vulkan;
};
pub const ExecutionMode = enum(u32) {
    Invocations = 0,
    SpacingEqual = 1,
    SpacingFractionalEven = 2,
    SpacingFractionalOdd = 3,
    VertexOrderCw = 4,
    VertexOrderCcw = 5,
    PixelCenterInteger = 6,
    OriginUpperLeft = 7,
    OriginLowerLeft = 8,
    EarlyFragmentTests = 9,
    PointMode = 10,
    Xfb = 11,
    DepthReplacing = 12,
    DepthGreater = 14,
    DepthLess = 15,
    DepthUnchanged = 16,
    LocalSize = 17,
    LocalSizeHint = 18,
    InputPoints = 19,
    InputLines = 20,
    InputLinesAdjacency = 21,
    Triangles = 22,
    InputTrianglesAdjacency = 23,
    Quads = 24,
    Isolines = 25,
    OutputVertices = 26,
    OutputPoints = 27,
    OutputLineStrip = 28,
    OutputTriangleStrip = 29,
    VecTypeHint = 30,
    ContractionOff = 31,
    Initializer = 33,
    Finalizer = 34,
    SubgroupSize = 35,
    SubgroupsPerWorkgroup = 36,
    SubgroupsPerWorkgroupId = 37,
    LocalSizeId = 38,
    LocalSizeHintId = 39,
    NonCoherentColorAttachmentReadEXT = 4169,
    NonCoherentDepthAttachmentReadEXT = 4170,
    NonCoherentStencilAttachmentReadEXT = 4171,
    SubgroupUniformControlFlowKHR = 4421,
    PostDepthCoverage = 4446,
    DenormPreserve = 4459,
    DenormFlushToZero = 4460,
    SignedZeroInfNanPreserve = 4461,
    RoundingModeRTE = 4462,
    RoundingModeRTZ = 4463,
    EarlyAndLateFragmentTestsAMD = 5017,
    StencilRefReplacingEXT = 5027,
    CoalescingAMDX = 5069,
    MaxNodeRecursionAMDX = 5071,
    StaticNumWorkgroupsAMDX = 5072,
    ShaderIndexAMDX = 5073,
    MaxNumWorkgroupsAMDX = 5077,
    StencilRefUnchangedFrontAMD = 5079,
    StencilRefGreaterFrontAMD = 5080,
    StencilRefLessFrontAMD = 5081,
    StencilRefUnchangedBackAMD = 5082,
    StencilRefGreaterBackAMD = 5083,
    StencilRefLessBackAMD = 5084,
    QuadDerivativesKHR = 5088,
    RequireFullQuadsKHR = 5089,
    OutputLinesEXT = 5269,
    OutputPrimitivesEXT = 5270,
    DerivativeGroupQuadsNV = 5289,
    DerivativeGroupLinearNV = 5290,
    OutputTrianglesEXT = 5298,
    PixelInterlockOrderedEXT = 5366,
    PixelInterlockUnorderedEXT = 5367,
    SampleInterlockOrderedEXT = 5368,
    SampleInterlockUnorderedEXT = 5369,
    ShadingRateInterlockOrderedEXT = 5370,
    ShadingRateInterlockUnorderedEXT = 5371,
    SharedLocalMemorySizeINTEL = 5618,
    RoundingModeRTPINTEL = 5620,
    RoundingModeRTNINTEL = 5621,
    FloatingPointModeALTINTEL = 5622,
    FloatingPointModeIEEEINTEL = 5623,
    MaxWorkgroupSizeINTEL = 5893,
    MaxWorkDimINTEL = 5894,
    NoGlobalOffsetINTEL = 5895,
    NumSIMDWorkitemsINTEL = 5896,
    SchedulerTargetFmaxMhzINTEL = 5903,
    MaximallyReconvergesKHR = 6023,
    FPFastMathDefault = 6028,
    StreamingInterfaceINTEL = 6154,
    RegisterMapInterfaceINTEL = 6160,
    NamedBarrierCountINTEL = 6417,
    MaximumRegistersINTEL = 6461,
    MaximumRegistersIdINTEL = 6462,
    NamedMaximumRegistersINTEL = 6463,

    pub const OutputLinesNV = ExecutionMode.OutputLinesEXT;
    pub const OutputPrimitivesNV = ExecutionMode.OutputPrimitivesEXT;
    pub const OutputTrianglesNV = ExecutionMode.OutputTrianglesEXT;

    pub const Extended = union(ExecutionMode) {
        Invocations: struct { literal_integer: LiteralInteger },
        SpacingEqual,
        SpacingFractionalEven,
        SpacingFractionalOdd,
        VertexOrderCw,
        VertexOrderCcw,
        PixelCenterInteger,
        OriginUpperLeft,
        OriginLowerLeft,
        EarlyFragmentTests,
        PointMode,
        Xfb,
        DepthReplacing,
        DepthGreater,
        DepthLess,
        DepthUnchanged,
        LocalSize: struct { x_size: LiteralInteger, y_size: LiteralInteger, z_size: LiteralInteger },
        LocalSizeHint: struct { x_size: LiteralInteger, y_size: LiteralInteger, z_size: LiteralInteger },
        InputPoints,
        InputLines,
        InputLinesAdjacency,
        Triangles,
        InputTrianglesAdjacency,
        Quads,
        Isolines,
        OutputVertices: struct { vertex_count: LiteralInteger },
        OutputPoints,
        OutputLineStrip,
        OutputTriangleStrip,
        VecTypeHint: struct { vector_type: LiteralInteger },
        ContractionOff,
        Initializer,
        Finalizer,
        SubgroupSize: struct { subgroup_size: LiteralInteger },
        SubgroupsPerWorkgroup: struct { subgroups_per_workgroup: LiteralInteger },
        SubgroupsPerWorkgroupId: struct { subgroups_per_workgroup: IdRef },
        LocalSizeId: struct { x_size: IdRef, y_size: IdRef, z_size: IdRef },
        LocalSizeHintId: struct { x_size_hint: IdRef, y_size_hint: IdRef, z_size_hint: IdRef },
        NonCoherentColorAttachmentReadEXT,
        NonCoherentDepthAttachmentReadEXT,
        NonCoherentStencilAttachmentReadEXT,
        SubgroupUniformControlFlowKHR,
        PostDepthCoverage,
        DenormPreserve: struct { target_width: LiteralInteger },
        DenormFlushToZero: struct { target_width: LiteralInteger },
        SignedZeroInfNanPreserve: struct { target_width: LiteralInteger },
        RoundingModeRTE: struct { target_width: LiteralInteger },
        RoundingModeRTZ: struct { target_width: LiteralInteger },
        EarlyAndLateFragmentTestsAMD,
        StencilRefReplacingEXT,
        CoalescingAMDX,
        MaxNodeRecursionAMDX: struct { number_of_recursions: IdRef },
        StaticNumWorkgroupsAMDX: struct { x_size: IdRef, y_size: IdRef, z_size: IdRef },
        ShaderIndexAMDX: struct { shader_index: IdRef },
        MaxNumWorkgroupsAMDX: struct { x_size: IdRef, y_size: IdRef, z_size: IdRef },
        StencilRefUnchangedFrontAMD,
        StencilRefGreaterFrontAMD,
        StencilRefLessFrontAMD,
        StencilRefUnchangedBackAMD,
        StencilRefGreaterBackAMD,
        StencilRefLessBackAMD,
        QuadDerivativesKHR,
        RequireFullQuadsKHR,
        OutputLinesEXT,
        OutputPrimitivesEXT: struct { primitive_count: LiteralInteger },
        DerivativeGroupQuadsNV,
        DerivativeGroupLinearNV,
        OutputTrianglesEXT,
        PixelInterlockOrderedEXT,
        PixelInterlockUnorderedEXT,
        SampleInterlockOrderedEXT,
        SampleInterlockUnorderedEXT,
        ShadingRateInterlockOrderedEXT,
        ShadingRateInterlockUnorderedEXT,
        SharedLocalMemorySizeINTEL: struct { size: LiteralInteger },
        RoundingModeRTPINTEL: struct { target_width: LiteralInteger },
        RoundingModeRTNINTEL: struct { target_width: LiteralInteger },
        FloatingPointModeALTINTEL: struct { target_width: LiteralInteger },
        FloatingPointModeIEEEINTEL: struct { target_width: LiteralInteger },
        MaxWorkgroupSizeINTEL: struct { literal_integer_0: LiteralInteger, literal_integer_1: LiteralInteger, literal_integer_2: LiteralInteger },
        MaxWorkDimINTEL: struct { literal_integer: LiteralInteger },
        NoGlobalOffsetINTEL,
        NumSIMDWorkitemsINTEL: struct { literal_integer: LiteralInteger },
        SchedulerTargetFmaxMhzINTEL: struct { literal_integer: LiteralInteger },
        MaximallyReconvergesKHR,
        FPFastMathDefault: struct { target_type: IdRef, id_ref_1: IdRef },
        StreamingInterfaceINTEL: struct { stallfreereturn: LiteralInteger },
        RegisterMapInterfaceINTEL: struct { waitfordonewrite: LiteralInteger },
        NamedBarrierCountINTEL: struct { barrier_count: LiteralInteger },
        MaximumRegistersINTEL: struct { number_of_registers: LiteralInteger },
        MaximumRegistersIdINTEL: struct { number_of_registers: IdRef },
        NamedMaximumRegistersINTEL: struct { named_maximum_number_of_registers: NamedMaximumNumberOfRegisters },
    };
};
pub const StorageClass = enum(u32) {
    UniformConstant = 0,
    Input = 1,
    Uniform = 2,
    Output = 3,
    Workgroup = 4,
    CrossWorkgroup = 5,
    Private = 6,
    Function = 7,
    Generic = 8,
    PushConstant = 9,
    AtomicCounter = 10,
    Image = 11,
    StorageBuffer = 12,
    TileImageEXT = 4172,
    NodePayloadAMDX = 5068,
    NodeOutputPayloadAMDX = 5076,
    CallableDataKHR = 5328,
    IncomingCallableDataKHR = 5329,
    RayPayloadKHR = 5338,
    HitAttributeKHR = 5339,
    IncomingRayPayloadKHR = 5342,
    ShaderRecordBufferKHR = 5343,
    PhysicalStorageBuffer = 5349,
    HitObjectAttributeNV = 5385,
    TaskPayloadWorkgroupEXT = 5402,
    CodeSectionINTEL = 5605,
    DeviceOnlyINTEL = 5936,
    HostOnlyINTEL = 5937,

    pub const CallableDataNV = StorageClass.CallableDataKHR;
    pub const IncomingCallableDataNV = StorageClass.IncomingCallableDataKHR;
    pub const RayPayloadNV = StorageClass.RayPayloadKHR;
    pub const HitAttributeNV = StorageClass.HitAttributeKHR;
    pub const IncomingRayPayloadNV = StorageClass.IncomingRayPayloadKHR;
    pub const ShaderRecordBufferNV = StorageClass.ShaderRecordBufferKHR;
    pub const PhysicalStorageBufferEXT = StorageClass.PhysicalStorageBuffer;
};
pub const Dim = enum(u32) {
    @"1D" = 0,
    @"2D" = 1,
    @"3D" = 2,
    Cube = 3,
    Rect = 4,
    Buffer = 5,
    SubpassData = 6,
    TileImageDataEXT = 4173,
};
pub const SamplerAddressingMode = enum(u32) {
    None = 0,
    ClampToEdge = 1,
    Clamp = 2,
    Repeat = 3,
    RepeatMirrored = 4,
};
pub const SamplerFilterMode = enum(u32) {
    Nearest = 0,
    Linear = 1,
};
pub const ImageFormat = enum(u32) {
    Unknown = 0,
    Rgba32f = 1,
    Rgba16f = 2,
    R32f = 3,
    Rgba8 = 4,
    Rgba8Snorm = 5,
    Rg32f = 6,
    Rg16f = 7,
    R11fG11fB10f = 8,
    R16f = 9,
    Rgba16 = 10,
    Rgb10A2 = 11,
    Rg16 = 12,
    Rg8 = 13,
    R16 = 14,
    R8 = 15,
    Rgba16Snorm = 16,
    Rg16Snorm = 17,
    Rg8Snorm = 18,
    R16Snorm = 19,
    R8Snorm = 20,
    Rgba32i = 21,
    Rgba16i = 22,
    Rgba8i = 23,
    R32i = 24,
    Rg32i = 25,
    Rg16i = 26,
    Rg8i = 27,
    R16i = 28,
    R8i = 29,
    Rgba32ui = 30,
    Rgba16ui = 31,
    Rgba8ui = 32,
    R32ui = 33,
    Rgb10a2ui = 34,
    Rg32ui = 35,
    Rg16ui = 36,
    Rg8ui = 37,
    R16ui = 38,
    R8ui = 39,
    R64ui = 40,
    R64i = 41,
};
pub const ImageChannelOrder = enum(u32) {
    R = 0,
    A = 1,
    RG = 2,
    RA = 3,
    RGB = 4,
    RGBA = 5,
    BGRA = 6,
    ARGB = 7,
    Intensity = 8,
    Luminance = 9,
    Rx = 10,
    RGx = 11,
    RGBx = 12,
    Depth = 13,
    DepthStencil = 14,
    sRGB = 15,
    sRGBx = 16,
    sRGBA = 17,
    sBGRA = 18,
    ABGR = 19,
};
pub const ImageChannelDataType = enum(u32) {
    SnormInt8 = 0,
    SnormInt16 = 1,
    UnormInt8 = 2,
    UnormInt16 = 3,
    UnormShort565 = 4,
    UnormShort555 = 5,
    UnormInt101010 = 6,
    SignedInt8 = 7,
    SignedInt16 = 8,
    SignedInt32 = 9,
    UnsignedInt8 = 10,
    UnsignedInt16 = 11,
    UnsignedInt32 = 12,
    HalfFloat = 13,
    Float = 14,
    UnormInt24 = 15,
    UnormInt101010_2 = 16,
    UnsignedIntRaw10EXT = 19,
    UnsignedIntRaw12EXT = 20,
};
pub const FPRoundingMode = enum(u32) {
    RTE = 0,
    RTZ = 1,
    RTP = 2,
    RTN = 3,
};
pub const FPDenormMode = enum(u32) {
    Preserve = 0,
    FlushToZero = 1,
};
pub const QuantizationModes = enum(u32) {
    TRN = 0,
    TRN_ZERO = 1,
    RND = 2,
    RND_ZERO = 3,
    RND_INF = 4,
    RND_MIN_INF = 5,
    RND_CONV = 6,
    RND_CONV_ODD = 7,
};
pub const FPOperationMode = enum(u32) {
    IEEE = 0,
    ALT = 1,
};
pub const OverflowModes = enum(u32) {
    WRAP = 0,
    SAT = 1,
    SAT_ZERO = 2,
    SAT_SYM = 3,
};
pub const LinkageType = enum(u32) {
    Export = 0,
    Import = 1,
    LinkOnceODR = 2,
};
pub const AccessQualifier = enum(u32) {
    ReadOnly = 0,
    WriteOnly = 1,
    ReadWrite = 2,
};
pub const HostAccessQualifier = enum(u32) {
    NoneINTEL = 0,
    ReadINTEL = 1,
    WriteINTEL = 2,
    ReadWriteINTEL = 3,
};
pub const FunctionParameterAttribute = enum(u32) {
    Zext = 0,
    Sext = 1,
    ByVal = 2,
    Sret = 3,
    NoAlias = 4,
    NoCapture = 5,
    NoWrite = 6,
    NoReadWrite = 7,
    RuntimeAlignedINTEL = 5940,
};
pub const Decoration = enum(u32) {
    RelaxedPrecision = 0,
    SpecId = 1,
    Block = 2,
    BufferBlock = 3,
    RowMajor = 4,
    ColMajor = 5,
    ArrayStride = 6,
    MatrixStride = 7,
    GLSLShared = 8,
    GLSLPacked = 9,
    CPacked = 10,
    BuiltIn = 11,
    NoPerspective = 13,
    Flat = 14,
    Patch = 15,
    Centroid = 16,
    Sample = 17,
    Invariant = 18,
    Restrict = 19,
    Aliased = 20,
    Volatile = 21,
    Constant = 22,
    Coherent = 23,
    NonWritable = 24,
    NonReadable = 25,
    Uniform = 26,
    UniformId = 27,
    SaturatedConversion = 28,
    Stream = 29,
    Location = 30,
    Component = 31,
    Index = 32,
    Binding = 33,
    DescriptorSet = 34,
    Offset = 35,
    XfbBuffer = 36,
    XfbStride = 37,
    FuncParamAttr = 38,
    FPRoundingMode = 39,
    FPFastMathMode = 40,
    LinkageAttributes = 41,
    NoContraction = 42,
    InputAttachmentIndex = 43,
    Alignment = 44,
    MaxByteOffset = 45,
    AlignmentId = 46,
    MaxByteOffsetId = 47,
    NoSignedWrap = 4469,
    NoUnsignedWrap = 4470,
    WeightTextureQCOM = 4487,
    BlockMatchTextureQCOM = 4488,
    BlockMatchSamplerQCOM = 4499,
    ExplicitInterpAMD = 4999,
    NodeSharesPayloadLimitsWithAMDX = 5019,
    NodeMaxPayloadsAMDX = 5020,
    TrackFinishWritingAMDX = 5078,
    PayloadNodeNameAMDX = 5091,
    OverrideCoverageNV = 5248,
    PassthroughNV = 5250,
    ViewportRelativeNV = 5252,
    SecondaryViewportRelativeNV = 5256,
    PerPrimitiveEXT = 5271,
    PerViewNV = 5272,
    PerTaskNV = 5273,
    PerVertexKHR = 5285,
    NonUniform = 5300,
    RestrictPointer = 5355,
    AliasedPointer = 5356,
    HitObjectShaderRecordBufferNV = 5386,
    BindlessSamplerNV = 5398,
    BindlessImageNV = 5399,
    BoundSamplerNV = 5400,
    BoundImageNV = 5401,
    SIMTCallINTEL = 5599,
    ReferencedIndirectlyINTEL = 5602,
    ClobberINTEL = 5607,
    SideEffectsINTEL = 5608,
    VectorComputeVariableINTEL = 5624,
    FuncParamIOKindINTEL = 5625,
    VectorComputeFunctionINTEL = 5626,
    StackCallINTEL = 5627,
    GlobalVariableOffsetINTEL = 5628,
    CounterBuffer = 5634,
    UserSemantic = 5635,
    UserTypeGOOGLE = 5636,
    FunctionRoundingModeINTEL = 5822,
    FunctionDenormModeINTEL = 5823,
    RegisterINTEL = 5825,
    MemoryINTEL = 5826,
    NumbanksINTEL = 5827,
    BankwidthINTEL = 5828,
    MaxPrivateCopiesINTEL = 5829,
    SinglepumpINTEL = 5830,
    DoublepumpINTEL = 5831,
    MaxReplicatesINTEL = 5832,
    SimpleDualPortINTEL = 5833,
    MergeINTEL = 5834,
    BankBitsINTEL = 5835,
    ForcePow2DepthINTEL = 5836,
    StridesizeINTEL = 5883,
    WordsizeINTEL = 5884,
    TrueDualPortINTEL = 5885,
    BurstCoalesceINTEL = 5899,
    CacheSizeINTEL = 5900,
    DontStaticallyCoalesceINTEL = 5901,
    PrefetchINTEL = 5902,
    StallEnableINTEL = 5905,
    FuseLoopsInFunctionINTEL = 5907,
    MathOpDSPModeINTEL = 5909,
    AliasScopeINTEL = 5914,
    NoAliasINTEL = 5915,
    InitiationIntervalINTEL = 5917,
    MaxConcurrencyINTEL = 5918,
    PipelineEnableINTEL = 5919,
    BufferLocationINTEL = 5921,
    IOPipeStorageINTEL = 5944,
    FunctionFloatingPointModeINTEL = 6080,
    SingleElementVectorINTEL = 6085,
    VectorComputeCallableFunctionINTEL = 6087,
    MediaBlockIOINTEL = 6140,
    StallFreeINTEL = 6151,
    FPMaxErrorDecorationINTEL = 6170,
    LatencyControlLabelINTEL = 6172,
    LatencyControlConstraintINTEL = 6173,
    ConduitKernelArgumentINTEL = 6175,
    RegisterMapKernelArgumentINTEL = 6176,
    MMHostInterfaceAddressWidthINTEL = 6177,
    MMHostInterfaceDataWidthINTEL = 6178,
    MMHostInterfaceLatencyINTEL = 6179,
    MMHostInterfaceReadWriteModeINTEL = 6180,
    MMHostInterfaceMaxBurstINTEL = 6181,
    MMHostInterfaceWaitRequestINTEL = 6182,
    StableKernelArgumentINTEL = 6183,
    HostAccessINTEL = 6188,
    InitModeINTEL = 6190,
    ImplementInRegisterMapINTEL = 6191,
    CacheControlLoadINTEL = 6442,
    CacheControlStoreINTEL = 6443,

    pub const PerPrimitiveNV = Decoration.PerPrimitiveEXT;
    pub const PerVertexNV = Decoration.PerVertexKHR;
    pub const NonUniformEXT = Decoration.NonUniform;
    pub const RestrictPointerEXT = Decoration.RestrictPointer;
    pub const AliasedPointerEXT = Decoration.AliasedPointer;
    pub const HlslCounterBufferGOOGLE = Decoration.CounterBuffer;
    pub const HlslSemanticGOOGLE = Decoration.UserSemantic;

    pub const Extended = union(Decoration) {
        RelaxedPrecision,
        SpecId: struct { specialization_constant_id: LiteralInteger },
        Block,
        BufferBlock,
        RowMajor,
        ColMajor,
        ArrayStride: struct { array_stride: LiteralInteger },
        MatrixStride: struct { matrix_stride: LiteralInteger },
        GLSLShared,
        GLSLPacked,
        CPacked,
        BuiltIn: struct { built_in: BuiltIn },
        NoPerspective,
        Flat,
        Patch,
        Centroid,
        Sample,
        Invariant,
        Restrict,
        Aliased,
        Volatile,
        Constant,
        Coherent,
        NonWritable,
        NonReadable,
        Uniform,
        UniformId: struct { execution: IdScope },
        SaturatedConversion,
        Stream: struct { stream_number: LiteralInteger },
        Location: struct { location: LiteralInteger },
        Component: struct { component: LiteralInteger },
        Index: struct { index: LiteralInteger },
        Binding: struct { binding_point: LiteralInteger },
        DescriptorSet: struct { descriptor_set: LiteralInteger },
        Offset: struct { byte_offset: LiteralInteger },
        XfbBuffer: struct { xfb_buffer_number: LiteralInteger },
        XfbStride: struct { xfb_stride: LiteralInteger },
        FuncParamAttr: struct { function_parameter_attribute: FunctionParameterAttribute },
        FPRoundingMode: struct { fprounding_mode: FPRoundingMode },
        FPFastMathMode: struct { fpfast_math_mode: FPFastMathMode },
        LinkageAttributes: struct { name: LiteralString, linkage_type: LinkageType },
        NoContraction,
        InputAttachmentIndex: struct { attachment_index: LiteralInteger },
        Alignment: struct { alignment: LiteralInteger },
        MaxByteOffset: struct { max_byte_offset: LiteralInteger },
        AlignmentId: struct { alignment: IdRef },
        MaxByteOffsetId: struct { max_byte_offset: IdRef },
        NoSignedWrap,
        NoUnsignedWrap,
        WeightTextureQCOM,
        BlockMatchTextureQCOM,
        BlockMatchSamplerQCOM,
        ExplicitInterpAMD,
        NodeSharesPayloadLimitsWithAMDX: struct { payload_array: IdRef },
        NodeMaxPayloadsAMDX: struct { max_number_of_payloads: IdRef },
        TrackFinishWritingAMDX,
        PayloadNodeNameAMDX: struct { node_name: LiteralString },
        OverrideCoverageNV,
        PassthroughNV,
        ViewportRelativeNV,
        SecondaryViewportRelativeNV: struct { offset: LiteralInteger },
        PerPrimitiveEXT,
        PerViewNV,
        PerTaskNV,
        PerVertexKHR,
        NonUniform,
        RestrictPointer,
        AliasedPointer,
        HitObjectShaderRecordBufferNV,
        BindlessSamplerNV,
        BindlessImageNV,
        BoundSamplerNV,
        BoundImageNV,
        SIMTCallINTEL: struct { n: LiteralInteger },
        ReferencedIndirectlyINTEL,
        ClobberINTEL: struct { register: LiteralString },
        SideEffectsINTEL,
        VectorComputeVariableINTEL,
        FuncParamIOKindINTEL: struct { kind: LiteralInteger },
        VectorComputeFunctionINTEL,
        StackCallINTEL,
        GlobalVariableOffsetINTEL: struct { offset: LiteralInteger },
        CounterBuffer: struct { counter_buffer: IdRef },
        UserSemantic: struct { semantic: LiteralString },
        UserTypeGOOGLE: struct { user_type: LiteralString },
        FunctionRoundingModeINTEL: struct { target_width: LiteralInteger, fp_rounding_mode: FPRoundingMode },
        FunctionDenormModeINTEL: struct { target_width: LiteralInteger, fp_denorm_mode: FPDenormMode },
        RegisterINTEL,
        MemoryINTEL: struct { memory_type: LiteralString },
        NumbanksINTEL: struct { banks: LiteralInteger },
        BankwidthINTEL: struct { bank_width: LiteralInteger },
        MaxPrivateCopiesINTEL: struct { maximum_copies: LiteralInteger },
        SinglepumpINTEL,
        DoublepumpINTEL,
        MaxReplicatesINTEL: struct { maximum_replicates: LiteralInteger },
        SimpleDualPortINTEL,
        MergeINTEL: struct { merge_key: LiteralString, merge_type: LiteralString },
        BankBitsINTEL: struct { bank_bits: []const LiteralInteger = &.{} },
        ForcePow2DepthINTEL: struct { force_key: LiteralInteger },
        StridesizeINTEL: struct { stride_size: LiteralInteger },
        WordsizeINTEL: struct { word_size: LiteralInteger },
        TrueDualPortINTEL,
        BurstCoalesceINTEL,
        CacheSizeINTEL: struct { cache_size_in_bytes: LiteralInteger },
        DontStaticallyCoalesceINTEL,
        PrefetchINTEL: struct { prefetcher_size_in_bytes: LiteralInteger },
        StallEnableINTEL,
        FuseLoopsInFunctionINTEL,
        MathOpDSPModeINTEL: struct { mode: LiteralInteger, propagate: LiteralInteger },
        AliasScopeINTEL: struct { aliasing_scopes_list: IdRef },
        NoAliasINTEL: struct { aliasing_scopes_list: IdRef },
        InitiationIntervalINTEL: struct { cycles: LiteralInteger },
        MaxConcurrencyINTEL: struct { invocations: LiteralInteger },
        PipelineEnableINTEL: struct { enable: LiteralInteger },
        BufferLocationINTEL: struct { buffer_location_id: LiteralInteger },
        IOPipeStorageINTEL: struct { io_pipe_id: LiteralInteger },
        FunctionFloatingPointModeINTEL: struct { target_width: LiteralInteger, fp_operation_mode: FPOperationMode },
        SingleElementVectorINTEL,
        VectorComputeCallableFunctionINTEL,
        MediaBlockIOINTEL,
        StallFreeINTEL,
        FPMaxErrorDecorationINTEL: struct { max_error: LiteralFloat },
        LatencyControlLabelINTEL: struct { latency_label: LiteralInteger },
        LatencyControlConstraintINTEL: struct { relative_to: LiteralInteger, control_type: LiteralInteger, relative_cycle: LiteralInteger },
        ConduitKernelArgumentINTEL,
        RegisterMapKernelArgumentINTEL,
        MMHostInterfaceAddressWidthINTEL: struct { addresswidth: LiteralInteger },
        MMHostInterfaceDataWidthINTEL: struct { datawidth: LiteralInteger },
        MMHostInterfaceLatencyINTEL: struct { latency: LiteralInteger },
        MMHostInterfaceReadWriteModeINTEL: struct { readwritemode: AccessQualifier },
        MMHostInterfaceMaxBurstINTEL: struct { maxburstcount: LiteralInteger },
        MMHostInterfaceWaitRequestINTEL: struct { waitrequest: LiteralInteger },
        StableKernelArgumentINTEL,
        HostAccessINTEL: struct { access: HostAccessQualifier, name: LiteralString },
        InitModeINTEL: struct { trigger: InitializationModeQualifier },
        ImplementInRegisterMapINTEL: struct { value: LiteralInteger },
        CacheControlLoadINTEL: struct { cache_level: LiteralInteger, cache_control: LoadCacheControl },
        CacheControlStoreINTEL: struct { cache_level: LiteralInteger, cache_control: StoreCacheControl },
    };
};
pub const BuiltIn = enum(u32) {
    Position = 0,
    PointSize = 1,
    ClipDistance = 3,
    CullDistance = 4,
    VertexId = 5,
    InstanceId = 6,
    PrimitiveId = 7,
    InvocationId = 8,
    Layer = 9,
    ViewportIndex = 10,
    TessLevelOuter = 11,
    TessLevelInner = 12,
    TessCoord = 13,
    PatchVertices = 14,
    FragCoord = 15,
    PointCoord = 16,
    FrontFacing = 17,
    SampleId = 18,
    SamplePosition = 19,
    SampleMask = 20,
    FragDepth = 22,
    HelperInvocation = 23,
    NumWorkgroups = 24,
    WorkgroupSize = 25,
    WorkgroupId = 26,
    LocalInvocationId = 27,
    GlobalInvocationId = 28,
    LocalInvocationIndex = 29,
    WorkDim = 30,
    GlobalSize = 31,
    EnqueuedWorkgroupSize = 32,
    GlobalOffset = 33,
    GlobalLinearId = 34,
    SubgroupSize = 36,
    SubgroupMaxSize = 37,
    NumSubgroups = 38,
    NumEnqueuedSubgroups = 39,
    SubgroupId = 40,
    SubgroupLocalInvocationId = 41,
    VertexIndex = 42,
    InstanceIndex = 43,
    CoreIDARM = 4160,
    CoreCountARM = 4161,
    CoreMaxIDARM = 4162,
    WarpIDARM = 4163,
    WarpMaxIDARM = 4164,
    SubgroupEqMask = 4416,
    SubgroupGeMask = 4417,
    SubgroupGtMask = 4418,
    SubgroupLeMask = 4419,
    SubgroupLtMask = 4420,
    BaseVertex = 4424,
    BaseInstance = 4425,
    DrawIndex = 4426,
    PrimitiveShadingRateKHR = 4432,
    DeviceIndex = 4438,
    ViewIndex = 4440,
    ShadingRateKHR = 4444,
    BaryCoordNoPerspAMD = 4992,
    BaryCoordNoPerspCentroidAMD = 4993,
    BaryCoordNoPerspSampleAMD = 4994,
    BaryCoordSmoothAMD = 4995,
    BaryCoordSmoothCentroidAMD = 4996,
    BaryCoordSmoothSampleAMD = 4997,
    BaryCoordPullModelAMD = 4998,
    FragStencilRefEXT = 5014,
    CoalescedInputCountAMDX = 5021,
    ShaderIndexAMDX = 5073,
    ViewportMaskNV = 5253,
    SecondaryPositionNV = 5257,
    SecondaryViewportMaskNV = 5258,
    PositionPerViewNV = 5261,
    ViewportMaskPerViewNV = 5262,
    FullyCoveredEXT = 5264,
    TaskCountNV = 5274,
    PrimitiveCountNV = 5275,
    PrimitiveIndicesNV = 5276,
    ClipDistancePerViewNV = 5277,
    CullDistancePerViewNV = 5278,
    LayerPerViewNV = 5279,
    MeshViewCountNV = 5280,
    MeshViewIndicesNV = 5281,
    BaryCoordKHR = 5286,
    BaryCoordNoPerspKHR = 5287,
    FragSizeEXT = 5292,
    FragInvocationCountEXT = 5293,
    PrimitivePointIndicesEXT = 5294,
    PrimitiveLineIndicesEXT = 5295,
    PrimitiveTriangleIndicesEXT = 5296,
    CullPrimitiveEXT = 5299,
    LaunchIdKHR = 5319,
    LaunchSizeKHR = 5320,
    WorldRayOriginKHR = 5321,
    WorldRayDirectionKHR = 5322,
    ObjectRayOriginKHR = 5323,
    ObjectRayDirectionKHR = 5324,
    RayTminKHR = 5325,
    RayTmaxKHR = 5326,
    InstanceCustomIndexKHR = 5327,
    ObjectToWorldKHR = 5330,
    WorldToObjectKHR = 5331,
    HitTNV = 5332,
    HitKindKHR = 5333,
    CurrentRayTimeNV = 5334,
    HitTriangleVertexPositionsKHR = 5335,
    HitMicroTriangleVertexPositionsNV = 5337,
    HitMicroTriangleVertexBarycentricsNV = 5344,
    IncomingRayFlagsKHR = 5351,
    RayGeometryIndexKHR = 5352,
    WarpsPerSMNV = 5374,
    SMCountNV = 5375,
    WarpIDNV = 5376,
    SMIDNV = 5377,
    HitKindFrontFacingMicroTriangleNV = 5405,
    HitKindBackFacingMicroTriangleNV = 5406,
    CullMaskKHR = 6021,

    pub const SubgroupEqMaskKHR = BuiltIn.SubgroupEqMask;
    pub const SubgroupGeMaskKHR = BuiltIn.SubgroupGeMask;
    pub const SubgroupGtMaskKHR = BuiltIn.SubgroupGtMask;
    pub const SubgroupLeMaskKHR = BuiltIn.SubgroupLeMask;
    pub const SubgroupLtMaskKHR = BuiltIn.SubgroupLtMask;
    pub const BaryCoordNV = BuiltIn.BaryCoordKHR;
    pub const BaryCoordNoPerspNV = BuiltIn.BaryCoordNoPerspKHR;
    pub const FragmentSizeNV = BuiltIn.FragSizeEXT;
    pub const InvocationsPerPixelNV = BuiltIn.FragInvocationCountEXT;
    pub const LaunchIdNV = BuiltIn.LaunchIdKHR;
    pub const LaunchSizeNV = BuiltIn.LaunchSizeKHR;
    pub const WorldRayOriginNV = BuiltIn.WorldRayOriginKHR;
    pub const WorldRayDirectionNV = BuiltIn.WorldRayDirectionKHR;
    pub const ObjectRayOriginNV = BuiltIn.ObjectRayOriginKHR;
    pub const ObjectRayDirectionNV = BuiltIn.ObjectRayDirectionKHR;
    pub const RayTminNV = BuiltIn.RayTminKHR;
    pub const RayTmaxNV = BuiltIn.RayTmaxKHR;
    pub const InstanceCustomIndexNV = BuiltIn.InstanceCustomIndexKHR;
    pub const ObjectToWorldNV = BuiltIn.ObjectToWorldKHR;
    pub const WorldToObjectNV = BuiltIn.WorldToObjectKHR;
    pub const HitKindNV = BuiltIn.HitKindKHR;
    pub const IncomingRayFlagsNV = BuiltIn.IncomingRayFlagsKHR;
};
pub const Scope = enum(u32) {
    CrossDevice = 0,
    Device = 1,
    Workgroup = 2,
    Subgroup = 3,
    Invocation = 4,
    QueueFamily = 5,
    ShaderCallKHR = 6,

    pub const QueueFamilyKHR = Scope.QueueFamily;
};
pub const GroupOperation = enum(u32) {
    Reduce = 0,
    InclusiveScan = 1,
    ExclusiveScan = 2,
    ClusteredReduce = 3,
    PartitionedReduceNV = 6,
    PartitionedInclusiveScanNV = 7,
    PartitionedExclusiveScanNV = 8,
};
pub const KernelEnqueueFlags = enum(u32) {
    NoWait = 0,
    WaitKernel = 1,
    WaitWorkGroup = 2,
};
pub const Capability = enum(u32) {
    Matrix = 0,
    Shader = 1,
    Geometry = 2,
    Tessellation = 3,
    Addresses = 4,
    Linkage = 5,
    Kernel = 6,
    Vector16 = 7,
    Float16Buffer = 8,
    Float16 = 9,
    Float64 = 10,
    Int64 = 11,
    Int64Atomics = 12,
    ImageBasic = 13,
    ImageReadWrite = 14,
    ImageMipmap = 15,
    Pipes = 17,
    Groups = 18,
    DeviceEnqueue = 19,
    LiteralSampler = 20,
    AtomicStorage = 21,
    Int16 = 22,
    TessellationPointSize = 23,
    GeometryPointSize = 24,
    ImageGatherExtended = 25,
    StorageImageMultisample = 27,
    UniformBufferArrayDynamicIndexing = 28,
    SampledImageArrayDynamicIndexing = 29,
    StorageBufferArrayDynamicIndexing = 30,
    StorageImageArrayDynamicIndexing = 31,
    ClipDistance = 32,
    CullDistance = 33,
    ImageCubeArray = 34,
    SampleRateShading = 35,
    ImageRect = 36,
    SampledRect = 37,
    GenericPointer = 38,
    Int8 = 39,
    InputAttachment = 40,
    SparseResidency = 41,
    MinLod = 42,
    Sampled1D = 43,
    Image1D = 44,
    SampledCubeArray = 45,
    SampledBuffer = 46,
    ImageBuffer = 47,
    ImageMSArray = 48,
    StorageImageExtendedFormats = 49,
    ImageQuery = 50,
    DerivativeControl = 51,
    InterpolationFunction = 52,
    TransformFeedback = 53,
    GeometryStreams = 54,
    StorageImageReadWithoutFormat = 55,
    StorageImageWriteWithoutFormat = 56,
    MultiViewport = 57,
    SubgroupDispatch = 58,
    NamedBarrier = 59,
    PipeStorage = 60,
    GroupNonUniform = 61,
    GroupNonUniformVote = 62,
    GroupNonUniformArithmetic = 63,
    GroupNonUniformBallot = 64,
    GroupNonUniformShuffle = 65,
    GroupNonUniformShuffleRelative = 66,
    GroupNonUniformClustered = 67,
    GroupNonUniformQuad = 68,
    ShaderLayer = 69,
    ShaderViewportIndex = 70,
    UniformDecoration = 71,
    CoreBuiltinsARM = 4165,
    TileImageColorReadAccessEXT = 4166,
    TileImageDepthReadAccessEXT = 4167,
    TileImageStencilReadAccessEXT = 4168,
    FragmentShadingRateKHR = 4422,
    SubgroupBallotKHR = 4423,
    DrawParameters = 4427,
    WorkgroupMemoryExplicitLayoutKHR = 4428,
    WorkgroupMemoryExplicitLayout8BitAccessKHR = 4429,
    WorkgroupMemoryExplicitLayout16BitAccessKHR = 4430,
    SubgroupVoteKHR = 4431,
    StorageBuffer16BitAccess = 4433,
    UniformAndStorageBuffer16BitAccess = 4434,
    StoragePushConstant16 = 4435,
    StorageInputOutput16 = 4436,
    DeviceGroup = 4437,
    MultiView = 4439,
    VariablePointersStorageBuffer = 4441,
    VariablePointers = 4442,
    AtomicStorageOps = 4445,
    SampleMaskPostDepthCoverage = 4447,
    StorageBuffer8BitAccess = 4448,
    UniformAndStorageBuffer8BitAccess = 4449,
    StoragePushConstant8 = 4450,
    DenormPreserve = 4464,
    DenormFlushToZero = 4465,
    SignedZeroInfNanPreserve = 4466,
    RoundingModeRTE = 4467,
    RoundingModeRTZ = 4468,
    RayQueryProvisionalKHR = 4471,
    RayQueryKHR = 4472,
    RayTraversalPrimitiveCullingKHR = 4478,
    RayTracingKHR = 4479,
    TextureSampleWeightedQCOM = 4484,
    TextureBoxFilterQCOM = 4485,
    TextureBlockMatchQCOM = 4486,
    TextureBlockMatch2QCOM = 4498,
    Float16ImageAMD = 5008,
    ImageGatherBiasLodAMD = 5009,
    FragmentMaskAMD = 5010,
    StencilExportEXT = 5013,
    ImageReadWriteLodAMD = 5015,
    Int64ImageEXT = 5016,
    ShaderClockKHR = 5055,
    ShaderEnqueueAMDX = 5067,
    QuadControlKHR = 5087,
    SampleMaskOverrideCoverageNV = 5249,
    GeometryShaderPassthroughNV = 5251,
    ShaderViewportIndexLayerEXT = 5254,
    ShaderViewportMaskNV = 5255,
    ShaderStereoViewNV = 5259,
    PerViewAttributesNV = 5260,
    FragmentFullyCoveredEXT = 5265,
    MeshShadingNV = 5266,
    ImageFootprintNV = 5282,
    MeshShadingEXT = 5283,
    FragmentBarycentricKHR = 5284,
    ComputeDerivativeGroupQuadsNV = 5288,
    FragmentDensityEXT = 5291,
    GroupNonUniformPartitionedNV = 5297,
    ShaderNonUniform = 5301,
    RuntimeDescriptorArray = 5302,
    InputAttachmentArrayDynamicIndexing = 5303,
    UniformTexelBufferArrayDynamicIndexing = 5304,
    StorageTexelBufferArrayDynamicIndexing = 5305,
    UniformBufferArrayNonUniformIndexing = 5306,
    SampledImageArrayNonUniformIndexing = 5307,
    StorageBufferArrayNonUniformIndexing = 5308,
    StorageImageArrayNonUniformIndexing = 5309,
    InputAttachmentArrayNonUniformIndexing = 5310,
    UniformTexelBufferArrayNonUniformIndexing = 5311,
    StorageTexelBufferArrayNonUniformIndexing = 5312,
    RayTracingPositionFetchKHR = 5336,
    RayTracingNV = 5340,
    RayTracingMotionBlurNV = 5341,
    VulkanMemoryModel = 5345,
    VulkanMemoryModelDeviceScope = 5346,
    PhysicalStorageBufferAddresses = 5347,
    ComputeDerivativeGroupLinearNV = 5350,
    RayTracingProvisionalKHR = 5353,
    CooperativeMatrixNV = 5357,
    FragmentShaderSampleInterlockEXT = 5363,
    FragmentShaderShadingRateInterlockEXT = 5372,
    ShaderSMBuiltinsNV = 5373,
    FragmentShaderPixelInterlockEXT = 5378,
    DemoteToHelperInvocation = 5379,
    DisplacementMicromapNV = 5380,
    RayTracingOpacityMicromapEXT = 5381,
    ShaderInvocationReorderNV = 5383,
    BindlessTextureNV = 5390,
    RayQueryPositionFetchKHR = 5391,
    AtomicFloat16VectorNV = 5404,
    RayTracingDisplacementMicromapNV = 5409,
    RawAccessChainsNV = 5414,
    SubgroupShuffleINTEL = 5568,
    SubgroupBufferBlockIOINTEL = 5569,
    SubgroupImageBlockIOINTEL = 5570,
    SubgroupImageMediaBlockIOINTEL = 5579,
    RoundToInfinityINTEL = 5582,
    FloatingPointModeINTEL = 5583,
    IntegerFunctions2INTEL = 5584,
    FunctionPointersINTEL = 5603,
    IndirectReferencesINTEL = 5604,
    AsmINTEL = 5606,
    AtomicFloat32MinMaxEXT = 5612,
    AtomicFloat64MinMaxEXT = 5613,
    AtomicFloat16MinMaxEXT = 5616,
    VectorComputeINTEL = 5617,
    VectorAnyINTEL = 5619,
    ExpectAssumeKHR = 5629,
    SubgroupAvcMotionEstimationINTEL = 5696,
    SubgroupAvcMotionEstimationIntraINTEL = 5697,
    SubgroupAvcMotionEstimationChromaINTEL = 5698,
    VariableLengthArrayINTEL = 5817,
    FunctionFloatControlINTEL = 5821,
    FPGAMemoryAttributesINTEL = 5824,
    FPFastMathModeINTEL = 5837,
    ArbitraryPrecisionIntegersINTEL = 5844,
    ArbitraryPrecisionFloatingPointINTEL = 5845,
    UnstructuredLoopControlsINTEL = 5886,
    FPGALoopControlsINTEL = 5888,
    KernelAttributesINTEL = 5892,
    FPGAKernelAttributesINTEL = 5897,
    FPGAMemoryAccessesINTEL = 5898,
    FPGAClusterAttributesINTEL = 5904,
    LoopFuseINTEL = 5906,
    FPGADSPControlINTEL = 5908,
    MemoryAccessAliasingINTEL = 5910,
    FPGAInvocationPipeliningAttributesINTEL = 5916,
    FPGABufferLocationINTEL = 5920,
    ArbitraryPrecisionFixedPointINTEL = 5922,
    USMStorageClassesINTEL = 5935,
    RuntimeAlignedAttributeINTEL = 5939,
    IOPipesINTEL = 5943,
    BlockingPipesINTEL = 5945,
    FPGARegINTEL = 5948,
    DotProductInputAll = 6016,
    DotProductInput4x8Bit = 6017,
    DotProductInput4x8BitPacked = 6018,
    DotProduct = 6019,
    RayCullMaskKHR = 6020,
    CooperativeMatrixKHR = 6022,
    BitInstructions = 6025,
    GroupNonUniformRotateKHR = 6026,
    FloatControls2 = 6029,
    AtomicFloat32AddEXT = 6033,
    AtomicFloat64AddEXT = 6034,
    LongCompositesINTEL = 6089,
    OptNoneINTEL = 6094,
    AtomicFloat16AddEXT = 6095,
    DebugInfoModuleINTEL = 6114,
    BFloat16ConversionINTEL = 6115,
    SplitBarrierINTEL = 6141,
    FPGAClusterAttributesV2INTEL = 6150,
    FPGAKernelAttributesv2INTEL = 6161,
    FPMaxErrorINTEL = 6169,
    FPGALatencyControlINTEL = 6171,
    FPGAArgumentInterfacesINTEL = 6174,
    GlobalVariableHostAccessINTEL = 6187,
    GlobalVariableFPGADecorationsINTEL = 6189,
    GroupUniformArithmeticKHR = 6400,
    MaskedGatherScatterINTEL = 6427,
    CacheControlsINTEL = 6441,
    RegisterLimitsINTEL = 6460,

    pub const StorageUniformBufferBlock16 = Capability.StorageBuffer16BitAccess;
    pub const StorageUniform16 = Capability.UniformAndStorageBuffer16BitAccess;
    pub const ShaderViewportIndexLayerNV = Capability.ShaderViewportIndexLayerEXT;
    pub const FragmentBarycentricNV = Capability.FragmentBarycentricKHR;
    pub const ShadingRateNV = Capability.FragmentDensityEXT;
    pub const ShaderNonUniformEXT = Capability.ShaderNonUniform;
    pub const RuntimeDescriptorArrayEXT = Capability.RuntimeDescriptorArray;
    pub const InputAttachmentArrayDynamicIndexingEXT = Capability.InputAttachmentArrayDynamicIndexing;
    pub const UniformTexelBufferArrayDynamicIndexingEXT = Capability.UniformTexelBufferArrayDynamicIndexing;
    pub const StorageTexelBufferArrayDynamicIndexingEXT = Capability.StorageTexelBufferArrayDynamicIndexing;
    pub const UniformBufferArrayNonUniformIndexingEXT = Capability.UniformBufferArrayNonUniformIndexing;
    pub const SampledImageArrayNonUniformIndexingEXT = Capability.SampledImageArrayNonUniformIndexing;
    pub const StorageBufferArrayNonUniformIndexingEXT = Capability.StorageBufferArrayNonUniformIndexing;
    pub const StorageImageArrayNonUniformIndexingEXT = Capability.StorageImageArrayNonUniformIndexing;
    pub const InputAttachmentArrayNonUniformIndexingEXT = Capability.InputAttachmentArrayNonUniformIndexing;
    pub const UniformTexelBufferArrayNonUniformIndexingEXT = Capability.UniformTexelBufferArrayNonUniformIndexing;
    pub const StorageTexelBufferArrayNonUniformIndexingEXT = Capability.StorageTexelBufferArrayNonUniformIndexing;
    pub const VulkanMemoryModelKHR = Capability.VulkanMemoryModel;
    pub const VulkanMemoryModelDeviceScopeKHR = Capability.VulkanMemoryModelDeviceScope;
    pub const PhysicalStorageBufferAddressesEXT = Capability.PhysicalStorageBufferAddresses;
    pub const DemoteToHelperInvocationEXT = Capability.DemoteToHelperInvocation;
    pub const DotProductInputAllKHR = Capability.DotProductInputAll;
    pub const DotProductInput4x8BitKHR = Capability.DotProductInput4x8Bit;
    pub const DotProductInput4x8BitPackedKHR = Capability.DotProductInput4x8BitPacked;
    pub const DotProductKHR = Capability.DotProduct;
};
pub const RayQueryIntersection = enum(u32) {
    RayQueryCandidateIntersectionKHR = 0,
    RayQueryCommittedIntersectionKHR = 1,
};
pub const RayQueryCommittedIntersectionType = enum(u32) {
    RayQueryCommittedIntersectionNoneKHR = 0,
    RayQueryCommittedIntersectionTriangleKHR = 1,
    RayQueryCommittedIntersectionGeneratedKHR = 2,
};
pub const RayQueryCandidateIntersectionType = enum(u32) {
    RayQueryCandidateIntersectionTriangleKHR = 0,
    RayQueryCandidateIntersectionAABBKHR = 1,
};
pub const PackedVectorFormat = enum(u32) {
    PackedVectorFormat4x8Bit = 0,

    pub const PackedVectorFormat4x8BitKHR = PackedVectorFormat.PackedVectorFormat4x8Bit;
};
pub const CooperativeMatrixOperands = packed struct {
    MatrixASignedComponentsKHR: bool = false,
    MatrixBSignedComponentsKHR: bool = false,
    MatrixCSignedComponentsKHR: bool = false,
    MatrixResultSignedComponentsKHR: bool = false,
    SaturatingAccumulationKHR: bool = false,
    _reserved_bit_5: bool = false,
    _reserved_bit_6: bool = false,
    _reserved_bit_7: bool = false,
    _reserved_bit_8: bool = false,
    _reserved_bit_9: bool = false,
    _reserved_bit_10: bool = false,
    _reserved_bit_11: bool = false,
    _reserved_bit_12: bool = false,
    _reserved_bit_13: bool = false,
    _reserved_bit_14: bool = false,
    _reserved_bit_15: bool = false,
    _reserved_bit_16: bool = false,
    _reserved_bit_17: bool = false,
    _reserved_bit_18: bool = false,
    _reserved_bit_19: bool = false,
    _reserved_bit_20: bool = false,
    _reserved_bit_21: bool = false,
    _reserved_bit_22: bool = false,
    _reserved_bit_23: bool = false,
    _reserved_bit_24: bool = false,
    _reserved_bit_25: bool = false,
    _reserved_bit_26: bool = false,
    _reserved_bit_27: bool = false,
    _reserved_bit_28: bool = false,
    _reserved_bit_29: bool = false,
    _reserved_bit_30: bool = false,
    _reserved_bit_31: bool = false,
};
pub const CooperativeMatrixLayout = enum(u32) {
    RowMajorKHR = 0,
    ColumnMajorKHR = 1,
};
pub const CooperativeMatrixUse = enum(u32) {
    MatrixAKHR = 0,
    MatrixBKHR = 1,
    MatrixAccumulatorKHR = 2,
};
pub const InitializationModeQualifier = enum(u32) {
    InitOnDeviceReprogramINTEL = 0,
    InitOnDeviceResetINTEL = 1,
};
pub const LoadCacheControl = enum(u32) {
    UncachedINTEL = 0,
    CachedINTEL = 1,
    StreamingINTEL = 2,
    InvalidateAfterReadINTEL = 3,
    ConstCachedINTEL = 4,
};
pub const StoreCacheControl = enum(u32) {
    UncachedINTEL = 0,
    WriteThroughINTEL = 1,
    WriteBackINTEL = 2,
    StreamingINTEL = 3,
};
pub const NamedMaximumNumberOfRegisters = enum(u32) {
    AutoINTEL = 0,
};
pub const @"OpenCL.DebugInfo.100.DebugInfoFlags" = packed struct {
    FlagIsProtected: bool = false,
    FlagIsPrivate: bool = false,
    FlagIsLocal: bool = false,
    FlagIsDefinition: bool = false,
    FlagFwdDecl: bool = false,
    FlagArtificial: bool = false,
    FlagExplicit: bool = false,
    FlagPrototyped: bool = false,
    FlagObjectPointer: bool = false,
    FlagStaticMember: bool = false,
    FlagIndirectVariable: bool = false,
    FlagLValueReference: bool = false,
    FlagRValueReference: bool = false,
    FlagIsOptimized: bool = false,
    FlagIsEnumClass: bool = false,
    FlagTypePassByValue: bool = false,
    FlagTypePassByReference: bool = false,
    _reserved_bit_17: bool = false,
    _reserved_bit_18: bool = false,
    _reserved_bit_19: bool = false,
    _reserved_bit_20: bool = false,
    _reserved_bit_21: bool = false,
    _reserved_bit_22: bool = false,
    _reserved_bit_23: bool = false,
    _reserved_bit_24: bool = false,
    _reserved_bit_25: bool = false,
    _reserved_bit_26: bool = false,
    _reserved_bit_27: bool = false,
    _reserved_bit_28: bool = false,
    _reserved_bit_29: bool = false,
    _reserved_bit_30: bool = false,
    _reserved_bit_31: bool = false,
};
pub const @"OpenCL.DebugInfo.100.DebugBaseTypeAttributeEncoding" = enum(u32) {
    Unspecified = 0,
    Address = 1,
    Boolean = 2,
    Float = 3,
    Signed = 4,
    SignedChar = 5,
    Unsigned = 6,
    UnsignedChar = 7,
};
pub const @"OpenCL.DebugInfo.100.DebugCompositeType" = enum(u32) {
    Class = 0,
    Structure = 1,
    Union = 2,
};
pub const @"OpenCL.DebugInfo.100.DebugTypeQualifier" = enum(u32) {
    ConstType = 0,
    VolatileType = 1,
    RestrictType = 2,
    AtomicType = 3,
};
pub const @"OpenCL.DebugInfo.100.DebugOperation" = enum(u32) {
    Deref = 0,
    Plus = 1,
    Minus = 2,
    PlusUconst = 3,
    BitPiece = 4,
    Swap = 5,
    Xderef = 6,
    StackValue = 7,
    Constu = 8,
    Fragment = 9,

    pub const Extended = union(@"OpenCL.DebugInfo.100.DebugOperation") {
        Deref,
        Plus,
        Minus,
        PlusUconst: struct { literal_integer: LiteralInteger },
        BitPiece: struct { literal_integer_0: LiteralInteger, literal_integer_1: LiteralInteger },
        Swap,
        Xderef,
        StackValue,
        Constu: struct { literal_integer: LiteralInteger },
        Fragment: struct { literal_integer_0: LiteralInteger, literal_integer_1: LiteralInteger },
    };
};
pub const @"OpenCL.DebugInfo.100.DebugImportedEntity" = enum(u32) {
    ImportedModule = 0,
    ImportedDeclaration = 1,
};
pub const @"NonSemantic.Shader.DebugInfo.100.DebugInfoFlags" = packed struct {
    FlagIsProtected: bool = false,
    FlagIsPrivate: bool = false,
    FlagIsLocal: bool = false,
    FlagIsDefinition: bool = false,
    FlagFwdDecl: bool = false,
    FlagArtificial: bool = false,
    FlagExplicit: bool = false,
    FlagPrototyped: bool = false,
    FlagObjectPointer: bool = false,
    FlagStaticMember: bool = false,
    FlagIndirectVariable: bool = false,
    FlagLValueReference: bool = false,
    FlagRValueReference: bool = false,
    FlagIsOptimized: bool = false,
    FlagIsEnumClass: bool = false,
    FlagTypePassByValue: bool = false,
    FlagTypePassByReference: bool = false,
    FlagUnknownPhysicalLayout: bool = false,
    _reserved_bit_18: bool = false,
    _reserved_bit_19: bool = false,
    _reserved_bit_20: bool = false,
    _reserved_bit_21: bool = false,
    _reserved_bit_22: bool = false,
    _reserved_bit_23: bool = false,
    _reserved_bit_24: bool = false,
    _reserved_bit_25: bool = false,
    _reserved_bit_26: bool = false,
    _reserved_bit_27: bool = false,
    _reserved_bit_28: bool = false,
    _reserved_bit_29: bool = false,
    _reserved_bit_30: bool = false,
    _reserved_bit_31: bool = false,
};
pub const @"NonSemantic.Shader.DebugInfo.100.BuildIdentifierFlags" = packed struct {
    IdentifierPossibleDuplicates: bool = false,
    _reserved_bit_1: bool = false,
    _reserved_bit_2: bool = false,
    _reserved_bit_3: bool = false,
    _reserved_bit_4: bool = false,
    _reserved_bit_5: bool = false,
    _reserved_bit_6: bool = false,
    _reserved_bit_7: bool = false,
    _reserved_bit_8: bool = false,
    _reserved_bit_9: bool = false,
    _reserved_bit_10: bool = false,
    _reserved_bit_11: bool = false,
    _reserved_bit_12: bool = false,
    _reserved_bit_13: bool = false,
    _reserved_bit_14: bool = false,
    _reserved_bit_15: bool = false,
    _reserved_bit_16: bool = false,
    _reserved_bit_17: bool = false,
    _reserved_bit_18: bool = false,
    _reserved_bit_19: bool = false,
    _reserved_bit_20: bool = false,
    _reserved_bit_21: bool = false,
    _reserved_bit_22: bool = false,
    _reserved_bit_23: bool = false,
    _reserved_bit_24: bool = false,
    _reserved_bit_25: bool = false,
    _reserved_bit_26: bool = false,
    _reserved_bit_27: bool = false,
    _reserved_bit_28: bool = false,
    _reserved_bit_29: bool = false,
    _reserved_bit_30: bool = false,
    _reserved_bit_31: bool = false,
};
pub const @"NonSemantic.Shader.DebugInfo.100.DebugBaseTypeAttributeEncoding" = enum(u32) {
    Unspecified = 0,
    Address = 1,
    Boolean = 2,
    Float = 3,
    Signed = 4,
    SignedChar = 5,
    Unsigned = 6,
    UnsignedChar = 7,
};
pub const @"NonSemantic.Shader.DebugInfo.100.DebugCompositeType" = enum(u32) {
    Class = 0,
    Structure = 1,
    Union = 2,
};
pub const @"NonSemantic.Shader.DebugInfo.100.DebugTypeQualifier" = enum(u32) {
    ConstType = 0,
    VolatileType = 1,
    RestrictType = 2,
    AtomicType = 3,
};
pub const @"NonSemantic.Shader.DebugInfo.100.DebugOperation" = enum(u32) {
    Deref = 0,
    Plus = 1,
    Minus = 2,
    PlusUconst = 3,
    BitPiece = 4,
    Swap = 5,
    Xderef = 6,
    StackValue = 7,
    Constu = 8,
    Fragment = 9,

    pub const Extended = union(@"NonSemantic.Shader.DebugInfo.100.DebugOperation") {
        Deref,
        Plus,
        Minus,
        PlusUconst: struct { id_ref: IdRef },
        BitPiece: struct { id_ref_0: IdRef, id_ref_1: IdRef },
        Swap,
        Xderef,
        StackValue,
        Constu: struct { id_ref: IdRef },
        Fragment: struct { id_ref_0: IdRef, id_ref_1: IdRef },
    };
};
pub const @"NonSemantic.Shader.DebugInfo.100.DebugImportedEntity" = enum(u32) {
    ImportedModule = 0,
    ImportedDeclaration = 1,
};
pub const @"NonSemantic.ClspvReflection.6.KernelPropertyFlags" = packed struct {
    MayUsePrintf: bool = false,
    _reserved_bit_1: bool = false,
    _reserved_bit_2: bool = false,
    _reserved_bit_3: bool = false,
    _reserved_bit_4: bool = false,
    _reserved_bit_5: bool = false,
    _reserved_bit_6: bool = false,
    _reserved_bit_7: bool = false,
    _reserved_bit_8: bool = false,
    _reserved_bit_9: bool = false,
    _reserved_bit_10: bool = false,
    _reserved_bit_11: bool = false,
    _reserved_bit_12: bool = false,
    _reserved_bit_13: bool = false,
    _reserved_bit_14: bool = false,
    _reserved_bit_15: bool = false,
    _reserved_bit_16: bool = false,
    _reserved_bit_17: bool = false,
    _reserved_bit_18: bool = false,
    _reserved_bit_19: bool = false,
    _reserved_bit_20: bool = false,
    _reserved_bit_21: bool = false,
    _reserved_bit_22: bool = false,
    _reserved_bit_23: bool = false,
    _reserved_bit_24: bool = false,
    _reserved_bit_25: bool = false,
    _reserved_bit_26: bool = false,
    _reserved_bit_27: bool = false,
    _reserved_bit_28: bool = false,
    _reserved_bit_29: bool = false,
    _reserved_bit_30: bool = false,
    _reserved_bit_31: bool = false,
};
pub const @"DebugInfo.DebugInfoFlags" = packed struct {
    FlagIsProtected: bool = false,
    FlagIsPrivate: bool = false,
    FlagIsLocal: bool = false,
    FlagIsDefinition: bool = false,
    FlagFwdDecl: bool = false,
    FlagArtificial: bool = false,
    FlagExplicit: bool = false,
    FlagPrototyped: bool = false,
    FlagObjectPointer: bool = false,
    FlagStaticMember: bool = false,
    FlagIndirectVariable: bool = false,
    FlagLValueReference: bool = false,
    FlagRValueReference: bool = false,
    FlagIsOptimized: bool = false,
    _reserved_bit_14: bool = false,
    _reserved_bit_15: bool = false,
    _reserved_bit_16: bool = false,
    _reserved_bit_17: bool = false,
    _reserved_bit_18: bool = false,
    _reserved_bit_19: bool = false,
    _reserved_bit_20: bool = false,
    _reserved_bit_21: bool = false,
    _reserved_bit_22: bool = false,
    _reserved_bit_23: bool = false,
    _reserved_bit_24: bool = false,
    _reserved_bit_25: bool = false,
    _reserved_bit_26: bool = false,
    _reserved_bit_27: bool = false,
    _reserved_bit_28: bool = false,
    _reserved_bit_29: bool = false,
    _reserved_bit_30: bool = false,
    _reserved_bit_31: bool = false,
};
pub const @"DebugInfo.DebugBaseTypeAttributeEncoding" = enum(u32) {
    Unspecified = 0,
    Address = 1,
    Boolean = 2,
    Float = 4,
    Signed = 5,
    SignedChar = 6,
    Unsigned = 7,
    UnsignedChar = 8,
};
pub const @"DebugInfo.DebugCompositeType" = enum(u32) {
    Class = 0,
    Structure = 1,
    Union = 2,
};
pub const @"DebugInfo.DebugTypeQualifier" = enum(u32) {
    ConstType = 0,
    VolatileType = 1,
    RestrictType = 2,
};
pub const @"DebugInfo.DebugOperation" = enum(u32) {
    Deref = 0,
    Plus = 1,
    Minus = 2,
    PlusUconst = 3,
    BitPiece = 4,
    Swap = 5,
    Xderef = 6,
    StackValue = 7,
    Constu = 8,

    pub const Extended = union(@"DebugInfo.DebugOperation") {
        Deref,
        Plus,
        Minus,
        PlusUconst: struct { literal_integer: LiteralInteger },
        BitPiece: struct { literal_integer_0: LiteralInteger, literal_integer_1: LiteralInteger },
        Swap,
        Xderef,
        StackValue,
        Constu: struct { literal_integer: LiteralInteger },
    };
};
pub const InstructionSet = enum {
    core,
    @"OpenCL.std",
    @"GLSL.std.450",
    @"OpenCL.DebugInfo.100",
    SPV_AMD_shader_ballot,
    @"NonSemantic.Shader.DebugInfo.100",
    @"NonSemantic.VkspReflection",
    @"NonSemantic.ClspvReflection.6",
    SPV_AMD_gcn_shader,
    SPV_AMD_shader_trinary_minmax,
    DebugInfo,
    @"NonSemantic.DebugPrintf",
    SPV_AMD_shader_explicit_vertex_parameter,
    @"NonSemantic.DebugBreak",
    zig,

    pub fn instructions(self: InstructionSet) []const Instruction {
        return switch (self) {
            .core => &[_]Instruction{
                .{
                    .name = "OpNop",
                    .opcode = 0,
                    .operands = &[_]Operand{},
                },
                .{
                    .name = "OpUndef",
                    .opcode = 1,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpSourceContinued",
                    .opcode = 2,
                    .operands = &[_]Operand{
                        .{ .kind = .LiteralString, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpSource",
                    .opcode = 3,
                    .operands = &[_]Operand{
                        .{ .kind = .SourceLanguage, .quantifier = .required },
                        .{ .kind = .LiteralInteger, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .optional },
                        .{ .kind = .LiteralString, .quantifier = .optional },
                    },
                },
                .{
                    .name = "OpSourceExtension",
                    .opcode = 4,
                    .operands = &[_]Operand{
                        .{ .kind = .LiteralString, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpName",
                    .opcode = 5,
                    .operands = &[_]Operand{
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .LiteralString, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpMemberName",
                    .opcode = 6,
                    .operands = &[_]Operand{
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .LiteralInteger, .quantifier = .required },
                        .{ .kind = .LiteralString, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpString",
                    .opcode = 7,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .LiteralString, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpLine",
                    .opcode = 8,
                    .operands = &[_]Operand{
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .LiteralInteger, .quantifier = .required },
                        .{ .kind = .LiteralInteger, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpExtension",
                    .opcode = 10,
                    .operands = &[_]Operand{
                        .{ .kind = .LiteralString, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpExtInstImport",
                    .opcode = 11,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .LiteralString, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpExtInst",
                    .opcode = 12,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .LiteralExtInstInteger, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .variadic },
                    },
                },
                .{
                    .name = "OpMemoryModel",
                    .opcode = 14,
                    .operands = &[_]Operand{
                        .{ .kind = .AddressingModel, .quantifier = .required },
                        .{ .kind = .MemoryModel, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpEntryPoint",
                    .opcode = 15,
                    .operands = &[_]Operand{
                        .{ .kind = .ExecutionModel, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .LiteralString, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .variadic },
                    },
                },
                .{
                    .name = "OpExecutionMode",
                    .opcode = 16,
                    .operands = &[_]Operand{
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .ExecutionMode, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpCapability",
                    .opcode = 17,
                    .operands = &[_]Operand{
                        .{ .kind = .Capability, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpTypeVoid",
                    .opcode = 19,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResult, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpTypeBool",
                    .opcode = 20,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResult, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpTypeInt",
                    .opcode = 21,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .LiteralInteger, .quantifier = .required },
                        .{ .kind = .LiteralInteger, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpTypeFloat",
                    .opcode = 22,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .LiteralInteger, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpTypeVector",
                    .opcode = 23,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .LiteralInteger, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpTypeMatrix",
                    .opcode = 24,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .LiteralInteger, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpTypeImage",
                    .opcode = 25,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .Dim, .quantifier = .required },
                        .{ .kind = .LiteralInteger, .quantifier = .required },
                        .{ .kind = .LiteralInteger, .quantifier = .required },
                        .{ .kind = .LiteralInteger, .quantifier = .required },
                        .{ .kind = .LiteralInteger, .quantifier = .required },
                        .{ .kind = .ImageFormat, .quantifier = .required },
                        .{ .kind = .AccessQualifier, .quantifier = .optional },
                    },
                },
                .{
                    .name = "OpTypeSampler",
                    .opcode = 26,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResult, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpTypeSampledImage",
                    .opcode = 27,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpTypeArray",
                    .opcode = 28,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpTypeRuntimeArray",
                    .opcode = 29,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpTypeStruct",
                    .opcode = 30,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .variadic },
                    },
                },
                .{
                    .name = "OpTypeOpaque",
                    .opcode = 31,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .LiteralString, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpTypePointer",
                    .opcode = 32,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .StorageClass, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpTypeFunction",
                    .opcode = 33,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .variadic },
                    },
                },
                .{
                    .name = "OpTypeEvent",
                    .opcode = 34,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResult, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpTypeDeviceEvent",
                    .opcode = 35,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResult, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpTypeReserveId",
                    .opcode = 36,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResult, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpTypeQueue",
                    .opcode = 37,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResult, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpTypePipe",
                    .opcode = 38,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .AccessQualifier, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpTypeForwardPointer",
                    .opcode = 39,
                    .operands = &[_]Operand{
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .StorageClass, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpConstantTrue",
                    .opcode = 41,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpConstantFalse",
                    .opcode = 42,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpConstant",
                    .opcode = 43,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .LiteralContextDependentNumber, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpConstantComposite",
                    .opcode = 44,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .variadic },
                    },
                },
                .{
                    .name = "OpConstantSampler",
                    .opcode = 45,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .SamplerAddressingMode, .quantifier = .required },
                        .{ .kind = .LiteralInteger, .quantifier = .required },
                        .{ .kind = .SamplerFilterMode, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpConstantNull",
                    .opcode = 46,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpSpecConstantTrue",
                    .opcode = 48,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpSpecConstantFalse",
                    .opcode = 49,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpSpecConstant",
                    .opcode = 50,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .LiteralContextDependentNumber, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpSpecConstantComposite",
                    .opcode = 51,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .variadic },
                    },
                },
                .{
                    .name = "OpSpecConstantOp",
                    .opcode = 52,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .LiteralSpecConstantOpInteger, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpFunction",
                    .opcode = 54,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .FunctionControl, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpFunctionParameter",
                    .opcode = 55,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpFunctionEnd",
                    .opcode = 56,
                    .operands = &[_]Operand{},
                },
                .{
                    .name = "OpFunctionCall",
                    .opcode = 57,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .variadic },
                    },
                },
                .{
                    .name = "OpVariable",
                    .opcode = 59,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .StorageClass, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .optional },
                    },
                },
                .{
                    .name = "OpImageTexelPointer",
                    .opcode = 60,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpLoad",
                    .opcode = 61,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .MemoryAccess, .quantifier = .optional },
                    },
                },
                .{
                    .name = "OpStore",
                    .opcode = 62,
                    .operands = &[_]Operand{
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .MemoryAccess, .quantifier = .optional },
                    },
                },
                .{
                    .name = "OpCopyMemory",
                    .opcode = 63,
                    .operands = &[_]Operand{
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .MemoryAccess, .quantifier = .optional },
                        .{ .kind = .MemoryAccess, .quantifier = .optional },
                    },
                },
                .{
                    .name = "OpCopyMemorySized",
                    .opcode = 64,
                    .operands = &[_]Operand{
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .MemoryAccess, .quantifier = .optional },
                        .{ .kind = .MemoryAccess, .quantifier = .optional },
                    },
                },
                .{
                    .name = "OpAccessChain",
                    .opcode = 65,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .variadic },
                    },
                },
                .{
                    .name = "OpInBoundsAccessChain",
                    .opcode = 66,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .variadic },
                    },
                },
                .{
                    .name = "OpPtrAccessChain",
                    .opcode = 67,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .variadic },
                    },
                },
                .{
                    .name = "OpArrayLength",
                    .opcode = 68,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .LiteralInteger, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpGenericPtrMemSemantics",
                    .opcode = 69,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpInBoundsPtrAccessChain",
                    .opcode = 70,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .variadic },
                    },
                },
                .{
                    .name = "OpDecorate",
                    .opcode = 71,
                    .operands = &[_]Operand{
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .Decoration, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpMemberDecorate",
                    .opcode = 72,
                    .operands = &[_]Operand{
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .LiteralInteger, .quantifier = .required },
                        .{ .kind = .Decoration, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpDecorationGroup",
                    .opcode = 73,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResult, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpGroupDecorate",
                    .opcode = 74,
                    .operands = &[_]Operand{
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .variadic },
                    },
                },
                .{
                    .name = "OpGroupMemberDecorate",
                    .opcode = 75,
                    .operands = &[_]Operand{
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .PairIdRefLiteralInteger, .quantifier = .variadic },
                    },
                },
                .{
                    .name = "OpVectorExtractDynamic",
                    .opcode = 77,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpVectorInsertDynamic",
                    .opcode = 78,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpVectorShuffle",
                    .opcode = 79,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .LiteralInteger, .quantifier = .variadic },
                    },
                },
                .{
                    .name = "OpCompositeConstruct",
                    .opcode = 80,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .variadic },
                    },
                },
                .{
                    .name = "OpCompositeExtract",
                    .opcode = 81,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .LiteralInteger, .quantifier = .variadic },
                    },
                },
                .{
                    .name = "OpCompositeInsert",
                    .opcode = 82,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .LiteralInteger, .quantifier = .variadic },
                    },
                },
                .{
                    .name = "OpCopyObject",
                    .opcode = 83,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpTranspose",
                    .opcode = 84,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpSampledImage",
                    .opcode = 86,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpImageSampleImplicitLod",
                    .opcode = 87,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .ImageOperands, .quantifier = .optional },
                    },
                },
                .{
                    .name = "OpImageSampleExplicitLod",
                    .opcode = 88,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .ImageOperands, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpImageSampleDrefImplicitLod",
                    .opcode = 89,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .ImageOperands, .quantifier = .optional },
                    },
                },
                .{
                    .name = "OpImageSampleDrefExplicitLod",
                    .opcode = 90,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .ImageOperands, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpImageSampleProjImplicitLod",
                    .opcode = 91,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .ImageOperands, .quantifier = .optional },
                    },
                },
                .{
                    .name = "OpImageSampleProjExplicitLod",
                    .opcode = 92,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .ImageOperands, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpImageSampleProjDrefImplicitLod",
                    .opcode = 93,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .ImageOperands, .quantifier = .optional },
                    },
                },
                .{
                    .name = "OpImageSampleProjDrefExplicitLod",
                    .opcode = 94,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .ImageOperands, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpImageFetch",
                    .opcode = 95,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .ImageOperands, .quantifier = .optional },
                    },
                },
                .{
                    .name = "OpImageGather",
                    .opcode = 96,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .ImageOperands, .quantifier = .optional },
                    },
                },
                .{
                    .name = "OpImageDrefGather",
                    .opcode = 97,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .ImageOperands, .quantifier = .optional },
                    },
                },
                .{
                    .name = "OpImageRead",
                    .opcode = 98,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .ImageOperands, .quantifier = .optional },
                    },
                },
                .{
                    .name = "OpImageWrite",
                    .opcode = 99,
                    .operands = &[_]Operand{
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .ImageOperands, .quantifier = .optional },
                    },
                },
                .{
                    .name = "OpImage",
                    .opcode = 100,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpImageQueryFormat",
                    .opcode = 101,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpImageQueryOrder",
                    .opcode = 102,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpImageQuerySizeLod",
                    .opcode = 103,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpImageQuerySize",
                    .opcode = 104,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpImageQueryLod",
                    .opcode = 105,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpImageQueryLevels",
                    .opcode = 106,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpImageQuerySamples",
                    .opcode = 107,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpConvertFToU",
                    .opcode = 109,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpConvertFToS",
                    .opcode = 110,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpConvertSToF",
                    .opcode = 111,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpConvertUToF",
                    .opcode = 112,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpUConvert",
                    .opcode = 113,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpSConvert",
                    .opcode = 114,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpFConvert",
                    .opcode = 115,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpQuantizeToF16",
                    .opcode = 116,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpConvertPtrToU",
                    .opcode = 117,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpSatConvertSToU",
                    .opcode = 118,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpSatConvertUToS",
                    .opcode = 119,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpConvertUToPtr",
                    .opcode = 120,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpPtrCastToGeneric",
                    .opcode = 121,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpGenericCastToPtr",
                    .opcode = 122,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpGenericCastToPtrExplicit",
                    .opcode = 123,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .StorageClass, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpBitcast",
                    .opcode = 124,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpSNegate",
                    .opcode = 126,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpFNegate",
                    .opcode = 127,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpIAdd",
                    .opcode = 128,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpFAdd",
                    .opcode = 129,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpISub",
                    .opcode = 130,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpFSub",
                    .opcode = 131,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpIMul",
                    .opcode = 132,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpFMul",
                    .opcode = 133,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpUDiv",
                    .opcode = 134,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpSDiv",
                    .opcode = 135,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpFDiv",
                    .opcode = 136,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpUMod",
                    .opcode = 137,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpSRem",
                    .opcode = 138,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpSMod",
                    .opcode = 139,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpFRem",
                    .opcode = 140,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpFMod",
                    .opcode = 141,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpVectorTimesScalar",
                    .opcode = 142,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpMatrixTimesScalar",
                    .opcode = 143,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpVectorTimesMatrix",
                    .opcode = 144,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpMatrixTimesVector",
                    .opcode = 145,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpMatrixTimesMatrix",
                    .opcode = 146,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpOuterProduct",
                    .opcode = 147,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpDot",
                    .opcode = 148,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpIAddCarry",
                    .opcode = 149,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpISubBorrow",
                    .opcode = 150,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpUMulExtended",
                    .opcode = 151,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpSMulExtended",
                    .opcode = 152,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpAny",
                    .opcode = 154,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpAll",
                    .opcode = 155,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpIsNan",
                    .opcode = 156,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpIsInf",
                    .opcode = 157,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpIsFinite",
                    .opcode = 158,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpIsNormal",
                    .opcode = 159,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpSignBitSet",
                    .opcode = 160,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpLessOrGreater",
                    .opcode = 161,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpOrdered",
                    .opcode = 162,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpUnordered",
                    .opcode = 163,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpLogicalEqual",
                    .opcode = 164,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpLogicalNotEqual",
                    .opcode = 165,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpLogicalOr",
                    .opcode = 166,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpLogicalAnd",
                    .opcode = 167,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpLogicalNot",
                    .opcode = 168,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpSelect",
                    .opcode = 169,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpIEqual",
                    .opcode = 170,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpINotEqual",
                    .opcode = 171,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpUGreaterThan",
                    .opcode = 172,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpSGreaterThan",
                    .opcode = 173,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpUGreaterThanEqual",
                    .opcode = 174,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpSGreaterThanEqual",
                    .opcode = 175,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpULessThan",
                    .opcode = 176,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpSLessThan",
                    .opcode = 177,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpULessThanEqual",
                    .opcode = 178,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpSLessThanEqual",
                    .opcode = 179,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpFOrdEqual",
                    .opcode = 180,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpFUnordEqual",
                    .opcode = 181,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpFOrdNotEqual",
                    .opcode = 182,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpFUnordNotEqual",
                    .opcode = 183,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpFOrdLessThan",
                    .opcode = 184,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpFUnordLessThan",
                    .opcode = 185,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpFOrdGreaterThan",
                    .opcode = 186,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpFUnordGreaterThan",
                    .opcode = 187,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpFOrdLessThanEqual",
                    .opcode = 188,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpFUnordLessThanEqual",
                    .opcode = 189,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpFOrdGreaterThanEqual",
                    .opcode = 190,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpFUnordGreaterThanEqual",
                    .opcode = 191,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpShiftRightLogical",
                    .opcode = 194,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpShiftRightArithmetic",
                    .opcode = 195,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpShiftLeftLogical",
                    .opcode = 196,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpBitwiseOr",
                    .opcode = 197,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpBitwiseXor",
                    .opcode = 198,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpBitwiseAnd",
                    .opcode = 199,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpNot",
                    .opcode = 200,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpBitFieldInsert",
                    .opcode = 201,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpBitFieldSExtract",
                    .opcode = 202,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpBitFieldUExtract",
                    .opcode = 203,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpBitReverse",
                    .opcode = 204,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpBitCount",
                    .opcode = 205,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpDPdx",
                    .opcode = 207,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpDPdy",
                    .opcode = 208,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpFwidth",
                    .opcode = 209,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpDPdxFine",
                    .opcode = 210,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpDPdyFine",
                    .opcode = 211,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpFwidthFine",
                    .opcode = 212,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpDPdxCoarse",
                    .opcode = 213,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpDPdyCoarse",
                    .opcode = 214,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpFwidthCoarse",
                    .opcode = 215,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpEmitVertex",
                    .opcode = 218,
                    .operands = &[_]Operand{},
                },
                .{
                    .name = "OpEndPrimitive",
                    .opcode = 219,
                    .operands = &[_]Operand{},
                },
                .{
                    .name = "OpEmitStreamVertex",
                    .opcode = 220,
                    .operands = &[_]Operand{
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpEndStreamPrimitive",
                    .opcode = 221,
                    .operands = &[_]Operand{
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpControlBarrier",
                    .opcode = 224,
                    .operands = &[_]Operand{
                        .{ .kind = .IdScope, .quantifier = .required },
                        .{ .kind = .IdScope, .quantifier = .required },
                        .{ .kind = .IdMemorySemantics, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpMemoryBarrier",
                    .opcode = 225,
                    .operands = &[_]Operand{
                        .{ .kind = .IdScope, .quantifier = .required },
                        .{ .kind = .IdMemorySemantics, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpAtomicLoad",
                    .opcode = 227,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdScope, .quantifier = .required },
                        .{ .kind = .IdMemorySemantics, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpAtomicStore",
                    .opcode = 228,
                    .operands = &[_]Operand{
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdScope, .quantifier = .required },
                        .{ .kind = .IdMemorySemantics, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpAtomicExchange",
                    .opcode = 229,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdScope, .quantifier = .required },
                        .{ .kind = .IdMemorySemantics, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpAtomicCompareExchange",
                    .opcode = 230,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdScope, .quantifier = .required },
                        .{ .kind = .IdMemorySemantics, .quantifier = .required },
                        .{ .kind = .IdMemorySemantics, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpAtomicCompareExchangeWeak",
                    .opcode = 231,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdScope, .quantifier = .required },
                        .{ .kind = .IdMemorySemantics, .quantifier = .required },
                        .{ .kind = .IdMemorySemantics, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpAtomicIIncrement",
                    .opcode = 232,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdScope, .quantifier = .required },
                        .{ .kind = .IdMemorySemantics, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpAtomicIDecrement",
                    .opcode = 233,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdScope, .quantifier = .required },
                        .{ .kind = .IdMemorySemantics, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpAtomicIAdd",
                    .opcode = 234,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdScope, .quantifier = .required },
                        .{ .kind = .IdMemorySemantics, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpAtomicISub",
                    .opcode = 235,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdScope, .quantifier = .required },
                        .{ .kind = .IdMemorySemantics, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpAtomicSMin",
                    .opcode = 236,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdScope, .quantifier = .required },
                        .{ .kind = .IdMemorySemantics, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpAtomicUMin",
                    .opcode = 237,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdScope, .quantifier = .required },
                        .{ .kind = .IdMemorySemantics, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpAtomicSMax",
                    .opcode = 238,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdScope, .quantifier = .required },
                        .{ .kind = .IdMemorySemantics, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpAtomicUMax",
                    .opcode = 239,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdScope, .quantifier = .required },
                        .{ .kind = .IdMemorySemantics, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpAtomicAnd",
                    .opcode = 240,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdScope, .quantifier = .required },
                        .{ .kind = .IdMemorySemantics, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpAtomicOr",
                    .opcode = 241,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdScope, .quantifier = .required },
                        .{ .kind = .IdMemorySemantics, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpAtomicXor",
                    .opcode = 242,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdScope, .quantifier = .required },
                        .{ .kind = .IdMemorySemantics, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpPhi",
                    .opcode = 245,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .PairIdRefIdRef, .quantifier = .variadic },
                    },
                },
                .{
                    .name = "OpLoopMerge",
                    .opcode = 246,
                    .operands = &[_]Operand{
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .LoopControl, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpSelectionMerge",
                    .opcode = 247,
                    .operands = &[_]Operand{
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .SelectionControl, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpLabel",
                    .opcode = 248,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResult, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpBranch",
                    .opcode = 249,
                    .operands = &[_]Operand{
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpBranchConditional",
                    .opcode = 250,
                    .operands = &[_]Operand{
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .LiteralInteger, .quantifier = .variadic },
                    },
                },
                .{
                    .name = "OpSwitch",
                    .opcode = 251,
                    .operands = &[_]Operand{
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .PairLiteralIntegerIdRef, .quantifier = .variadic },
                    },
                },
                .{
                    .name = "OpKill",
                    .opcode = 252,
                    .operands = &[_]Operand{},
                },
                .{
                    .name = "OpReturn",
                    .opcode = 253,
                    .operands = &[_]Operand{},
                },
                .{
                    .name = "OpReturnValue",
                    .opcode = 254,
                    .operands = &[_]Operand{
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpUnreachable",
                    .opcode = 255,
                    .operands = &[_]Operand{},
                },
                .{
                    .name = "OpLifetimeStart",
                    .opcode = 256,
                    .operands = &[_]Operand{
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .LiteralInteger, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpLifetimeStop",
                    .opcode = 257,
                    .operands = &[_]Operand{
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .LiteralInteger, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpGroupAsyncCopy",
                    .opcode = 259,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdScope, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpGroupWaitEvents",
                    .opcode = 260,
                    .operands = &[_]Operand{
                        .{ .kind = .IdScope, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpGroupAll",
                    .opcode = 261,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdScope, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpGroupAny",
                    .opcode = 262,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdScope, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpGroupBroadcast",
                    .opcode = 263,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdScope, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpGroupIAdd",
                    .opcode = 264,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdScope, .quantifier = .required },
                        .{ .kind = .GroupOperation, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpGroupFAdd",
                    .opcode = 265,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdScope, .quantifier = .required },
                        .{ .kind = .GroupOperation, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpGroupFMin",
                    .opcode = 266,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdScope, .quantifier = .required },
                        .{ .kind = .GroupOperation, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpGroupUMin",
                    .opcode = 267,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdScope, .quantifier = .required },
                        .{ .kind = .GroupOperation, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpGroupSMin",
                    .opcode = 268,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdScope, .quantifier = .required },
                        .{ .kind = .GroupOperation, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpGroupFMax",
                    .opcode = 269,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdScope, .quantifier = .required },
                        .{ .kind = .GroupOperation, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpGroupUMax",
                    .opcode = 270,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdScope, .quantifier = .required },
                        .{ .kind = .GroupOperation, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpGroupSMax",
                    .opcode = 271,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdScope, .quantifier = .required },
                        .{ .kind = .GroupOperation, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpReadPipe",
                    .opcode = 274,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpWritePipe",
                    .opcode = 275,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpReservedReadPipe",
                    .opcode = 276,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpReservedWritePipe",
                    .opcode = 277,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpReserveReadPipePackets",
                    .opcode = 278,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpReserveWritePipePackets",
                    .opcode = 279,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpCommitReadPipe",
                    .opcode = 280,
                    .operands = &[_]Operand{
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpCommitWritePipe",
                    .opcode = 281,
                    .operands = &[_]Operand{
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpIsValidReserveId",
                    .opcode = 282,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpGetNumPipePackets",
                    .opcode = 283,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpGetMaxPipePackets",
                    .opcode = 284,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpGroupReserveReadPipePackets",
                    .opcode = 285,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdScope, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpGroupReserveWritePipePackets",
                    .opcode = 286,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdScope, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpGroupCommitReadPipe",
                    .opcode = 287,
                    .operands = &[_]Operand{
                        .{ .kind = .IdScope, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpGroupCommitWritePipe",
                    .opcode = 288,
                    .operands = &[_]Operand{
                        .{ .kind = .IdScope, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpEnqueueMarker",
                    .opcode = 291,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpEnqueueKernel",
                    .opcode = 292,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .variadic },
                    },
                },
                .{
                    .name = "OpGetKernelNDrangeSubGroupCount",
                    .opcode = 293,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpGetKernelNDrangeMaxSubGroupSize",
                    .opcode = 294,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpGetKernelWorkGroupSize",
                    .opcode = 295,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpGetKernelPreferredWorkGroupSizeMultiple",
                    .opcode = 296,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpRetainEvent",
                    .opcode = 297,
                    .operands = &[_]Operand{
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpReleaseEvent",
                    .opcode = 298,
                    .operands = &[_]Operand{
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpCreateUserEvent",
                    .opcode = 299,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpIsValidEvent",
                    .opcode = 300,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpSetUserEventStatus",
                    .opcode = 301,
                    .operands = &[_]Operand{
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpCaptureEventProfilingInfo",
                    .opcode = 302,
                    .operands = &[_]Operand{
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpGetDefaultQueue",
                    .opcode = 303,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpBuildNDRange",
                    .opcode = 304,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpImageSparseSampleImplicitLod",
                    .opcode = 305,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .ImageOperands, .quantifier = .optional },
                    },
                },
                .{
                    .name = "OpImageSparseSampleExplicitLod",
                    .opcode = 306,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .ImageOperands, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpImageSparseSampleDrefImplicitLod",
                    .opcode = 307,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .ImageOperands, .quantifier = .optional },
                    },
                },
                .{
                    .name = "OpImageSparseSampleDrefExplicitLod",
                    .opcode = 308,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .ImageOperands, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpImageSparseSampleProjImplicitLod",
                    .opcode = 309,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .ImageOperands, .quantifier = .optional },
                    },
                },
                .{
                    .name = "OpImageSparseSampleProjExplicitLod",
                    .opcode = 310,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .ImageOperands, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpImageSparseSampleProjDrefImplicitLod",
                    .opcode = 311,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .ImageOperands, .quantifier = .optional },
                    },
                },
                .{
                    .name = "OpImageSparseSampleProjDrefExplicitLod",
                    .opcode = 312,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .ImageOperands, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpImageSparseFetch",
                    .opcode = 313,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .ImageOperands, .quantifier = .optional },
                    },
                },
                .{
                    .name = "OpImageSparseGather",
                    .opcode = 314,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .ImageOperands, .quantifier = .optional },
                    },
                },
                .{
                    .name = "OpImageSparseDrefGather",
                    .opcode = 315,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .ImageOperands, .quantifier = .optional },
                    },
                },
                .{
                    .name = "OpImageSparseTexelsResident",
                    .opcode = 316,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpNoLine",
                    .opcode = 317,
                    .operands = &[_]Operand{},
                },
                .{
                    .name = "OpAtomicFlagTestAndSet",
                    .opcode = 318,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdScope, .quantifier = .required },
                        .{ .kind = .IdMemorySemantics, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpAtomicFlagClear",
                    .opcode = 319,
                    .operands = &[_]Operand{
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdScope, .quantifier = .required },
                        .{ .kind = .IdMemorySemantics, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpImageSparseRead",
                    .opcode = 320,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .ImageOperands, .quantifier = .optional },
                    },
                },
                .{
                    .name = "OpSizeOf",
                    .opcode = 321,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpTypePipeStorage",
                    .opcode = 322,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResult, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpConstantPipeStorage",
                    .opcode = 323,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .LiteralInteger, .quantifier = .required },
                        .{ .kind = .LiteralInteger, .quantifier = .required },
                        .{ .kind = .LiteralInteger, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpCreatePipeFromPipeStorage",
                    .opcode = 324,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpGetKernelLocalSizeForSubgroupCount",
                    .opcode = 325,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpGetKernelMaxNumSubgroups",
                    .opcode = 326,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpTypeNamedBarrier",
                    .opcode = 327,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResult, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpNamedBarrierInitialize",
                    .opcode = 328,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpMemoryNamedBarrier",
                    .opcode = 329,
                    .operands = &[_]Operand{
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdScope, .quantifier = .required },
                        .{ .kind = .IdMemorySemantics, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpModuleProcessed",
                    .opcode = 330,
                    .operands = &[_]Operand{
                        .{ .kind = .LiteralString, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpExecutionModeId",
                    .opcode = 331,
                    .operands = &[_]Operand{
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .ExecutionMode, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpDecorateId",
                    .opcode = 332,
                    .operands = &[_]Operand{
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .Decoration, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpGroupNonUniformElect",
                    .opcode = 333,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdScope, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpGroupNonUniformAll",
                    .opcode = 334,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdScope, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpGroupNonUniformAny",
                    .opcode = 335,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdScope, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpGroupNonUniformAllEqual",
                    .opcode = 336,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdScope, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpGroupNonUniformBroadcast",
                    .opcode = 337,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdScope, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpGroupNonUniformBroadcastFirst",
                    .opcode = 338,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdScope, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpGroupNonUniformBallot",
                    .opcode = 339,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdScope, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpGroupNonUniformInverseBallot",
                    .opcode = 340,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdScope, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpGroupNonUniformBallotBitExtract",
                    .opcode = 341,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdScope, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpGroupNonUniformBallotBitCount",
                    .opcode = 342,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdScope, .quantifier = .required },
                        .{ .kind = .GroupOperation, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpGroupNonUniformBallotFindLSB",
                    .opcode = 343,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdScope, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpGroupNonUniformBallotFindMSB",
                    .opcode = 344,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdScope, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpGroupNonUniformShuffle",
                    .opcode = 345,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdScope, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpGroupNonUniformShuffleXor",
                    .opcode = 346,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdScope, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpGroupNonUniformShuffleUp",
                    .opcode = 347,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdScope, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpGroupNonUniformShuffleDown",
                    .opcode = 348,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdScope, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpGroupNonUniformIAdd",
                    .opcode = 349,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdScope, .quantifier = .required },
                        .{ .kind = .GroupOperation, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .optional },
                    },
                },
                .{
                    .name = "OpGroupNonUniformFAdd",
                    .opcode = 350,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdScope, .quantifier = .required },
                        .{ .kind = .GroupOperation, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .optional },
                    },
                },
                .{
                    .name = "OpGroupNonUniformIMul",
                    .opcode = 351,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdScope, .quantifier = .required },
                        .{ .kind = .GroupOperation, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .optional },
                    },
                },
                .{
                    .name = "OpGroupNonUniformFMul",
                    .opcode = 352,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdScope, .quantifier = .required },
                        .{ .kind = .GroupOperation, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .optional },
                    },
                },
                .{
                    .name = "OpGroupNonUniformSMin",
                    .opcode = 353,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdScope, .quantifier = .required },
                        .{ .kind = .GroupOperation, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .optional },
                    },
                },
                .{
                    .name = "OpGroupNonUniformUMin",
                    .opcode = 354,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdScope, .quantifier = .required },
                        .{ .kind = .GroupOperation, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .optional },
                    },
                },
                .{
                    .name = "OpGroupNonUniformFMin",
                    .opcode = 355,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdScope, .quantifier = .required },
                        .{ .kind = .GroupOperation, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .optional },
                    },
                },
                .{
                    .name = "OpGroupNonUniformSMax",
                    .opcode = 356,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdScope, .quantifier = .required },
                        .{ .kind = .GroupOperation, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .optional },
                    },
                },
                .{
                    .name = "OpGroupNonUniformUMax",
                    .opcode = 357,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdScope, .quantifier = .required },
                        .{ .kind = .GroupOperation, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .optional },
                    },
                },
                .{
                    .name = "OpGroupNonUniformFMax",
                    .opcode = 358,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdScope, .quantifier = .required },
                        .{ .kind = .GroupOperation, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .optional },
                    },
                },
                .{
                    .name = "OpGroupNonUniformBitwiseAnd",
                    .opcode = 359,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdScope, .quantifier = .required },
                        .{ .kind = .GroupOperation, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .optional },
                    },
                },
                .{
                    .name = "OpGroupNonUniformBitwiseOr",
                    .opcode = 360,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdScope, .quantifier = .required },
                        .{ .kind = .GroupOperation, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .optional },
                    },
                },
                .{
                    .name = "OpGroupNonUniformBitwiseXor",
                    .opcode = 361,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdScope, .quantifier = .required },
                        .{ .kind = .GroupOperation, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .optional },
                    },
                },
                .{
                    .name = "OpGroupNonUniformLogicalAnd",
                    .opcode = 362,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdScope, .quantifier = .required },
                        .{ .kind = .GroupOperation, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .optional },
                    },
                },
                .{
                    .name = "OpGroupNonUniformLogicalOr",
                    .opcode = 363,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdScope, .quantifier = .required },
                        .{ .kind = .GroupOperation, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .optional },
                    },
                },
                .{
                    .name = "OpGroupNonUniformLogicalXor",
                    .opcode = 364,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdScope, .quantifier = .required },
                        .{ .kind = .GroupOperation, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .optional },
                    },
                },
                .{
                    .name = "OpGroupNonUniformQuadBroadcast",
                    .opcode = 365,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdScope, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpGroupNonUniformQuadSwap",
                    .opcode = 366,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdScope, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpCopyLogical",
                    .opcode = 400,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpPtrEqual",
                    .opcode = 401,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpPtrNotEqual",
                    .opcode = 402,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpPtrDiff",
                    .opcode = 403,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpColorAttachmentReadEXT",
                    .opcode = 4160,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .optional },
                    },
                },
                .{
                    .name = "OpDepthAttachmentReadEXT",
                    .opcode = 4161,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .optional },
                    },
                },
                .{
                    .name = "OpStencilAttachmentReadEXT",
                    .opcode = 4162,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .optional },
                    },
                },
                .{
                    .name = "OpTerminateInvocation",
                    .opcode = 4416,
                    .operands = &[_]Operand{},
                },
                .{
                    .name = "OpSubgroupBallotKHR",
                    .opcode = 4421,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpSubgroupFirstInvocationKHR",
                    .opcode = 4422,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpSubgroupAllKHR",
                    .opcode = 4428,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpSubgroupAnyKHR",
                    .opcode = 4429,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpSubgroupAllEqualKHR",
                    .opcode = 4430,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpGroupNonUniformRotateKHR",
                    .opcode = 4431,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdScope, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .optional },
                    },
                },
                .{
                    .name = "OpSubgroupReadInvocationKHR",
                    .opcode = 4432,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpTraceRayKHR",
                    .opcode = 4445,
                    .operands = &[_]Operand{
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpExecuteCallableKHR",
                    .opcode = 4446,
                    .operands = &[_]Operand{
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpConvertUToAccelerationStructureKHR",
                    .opcode = 4447,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpIgnoreIntersectionKHR",
                    .opcode = 4448,
                    .operands = &[_]Operand{},
                },
                .{
                    .name = "OpTerminateRayKHR",
                    .opcode = 4449,
                    .operands = &[_]Operand{},
                },
                .{
                    .name = "OpSDot",
                    .opcode = 4450,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .PackedVectorFormat, .quantifier = .optional },
                    },
                },
                .{
                    .name = "OpSDotKHR",
                    .opcode = 4450,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .PackedVectorFormat, .quantifier = .optional },
                    },
                },
                .{
                    .name = "OpUDot",
                    .opcode = 4451,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .PackedVectorFormat, .quantifier = .optional },
                    },
                },
                .{
                    .name = "OpUDotKHR",
                    .opcode = 4451,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .PackedVectorFormat, .quantifier = .optional },
                    },
                },
                .{
                    .name = "OpSUDot",
                    .opcode = 4452,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .PackedVectorFormat, .quantifier = .optional },
                    },
                },
                .{
                    .name = "OpSUDotKHR",
                    .opcode = 4452,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .PackedVectorFormat, .quantifier = .optional },
                    },
                },
                .{
                    .name = "OpSDotAccSat",
                    .opcode = 4453,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .PackedVectorFormat, .quantifier = .optional },
                    },
                },
                .{
                    .name = "OpSDotAccSatKHR",
                    .opcode = 4453,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .PackedVectorFormat, .quantifier = .optional },
                    },
                },
                .{
                    .name = "OpUDotAccSat",
                    .opcode = 4454,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .PackedVectorFormat, .quantifier = .optional },
                    },
                },
                .{
                    .name = "OpUDotAccSatKHR",
                    .opcode = 4454,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .PackedVectorFormat, .quantifier = .optional },
                    },
                },
                .{
                    .name = "OpSUDotAccSat",
                    .opcode = 4455,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .PackedVectorFormat, .quantifier = .optional },
                    },
                },
                .{
                    .name = "OpSUDotAccSatKHR",
                    .opcode = 4455,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .PackedVectorFormat, .quantifier = .optional },
                    },
                },
                .{
                    .name = "OpTypeCooperativeMatrixKHR",
                    .opcode = 4456,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdScope, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpCooperativeMatrixLoadKHR",
                    .opcode = 4457,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .optional },
                        .{ .kind = .MemoryAccess, .quantifier = .optional },
                    },
                },
                .{
                    .name = "OpCooperativeMatrixStoreKHR",
                    .opcode = 4458,
                    .operands = &[_]Operand{
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .optional },
                        .{ .kind = .MemoryAccess, .quantifier = .optional },
                    },
                },
                .{
                    .name = "OpCooperativeMatrixMulAddKHR",
                    .opcode = 4459,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .CooperativeMatrixOperands, .quantifier = .optional },
                    },
                },
                .{
                    .name = "OpCooperativeMatrixLengthKHR",
                    .opcode = 4460,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpTypeRayQueryKHR",
                    .opcode = 4472,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResult, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpRayQueryInitializeKHR",
                    .opcode = 4473,
                    .operands = &[_]Operand{
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpRayQueryTerminateKHR",
                    .opcode = 4474,
                    .operands = &[_]Operand{
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpRayQueryGenerateIntersectionKHR",
                    .opcode = 4475,
                    .operands = &[_]Operand{
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpRayQueryConfirmIntersectionKHR",
                    .opcode = 4476,
                    .operands = &[_]Operand{
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpRayQueryProceedKHR",
                    .opcode = 4477,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpRayQueryGetIntersectionTypeKHR",
                    .opcode = 4479,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpImageSampleWeightedQCOM",
                    .opcode = 4480,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpImageBoxFilterQCOM",
                    .opcode = 4481,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpImageBlockMatchSSDQCOM",
                    .opcode = 4482,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpImageBlockMatchSADQCOM",
                    .opcode = 4483,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpImageBlockMatchWindowSSDQCOM",
                    .opcode = 4500,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpImageBlockMatchWindowSADQCOM",
                    .opcode = 4501,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpImageBlockMatchGatherSSDQCOM",
                    .opcode = 4502,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpImageBlockMatchGatherSADQCOM",
                    .opcode = 4503,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpGroupIAddNonUniformAMD",
                    .opcode = 5000,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdScope, .quantifier = .required },
                        .{ .kind = .GroupOperation, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpGroupFAddNonUniformAMD",
                    .opcode = 5001,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdScope, .quantifier = .required },
                        .{ .kind = .GroupOperation, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpGroupFMinNonUniformAMD",
                    .opcode = 5002,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdScope, .quantifier = .required },
                        .{ .kind = .GroupOperation, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpGroupUMinNonUniformAMD",
                    .opcode = 5003,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdScope, .quantifier = .required },
                        .{ .kind = .GroupOperation, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpGroupSMinNonUniformAMD",
                    .opcode = 5004,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdScope, .quantifier = .required },
                        .{ .kind = .GroupOperation, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpGroupFMaxNonUniformAMD",
                    .opcode = 5005,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdScope, .quantifier = .required },
                        .{ .kind = .GroupOperation, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpGroupUMaxNonUniformAMD",
                    .opcode = 5006,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdScope, .quantifier = .required },
                        .{ .kind = .GroupOperation, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpGroupSMaxNonUniformAMD",
                    .opcode = 5007,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdScope, .quantifier = .required },
                        .{ .kind = .GroupOperation, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpFragmentMaskFetchAMD",
                    .opcode = 5011,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpFragmentFetchAMD",
                    .opcode = 5012,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpReadClockKHR",
                    .opcode = 5056,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdScope, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpFinalizeNodePayloadsAMDX",
                    .opcode = 5075,
                    .operands = &[_]Operand{
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpFinishWritingNodePayloadAMDX",
                    .opcode = 5078,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpInitializeNodePayloadsAMDX",
                    .opcode = 5090,
                    .operands = &[_]Operand{
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdScope, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpGroupNonUniformQuadAllKHR",
                    .opcode = 5110,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpGroupNonUniformQuadAnyKHR",
                    .opcode = 5111,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpHitObjectRecordHitMotionNV",
                    .opcode = 5249,
                    .operands = &[_]Operand{
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpHitObjectRecordHitWithIndexMotionNV",
                    .opcode = 5250,
                    .operands = &[_]Operand{
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpHitObjectRecordMissMotionNV",
                    .opcode = 5251,
                    .operands = &[_]Operand{
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpHitObjectGetWorldToObjectNV",
                    .opcode = 5252,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpHitObjectGetObjectToWorldNV",
                    .opcode = 5253,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpHitObjectGetObjectRayDirectionNV",
                    .opcode = 5254,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpHitObjectGetObjectRayOriginNV",
                    .opcode = 5255,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpHitObjectTraceRayMotionNV",
                    .opcode = 5256,
                    .operands = &[_]Operand{
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpHitObjectGetShaderRecordBufferHandleNV",
                    .opcode = 5257,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpHitObjectGetShaderBindingTableRecordIndexNV",
                    .opcode = 5258,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpHitObjectRecordEmptyNV",
                    .opcode = 5259,
                    .operands = &[_]Operand{
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpHitObjectTraceRayNV",
                    .opcode = 5260,
                    .operands = &[_]Operand{
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpHitObjectRecordHitNV",
                    .opcode = 5261,
                    .operands = &[_]Operand{
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpHitObjectRecordHitWithIndexNV",
                    .opcode = 5262,
                    .operands = &[_]Operand{
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpHitObjectRecordMissNV",
                    .opcode = 5263,
                    .operands = &[_]Operand{
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpHitObjectExecuteShaderNV",
                    .opcode = 5264,
                    .operands = &[_]Operand{
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpHitObjectGetCurrentTimeNV",
                    .opcode = 5265,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpHitObjectGetAttributesNV",
                    .opcode = 5266,
                    .operands = &[_]Operand{
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpHitObjectGetHitKindNV",
                    .opcode = 5267,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpHitObjectGetPrimitiveIndexNV",
                    .opcode = 5268,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpHitObjectGetGeometryIndexNV",
                    .opcode = 5269,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpHitObjectGetInstanceIdNV",
                    .opcode = 5270,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpHitObjectGetInstanceCustomIndexNV",
                    .opcode = 5271,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpHitObjectGetWorldRayDirectionNV",
                    .opcode = 5272,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpHitObjectGetWorldRayOriginNV",
                    .opcode = 5273,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpHitObjectGetRayTMaxNV",
                    .opcode = 5274,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpHitObjectGetRayTMinNV",
                    .opcode = 5275,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpHitObjectIsEmptyNV",
                    .opcode = 5276,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpHitObjectIsHitNV",
                    .opcode = 5277,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpHitObjectIsMissNV",
                    .opcode = 5278,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpReorderThreadWithHitObjectNV",
                    .opcode = 5279,
                    .operands = &[_]Operand{
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .optional },
                        .{ .kind = .IdRef, .quantifier = .optional },
                    },
                },
                .{
                    .name = "OpReorderThreadWithHintNV",
                    .opcode = 5280,
                    .operands = &[_]Operand{
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpTypeHitObjectNV",
                    .opcode = 5281,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResult, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpImageSampleFootprintNV",
                    .opcode = 5283,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .ImageOperands, .quantifier = .optional },
                    },
                },
                .{
                    .name = "OpEmitMeshTasksEXT",
                    .opcode = 5294,
                    .operands = &[_]Operand{
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .optional },
                    },
                },
                .{
                    .name = "OpSetMeshOutputsEXT",
                    .opcode = 5295,
                    .operands = &[_]Operand{
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpGroupNonUniformPartitionNV",
                    .opcode = 5296,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpWritePackedPrimitiveIndices4x8NV",
                    .opcode = 5299,
                    .operands = &[_]Operand{
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpFetchMicroTriangleVertexPositionNV",
                    .opcode = 5300,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpFetchMicroTriangleVertexBarycentricNV",
                    .opcode = 5301,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpReportIntersectionNV",
                    .opcode = 5334,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpReportIntersectionKHR",
                    .opcode = 5334,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpIgnoreIntersectionNV",
                    .opcode = 5335,
                    .operands = &[_]Operand{},
                },
                .{
                    .name = "OpTerminateRayNV",
                    .opcode = 5336,
                    .operands = &[_]Operand{},
                },
                .{
                    .name = "OpTraceNV",
                    .opcode = 5337,
                    .operands = &[_]Operand{
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpTraceMotionNV",
                    .opcode = 5338,
                    .operands = &[_]Operand{
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpTraceRayMotionNV",
                    .opcode = 5339,
                    .operands = &[_]Operand{
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpRayQueryGetIntersectionTriangleVertexPositionsKHR",
                    .opcode = 5340,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpTypeAccelerationStructureNV",
                    .opcode = 5341,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResult, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpTypeAccelerationStructureKHR",
                    .opcode = 5341,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResult, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpExecuteCallableNV",
                    .opcode = 5344,
                    .operands = &[_]Operand{
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpTypeCooperativeMatrixNV",
                    .opcode = 5358,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdScope, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpCooperativeMatrixLoadNV",
                    .opcode = 5359,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .MemoryAccess, .quantifier = .optional },
                    },
                },
                .{
                    .name = "OpCooperativeMatrixStoreNV",
                    .opcode = 5360,
                    .operands = &[_]Operand{
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .MemoryAccess, .quantifier = .optional },
                    },
                },
                .{
                    .name = "OpCooperativeMatrixMulAddNV",
                    .opcode = 5361,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpCooperativeMatrixLengthNV",
                    .opcode = 5362,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpBeginInvocationInterlockEXT",
                    .opcode = 5364,
                    .operands = &[_]Operand{},
                },
                .{
                    .name = "OpEndInvocationInterlockEXT",
                    .opcode = 5365,
                    .operands = &[_]Operand{},
                },
                .{
                    .name = "OpDemoteToHelperInvocation",
                    .opcode = 5380,
                    .operands = &[_]Operand{},
                },
                .{
                    .name = "OpDemoteToHelperInvocationEXT",
                    .opcode = 5380,
                    .operands = &[_]Operand{},
                },
                .{
                    .name = "OpIsHelperInvocationEXT",
                    .opcode = 5381,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpConvertUToImageNV",
                    .opcode = 5391,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpConvertUToSamplerNV",
                    .opcode = 5392,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpConvertImageToUNV",
                    .opcode = 5393,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpConvertSamplerToUNV",
                    .opcode = 5394,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpConvertUToSampledImageNV",
                    .opcode = 5395,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpConvertSampledImageToUNV",
                    .opcode = 5396,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpSamplerImageAddressingModeNV",
                    .opcode = 5397,
                    .operands = &[_]Operand{
                        .{ .kind = .LiteralInteger, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpRawAccessChainNV",
                    .opcode = 5398,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .RawAccessChainOperands, .quantifier = .optional },
                    },
                },
                .{
                    .name = "OpSubgroupShuffleINTEL",
                    .opcode = 5571,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpSubgroupShuffleDownINTEL",
                    .opcode = 5572,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpSubgroupShuffleUpINTEL",
                    .opcode = 5573,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpSubgroupShuffleXorINTEL",
                    .opcode = 5574,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpSubgroupBlockReadINTEL",
                    .opcode = 5575,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpSubgroupBlockWriteINTEL",
                    .opcode = 5576,
                    .operands = &[_]Operand{
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpSubgroupImageBlockReadINTEL",
                    .opcode = 5577,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpSubgroupImageBlockWriteINTEL",
                    .opcode = 5578,
                    .operands = &[_]Operand{
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpSubgroupImageMediaBlockReadINTEL",
                    .opcode = 5580,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpSubgroupImageMediaBlockWriteINTEL",
                    .opcode = 5581,
                    .operands = &[_]Operand{
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpUCountLeadingZerosINTEL",
                    .opcode = 5585,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpUCountTrailingZerosINTEL",
                    .opcode = 5586,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpAbsISubINTEL",
                    .opcode = 5587,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpAbsUSubINTEL",
                    .opcode = 5588,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpIAddSatINTEL",
                    .opcode = 5589,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpUAddSatINTEL",
                    .opcode = 5590,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpIAverageINTEL",
                    .opcode = 5591,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpUAverageINTEL",
                    .opcode = 5592,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpIAverageRoundedINTEL",
                    .opcode = 5593,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpUAverageRoundedINTEL",
                    .opcode = 5594,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpISubSatINTEL",
                    .opcode = 5595,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpUSubSatINTEL",
                    .opcode = 5596,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpIMul32x16INTEL",
                    .opcode = 5597,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpUMul32x16INTEL",
                    .opcode = 5598,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpConstantFunctionPointerINTEL",
                    .opcode = 5600,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpFunctionPointerCallINTEL",
                    .opcode = 5601,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .variadic },
                    },
                },
                .{
                    .name = "OpAsmTargetINTEL",
                    .opcode = 5609,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .LiteralString, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpAsmINTEL",
                    .opcode = 5610,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .LiteralString, .quantifier = .required },
                        .{ .kind = .LiteralString, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpAsmCallINTEL",
                    .opcode = 5611,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .variadic },
                    },
                },
                .{
                    .name = "OpAtomicFMinEXT",
                    .opcode = 5614,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdScope, .quantifier = .required },
                        .{ .kind = .IdMemorySemantics, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpAtomicFMaxEXT",
                    .opcode = 5615,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdScope, .quantifier = .required },
                        .{ .kind = .IdMemorySemantics, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpAssumeTrueKHR",
                    .opcode = 5630,
                    .operands = &[_]Operand{
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpExpectKHR",
                    .opcode = 5631,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpDecorateString",
                    .opcode = 5632,
                    .operands = &[_]Operand{
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .Decoration, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpDecorateStringGOOGLE",
                    .opcode = 5632,
                    .operands = &[_]Operand{
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .Decoration, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpMemberDecorateString",
                    .opcode = 5633,
                    .operands = &[_]Operand{
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .LiteralInteger, .quantifier = .required },
                        .{ .kind = .Decoration, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpMemberDecorateStringGOOGLE",
                    .opcode = 5633,
                    .operands = &[_]Operand{
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .LiteralInteger, .quantifier = .required },
                        .{ .kind = .Decoration, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpVmeImageINTEL",
                    .opcode = 5699,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpTypeVmeImageINTEL",
                    .opcode = 5700,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpTypeAvcImePayloadINTEL",
                    .opcode = 5701,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResult, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpTypeAvcRefPayloadINTEL",
                    .opcode = 5702,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResult, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpTypeAvcSicPayloadINTEL",
                    .opcode = 5703,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResult, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpTypeAvcMcePayloadINTEL",
                    .opcode = 5704,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResult, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpTypeAvcMceResultINTEL",
                    .opcode = 5705,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResult, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpTypeAvcImeResultINTEL",
                    .opcode = 5706,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResult, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpTypeAvcImeResultSingleReferenceStreamoutINTEL",
                    .opcode = 5707,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResult, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpTypeAvcImeResultDualReferenceStreamoutINTEL",
                    .opcode = 5708,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResult, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpTypeAvcImeSingleReferenceStreaminINTEL",
                    .opcode = 5709,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResult, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpTypeAvcImeDualReferenceStreaminINTEL",
                    .opcode = 5710,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResult, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpTypeAvcRefResultINTEL",
                    .opcode = 5711,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResult, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpTypeAvcSicResultINTEL",
                    .opcode = 5712,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResult, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpSubgroupAvcMceGetDefaultInterBaseMultiReferencePenaltyINTEL",
                    .opcode = 5713,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpSubgroupAvcMceSetInterBaseMultiReferencePenaltyINTEL",
                    .opcode = 5714,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpSubgroupAvcMceGetDefaultInterShapePenaltyINTEL",
                    .opcode = 5715,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpSubgroupAvcMceSetInterShapePenaltyINTEL",
                    .opcode = 5716,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpSubgroupAvcMceGetDefaultInterDirectionPenaltyINTEL",
                    .opcode = 5717,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpSubgroupAvcMceSetInterDirectionPenaltyINTEL",
                    .opcode = 5718,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpSubgroupAvcMceGetDefaultIntraLumaShapePenaltyINTEL",
                    .opcode = 5719,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpSubgroupAvcMceGetDefaultInterMotionVectorCostTableINTEL",
                    .opcode = 5720,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpSubgroupAvcMceGetDefaultHighPenaltyCostTableINTEL",
                    .opcode = 5721,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpSubgroupAvcMceGetDefaultMediumPenaltyCostTableINTEL",
                    .opcode = 5722,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpSubgroupAvcMceGetDefaultLowPenaltyCostTableINTEL",
                    .opcode = 5723,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpSubgroupAvcMceSetMotionVectorCostFunctionINTEL",
                    .opcode = 5724,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpSubgroupAvcMceGetDefaultIntraLumaModePenaltyINTEL",
                    .opcode = 5725,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpSubgroupAvcMceGetDefaultNonDcLumaIntraPenaltyINTEL",
                    .opcode = 5726,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpSubgroupAvcMceGetDefaultIntraChromaModeBasePenaltyINTEL",
                    .opcode = 5727,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpSubgroupAvcMceSetAcOnlyHaarINTEL",
                    .opcode = 5728,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpSubgroupAvcMceSetSourceInterlacedFieldPolarityINTEL",
                    .opcode = 5729,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpSubgroupAvcMceSetSingleReferenceInterlacedFieldPolarityINTEL",
                    .opcode = 5730,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpSubgroupAvcMceSetDualReferenceInterlacedFieldPolaritiesINTEL",
                    .opcode = 5731,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpSubgroupAvcMceConvertToImePayloadINTEL",
                    .opcode = 5732,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpSubgroupAvcMceConvertToImeResultINTEL",
                    .opcode = 5733,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpSubgroupAvcMceConvertToRefPayloadINTEL",
                    .opcode = 5734,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpSubgroupAvcMceConvertToRefResultINTEL",
                    .opcode = 5735,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpSubgroupAvcMceConvertToSicPayloadINTEL",
                    .opcode = 5736,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpSubgroupAvcMceConvertToSicResultINTEL",
                    .opcode = 5737,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpSubgroupAvcMceGetMotionVectorsINTEL",
                    .opcode = 5738,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpSubgroupAvcMceGetInterDistortionsINTEL",
                    .opcode = 5739,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpSubgroupAvcMceGetBestInterDistortionsINTEL",
                    .opcode = 5740,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpSubgroupAvcMceGetInterMajorShapeINTEL",
                    .opcode = 5741,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpSubgroupAvcMceGetInterMinorShapeINTEL",
                    .opcode = 5742,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpSubgroupAvcMceGetInterDirectionsINTEL",
                    .opcode = 5743,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpSubgroupAvcMceGetInterMotionVectorCountINTEL",
                    .opcode = 5744,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpSubgroupAvcMceGetInterReferenceIdsINTEL",
                    .opcode = 5745,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpSubgroupAvcMceGetInterReferenceInterlacedFieldPolaritiesINTEL",
                    .opcode = 5746,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpSubgroupAvcImeInitializeINTEL",
                    .opcode = 5747,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpSubgroupAvcImeSetSingleReferenceINTEL",
                    .opcode = 5748,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpSubgroupAvcImeSetDualReferenceINTEL",
                    .opcode = 5749,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpSubgroupAvcImeRefWindowSizeINTEL",
                    .opcode = 5750,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpSubgroupAvcImeAdjustRefOffsetINTEL",
                    .opcode = 5751,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpSubgroupAvcImeConvertToMcePayloadINTEL",
                    .opcode = 5752,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpSubgroupAvcImeSetMaxMotionVectorCountINTEL",
                    .opcode = 5753,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpSubgroupAvcImeSetUnidirectionalMixDisableINTEL",
                    .opcode = 5754,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpSubgroupAvcImeSetEarlySearchTerminationThresholdINTEL",
                    .opcode = 5755,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpSubgroupAvcImeSetWeightedSadINTEL",
                    .opcode = 5756,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpSubgroupAvcImeEvaluateWithSingleReferenceINTEL",
                    .opcode = 5757,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpSubgroupAvcImeEvaluateWithDualReferenceINTEL",
                    .opcode = 5758,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpSubgroupAvcImeEvaluateWithSingleReferenceStreaminINTEL",
                    .opcode = 5759,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpSubgroupAvcImeEvaluateWithDualReferenceStreaminINTEL",
                    .opcode = 5760,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpSubgroupAvcImeEvaluateWithSingleReferenceStreamoutINTEL",
                    .opcode = 5761,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpSubgroupAvcImeEvaluateWithDualReferenceStreamoutINTEL",
                    .opcode = 5762,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpSubgroupAvcImeEvaluateWithSingleReferenceStreaminoutINTEL",
                    .opcode = 5763,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpSubgroupAvcImeEvaluateWithDualReferenceStreaminoutINTEL",
                    .opcode = 5764,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpSubgroupAvcImeConvertToMceResultINTEL",
                    .opcode = 5765,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpSubgroupAvcImeGetSingleReferenceStreaminINTEL",
                    .opcode = 5766,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpSubgroupAvcImeGetDualReferenceStreaminINTEL",
                    .opcode = 5767,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpSubgroupAvcImeStripSingleReferenceStreamoutINTEL",
                    .opcode = 5768,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpSubgroupAvcImeStripDualReferenceStreamoutINTEL",
                    .opcode = 5769,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpSubgroupAvcImeGetStreamoutSingleReferenceMajorShapeMotionVectorsINTEL",
                    .opcode = 5770,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpSubgroupAvcImeGetStreamoutSingleReferenceMajorShapeDistortionsINTEL",
                    .opcode = 5771,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpSubgroupAvcImeGetStreamoutSingleReferenceMajorShapeReferenceIdsINTEL",
                    .opcode = 5772,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpSubgroupAvcImeGetStreamoutDualReferenceMajorShapeMotionVectorsINTEL",
                    .opcode = 5773,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpSubgroupAvcImeGetStreamoutDualReferenceMajorShapeDistortionsINTEL",
                    .opcode = 5774,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpSubgroupAvcImeGetStreamoutDualReferenceMajorShapeReferenceIdsINTEL",
                    .opcode = 5775,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpSubgroupAvcImeGetBorderReachedINTEL",
                    .opcode = 5776,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpSubgroupAvcImeGetTruncatedSearchIndicationINTEL",
                    .opcode = 5777,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpSubgroupAvcImeGetUnidirectionalEarlySearchTerminationINTEL",
                    .opcode = 5778,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpSubgroupAvcImeGetWeightingPatternMinimumMotionVectorINTEL",
                    .opcode = 5779,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpSubgroupAvcImeGetWeightingPatternMinimumDistortionINTEL",
                    .opcode = 5780,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpSubgroupAvcFmeInitializeINTEL",
                    .opcode = 5781,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpSubgroupAvcBmeInitializeINTEL",
                    .opcode = 5782,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpSubgroupAvcRefConvertToMcePayloadINTEL",
                    .opcode = 5783,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpSubgroupAvcRefSetBidirectionalMixDisableINTEL",
                    .opcode = 5784,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpSubgroupAvcRefSetBilinearFilterEnableINTEL",
                    .opcode = 5785,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpSubgroupAvcRefEvaluateWithSingleReferenceINTEL",
                    .opcode = 5786,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpSubgroupAvcRefEvaluateWithDualReferenceINTEL",
                    .opcode = 5787,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpSubgroupAvcRefEvaluateWithMultiReferenceINTEL",
                    .opcode = 5788,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpSubgroupAvcRefEvaluateWithMultiReferenceInterlacedINTEL",
                    .opcode = 5789,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpSubgroupAvcRefConvertToMceResultINTEL",
                    .opcode = 5790,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpSubgroupAvcSicInitializeINTEL",
                    .opcode = 5791,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpSubgroupAvcSicConfigureSkcINTEL",
                    .opcode = 5792,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpSubgroupAvcSicConfigureIpeLumaINTEL",
                    .opcode = 5793,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpSubgroupAvcSicConfigureIpeLumaChromaINTEL",
                    .opcode = 5794,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpSubgroupAvcSicGetMotionVectorMaskINTEL",
                    .opcode = 5795,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpSubgroupAvcSicConvertToMcePayloadINTEL",
                    .opcode = 5796,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpSubgroupAvcSicSetIntraLumaShapePenaltyINTEL",
                    .opcode = 5797,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpSubgroupAvcSicSetIntraLumaModeCostFunctionINTEL",
                    .opcode = 5798,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpSubgroupAvcSicSetIntraChromaModeCostFunctionINTEL",
                    .opcode = 5799,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpSubgroupAvcSicSetBilinearFilterEnableINTEL",
                    .opcode = 5800,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpSubgroupAvcSicSetSkcForwardTransformEnableINTEL",
                    .opcode = 5801,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpSubgroupAvcSicSetBlockBasedRawSkipSadINTEL",
                    .opcode = 5802,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpSubgroupAvcSicEvaluateIpeINTEL",
                    .opcode = 5803,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpSubgroupAvcSicEvaluateWithSingleReferenceINTEL",
                    .opcode = 5804,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpSubgroupAvcSicEvaluateWithDualReferenceINTEL",
                    .opcode = 5805,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpSubgroupAvcSicEvaluateWithMultiReferenceINTEL",
                    .opcode = 5806,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpSubgroupAvcSicEvaluateWithMultiReferenceInterlacedINTEL",
                    .opcode = 5807,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpSubgroupAvcSicConvertToMceResultINTEL",
                    .opcode = 5808,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpSubgroupAvcSicGetIpeLumaShapeINTEL",
                    .opcode = 5809,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpSubgroupAvcSicGetBestIpeLumaDistortionINTEL",
                    .opcode = 5810,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpSubgroupAvcSicGetBestIpeChromaDistortionINTEL",
                    .opcode = 5811,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpSubgroupAvcSicGetPackedIpeLumaModesINTEL",
                    .opcode = 5812,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpSubgroupAvcSicGetIpeChromaModeINTEL",
                    .opcode = 5813,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpSubgroupAvcSicGetPackedSkcLumaCountThresholdINTEL",
                    .opcode = 5814,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpSubgroupAvcSicGetPackedSkcLumaSumThresholdINTEL",
                    .opcode = 5815,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpSubgroupAvcSicGetInterRawSadsINTEL",
                    .opcode = 5816,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpVariableLengthArrayINTEL",
                    .opcode = 5818,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpSaveMemoryINTEL",
                    .opcode = 5819,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpRestoreMemoryINTEL",
                    .opcode = 5820,
                    .operands = &[_]Operand{
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpArbitraryFloatSinCosPiINTEL",
                    .opcode = 5840,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .LiteralInteger, .quantifier = .required },
                        .{ .kind = .LiteralInteger, .quantifier = .required },
                        .{ .kind = .LiteralInteger, .quantifier = .required },
                        .{ .kind = .LiteralInteger, .quantifier = .required },
                        .{ .kind = .LiteralInteger, .quantifier = .required },
                        .{ .kind = .LiteralInteger, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpArbitraryFloatCastINTEL",
                    .opcode = 5841,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .LiteralInteger, .quantifier = .required },
                        .{ .kind = .LiteralInteger, .quantifier = .required },
                        .{ .kind = .LiteralInteger, .quantifier = .required },
                        .{ .kind = .LiteralInteger, .quantifier = .required },
                        .{ .kind = .LiteralInteger, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpArbitraryFloatCastFromIntINTEL",
                    .opcode = 5842,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .LiteralInteger, .quantifier = .required },
                        .{ .kind = .LiteralInteger, .quantifier = .required },
                        .{ .kind = .LiteralInteger, .quantifier = .required },
                        .{ .kind = .LiteralInteger, .quantifier = .required },
                        .{ .kind = .LiteralInteger, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpArbitraryFloatCastToIntINTEL",
                    .opcode = 5843,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .LiteralInteger, .quantifier = .required },
                        .{ .kind = .LiteralInteger, .quantifier = .required },
                        .{ .kind = .LiteralInteger, .quantifier = .required },
                        .{ .kind = .LiteralInteger, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpArbitraryFloatAddINTEL",
                    .opcode = 5846,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .LiteralInteger, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .LiteralInteger, .quantifier = .required },
                        .{ .kind = .LiteralInteger, .quantifier = .required },
                        .{ .kind = .LiteralInteger, .quantifier = .required },
                        .{ .kind = .LiteralInteger, .quantifier = .required },
                        .{ .kind = .LiteralInteger, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpArbitraryFloatSubINTEL",
                    .opcode = 5847,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .LiteralInteger, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .LiteralInteger, .quantifier = .required },
                        .{ .kind = .LiteralInteger, .quantifier = .required },
                        .{ .kind = .LiteralInteger, .quantifier = .required },
                        .{ .kind = .LiteralInteger, .quantifier = .required },
                        .{ .kind = .LiteralInteger, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpArbitraryFloatMulINTEL",
                    .opcode = 5848,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .LiteralInteger, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .LiteralInteger, .quantifier = .required },
                        .{ .kind = .LiteralInteger, .quantifier = .required },
                        .{ .kind = .LiteralInteger, .quantifier = .required },
                        .{ .kind = .LiteralInteger, .quantifier = .required },
                        .{ .kind = .LiteralInteger, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpArbitraryFloatDivINTEL",
                    .opcode = 5849,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .LiteralInteger, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .LiteralInteger, .quantifier = .required },
                        .{ .kind = .LiteralInteger, .quantifier = .required },
                        .{ .kind = .LiteralInteger, .quantifier = .required },
                        .{ .kind = .LiteralInteger, .quantifier = .required },
                        .{ .kind = .LiteralInteger, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpArbitraryFloatGTINTEL",
                    .opcode = 5850,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .LiteralInteger, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .LiteralInteger, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpArbitraryFloatGEINTEL",
                    .opcode = 5851,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .LiteralInteger, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .LiteralInteger, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpArbitraryFloatLTINTEL",
                    .opcode = 5852,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .LiteralInteger, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .LiteralInteger, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpArbitraryFloatLEINTEL",
                    .opcode = 5853,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .LiteralInteger, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .LiteralInteger, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpArbitraryFloatEQINTEL",
                    .opcode = 5854,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .LiteralInteger, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .LiteralInteger, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpArbitraryFloatRecipINTEL",
                    .opcode = 5855,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .LiteralInteger, .quantifier = .required },
                        .{ .kind = .LiteralInteger, .quantifier = .required },
                        .{ .kind = .LiteralInteger, .quantifier = .required },
                        .{ .kind = .LiteralInteger, .quantifier = .required },
                        .{ .kind = .LiteralInteger, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpArbitraryFloatRSqrtINTEL",
                    .opcode = 5856,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .LiteralInteger, .quantifier = .required },
                        .{ .kind = .LiteralInteger, .quantifier = .required },
                        .{ .kind = .LiteralInteger, .quantifier = .required },
                        .{ .kind = .LiteralInteger, .quantifier = .required },
                        .{ .kind = .LiteralInteger, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpArbitraryFloatCbrtINTEL",
                    .opcode = 5857,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .LiteralInteger, .quantifier = .required },
                        .{ .kind = .LiteralInteger, .quantifier = .required },
                        .{ .kind = .LiteralInteger, .quantifier = .required },
                        .{ .kind = .LiteralInteger, .quantifier = .required },
                        .{ .kind = .LiteralInteger, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpArbitraryFloatHypotINTEL",
                    .opcode = 5858,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .LiteralInteger, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .LiteralInteger, .quantifier = .required },
                        .{ .kind = .LiteralInteger, .quantifier = .required },
                        .{ .kind = .LiteralInteger, .quantifier = .required },
                        .{ .kind = .LiteralInteger, .quantifier = .required },
                        .{ .kind = .LiteralInteger, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpArbitraryFloatSqrtINTEL",
                    .opcode = 5859,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .LiteralInteger, .quantifier = .required },
                        .{ .kind = .LiteralInteger, .quantifier = .required },
                        .{ .kind = .LiteralInteger, .quantifier = .required },
                        .{ .kind = .LiteralInteger, .quantifier = .required },
                        .{ .kind = .LiteralInteger, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpArbitraryFloatLogINTEL",
                    .opcode = 5860,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .LiteralInteger, .quantifier = .required },
                        .{ .kind = .LiteralInteger, .quantifier = .required },
                        .{ .kind = .LiteralInteger, .quantifier = .required },
                        .{ .kind = .LiteralInteger, .quantifier = .required },
                        .{ .kind = .LiteralInteger, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpArbitraryFloatLog2INTEL",
                    .opcode = 5861,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .LiteralInteger, .quantifier = .required },
                        .{ .kind = .LiteralInteger, .quantifier = .required },
                        .{ .kind = .LiteralInteger, .quantifier = .required },
                        .{ .kind = .LiteralInteger, .quantifier = .required },
                        .{ .kind = .LiteralInteger, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpArbitraryFloatLog10INTEL",
                    .opcode = 5862,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .LiteralInteger, .quantifier = .required },
                        .{ .kind = .LiteralInteger, .quantifier = .required },
                        .{ .kind = .LiteralInteger, .quantifier = .required },
                        .{ .kind = .LiteralInteger, .quantifier = .required },
                        .{ .kind = .LiteralInteger, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpArbitraryFloatLog1pINTEL",
                    .opcode = 5863,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .LiteralInteger, .quantifier = .required },
                        .{ .kind = .LiteralInteger, .quantifier = .required },
                        .{ .kind = .LiteralInteger, .quantifier = .required },
                        .{ .kind = .LiteralInteger, .quantifier = .required },
                        .{ .kind = .LiteralInteger, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpArbitraryFloatExpINTEL",
                    .opcode = 5864,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .LiteralInteger, .quantifier = .required },
                        .{ .kind = .LiteralInteger, .quantifier = .required },
                        .{ .kind = .LiteralInteger, .quantifier = .required },
                        .{ .kind = .LiteralInteger, .quantifier = .required },
                        .{ .kind = .LiteralInteger, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpArbitraryFloatExp2INTEL",
                    .opcode = 5865,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .LiteralInteger, .quantifier = .required },
                        .{ .kind = .LiteralInteger, .quantifier = .required },
                        .{ .kind = .LiteralInteger, .quantifier = .required },
                        .{ .kind = .LiteralInteger, .quantifier = .required },
                        .{ .kind = .LiteralInteger, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpArbitraryFloatExp10INTEL",
                    .opcode = 5866,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .LiteralInteger, .quantifier = .required },
                        .{ .kind = .LiteralInteger, .quantifier = .required },
                        .{ .kind = .LiteralInteger, .quantifier = .required },
                        .{ .kind = .LiteralInteger, .quantifier = .required },
                        .{ .kind = .LiteralInteger, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpArbitraryFloatExpm1INTEL",
                    .opcode = 5867,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .LiteralInteger, .quantifier = .required },
                        .{ .kind = .LiteralInteger, .quantifier = .required },
                        .{ .kind = .LiteralInteger, .quantifier = .required },
                        .{ .kind = .LiteralInteger, .quantifier = .required },
                        .{ .kind = .LiteralInteger, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpArbitraryFloatSinINTEL",
                    .opcode = 5868,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .LiteralInteger, .quantifier = .required },
                        .{ .kind = .LiteralInteger, .quantifier = .required },
                        .{ .kind = .LiteralInteger, .quantifier = .required },
                        .{ .kind = .LiteralInteger, .quantifier = .required },
                        .{ .kind = .LiteralInteger, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpArbitraryFloatCosINTEL",
                    .opcode = 5869,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .LiteralInteger, .quantifier = .required },
                        .{ .kind = .LiteralInteger, .quantifier = .required },
                        .{ .kind = .LiteralInteger, .quantifier = .required },
                        .{ .kind = .LiteralInteger, .quantifier = .required },
                        .{ .kind = .LiteralInteger, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpArbitraryFloatSinCosINTEL",
                    .opcode = 5870,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .LiteralInteger, .quantifier = .required },
                        .{ .kind = .LiteralInteger, .quantifier = .required },
                        .{ .kind = .LiteralInteger, .quantifier = .required },
                        .{ .kind = .LiteralInteger, .quantifier = .required },
                        .{ .kind = .LiteralInteger, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpArbitraryFloatSinPiINTEL",
                    .opcode = 5871,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .LiteralInteger, .quantifier = .required },
                        .{ .kind = .LiteralInteger, .quantifier = .required },
                        .{ .kind = .LiteralInteger, .quantifier = .required },
                        .{ .kind = .LiteralInteger, .quantifier = .required },
                        .{ .kind = .LiteralInteger, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpArbitraryFloatCosPiINTEL",
                    .opcode = 5872,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .LiteralInteger, .quantifier = .required },
                        .{ .kind = .LiteralInteger, .quantifier = .required },
                        .{ .kind = .LiteralInteger, .quantifier = .required },
                        .{ .kind = .LiteralInteger, .quantifier = .required },
                        .{ .kind = .LiteralInteger, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpArbitraryFloatASinINTEL",
                    .opcode = 5873,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .LiteralInteger, .quantifier = .required },
                        .{ .kind = .LiteralInteger, .quantifier = .required },
                        .{ .kind = .LiteralInteger, .quantifier = .required },
                        .{ .kind = .LiteralInteger, .quantifier = .required },
                        .{ .kind = .LiteralInteger, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpArbitraryFloatASinPiINTEL",
                    .opcode = 5874,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .LiteralInteger, .quantifier = .required },
                        .{ .kind = .LiteralInteger, .quantifier = .required },
                        .{ .kind = .LiteralInteger, .quantifier = .required },
                        .{ .kind = .LiteralInteger, .quantifier = .required },
                        .{ .kind = .LiteralInteger, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpArbitraryFloatACosINTEL",
                    .opcode = 5875,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .LiteralInteger, .quantifier = .required },
                        .{ .kind = .LiteralInteger, .quantifier = .required },
                        .{ .kind = .LiteralInteger, .quantifier = .required },
                        .{ .kind = .LiteralInteger, .quantifier = .required },
                        .{ .kind = .LiteralInteger, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpArbitraryFloatACosPiINTEL",
                    .opcode = 5876,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .LiteralInteger, .quantifier = .required },
                        .{ .kind = .LiteralInteger, .quantifier = .required },
                        .{ .kind = .LiteralInteger, .quantifier = .required },
                        .{ .kind = .LiteralInteger, .quantifier = .required },
                        .{ .kind = .LiteralInteger, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpArbitraryFloatATanINTEL",
                    .opcode = 5877,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .LiteralInteger, .quantifier = .required },
                        .{ .kind = .LiteralInteger, .quantifier = .required },
                        .{ .kind = .LiteralInteger, .quantifier = .required },
                        .{ .kind = .LiteralInteger, .quantifier = .required },
                        .{ .kind = .LiteralInteger, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpArbitraryFloatATanPiINTEL",
                    .opcode = 5878,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .LiteralInteger, .quantifier = .required },
                        .{ .kind = .LiteralInteger, .quantifier = .required },
                        .{ .kind = .LiteralInteger, .quantifier = .required },
                        .{ .kind = .LiteralInteger, .quantifier = .required },
                        .{ .kind = .LiteralInteger, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpArbitraryFloatATan2INTEL",
                    .opcode = 5879,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .LiteralInteger, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .LiteralInteger, .quantifier = .required },
                        .{ .kind = .LiteralInteger, .quantifier = .required },
                        .{ .kind = .LiteralInteger, .quantifier = .required },
                        .{ .kind = .LiteralInteger, .quantifier = .required },
                        .{ .kind = .LiteralInteger, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpArbitraryFloatPowINTEL",
                    .opcode = 5880,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .LiteralInteger, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .LiteralInteger, .quantifier = .required },
                        .{ .kind = .LiteralInteger, .quantifier = .required },
                        .{ .kind = .LiteralInteger, .quantifier = .required },
                        .{ .kind = .LiteralInteger, .quantifier = .required },
                        .{ .kind = .LiteralInteger, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpArbitraryFloatPowRINTEL",
                    .opcode = 5881,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .LiteralInteger, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .LiteralInteger, .quantifier = .required },
                        .{ .kind = .LiteralInteger, .quantifier = .required },
                        .{ .kind = .LiteralInteger, .quantifier = .required },
                        .{ .kind = .LiteralInteger, .quantifier = .required },
                        .{ .kind = .LiteralInteger, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpArbitraryFloatPowNINTEL",
                    .opcode = 5882,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .LiteralInteger, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .LiteralInteger, .quantifier = .required },
                        .{ .kind = .LiteralInteger, .quantifier = .required },
                        .{ .kind = .LiteralInteger, .quantifier = .required },
                        .{ .kind = .LiteralInteger, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpLoopControlINTEL",
                    .opcode = 5887,
                    .operands = &[_]Operand{
                        .{ .kind = .LiteralInteger, .quantifier = .variadic },
                    },
                },
                .{
                    .name = "OpAliasDomainDeclINTEL",
                    .opcode = 5911,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .optional },
                    },
                },
                .{
                    .name = "OpAliasScopeDeclINTEL",
                    .opcode = 5912,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .optional },
                    },
                },
                .{
                    .name = "OpAliasScopeListDeclINTEL",
                    .opcode = 5913,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .variadic },
                    },
                },
                .{
                    .name = "OpFixedSqrtINTEL",
                    .opcode = 5923,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .LiteralInteger, .quantifier = .required },
                        .{ .kind = .LiteralInteger, .quantifier = .required },
                        .{ .kind = .LiteralInteger, .quantifier = .required },
                        .{ .kind = .LiteralInteger, .quantifier = .required },
                        .{ .kind = .LiteralInteger, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpFixedRecipINTEL",
                    .opcode = 5924,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .LiteralInteger, .quantifier = .required },
                        .{ .kind = .LiteralInteger, .quantifier = .required },
                        .{ .kind = .LiteralInteger, .quantifier = .required },
                        .{ .kind = .LiteralInteger, .quantifier = .required },
                        .{ .kind = .LiteralInteger, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpFixedRsqrtINTEL",
                    .opcode = 5925,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .LiteralInteger, .quantifier = .required },
                        .{ .kind = .LiteralInteger, .quantifier = .required },
                        .{ .kind = .LiteralInteger, .quantifier = .required },
                        .{ .kind = .LiteralInteger, .quantifier = .required },
                        .{ .kind = .LiteralInteger, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpFixedSinINTEL",
                    .opcode = 5926,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .LiteralInteger, .quantifier = .required },
                        .{ .kind = .LiteralInteger, .quantifier = .required },
                        .{ .kind = .LiteralInteger, .quantifier = .required },
                        .{ .kind = .LiteralInteger, .quantifier = .required },
                        .{ .kind = .LiteralInteger, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpFixedCosINTEL",
                    .opcode = 5927,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .LiteralInteger, .quantifier = .required },
                        .{ .kind = .LiteralInteger, .quantifier = .required },
                        .{ .kind = .LiteralInteger, .quantifier = .required },
                        .{ .kind = .LiteralInteger, .quantifier = .required },
                        .{ .kind = .LiteralInteger, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpFixedSinCosINTEL",
                    .opcode = 5928,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .LiteralInteger, .quantifier = .required },
                        .{ .kind = .LiteralInteger, .quantifier = .required },
                        .{ .kind = .LiteralInteger, .quantifier = .required },
                        .{ .kind = .LiteralInteger, .quantifier = .required },
                        .{ .kind = .LiteralInteger, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpFixedSinPiINTEL",
                    .opcode = 5929,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .LiteralInteger, .quantifier = .required },
                        .{ .kind = .LiteralInteger, .quantifier = .required },
                        .{ .kind = .LiteralInteger, .quantifier = .required },
                        .{ .kind = .LiteralInteger, .quantifier = .required },
                        .{ .kind = .LiteralInteger, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpFixedCosPiINTEL",
                    .opcode = 5930,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .LiteralInteger, .quantifier = .required },
                        .{ .kind = .LiteralInteger, .quantifier = .required },
                        .{ .kind = .LiteralInteger, .quantifier = .required },
                        .{ .kind = .LiteralInteger, .quantifier = .required },
                        .{ .kind = .LiteralInteger, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpFixedSinCosPiINTEL",
                    .opcode = 5931,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .LiteralInteger, .quantifier = .required },
                        .{ .kind = .LiteralInteger, .quantifier = .required },
                        .{ .kind = .LiteralInteger, .quantifier = .required },
                        .{ .kind = .LiteralInteger, .quantifier = .required },
                        .{ .kind = .LiteralInteger, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpFixedLogINTEL",
                    .opcode = 5932,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .LiteralInteger, .quantifier = .required },
                        .{ .kind = .LiteralInteger, .quantifier = .required },
                        .{ .kind = .LiteralInteger, .quantifier = .required },
                        .{ .kind = .LiteralInteger, .quantifier = .required },
                        .{ .kind = .LiteralInteger, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpFixedExpINTEL",
                    .opcode = 5933,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .LiteralInteger, .quantifier = .required },
                        .{ .kind = .LiteralInteger, .quantifier = .required },
                        .{ .kind = .LiteralInteger, .quantifier = .required },
                        .{ .kind = .LiteralInteger, .quantifier = .required },
                        .{ .kind = .LiteralInteger, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpPtrCastToCrossWorkgroupINTEL",
                    .opcode = 5934,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpCrossWorkgroupCastToPtrINTEL",
                    .opcode = 5938,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpReadPipeBlockingINTEL",
                    .opcode = 5946,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpWritePipeBlockingINTEL",
                    .opcode = 5947,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpFPGARegINTEL",
                    .opcode = 5949,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpRayQueryGetRayTMinKHR",
                    .opcode = 6016,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpRayQueryGetRayFlagsKHR",
                    .opcode = 6017,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpRayQueryGetIntersectionTKHR",
                    .opcode = 6018,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpRayQueryGetIntersectionInstanceCustomIndexKHR",
                    .opcode = 6019,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpRayQueryGetIntersectionInstanceIdKHR",
                    .opcode = 6020,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpRayQueryGetIntersectionInstanceShaderBindingTableRecordOffsetKHR",
                    .opcode = 6021,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpRayQueryGetIntersectionGeometryIndexKHR",
                    .opcode = 6022,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpRayQueryGetIntersectionPrimitiveIndexKHR",
                    .opcode = 6023,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpRayQueryGetIntersectionBarycentricsKHR",
                    .opcode = 6024,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpRayQueryGetIntersectionFrontFaceKHR",
                    .opcode = 6025,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpRayQueryGetIntersectionCandidateAABBOpaqueKHR",
                    .opcode = 6026,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpRayQueryGetIntersectionObjectRayDirectionKHR",
                    .opcode = 6027,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpRayQueryGetIntersectionObjectRayOriginKHR",
                    .opcode = 6028,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpRayQueryGetWorldRayDirectionKHR",
                    .opcode = 6029,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpRayQueryGetWorldRayOriginKHR",
                    .opcode = 6030,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpRayQueryGetIntersectionObjectToWorldKHR",
                    .opcode = 6031,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpRayQueryGetIntersectionWorldToObjectKHR",
                    .opcode = 6032,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpAtomicFAddEXT",
                    .opcode = 6035,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdScope, .quantifier = .required },
                        .{ .kind = .IdMemorySemantics, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpTypeBufferSurfaceINTEL",
                    .opcode = 6086,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .AccessQualifier, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpTypeStructContinuedINTEL",
                    .opcode = 6090,
                    .operands = &[_]Operand{
                        .{ .kind = .IdRef, .quantifier = .variadic },
                    },
                },
                .{
                    .name = "OpConstantCompositeContinuedINTEL",
                    .opcode = 6091,
                    .operands = &[_]Operand{
                        .{ .kind = .IdRef, .quantifier = .variadic },
                    },
                },
                .{
                    .name = "OpSpecConstantCompositeContinuedINTEL",
                    .opcode = 6092,
                    .operands = &[_]Operand{
                        .{ .kind = .IdRef, .quantifier = .variadic },
                    },
                },
                .{
                    .name = "OpCompositeConstructContinuedINTEL",
                    .opcode = 6096,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .variadic },
                    },
                },
                .{
                    .name = "OpConvertFToBF16INTEL",
                    .opcode = 6116,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpConvertBF16ToFINTEL",
                    .opcode = 6117,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpControlBarrierArriveINTEL",
                    .opcode = 6142,
                    .operands = &[_]Operand{
                        .{ .kind = .IdScope, .quantifier = .required },
                        .{ .kind = .IdScope, .quantifier = .required },
                        .{ .kind = .IdMemorySemantics, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpControlBarrierWaitINTEL",
                    .opcode = 6143,
                    .operands = &[_]Operand{
                        .{ .kind = .IdScope, .quantifier = .required },
                        .{ .kind = .IdScope, .quantifier = .required },
                        .{ .kind = .IdMemorySemantics, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpGroupIMulKHR",
                    .opcode = 6401,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdScope, .quantifier = .required },
                        .{ .kind = .GroupOperation, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpGroupFMulKHR",
                    .opcode = 6402,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdScope, .quantifier = .required },
                        .{ .kind = .GroupOperation, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpGroupBitwiseAndKHR",
                    .opcode = 6403,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdScope, .quantifier = .required },
                        .{ .kind = .GroupOperation, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpGroupBitwiseOrKHR",
                    .opcode = 6404,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdScope, .quantifier = .required },
                        .{ .kind = .GroupOperation, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpGroupBitwiseXorKHR",
                    .opcode = 6405,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdScope, .quantifier = .required },
                        .{ .kind = .GroupOperation, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpGroupLogicalAndKHR",
                    .opcode = 6406,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdScope, .quantifier = .required },
                        .{ .kind = .GroupOperation, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpGroupLogicalOrKHR",
                    .opcode = 6407,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdScope, .quantifier = .required },
                        .{ .kind = .GroupOperation, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpGroupLogicalXorKHR",
                    .opcode = 6408,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdScope, .quantifier = .required },
                        .{ .kind = .GroupOperation, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpMaskedGatherINTEL",
                    .opcode = 6428,
                    .operands = &[_]Operand{
                        .{ .kind = .IdResultType, .quantifier = .required },
                        .{ .kind = .IdResult, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .LiteralInteger, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpMaskedScatterINTEL",
                    .opcode = 6429,
                    .operands = &[_]Operand{
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .LiteralInteger, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
            },
            .@"OpenCL.std" => &[_]Instruction{
                .{
                    .name = "acos",
                    .opcode = 0,
                    .operands = &[_]Operand{
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "acosh",
                    .opcode = 1,
                    .operands = &[_]Operand{
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "acospi",
                    .opcode = 2,
                    .operands = &[_]Operand{
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "asin",
                    .opcode = 3,
                    .operands = &[_]Operand{
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "asinh",
                    .opcode = 4,
                    .operands = &[_]Operand{
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "asinpi",
                    .opcode = 5,
                    .operands = &[_]Operand{
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "atan",
                    .opcode = 6,
                    .operands = &[_]Operand{
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "atan2",
                    .opcode = 7,
                    .operands = &[_]Operand{
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "atanh",
                    .opcode = 8,
                    .operands = &[_]Operand{
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "atanpi",
                    .opcode = 9,
                    .operands = &[_]Operand{
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "atan2pi",
                    .opcode = 10,
                    .operands = &[_]Operand{
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "cbrt",
                    .opcode = 11,
                    .operands = &[_]Operand{
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "ceil",
                    .opcode = 12,
                    .operands = &[_]Operand{
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "copysign",
                    .opcode = 13,
                    .operands = &[_]Operand{
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "cos",
                    .opcode = 14,
                    .operands = &[_]Operand{
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "cosh",
                    .opcode = 15,
                    .operands = &[_]Operand{
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "cospi",
                    .opcode = 16,
                    .operands = &[_]Operand{
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "erfc",
                    .opcode = 17,
                    .operands = &[_]Operand{
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "erf",
                    .opcode = 18,
                    .operands = &[_]Operand{
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "exp",
                    .opcode = 19,
                    .operands = &[_]Operand{
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "exp2",
                    .opcode = 20,
                    .operands = &[_]Operand{
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "exp10",
                    .opcode = 21,
                    .operands = &[_]Operand{
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "expm1",
                    .opcode = 22,
                    .operands = &[_]Operand{
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "fabs",
                    .opcode = 23,
                    .operands = &[_]Operand{
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "fdim",
                    .opcode = 24,
                    .operands = &[_]Operand{
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "floor",
                    .opcode = 25,
                    .operands = &[_]Operand{
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "fma",
                    .opcode = 26,
                    .operands = &[_]Operand{
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "fmax",
                    .opcode = 27,
                    .operands = &[_]Operand{
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "fmin",
                    .opcode = 28,
                    .operands = &[_]Operand{
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "fmod",
                    .opcode = 29,
                    .operands = &[_]Operand{
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "fract",
                    .opcode = 30,
                    .operands = &[_]Operand{
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "frexp",
                    .opcode = 31,
                    .operands = &[_]Operand{
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "hypot",
                    .opcode = 32,
                    .operands = &[_]Operand{
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "ilogb",
                    .opcode = 33,
                    .operands = &[_]Operand{
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "ldexp",
                    .opcode = 34,
                    .operands = &[_]Operand{
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "lgamma",
                    .opcode = 35,
                    .operands = &[_]Operand{
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "lgamma_r",
                    .opcode = 36,
                    .operands = &[_]Operand{
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "log",
                    .opcode = 37,
                    .operands = &[_]Operand{
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "log2",
                    .opcode = 38,
                    .operands = &[_]Operand{
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "log10",
                    .opcode = 39,
                    .operands = &[_]Operand{
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "log1p",
                    .opcode = 40,
                    .operands = &[_]Operand{
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "logb",
                    .opcode = 41,
                    .operands = &[_]Operand{
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "mad",
                    .opcode = 42,
                    .operands = &[_]Operand{
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "maxmag",
                    .opcode = 43,
                    .operands = &[_]Operand{
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "minmag",
                    .opcode = 44,
                    .operands = &[_]Operand{
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "modf",
                    .opcode = 45,
                    .operands = &[_]Operand{
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "nan",
                    .opcode = 46,
                    .operands = &[_]Operand{
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "nextafter",
                    .opcode = 47,
                    .operands = &[_]Operand{
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "pow",
                    .opcode = 48,
                    .operands = &[_]Operand{
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "pown",
                    .opcode = 49,
                    .operands = &[_]Operand{
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "powr",
                    .opcode = 50,
                    .operands = &[_]Operand{
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "remainder",
                    .opcode = 51,
                    .operands = &[_]Operand{
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "remquo",
                    .opcode = 52,
                    .operands = &[_]Operand{
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "rint",
                    .opcode = 53,
                    .operands = &[_]Operand{
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "rootn",
                    .opcode = 54,
                    .operands = &[_]Operand{
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "round",
                    .opcode = 55,
                    .operands = &[_]Operand{
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "rsqrt",
                    .opcode = 56,
                    .operands = &[_]Operand{
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "sin",
                    .opcode = 57,
                    .operands = &[_]Operand{
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "sincos",
                    .opcode = 58,
                    .operands = &[_]Operand{
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "sinh",
                    .opcode = 59,
                    .operands = &[_]Operand{
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "sinpi",
                    .opcode = 60,
                    .operands = &[_]Operand{
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "sqrt",
                    .opcode = 61,
                    .operands = &[_]Operand{
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "tan",
                    .opcode = 62,
                    .operands = &[_]Operand{
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "tanh",
                    .opcode = 63,
                    .operands = &[_]Operand{
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "tanpi",
                    .opcode = 64,
                    .operands = &[_]Operand{
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "tgamma",
                    .opcode = 65,
                    .operands = &[_]Operand{
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "trunc",
                    .opcode = 66,
                    .operands = &[_]Operand{
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "half_cos",
                    .opcode = 67,
                    .operands = &[_]Operand{
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "half_divide",
                    .opcode = 68,
                    .operands = &[_]Operand{
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "half_exp",
                    .opcode = 69,
                    .operands = &[_]Operand{
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "half_exp2",
                    .opcode = 70,
                    .operands = &[_]Operand{
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "half_exp10",
                    .opcode = 71,
                    .operands = &[_]Operand{
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "half_log",
                    .opcode = 72,
                    .operands = &[_]Operand{
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "half_log2",
                    .opcode = 73,
                    .operands = &[_]Operand{
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "half_log10",
                    .opcode = 74,
                    .operands = &[_]Operand{
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "half_powr",
                    .opcode = 75,
                    .operands = &[_]Operand{
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "half_recip",
                    .opcode = 76,
                    .operands = &[_]Operand{
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "half_rsqrt",
                    .opcode = 77,
                    .operands = &[_]Operand{
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "half_sin",
                    .opcode = 78,
                    .operands = &[_]Operand{
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "half_sqrt",
                    .opcode = 79,
                    .operands = &[_]Operand{
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "half_tan",
                    .opcode = 80,
                    .operands = &[_]Operand{
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "native_cos",
                    .opcode = 81,
                    .operands = &[_]Operand{
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "native_divide",
                    .opcode = 82,
                    .operands = &[_]Operand{
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "native_exp",
                    .opcode = 83,
                    .operands = &[_]Operand{
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "native_exp2",
                    .opcode = 84,
                    .operands = &[_]Operand{
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "native_exp10",
                    .opcode = 85,
                    .operands = &[_]Operand{
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "native_log",
                    .opcode = 86,
                    .operands = &[_]Operand{
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "native_log2",
                    .opcode = 87,
                    .operands = &[_]Operand{
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "native_log10",
                    .opcode = 88,
                    .operands = &[_]Operand{
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "native_powr",
                    .opcode = 89,
                    .operands = &[_]Operand{
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "native_recip",
                    .opcode = 90,
                    .operands = &[_]Operand{
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "native_rsqrt",
                    .opcode = 91,
                    .operands = &[_]Operand{
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "native_sin",
                    .opcode = 92,
                    .operands = &[_]Operand{
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "native_sqrt",
                    .opcode = 93,
                    .operands = &[_]Operand{
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "native_tan",
                    .opcode = 94,
                    .operands = &[_]Operand{
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "fclamp",
                    .opcode = 95,
                    .operands = &[_]Operand{
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "degrees",
                    .opcode = 96,
                    .operands = &[_]Operand{
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "fmax_common",
                    .opcode = 97,
                    .operands = &[_]Operand{
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "fmin_common",
                    .opcode = 98,
                    .operands = &[_]Operand{
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "mix",
                    .opcode = 99,
                    .operands = &[_]Operand{
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "radians",
                    .opcode = 100,
                    .operands = &[_]Operand{
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "step",
                    .opcode = 101,
                    .operands = &[_]Operand{
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "smoothstep",
                    .opcode = 102,
                    .operands = &[_]Operand{
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "sign",
                    .opcode = 103,
                    .operands = &[_]Operand{
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "cross",
                    .opcode = 104,
                    .operands = &[_]Operand{
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "distance",
                    .opcode = 105,
                    .operands = &[_]Operand{
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "length",
                    .opcode = 106,
                    .operands = &[_]Operand{
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "normalize",
                    .opcode = 107,
                    .operands = &[_]Operand{
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "fast_distance",
                    .opcode = 108,
                    .operands = &[_]Operand{
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "fast_length",
                    .opcode = 109,
                    .operands = &[_]Operand{
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "fast_normalize",
                    .opcode = 110,
                    .operands = &[_]Operand{
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "s_abs",
                    .opcode = 141,
                    .operands = &[_]Operand{
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "s_abs_diff",
                    .opcode = 142,
                    .operands = &[_]Operand{
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "s_add_sat",
                    .opcode = 143,
                    .operands = &[_]Operand{
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "u_add_sat",
                    .opcode = 144,
                    .operands = &[_]Operand{
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "s_hadd",
                    .opcode = 145,
                    .operands = &[_]Operand{
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "u_hadd",
                    .opcode = 146,
                    .operands = &[_]Operand{
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "s_rhadd",
                    .opcode = 147,
                    .operands = &[_]Operand{
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "u_rhadd",
                    .opcode = 148,
                    .operands = &[_]Operand{
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "s_clamp",
                    .opcode = 149,
                    .operands = &[_]Operand{
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "u_clamp",
                    .opcode = 150,
                    .operands = &[_]Operand{
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "clz",
                    .opcode = 151,
                    .operands = &[_]Operand{
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "ctz",
                    .opcode = 152,
                    .operands = &[_]Operand{
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "s_mad_hi",
                    .opcode = 153,
                    .operands = &[_]Operand{
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "u_mad_sat",
                    .opcode = 154,
                    .operands = &[_]Operand{
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "s_mad_sat",
                    .opcode = 155,
                    .operands = &[_]Operand{
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "s_max",
                    .opcode = 156,
                    .operands = &[_]Operand{
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "u_max",
                    .opcode = 157,
                    .operands = &[_]Operand{
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "s_min",
                    .opcode = 158,
                    .operands = &[_]Operand{
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "u_min",
                    .opcode = 159,
                    .operands = &[_]Operand{
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "s_mul_hi",
                    .opcode = 160,
                    .operands = &[_]Operand{
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "rotate",
                    .opcode = 161,
                    .operands = &[_]Operand{
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "s_sub_sat",
                    .opcode = 162,
                    .operands = &[_]Operand{
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "u_sub_sat",
                    .opcode = 163,
                    .operands = &[_]Operand{
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "u_upsample",
                    .opcode = 164,
                    .operands = &[_]Operand{
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "s_upsample",
                    .opcode = 165,
                    .operands = &[_]Operand{
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "popcount",
                    .opcode = 166,
                    .operands = &[_]Operand{
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "s_mad24",
                    .opcode = 167,
                    .operands = &[_]Operand{
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "u_mad24",
                    .opcode = 168,
                    .operands = &[_]Operand{
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "s_mul24",
                    .opcode = 169,
                    .operands = &[_]Operand{
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "u_mul24",
                    .opcode = 170,
                    .operands = &[_]Operand{
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "vloadn",
                    .opcode = 171,
                    .operands = &[_]Operand{
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .LiteralInteger, .quantifier = .required },
                    },
                },
                .{
                    .name = "vstoren",
                    .opcode = 172,
                    .operands = &[_]Operand{
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "vload_half",
                    .opcode = 173,
                    .operands = &[_]Operand{
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "vload_halfn",
                    .opcode = 174,
                    .operands = &[_]Operand{
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .LiteralInteger, .quantifier = .required },
                    },
                },
                .{
                    .name = "vstore_half",
                    .opcode = 175,
                    .operands = &[_]Operand{
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "vstore_half_r",
                    .opcode = 176,
                    .operands = &[_]Operand{
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .FPRoundingMode, .quantifier = .required },
                    },
                },
                .{
                    .name = "vstore_halfn",
                    .opcode = 177,
                    .operands = &[_]Operand{
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "vstore_halfn_r",
                    .opcode = 178,
                    .operands = &[_]Operand{
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .FPRoundingMode, .quantifier = .required },
                    },
                },
                .{
                    .name = "vloada_halfn",
                    .opcode = 179,
                    .operands = &[_]Operand{
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .LiteralInteger, .quantifier = .required },
                    },
                },
                .{
                    .name = "vstorea_halfn",
                    .opcode = 180,
                    .operands = &[_]Operand{
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "vstorea_halfn_r",
                    .opcode = 181,
                    .operands = &[_]Operand{
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .FPRoundingMode, .quantifier = .required },
                    },
                },
                .{
                    .name = "shuffle",
                    .opcode = 182,
                    .operands = &[_]Operand{
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "shuffle2",
                    .opcode = 183,
                    .operands = &[_]Operand{
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "printf",
                    .opcode = 184,
                    .operands = &[_]Operand{
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .variadic },
                    },
                },
                .{
                    .name = "prefetch",
                    .opcode = 185,
                    .operands = &[_]Operand{
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "bitselect",
                    .opcode = 186,
                    .operands = &[_]Operand{
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "select",
                    .opcode = 187,
                    .operands = &[_]Operand{
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "u_abs",
                    .opcode = 201,
                    .operands = &[_]Operand{
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "u_abs_diff",
                    .opcode = 202,
                    .operands = &[_]Operand{
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "u_mul_hi",
                    .opcode = 203,
                    .operands = &[_]Operand{
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "u_mad_hi",
                    .opcode = 204,
                    .operands = &[_]Operand{
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
            },
            .@"GLSL.std.450" => &[_]Instruction{
                .{
                    .name = "Round",
                    .opcode = 1,
                    .operands = &[_]Operand{
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "RoundEven",
                    .opcode = 2,
                    .operands = &[_]Operand{
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "Trunc",
                    .opcode = 3,
                    .operands = &[_]Operand{
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "FAbs",
                    .opcode = 4,
                    .operands = &[_]Operand{
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "SAbs",
                    .opcode = 5,
                    .operands = &[_]Operand{
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "FSign",
                    .opcode = 6,
                    .operands = &[_]Operand{
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "SSign",
                    .opcode = 7,
                    .operands = &[_]Operand{
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "Floor",
                    .opcode = 8,
                    .operands = &[_]Operand{
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "Ceil",
                    .opcode = 9,
                    .operands = &[_]Operand{
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "Fract",
                    .opcode = 10,
                    .operands = &[_]Operand{
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "Radians",
                    .opcode = 11,
                    .operands = &[_]Operand{
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "Degrees",
                    .opcode = 12,
                    .operands = &[_]Operand{
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "Sin",
                    .opcode = 13,
                    .operands = &[_]Operand{
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "Cos",
                    .opcode = 14,
                    .operands = &[_]Operand{
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "Tan",
                    .opcode = 15,
                    .operands = &[_]Operand{
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "Asin",
                    .opcode = 16,
                    .operands = &[_]Operand{
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "Acos",
                    .opcode = 17,
                    .operands = &[_]Operand{
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "Atan",
                    .opcode = 18,
                    .operands = &[_]Operand{
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "Sinh",
                    .opcode = 19,
                    .operands = &[_]Operand{
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "Cosh",
                    .opcode = 20,
                    .operands = &[_]Operand{
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "Tanh",
                    .opcode = 21,
                    .operands = &[_]Operand{
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "Asinh",
                    .opcode = 22,
                    .operands = &[_]Operand{
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "Acosh",
                    .opcode = 23,
                    .operands = &[_]Operand{
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "Atanh",
                    .opcode = 24,
                    .operands = &[_]Operand{
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "Atan2",
                    .opcode = 25,
                    .operands = &[_]Operand{
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "Pow",
                    .opcode = 26,
                    .operands = &[_]Operand{
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "Exp",
                    .opcode = 27,
                    .operands = &[_]Operand{
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "Log",
                    .opcode = 28,
                    .operands = &[_]Operand{
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "Exp2",
                    .opcode = 29,
                    .operands = &[_]Operand{
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "Log2",
                    .opcode = 30,
                    .operands = &[_]Operand{
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "Sqrt",
                    .opcode = 31,
                    .operands = &[_]Operand{
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "InverseSqrt",
                    .opcode = 32,
                    .operands = &[_]Operand{
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "Determinant",
                    .opcode = 33,
                    .operands = &[_]Operand{
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "MatrixInverse",
                    .opcode = 34,
                    .operands = &[_]Operand{
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "Modf",
                    .opcode = 35,
                    .operands = &[_]Operand{
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "ModfStruct",
                    .opcode = 36,
                    .operands = &[_]Operand{
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "FMin",
                    .opcode = 37,
                    .operands = &[_]Operand{
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "UMin",
                    .opcode = 38,
                    .operands = &[_]Operand{
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "SMin",
                    .opcode = 39,
                    .operands = &[_]Operand{
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "FMax",
                    .opcode = 40,
                    .operands = &[_]Operand{
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "UMax",
                    .opcode = 41,
                    .operands = &[_]Operand{
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "SMax",
                    .opcode = 42,
                    .operands = &[_]Operand{
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "FClamp",
                    .opcode = 43,
                    .operands = &[_]Operand{
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "UClamp",
                    .opcode = 44,
                    .operands = &[_]Operand{
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "SClamp",
                    .opcode = 45,
                    .operands = &[_]Operand{
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "FMix",
                    .opcode = 46,
                    .operands = &[_]Operand{
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "IMix",
                    .opcode = 47,
                    .operands = &[_]Operand{
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "Step",
                    .opcode = 48,
                    .operands = &[_]Operand{
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "SmoothStep",
                    .opcode = 49,
                    .operands = &[_]Operand{
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "Fma",
                    .opcode = 50,
                    .operands = &[_]Operand{
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "Frexp",
                    .opcode = 51,
                    .operands = &[_]Operand{
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "FrexpStruct",
                    .opcode = 52,
                    .operands = &[_]Operand{
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "Ldexp",
                    .opcode = 53,
                    .operands = &[_]Operand{
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "PackSnorm4x8",
                    .opcode = 54,
                    .operands = &[_]Operand{
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "PackUnorm4x8",
                    .opcode = 55,
                    .operands = &[_]Operand{
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "PackSnorm2x16",
                    .opcode = 56,
                    .operands = &[_]Operand{
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "PackUnorm2x16",
                    .opcode = 57,
                    .operands = &[_]Operand{
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "PackHalf2x16",
                    .opcode = 58,
                    .operands = &[_]Operand{
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "PackDouble2x32",
                    .opcode = 59,
                    .operands = &[_]Operand{
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "UnpackSnorm2x16",
                    .opcode = 60,
                    .operands = &[_]Operand{
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "UnpackUnorm2x16",
                    .opcode = 61,
                    .operands = &[_]Operand{
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "UnpackHalf2x16",
                    .opcode = 62,
                    .operands = &[_]Operand{
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "UnpackSnorm4x8",
                    .opcode = 63,
                    .operands = &[_]Operand{
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "UnpackUnorm4x8",
                    .opcode = 64,
                    .operands = &[_]Operand{
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "UnpackDouble2x32",
                    .opcode = 65,
                    .operands = &[_]Operand{
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "Length",
                    .opcode = 66,
                    .operands = &[_]Operand{
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "Distance",
                    .opcode = 67,
                    .operands = &[_]Operand{
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "Cross",
                    .opcode = 68,
                    .operands = &[_]Operand{
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "Normalize",
                    .opcode = 69,
                    .operands = &[_]Operand{
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "FaceForward",
                    .opcode = 70,
                    .operands = &[_]Operand{
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "Reflect",
                    .opcode = 71,
                    .operands = &[_]Operand{
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "Refract",
                    .opcode = 72,
                    .operands = &[_]Operand{
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "FindILsb",
                    .opcode = 73,
                    .operands = &[_]Operand{
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "FindSMsb",
                    .opcode = 74,
                    .operands = &[_]Operand{
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "FindUMsb",
                    .opcode = 75,
                    .operands = &[_]Operand{
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "InterpolateAtCentroid",
                    .opcode = 76,
                    .operands = &[_]Operand{
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "InterpolateAtSample",
                    .opcode = 77,
                    .operands = &[_]Operand{
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "InterpolateAtOffset",
                    .opcode = 78,
                    .operands = &[_]Operand{
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "NMin",
                    .opcode = 79,
                    .operands = &[_]Operand{
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "NMax",
                    .opcode = 80,
                    .operands = &[_]Operand{
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "NClamp",
                    .opcode = 81,
                    .operands = &[_]Operand{
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
            },
            .@"OpenCL.DebugInfo.100" => &[_]Instruction{
                .{
                    .name = "DebugInfoNone",
                    .opcode = 0,
                    .operands = &[_]Operand{},
                },
                .{
                    .name = "DebugCompilationUnit",
                    .opcode = 1,
                    .operands = &[_]Operand{
                        .{ .kind = .LiteralInteger, .quantifier = .required },
                        .{ .kind = .LiteralInteger, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .SourceLanguage, .quantifier = .required },
                    },
                },
                .{
                    .name = "DebugTypeBasic",
                    .opcode = 2,
                    .operands = &[_]Operand{
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .@"OpenCL.DebugInfo.100.DebugBaseTypeAttributeEncoding", .quantifier = .required },
                    },
                },
                .{
                    .name = "DebugTypePointer",
                    .opcode = 3,
                    .operands = &[_]Operand{
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .StorageClass, .quantifier = .required },
                        .{ .kind = .@"OpenCL.DebugInfo.100.DebugInfoFlags", .quantifier = .required },
                    },
                },
                .{
                    .name = "DebugTypeQualifier",
                    .opcode = 4,
                    .operands = &[_]Operand{
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .@"OpenCL.DebugInfo.100.DebugTypeQualifier", .quantifier = .required },
                    },
                },
                .{
                    .name = "DebugTypeArray",
                    .opcode = 5,
                    .operands = &[_]Operand{
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .variadic },
                    },
                },
                .{
                    .name = "DebugTypeVector",
                    .opcode = 6,
                    .operands = &[_]Operand{
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .LiteralInteger, .quantifier = .required },
                    },
                },
                .{
                    .name = "DebugTypedef",
                    .opcode = 7,
                    .operands = &[_]Operand{
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .LiteralInteger, .quantifier = .required },
                        .{ .kind = .LiteralInteger, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "DebugTypeFunction",
                    .opcode = 8,
                    .operands = &[_]Operand{
                        .{ .kind = .@"OpenCL.DebugInfo.100.DebugInfoFlags", .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .variadic },
                    },
                },
                .{
                    .name = "DebugTypeEnum",
                    .opcode = 9,
                    .operands = &[_]Operand{
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .LiteralInteger, .quantifier = .required },
                        .{ .kind = .LiteralInteger, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .@"OpenCL.DebugInfo.100.DebugInfoFlags", .quantifier = .required },
                        .{ .kind = .PairIdRefIdRef, .quantifier = .variadic },
                    },
                },
                .{
                    .name = "DebugTypeComposite",
                    .opcode = 10,
                    .operands = &[_]Operand{
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .@"OpenCL.DebugInfo.100.DebugCompositeType", .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .LiteralInteger, .quantifier = .required },
                        .{ .kind = .LiteralInteger, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .@"OpenCL.DebugInfo.100.DebugInfoFlags", .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .variadic },
                    },
                },
                .{
                    .name = "DebugTypeMember",
                    .opcode = 11,
                    .operands = &[_]Operand{
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .LiteralInteger, .quantifier = .required },
                        .{ .kind = .LiteralInteger, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .@"OpenCL.DebugInfo.100.DebugInfoFlags", .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .optional },
                    },
                },
                .{
                    .name = "DebugTypeInheritance",
                    .opcode = 12,
                    .operands = &[_]Operand{
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .@"OpenCL.DebugInfo.100.DebugInfoFlags", .quantifier = .required },
                    },
                },
                .{
                    .name = "DebugTypePtrToMember",
                    .opcode = 13,
                    .operands = &[_]Operand{
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "DebugTypeTemplate",
                    .opcode = 14,
                    .operands = &[_]Operand{
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .variadic },
                    },
                },
                .{
                    .name = "DebugTypeTemplateParameter",
                    .opcode = 15,
                    .operands = &[_]Operand{
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .LiteralInteger, .quantifier = .required },
                        .{ .kind = .LiteralInteger, .quantifier = .required },
                    },
                },
                .{
                    .name = "DebugTypeTemplateTemplateParameter",
                    .opcode = 16,
                    .operands = &[_]Operand{
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .LiteralInteger, .quantifier = .required },
                        .{ .kind = .LiteralInteger, .quantifier = .required },
                    },
                },
                .{
                    .name = "DebugTypeTemplateParameterPack",
                    .opcode = 17,
                    .operands = &[_]Operand{
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .LiteralInteger, .quantifier = .required },
                        .{ .kind = .LiteralInteger, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .variadic },
                    },
                },
                .{
                    .name = "DebugGlobalVariable",
                    .opcode = 18,
                    .operands = &[_]Operand{
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .LiteralInteger, .quantifier = .required },
                        .{ .kind = .LiteralInteger, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .@"OpenCL.DebugInfo.100.DebugInfoFlags", .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .optional },
                    },
                },
                .{
                    .name = "DebugFunctionDeclaration",
                    .opcode = 19,
                    .operands = &[_]Operand{
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .LiteralInteger, .quantifier = .required },
                        .{ .kind = .LiteralInteger, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .@"OpenCL.DebugInfo.100.DebugInfoFlags", .quantifier = .required },
                    },
                },
                .{
                    .name = "DebugFunction",
                    .opcode = 20,
                    .operands = &[_]Operand{
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .LiteralInteger, .quantifier = .required },
                        .{ .kind = .LiteralInteger, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .@"OpenCL.DebugInfo.100.DebugInfoFlags", .quantifier = .required },
                        .{ .kind = .LiteralInteger, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .optional },
                    },
                },
                .{
                    .name = "DebugLexicalBlock",
                    .opcode = 21,
                    .operands = &[_]Operand{
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .LiteralInteger, .quantifier = .required },
                        .{ .kind = .LiteralInteger, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .optional },
                    },
                },
                .{
                    .name = "DebugLexicalBlockDiscriminator",
                    .opcode = 22,
                    .operands = &[_]Operand{
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .LiteralInteger, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "DebugScope",
                    .opcode = 23,
                    .operands = &[_]Operand{
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .optional },
                    },
                },
                .{
                    .name = "DebugNoScope",
                    .opcode = 24,
                    .operands = &[_]Operand{},
                },
                .{
                    .name = "DebugInlinedAt",
                    .opcode = 25,
                    .operands = &[_]Operand{
                        .{ .kind = .LiteralInteger, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .optional },
                    },
                },
                .{
                    .name = "DebugLocalVariable",
                    .opcode = 26,
                    .operands = &[_]Operand{
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .LiteralInteger, .quantifier = .required },
                        .{ .kind = .LiteralInteger, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .@"OpenCL.DebugInfo.100.DebugInfoFlags", .quantifier = .required },
                        .{ .kind = .LiteralInteger, .quantifier = .optional },
                    },
                },
                .{
                    .name = "DebugInlinedVariable",
                    .opcode = 27,
                    .operands = &[_]Operand{
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "DebugDeclare",
                    .opcode = 28,
                    .operands = &[_]Operand{
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "DebugValue",
                    .opcode = 29,
                    .operands = &[_]Operand{
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .variadic },
                    },
                },
                .{
                    .name = "DebugOperation",
                    .opcode = 30,
                    .operands = &[_]Operand{
                        .{ .kind = .@"OpenCL.DebugInfo.100.DebugOperation", .quantifier = .required },
                        .{ .kind = .LiteralInteger, .quantifier = .variadic },
                    },
                },
                .{
                    .name = "DebugExpression",
                    .opcode = 31,
                    .operands = &[_]Operand{
                        .{ .kind = .IdRef, .quantifier = .variadic },
                    },
                },
                .{
                    .name = "DebugMacroDef",
                    .opcode = 32,
                    .operands = &[_]Operand{
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .LiteralInteger, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .optional },
                    },
                },
                .{
                    .name = "DebugMacroUndef",
                    .opcode = 33,
                    .operands = &[_]Operand{
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .LiteralInteger, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "DebugImportedEntity",
                    .opcode = 34,
                    .operands = &[_]Operand{
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .@"OpenCL.DebugInfo.100.DebugImportedEntity", .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .LiteralInteger, .quantifier = .required },
                        .{ .kind = .LiteralInteger, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "DebugSource",
                    .opcode = 35,
                    .operands = &[_]Operand{
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .optional },
                    },
                },
                .{
                    .name = "DebugModuleINTEL",
                    .opcode = 36,
                    .operands = &[_]Operand{
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .LiteralInteger, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .LiteralInteger, .quantifier = .required },
                    },
                },
            },
            .SPV_AMD_shader_ballot => &[_]Instruction{
                .{
                    .name = "SwizzleInvocationsAMD",
                    .opcode = 1,
                    .operands = &[_]Operand{
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "SwizzleInvocationsMaskedAMD",
                    .opcode = 2,
                    .operands = &[_]Operand{
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "WriteInvocationAMD",
                    .opcode = 3,
                    .operands = &[_]Operand{
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "MbcntAMD",
                    .opcode = 4,
                    .operands = &[_]Operand{
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
            },
            .@"NonSemantic.Shader.DebugInfo.100" => &[_]Instruction{
                .{
                    .name = "DebugInfoNone",
                    .opcode = 0,
                    .operands = &[_]Operand{},
                },
                .{
                    .name = "DebugCompilationUnit",
                    .opcode = 1,
                    .operands = &[_]Operand{
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "DebugTypeBasic",
                    .opcode = 2,
                    .operands = &[_]Operand{
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "DebugTypePointer",
                    .opcode = 3,
                    .operands = &[_]Operand{
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "DebugTypeQualifier",
                    .opcode = 4,
                    .operands = &[_]Operand{
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "DebugTypeArray",
                    .opcode = 5,
                    .operands = &[_]Operand{
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .variadic },
                    },
                },
                .{
                    .name = "DebugTypeVector",
                    .opcode = 6,
                    .operands = &[_]Operand{
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "DebugTypedef",
                    .opcode = 7,
                    .operands = &[_]Operand{
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "DebugTypeFunction",
                    .opcode = 8,
                    .operands = &[_]Operand{
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .variadic },
                    },
                },
                .{
                    .name = "DebugTypeEnum",
                    .opcode = 9,
                    .operands = &[_]Operand{
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .PairIdRefIdRef, .quantifier = .variadic },
                    },
                },
                .{
                    .name = "DebugTypeComposite",
                    .opcode = 10,
                    .operands = &[_]Operand{
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .variadic },
                    },
                },
                .{
                    .name = "DebugTypeMember",
                    .opcode = 11,
                    .operands = &[_]Operand{
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .optional },
                    },
                },
                .{
                    .name = "DebugTypeInheritance",
                    .opcode = 12,
                    .operands = &[_]Operand{
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "DebugTypePtrToMember",
                    .opcode = 13,
                    .operands = &[_]Operand{
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "DebugTypeTemplate",
                    .opcode = 14,
                    .operands = &[_]Operand{
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .variadic },
                    },
                },
                .{
                    .name = "DebugTypeTemplateParameter",
                    .opcode = 15,
                    .operands = &[_]Operand{
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "DebugTypeTemplateTemplateParameter",
                    .opcode = 16,
                    .operands = &[_]Operand{
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "DebugTypeTemplateParameterPack",
                    .opcode = 17,
                    .operands = &[_]Operand{
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .variadic },
                    },
                },
                .{
                    .name = "DebugGlobalVariable",
                    .opcode = 18,
                    .operands = &[_]Operand{
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .optional },
                    },
                },
                .{
                    .name = "DebugFunctionDeclaration",
                    .opcode = 19,
                    .operands = &[_]Operand{
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "DebugFunction",
                    .opcode = 20,
                    .operands = &[_]Operand{
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .optional },
                    },
                },
                .{
                    .name = "DebugLexicalBlock",
                    .opcode = 21,
                    .operands = &[_]Operand{
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .optional },
                    },
                },
                .{
                    .name = "DebugLexicalBlockDiscriminator",
                    .opcode = 22,
                    .operands = &[_]Operand{
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "DebugScope",
                    .opcode = 23,
                    .operands = &[_]Operand{
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .optional },
                    },
                },
                .{
                    .name = "DebugNoScope",
                    .opcode = 24,
                    .operands = &[_]Operand{},
                },
                .{
                    .name = "DebugInlinedAt",
                    .opcode = 25,
                    .operands = &[_]Operand{
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .optional },
                    },
                },
                .{
                    .name = "DebugLocalVariable",
                    .opcode = 26,
                    .operands = &[_]Operand{
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .optional },
                    },
                },
                .{
                    .name = "DebugInlinedVariable",
                    .opcode = 27,
                    .operands = &[_]Operand{
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "DebugDeclare",
                    .opcode = 28,
                    .operands = &[_]Operand{
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .variadic },
                    },
                },
                .{
                    .name = "DebugValue",
                    .opcode = 29,
                    .operands = &[_]Operand{
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .variadic },
                    },
                },
                .{
                    .name = "DebugOperation",
                    .opcode = 30,
                    .operands = &[_]Operand{
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .variadic },
                    },
                },
                .{
                    .name = "DebugExpression",
                    .opcode = 31,
                    .operands = &[_]Operand{
                        .{ .kind = .IdRef, .quantifier = .variadic },
                    },
                },
                .{
                    .name = "DebugMacroDef",
                    .opcode = 32,
                    .operands = &[_]Operand{
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .optional },
                    },
                },
                .{
                    .name = "DebugMacroUndef",
                    .opcode = 33,
                    .operands = &[_]Operand{
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "DebugImportedEntity",
                    .opcode = 34,
                    .operands = &[_]Operand{
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "DebugSource",
                    .opcode = 35,
                    .operands = &[_]Operand{
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .optional },
                    },
                },
                .{
                    .name = "DebugFunctionDefinition",
                    .opcode = 101,
                    .operands = &[_]Operand{
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "DebugSourceContinued",
                    .opcode = 102,
                    .operands = &[_]Operand{
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "DebugLine",
                    .opcode = 103,
                    .operands = &[_]Operand{
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "DebugNoLine",
                    .opcode = 104,
                    .operands = &[_]Operand{},
                },
                .{
                    .name = "DebugBuildIdentifier",
                    .opcode = 105,
                    .operands = &[_]Operand{
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "DebugStoragePath",
                    .opcode = 106,
                    .operands = &[_]Operand{
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "DebugEntryPoint",
                    .opcode = 107,
                    .operands = &[_]Operand{
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "DebugTypeMatrix",
                    .opcode = 108,
                    .operands = &[_]Operand{
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
            },
            .@"NonSemantic.VkspReflection" => &[_]Instruction{
                .{
                    .name = "Configuration",
                    .opcode = 1,
                    .operands = &[_]Operand{
                        .{ .kind = .LiteralString, .quantifier = .required },
                        .{ .kind = .LiteralInteger, .quantifier = .required },
                        .{ .kind = .LiteralString, .quantifier = .required },
                        .{ .kind = .LiteralString, .quantifier = .required },
                        .{ .kind = .LiteralString, .quantifier = .required },
                        .{ .kind = .LiteralInteger, .quantifier = .required },
                        .{ .kind = .LiteralInteger, .quantifier = .required },
                        .{ .kind = .LiteralInteger, .quantifier = .required },
                    },
                },
                .{
                    .name = "StartCounter",
                    .opcode = 2,
                    .operands = &[_]Operand{
                        .{ .kind = .LiteralString, .quantifier = .required },
                    },
                },
                .{
                    .name = "StopCounter",
                    .opcode = 3,
                    .operands = &[_]Operand{
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "PushConstants",
                    .opcode = 4,
                    .operands = &[_]Operand{
                        .{ .kind = .LiteralInteger, .quantifier = .required },
                        .{ .kind = .LiteralInteger, .quantifier = .required },
                        .{ .kind = .LiteralString, .quantifier = .required },
                        .{ .kind = .LiteralInteger, .quantifier = .required },
                    },
                },
                .{
                    .name = "SpecializationMapEntry",
                    .opcode = 5,
                    .operands = &[_]Operand{
                        .{ .kind = .LiteralInteger, .quantifier = .required },
                        .{ .kind = .LiteralInteger, .quantifier = .required },
                        .{ .kind = .LiteralInteger, .quantifier = .required },
                    },
                },
                .{
                    .name = "DescriptorSetBuffer",
                    .opcode = 6,
                    .operands = &[_]Operand{
                        .{ .kind = .LiteralInteger, .quantifier = .required },
                        .{ .kind = .LiteralInteger, .quantifier = .required },
                        .{ .kind = .LiteralInteger, .quantifier = .required },
                        .{ .kind = .LiteralInteger, .quantifier = .required },
                        .{ .kind = .LiteralInteger, .quantifier = .required },
                        .{ .kind = .LiteralInteger, .quantifier = .required },
                        .{ .kind = .LiteralInteger, .quantifier = .required },
                        .{ .kind = .LiteralInteger, .quantifier = .required },
                        .{ .kind = .LiteralInteger, .quantifier = .required },
                        .{ .kind = .LiteralInteger, .quantifier = .required },
                        .{ .kind = .LiteralInteger, .quantifier = .required },
                        .{ .kind = .LiteralInteger, .quantifier = .required },
                        .{ .kind = .LiteralInteger, .quantifier = .required },
                    },
                },
                .{
                    .name = "DescriptorSetImage",
                    .opcode = 7,
                    .operands = &[_]Operand{
                        .{ .kind = .LiteralInteger, .quantifier = .required },
                        .{ .kind = .LiteralInteger, .quantifier = .required },
                        .{ .kind = .LiteralInteger, .quantifier = .required },
                        .{ .kind = .LiteralInteger, .quantifier = .required },
                        .{ .kind = .LiteralInteger, .quantifier = .required },
                        .{ .kind = .LiteralInteger, .quantifier = .required },
                        .{ .kind = .LiteralInteger, .quantifier = .required },
                        .{ .kind = .LiteralInteger, .quantifier = .required },
                        .{ .kind = .LiteralInteger, .quantifier = .required },
                        .{ .kind = .LiteralInteger, .quantifier = .required },
                        .{ .kind = .LiteralInteger, .quantifier = .required },
                        .{ .kind = .LiteralInteger, .quantifier = .required },
                        .{ .kind = .LiteralInteger, .quantifier = .required },
                        .{ .kind = .LiteralInteger, .quantifier = .required },
                        .{ .kind = .LiteralInteger, .quantifier = .required },
                        .{ .kind = .LiteralInteger, .quantifier = .required },
                        .{ .kind = .LiteralInteger, .quantifier = .required },
                        .{ .kind = .LiteralInteger, .quantifier = .required },
                        .{ .kind = .LiteralInteger, .quantifier = .required },
                        .{ .kind = .LiteralInteger, .quantifier = .required },
                        .{ .kind = .LiteralInteger, .quantifier = .required },
                        .{ .kind = .LiteralInteger, .quantifier = .required },
                        .{ .kind = .LiteralInteger, .quantifier = .required },
                        .{ .kind = .LiteralInteger, .quantifier = .required },
                        .{ .kind = .LiteralInteger, .quantifier = .required },
                        .{ .kind = .LiteralInteger, .quantifier = .required },
                        .{ .kind = .LiteralInteger, .quantifier = .required },
                        .{ .kind = .LiteralInteger, .quantifier = .required },
                        .{ .kind = .LiteralInteger, .quantifier = .required },
                        .{ .kind = .LiteralInteger, .quantifier = .required },
                        .{ .kind = .LiteralInteger, .quantifier = .required },
                        .{ .kind = .LiteralInteger, .quantifier = .required },
                        .{ .kind = .LiteralInteger, .quantifier = .required },
                    },
                },
                .{
                    .name = "DescriptorSetSampler",
                    .opcode = 8,
                    .operands = &[_]Operand{
                        .{ .kind = .LiteralInteger, .quantifier = .required },
                        .{ .kind = .LiteralInteger, .quantifier = .required },
                        .{ .kind = .LiteralInteger, .quantifier = .required },
                        .{ .kind = .LiteralInteger, .quantifier = .required },
                        .{ .kind = .LiteralInteger, .quantifier = .required },
                        .{ .kind = .LiteralInteger, .quantifier = .required },
                        .{ .kind = .LiteralInteger, .quantifier = .required },
                        .{ .kind = .LiteralInteger, .quantifier = .required },
                        .{ .kind = .LiteralInteger, .quantifier = .required },
                        .{ .kind = .LiteralInteger, .quantifier = .required },
                        .{ .kind = .LiteralFloat, .quantifier = .required },
                        .{ .kind = .LiteralInteger, .quantifier = .required },
                        .{ .kind = .LiteralFloat, .quantifier = .required },
                        .{ .kind = .LiteralInteger, .quantifier = .required },
                        .{ .kind = .LiteralInteger, .quantifier = .required },
                        .{ .kind = .LiteralFloat, .quantifier = .required },
                        .{ .kind = .LiteralFloat, .quantifier = .required },
                        .{ .kind = .LiteralInteger, .quantifier = .required },
                        .{ .kind = .LiteralInteger, .quantifier = .required },
                    },
                },
            },
            .@"NonSemantic.ClspvReflection.6" => &[_]Instruction{
                .{
                    .name = "Kernel",
                    .opcode = 1,
                    .operands = &[_]Operand{
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .optional },
                        .{ .kind = .IdRef, .quantifier = .optional },
                        .{ .kind = .IdRef, .quantifier = .optional },
                    },
                },
                .{
                    .name = "ArgumentInfo",
                    .opcode = 2,
                    .operands = &[_]Operand{
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .optional },
                        .{ .kind = .IdRef, .quantifier = .optional },
                        .{ .kind = .IdRef, .quantifier = .optional },
                        .{ .kind = .IdRef, .quantifier = .optional },
                    },
                },
                .{
                    .name = "ArgumentStorageBuffer",
                    .opcode = 3,
                    .operands = &[_]Operand{
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .optional },
                    },
                },
                .{
                    .name = "ArgumentUniform",
                    .opcode = 4,
                    .operands = &[_]Operand{
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .optional },
                    },
                },
                .{
                    .name = "ArgumentPodStorageBuffer",
                    .opcode = 5,
                    .operands = &[_]Operand{
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .optional },
                    },
                },
                .{
                    .name = "ArgumentPodUniform",
                    .opcode = 6,
                    .operands = &[_]Operand{
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .optional },
                    },
                },
                .{
                    .name = "ArgumentPodPushConstant",
                    .opcode = 7,
                    .operands = &[_]Operand{
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .optional },
                    },
                },
                .{
                    .name = "ArgumentSampledImage",
                    .opcode = 8,
                    .operands = &[_]Operand{
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .optional },
                    },
                },
                .{
                    .name = "ArgumentStorageImage",
                    .opcode = 9,
                    .operands = &[_]Operand{
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .optional },
                    },
                },
                .{
                    .name = "ArgumentSampler",
                    .opcode = 10,
                    .operands = &[_]Operand{
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .optional },
                    },
                },
                .{
                    .name = "ArgumentWorkgroup",
                    .opcode = 11,
                    .operands = &[_]Operand{
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .optional },
                    },
                },
                .{
                    .name = "SpecConstantWorkgroupSize",
                    .opcode = 12,
                    .operands = &[_]Operand{
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "SpecConstantGlobalOffset",
                    .opcode = 13,
                    .operands = &[_]Operand{
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "SpecConstantWorkDim",
                    .opcode = 14,
                    .operands = &[_]Operand{
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "PushConstantGlobalOffset",
                    .opcode = 15,
                    .operands = &[_]Operand{
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "PushConstantEnqueuedLocalSize",
                    .opcode = 16,
                    .operands = &[_]Operand{
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "PushConstantGlobalSize",
                    .opcode = 17,
                    .operands = &[_]Operand{
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "PushConstantRegionOffset",
                    .opcode = 18,
                    .operands = &[_]Operand{
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "PushConstantNumWorkgroups",
                    .opcode = 19,
                    .operands = &[_]Operand{
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "PushConstantRegionGroupOffset",
                    .opcode = 20,
                    .operands = &[_]Operand{
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "ConstantDataStorageBuffer",
                    .opcode = 21,
                    .operands = &[_]Operand{
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "ConstantDataUniform",
                    .opcode = 22,
                    .operands = &[_]Operand{
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "LiteralSampler",
                    .opcode = 23,
                    .operands = &[_]Operand{
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "PropertyRequiredWorkgroupSize",
                    .opcode = 24,
                    .operands = &[_]Operand{
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "SpecConstantSubgroupMaxSize",
                    .opcode = 25,
                    .operands = &[_]Operand{
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "ArgumentPointerPushConstant",
                    .opcode = 26,
                    .operands = &[_]Operand{
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .optional },
                    },
                },
                .{
                    .name = "ArgumentPointerUniform",
                    .opcode = 27,
                    .operands = &[_]Operand{
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .optional },
                    },
                },
                .{
                    .name = "ProgramScopeVariablesStorageBuffer",
                    .opcode = 28,
                    .operands = &[_]Operand{
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "ProgramScopeVariablePointerRelocation",
                    .opcode = 29,
                    .operands = &[_]Operand{
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "ImageArgumentInfoChannelOrderPushConstant",
                    .opcode = 30,
                    .operands = &[_]Operand{
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "ImageArgumentInfoChannelDataTypePushConstant",
                    .opcode = 31,
                    .operands = &[_]Operand{
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "ImageArgumentInfoChannelOrderUniform",
                    .opcode = 32,
                    .operands = &[_]Operand{
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "ImageArgumentInfoChannelDataTypeUniform",
                    .opcode = 33,
                    .operands = &[_]Operand{
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "ArgumentStorageTexelBuffer",
                    .opcode = 34,
                    .operands = &[_]Operand{
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .optional },
                    },
                },
                .{
                    .name = "ArgumentUniformTexelBuffer",
                    .opcode = 35,
                    .operands = &[_]Operand{
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .optional },
                    },
                },
                .{
                    .name = "ConstantDataPointerPushConstant",
                    .opcode = 36,
                    .operands = &[_]Operand{
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "ProgramScopeVariablePointerPushConstant",
                    .opcode = 37,
                    .operands = &[_]Operand{
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "PrintfInfo",
                    .opcode = 38,
                    .operands = &[_]Operand{
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .variadic },
                    },
                },
                .{
                    .name = "PrintfBufferStorageBuffer",
                    .opcode = 39,
                    .operands = &[_]Operand{
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "PrintfBufferPointerPushConstant",
                    .opcode = 40,
                    .operands = &[_]Operand{
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "NormalizedSamplerMaskPushConstant",
                    .opcode = 41,
                    .operands = &[_]Operand{
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
            },
            .SPV_AMD_gcn_shader => &[_]Instruction{
                .{
                    .name = "CubeFaceIndexAMD",
                    .opcode = 1,
                    .operands = &[_]Operand{
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "CubeFaceCoordAMD",
                    .opcode = 2,
                    .operands = &[_]Operand{
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "TimeAMD",
                    .opcode = 3,
                    .operands = &[_]Operand{},
                },
            },
            .SPV_AMD_shader_trinary_minmax => &[_]Instruction{
                .{
                    .name = "FMin3AMD",
                    .opcode = 1,
                    .operands = &[_]Operand{
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "UMin3AMD",
                    .opcode = 2,
                    .operands = &[_]Operand{
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "SMin3AMD",
                    .opcode = 3,
                    .operands = &[_]Operand{
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "FMax3AMD",
                    .opcode = 4,
                    .operands = &[_]Operand{
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "UMax3AMD",
                    .opcode = 5,
                    .operands = &[_]Operand{
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "SMax3AMD",
                    .opcode = 6,
                    .operands = &[_]Operand{
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "FMid3AMD",
                    .opcode = 7,
                    .operands = &[_]Operand{
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "UMid3AMD",
                    .opcode = 8,
                    .operands = &[_]Operand{
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "SMid3AMD",
                    .opcode = 9,
                    .operands = &[_]Operand{
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
            },
            .DebugInfo => &[_]Instruction{
                .{
                    .name = "DebugInfoNone",
                    .opcode = 0,
                    .operands = &[_]Operand{},
                },
                .{
                    .name = "DebugCompilationUnit",
                    .opcode = 1,
                    .operands = &[_]Operand{
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .LiteralInteger, .quantifier = .required },
                        .{ .kind = .LiteralInteger, .quantifier = .required },
                    },
                },
                .{
                    .name = "DebugTypeBasic",
                    .opcode = 2,
                    .operands = &[_]Operand{
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .@"DebugInfo.DebugBaseTypeAttributeEncoding", .quantifier = .required },
                    },
                },
                .{
                    .name = "DebugTypePointer",
                    .opcode = 3,
                    .operands = &[_]Operand{
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .StorageClass, .quantifier = .required },
                        .{ .kind = .@"DebugInfo.DebugInfoFlags", .quantifier = .required },
                    },
                },
                .{
                    .name = "DebugTypeQualifier",
                    .opcode = 4,
                    .operands = &[_]Operand{
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .@"DebugInfo.DebugTypeQualifier", .quantifier = .required },
                    },
                },
                .{
                    .name = "DebugTypeArray",
                    .opcode = 5,
                    .operands = &[_]Operand{
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .variadic },
                    },
                },
                .{
                    .name = "DebugTypeVector",
                    .opcode = 6,
                    .operands = &[_]Operand{
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .LiteralInteger, .quantifier = .required },
                    },
                },
                .{
                    .name = "DebugTypedef",
                    .opcode = 7,
                    .operands = &[_]Operand{
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .LiteralInteger, .quantifier = .required },
                        .{ .kind = .LiteralInteger, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "DebugTypeFunction",
                    .opcode = 8,
                    .operands = &[_]Operand{
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .variadic },
                    },
                },
                .{
                    .name = "DebugTypeEnum",
                    .opcode = 9,
                    .operands = &[_]Operand{
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .LiteralInteger, .quantifier = .required },
                        .{ .kind = .LiteralInteger, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .@"DebugInfo.DebugInfoFlags", .quantifier = .required },
                        .{ .kind = .PairIdRefIdRef, .quantifier = .variadic },
                    },
                },
                .{
                    .name = "DebugTypeComposite",
                    .opcode = 10,
                    .operands = &[_]Operand{
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .@"DebugInfo.DebugCompositeType", .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .LiteralInteger, .quantifier = .required },
                        .{ .kind = .LiteralInteger, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .@"DebugInfo.DebugInfoFlags", .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .variadic },
                    },
                },
                .{
                    .name = "DebugTypeMember",
                    .opcode = 11,
                    .operands = &[_]Operand{
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .LiteralInteger, .quantifier = .required },
                        .{ .kind = .LiteralInteger, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .@"DebugInfo.DebugInfoFlags", .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .optional },
                    },
                },
                .{
                    .name = "DebugTypeInheritance",
                    .opcode = 12,
                    .operands = &[_]Operand{
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .@"DebugInfo.DebugInfoFlags", .quantifier = .required },
                    },
                },
                .{
                    .name = "DebugTypePtrToMember",
                    .opcode = 13,
                    .operands = &[_]Operand{
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "DebugTypeTemplate",
                    .opcode = 14,
                    .operands = &[_]Operand{
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .variadic },
                    },
                },
                .{
                    .name = "DebugTypeTemplateParameter",
                    .opcode = 15,
                    .operands = &[_]Operand{
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .LiteralInteger, .quantifier = .required },
                        .{ .kind = .LiteralInteger, .quantifier = .required },
                    },
                },
                .{
                    .name = "DebugTypeTemplateTemplateParameter",
                    .opcode = 16,
                    .operands = &[_]Operand{
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .LiteralInteger, .quantifier = .required },
                        .{ .kind = .LiteralInteger, .quantifier = .required },
                    },
                },
                .{
                    .name = "DebugTypeTemplateParameterPack",
                    .opcode = 17,
                    .operands = &[_]Operand{
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .LiteralInteger, .quantifier = .required },
                        .{ .kind = .LiteralInteger, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .variadic },
                    },
                },
                .{
                    .name = "DebugGlobalVariable",
                    .opcode = 18,
                    .operands = &[_]Operand{
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .LiteralInteger, .quantifier = .required },
                        .{ .kind = .LiteralInteger, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .@"DebugInfo.DebugInfoFlags", .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .optional },
                    },
                },
                .{
                    .name = "DebugFunctionDeclaration",
                    .opcode = 19,
                    .operands = &[_]Operand{
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .LiteralInteger, .quantifier = .required },
                        .{ .kind = .LiteralInteger, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .@"DebugInfo.DebugInfoFlags", .quantifier = .required },
                    },
                },
                .{
                    .name = "DebugFunction",
                    .opcode = 20,
                    .operands = &[_]Operand{
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .LiteralInteger, .quantifier = .required },
                        .{ .kind = .LiteralInteger, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .@"DebugInfo.DebugInfoFlags", .quantifier = .required },
                        .{ .kind = .LiteralInteger, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .optional },
                    },
                },
                .{
                    .name = "DebugLexicalBlock",
                    .opcode = 21,
                    .operands = &[_]Operand{
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .LiteralInteger, .quantifier = .required },
                        .{ .kind = .LiteralInteger, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .optional },
                    },
                },
                .{
                    .name = "DebugLexicalBlockDiscriminator",
                    .opcode = 22,
                    .operands = &[_]Operand{
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .LiteralInteger, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "DebugScope",
                    .opcode = 23,
                    .operands = &[_]Operand{
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .optional },
                    },
                },
                .{
                    .name = "DebugNoScope",
                    .opcode = 24,
                    .operands = &[_]Operand{},
                },
                .{
                    .name = "DebugInlinedAt",
                    .opcode = 25,
                    .operands = &[_]Operand{
                        .{ .kind = .LiteralInteger, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .optional },
                    },
                },
                .{
                    .name = "DebugLocalVariable",
                    .opcode = 26,
                    .operands = &[_]Operand{
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .LiteralInteger, .quantifier = .required },
                        .{ .kind = .LiteralInteger, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .LiteralInteger, .quantifier = .optional },
                    },
                },
                .{
                    .name = "DebugInlinedVariable",
                    .opcode = 27,
                    .operands = &[_]Operand{
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "DebugDeclare",
                    .opcode = 28,
                    .operands = &[_]Operand{
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
                .{
                    .name = "DebugValue",
                    .opcode = 29,
                    .operands = &[_]Operand{
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .variadic },
                    },
                },
                .{
                    .name = "DebugOperation",
                    .opcode = 30,
                    .operands = &[_]Operand{
                        .{ .kind = .@"DebugInfo.DebugOperation", .quantifier = .required },
                        .{ .kind = .LiteralInteger, .quantifier = .variadic },
                    },
                },
                .{
                    .name = "DebugExpression",
                    .opcode = 31,
                    .operands = &[_]Operand{
                        .{ .kind = .IdRef, .quantifier = .variadic },
                    },
                },
                .{
                    .name = "DebugMacroDef",
                    .opcode = 32,
                    .operands = &[_]Operand{
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .LiteralInteger, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .optional },
                    },
                },
                .{
                    .name = "DebugMacroUndef",
                    .opcode = 33,
                    .operands = &[_]Operand{
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .LiteralInteger, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
            },
            .@"NonSemantic.DebugPrintf" => &[_]Instruction{
                .{
                    .name = "DebugPrintf",
                    .opcode = 1,
                    .operands = &[_]Operand{
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .variadic },
                    },
                },
            },
            .SPV_AMD_shader_explicit_vertex_parameter => &[_]Instruction{
                .{
                    .name = "InterpolateAtVertexAMD",
                    .opcode = 1,
                    .operands = &[_]Operand{
                        .{ .kind = .IdRef, .quantifier = .required },
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
            },
            .@"NonSemantic.DebugBreak" => &[_]Instruction{
                .{
                    .name = "DebugBreak",
                    .opcode = 1,
                    .operands = &[_]Operand{},
                },
            },
            .zig => &[_]Instruction{
                .{
                    .name = "InvocationGlobal",
                    .opcode = 0,
                    .operands = &[_]Operand{
                        .{ .kind = .IdRef, .quantifier = .required },
                    },
                },
            },
        };
    }
};
